/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import darrylbu.util.SwingUtils;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.gui.AlignFrame;
import jalview.gui.JvOptionPane;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.JalviewFileFilter;
import jalview.util.ChannelProperties;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.dialogrunner.DialogRunnerI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class JalviewFileChooser
extends JFileChooser
implements DialogRunnerI,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Map<Object, Runnable> callbacks = new HashMap<Object, Runnable>();
    File selectedFile = null;
    private JCheckBox backupfilesCheckBox = null;
    protected boolean includeBackupFiles = false;
    public static final String DEFAULT_FORMAT_PROPERTY = "DEFAULT_FILE_FORMAT";
    public static final String DEFAULT_SAVE_FORMAT_PROPERTY = "DEFAULT_SAVE_FILE_FORMAT";
    public static final String USE_LAST_SAVED_FORMAT_VALUE = "USE_LAST_SAVED";
    public static final String ALWAYS_USE_DEFAULT_SAVED_FORMAT_PROPERTY = "ALWAYS_USE_DEFAULT_SAVE_FORMAT";
    private static String byExtensionTooltip = null;

    public static JalviewFileChooser forRead(String directory, String selected) {
        return JalviewFileChooser.forRead(directory, selected, false);
    }

    public static JalviewFileChooser forRead(String directory, String selected, boolean allowBackupFiles) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> descs = new ArrayList<String>();
        for (FileFormatI format : FileFormats.getInstance().getFormats()) {
            if (!format.isReadable()) continue;
            extensions.add(format.getExtensions());
            descs.add(format.getName());
        }
        if (selected == null) {
            selected = JalviewFileChooser.defaultLoadFileFormat();
        }
        return new JalviewFileChooser(directory, extensions.toArray(new String[extensions.size()]), descs.toArray(new String[descs.size()]), selected, true, allowBackupFiles);
    }

    public static JalviewFileChooser forWrite(String directory, String selected, boolean addSelectFormatFromFileExtension) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> descs = new ArrayList<String>();
        for (FileFormatI format : FileFormats.getInstance().getFormats()) {
            if (!format.isWritable()) continue;
            extensions.add(format.getExtensions());
            descs.add(format.getName());
        }
        return new JalviewFileChooser(directory, extensions.toArray(new String[extensions.size()]), descs.toArray(new String[descs.size()]), JalviewFileChooser.defaultSaveFileFormat(selected), false, false, addSelectFormatFromFileExtension);
    }

    public JalviewFileChooser(String dir) {
        super(JalviewFileChooser.safePath(dir));
        this.setAccessory(new RecentlyOpened());
    }

    public JalviewFileChooser(String dir, String[] suffix, String[] desc, String selected) {
        this(dir, suffix, desc, selected, true);
    }

    public JalviewFileChooser(String extension, String desc) {
        this(Cache.getProperty("LAST_DIRECTORY"), new String[]{extension}, new String[]{desc}, desc, true);
    }

    JalviewFileChooser(String dir, String[] extensions, String[] descs, String selected, boolean acceptAny) {
        this(dir, extensions, descs, selected, acceptAny, false);
    }

    public JalviewFileChooser(String dir, String[] extensions, String[] descs, String selected, boolean acceptAny, boolean allowBackupFiles) {
        this(dir, extensions, descs, selected, acceptAny, allowBackupFiles, false);
    }

    public JalviewFileChooser(String dir, String[] extensions, String[] descs, String selected, boolean acceptAny, boolean allowBackupFiles, boolean addSelectFormatFromExtension) {
        super(JalviewFileChooser.safePath(dir));
        if (extensions.length == descs.length) {
            ArrayList<String[]> formats = new ArrayList<String[]>();
            for (int i = 0; i < extensions.length; ++i) {
                formats.add(new String[]{extensions[i], descs[i]});
            }
            this.init(formats, selected, acceptAny, allowBackupFiles, addSelectFormatFromExtension);
        } else {
            Console.errPrintln("JalviewFileChooser arguments mismatch: " + extensions + ", " + descs);
        }
    }

    private static File safePath(String dir) {
        if (dir == null) {
            return null;
        }
        File f = new File(dir);
        if (f.getName().indexOf(58) > -1) {
            return null;
        }
        return f;
    }

    @Override
    public int showOpenDialog(Component parent) {
        int value = super.showOpenDialog(this);
        if (!Platform.isJS()) {
            this.handleResponse(value);
        }
        return value;
    }

    void init(List<String[]> formats, String selected, boolean acceptAny) {
        this.init(formats, selected, acceptAny, false);
    }

    void init(List<String[]> formats, String selected, boolean acceptAny, boolean allowBackupFiles) {
        this.init(formats, selected, acceptAny, allowBackupFiles, false);
    }

    void init(List<String[]> formats, String selected, boolean acceptAny, boolean allowBackupFiles, boolean addSelectFormatFromExtension) {
        JalviewFileFilter chosen = null;
        this.setAcceptAllFileFilterUsed(acceptAny);
        ArrayList<String> allExtensions = new ArrayList<String>();
        for (String[] format : formats) {
            String[] extensions = format[0].split(",");
            for (String ext : extensions) {
                if (allExtensions.contains(ext)) continue;
                allExtensions.add(ext);
            }
        }
        allExtensions.sort(null);
        if (acceptAny || addSelectFormatFromExtension) {
            String label = MessageManager.getString(addSelectFormatFromExtension ? "label.by_extension" : "label.all_known_alignment_files");
            JalviewFileFilter alljvf = new JalviewFileFilter(allExtensions.toArray(new String[0]), label);
            alljvf.setMultiFormat(true);
            alljvf.setExtensionListInDescription(false);
            this.addChoosableFileFilter(alljvf);
            if (selected == null) {
                chosen = alljvf;
            }
            if (addSelectFormatFromExtension) {
                List<JComboBox> dropdowns = SwingUtils.getDescendantsOfType(JComboBox.class, this);
                for (final JComboBox dd : dropdowns) {
                    if (dd.getItemCount() <= 0 || !(dd.getItemAt(0) instanceof JalviewFileFilter)) continue;
                    JalviewFileChooser.setByExtensionTooltip(dd);
                    dd.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JalviewFileChooser.setByExtensionTooltip(dd);
                        }
                    });
                    break;
                }
            }
        }
        for (String[] format : formats) {
            JalviewFileFilter jvf = new JalviewFileFilter(format[0], format[1]);
            if (allowBackupFiles) {
                jvf.setParentJFC(this);
            }
            this.addChoosableFileFilter(jvf);
            if (selected == null || !selected.equalsIgnoreCase(format[1])) continue;
            chosen = jvf;
        }
        if (chosen != null) {
            this.setFileFilter(chosen);
        }
        JPanel multi = new JPanel();
        multi.setLayout(new BoxLayout(multi, 3));
        multi.add(new RecentlyOpened());
        if (allowBackupFiles) {
            if (this.backupfilesCheckBox == null) {
                try {
                    this.includeBackupFiles = Boolean.parseBoolean(Cache.getProperty("BACKUPFILES_FC_INCLUDE"));
                }
                catch (Exception e) {
                    this.includeBackupFiles = false;
                }
                this.backupfilesCheckBox = new JCheckBox(MessageManager.getString("label.include_backup_files"), this.includeBackupFiles);
                this.backupfilesCheckBox.setAlignmentX(0.5f);
                final JalviewFileChooser jfc = this;
                this.backupfilesCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JalviewFileChooser.this.includeBackupFiles = JalviewFileChooser.this.backupfilesCheckBox.isSelected();
                        Cache.setProperty("BACKUPFILES_FC_INCLUDE", String.valueOf(JalviewFileChooser.this.includeBackupFiles));
                        FileFilter f = jfc.getFileFilter();
                        File selectedFile = jfc.getSelectedFile();
                        if (selectedFile != null && !f.accept(selectedFile)) {
                            jfc.setSelectedFile(null);
                        }
                        String s = jfc.getApproveButtonText();
                        jfc.firePropertyChange("ApproveButtonTextChangedProperty", null, s);
                        jfc.firePropertyChange("fileFilterChanged", null, f);
                        jfc.rescanCurrentDirectory();
                        jfc.revalidate();
                        jfc.repaint();
                    }
                });
            }
            multi.add(this.backupfilesCheckBox);
        } else {
            this.includeBackupFiles = false;
        }
        this.setAccessory(multi);
    }

    private static void setByExtensionTooltip(JComboBox dd) {
        if (dd.getItemCount() > 0 && dd.getItemAt(0) instanceof JalviewFileFilter) {
            if (((JalviewFileFilter)dd.getSelectedItem()).isMultiFormat()) {
                if (byExtensionTooltip == null) {
                    StringBuilder sb = new StringBuilder(MessageManager.getString("label.by_extension_tooltip"));
                    JalviewFileFilter jvf = (JalviewFileFilter)dd.getSelectedItem();
                    Iterator<String> extensions = jvf.getExtensions();
                    if (extensions.hasNext()) {
                        sb.append("\n(.");
                        while (extensions.hasNext()) {
                            sb.append(extensions.next());
                            if (!extensions.hasNext()) continue;
                            sb.append(", .");
                        }
                        sb.append(")");
                    }
                    byExtensionTooltip = sb.toString();
                }
                dd.setToolTipText(byExtensionTooltip);
            } else {
                dd.setToolTipText(null);
            }
        }
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        try {
            if (this.getUI() instanceof BasicFileChooserUI) {
                final BasicFileChooserUI fcui = (BasicFileChooserUI)this.getUI();
                final String name = fcui.getFileName().trim();
                if (name == null || name.length() == 0) {
                    return;
                }
                EventQueue.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        String currentName = fcui.getFileName();
                        if (currentName == null || currentName.length() == 0) {
                            fcui.setFileName(name);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FileFormatI getSelectedFormat() {
        if (this.getFileFilter() == null) {
            return null;
        }
        String format = this.getFileFilter().getDescription();
        int parenPos = format.indexOf("(");
        if (parenPos > 0) {
            format = format.substring(0, parenPos).trim();
            try {
                return FileFormats.getInstance().forName(format);
            }
            catch (IllegalArgumentException e) {
                Console.errPrintln("Unexpected format: " + format);
            }
        }
        return null;
    }

    public boolean setSelectedFormat(FileFormatI format) {
        if (format == null) {
            return false;
        }
        String toSelect = format.getName();
        for (FileFilter available : this.getChoosableFileFilters()) {
            if (!(available instanceof JalviewFileFilter) || !((JalviewFileFilter)available).getDescription().equals(toSelect)) continue;
            this.setFileFilter(available);
            return true;
        }
        return false;
    }

    @Override
    public File getSelectedFile() {
        File f = super.getSelectedFile();
        return f == null ? this.selectedFile : f;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setAccessory(null);
        this.setSelectedFile(null);
        return super.showSaveDialog(parent);
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() != 1) {
            super.approveSelection();
            return;
        }
        this.selectedFile = this.getSelectedFile();
        if (this.selectedFile == null) {
            try {
                String filename = ((BasicFileChooserUI)this.getUI()).getFileName();
                if (filename != null && filename.length() > 0) {
                    this.selectedFile = new File(this.getCurrentDirectory(), filename);
                }
            }
            catch (Throwable x) {
                Console.errPrintln("Unexpected exception when trying to get filename.");
                x.printStackTrace();
            }
        }
        if (this.selectedFile == null) {
            return;
        }
        if (this.getFileFilter() instanceof JalviewFileFilter) {
            JalviewFileFilter jvf = (JalviewFileFilter)this.getFileFilter();
            if (!jvf.accept(this.selectedFile) && !jvf.isMultiFormat()) {
                String withExtension = this.getSelectedFile().getName() + "." + jvf.getAcceptableExtension();
                this.selectedFile = new File(this.getCurrentDirectory(), withExtension);
                this.setSelectedFile(this.selectedFile);
            } else if (jvf.isMultiFormat() && jvf.accept(this.selectedFile)) {
                for (FileFilter jff : this.getChoosableFileFilters()) {
                    if (jvf == jff || !jff.accept(this.selectedFile)) continue;
                    this.setFileFilter(jff);
                    return;
                }
            }
        }
        if (this.selectedFile.exists()) {
            int confirm;
            int n = confirm = Cache.getDefault("CONFIRM_OVERWRITE_FILE", true) ? JvOptionPane.showConfirmDialog(this, MessageManager.getString("label.overwrite_existing_file"), MessageManager.getString("label.file_already_exists"), 0) : 0;
            if (confirm != 0) {
                return;
            }
        }
        super.approveSelection();
    }

    void recentListSelectionChanged(Object selection) {
        this.setSelectedFile(null);
        if (selection != null) {
            JalviewFileFilter jvf;
            File file = new File((String)selection);
            if (this.getFileFilter() instanceof JalviewFileFilter && !(jvf = (JalviewFileFilter)this.getFileFilter()).accept(file)) {
                this.setFileFilter(this.getChoosableFileFilters()[0]);
            }
            if (!file.isAbsolute() && file.exists()) {
                file = file.getAbsoluteFile();
            }
            this.setSelectedFile(file);
        }
    }

    @Override
    public DialogRunnerI setResponseHandler(Object response, Runnable action) {
        this.callbacks.put(response, action);
        return this;
    }

    @Override
    public void handleResponse(Object response) {
        if (response != null && !response.equals(response)) {
            return;
        }
        Runnable action = this.callbacks.get(response);
        if (action != null) {
            try {
                action.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "SelectedFile": {
                this.handleResponse(0);
            }
        }
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        dialog.setIconImages(ChannelProperties.getIconList());
        return dialog;
    }

    public static String defaultLoadFileFormat() {
        return FileLoader.getUseDefaultFileFormat() ? Cache.getProperty(DEFAULT_FORMAT_PROPERTY) : null;
    }

    public static String defaultSaveFileFormat(String lastUsedFormat) {
        if (!Cache.getDefault(ALWAYS_USE_DEFAULT_SAVED_FORMAT_PROPERTY, false) && lastUsedFormat != null) {
            return lastUsedFormat;
        }
        String pref = Cache.getDefault(DEFAULT_SAVE_FORMAT_PROPERTY, null);
        if (USE_LAST_SAVED_FORMAT_VALUE.equals(pref)) {
            FileFormatI globalLastSavedFormat = AlignFrame.getLastAlignmentSavedFormat();
            if (globalLastSavedFormat != null || lastUsedFormat != null) {
                return globalLastSavedFormat != null ? globalLastSavedFormat.toString() : lastUsedFormat;
            }
            pref = null;
        }
        return pref == null ? FileFormat.Fasta.getName() : pref;
    }

    class recentlyOpenedCellRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private static final int maxChars = 46;
        private static final String ellipsis = "...";

        recentlyOpenedCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayFilename;
            String filename = value.toString();
            if (filename.length() > 46) {
                StringBuilder displayFileSB = new StringBuilder();
                File file = new File(filename);
                displayFileSB.append(file.getName());
                if (file.getParent() != null) {
                    File parent = file;
                    boolean spaceleft = true;
                    while (spaceleft && parent.getParent() != null) {
                        parent = parent.getParentFile();
                        String name = parent.getName();
                        displayFileSB.insert(0, File.separator);
                        if (displayFileSB.length() + name.length() < 45) {
                            displayFileSB.insert(0, name);
                            continue;
                        }
                        displayFileSB.insert(0, ellipsis);
                        spaceleft = false;
                    }
                    if (spaceleft && filename.startsWith(File.separator) && displayFileSB.charAt(0) != File.separatorChar) {
                        displayFileSB.insert(0, File.separator);
                    }
                }
                displayFilename = displayFileSB.toString();
            } else {
                displayFilename = filename;
            }
            this.setText(displayFilename.toString());
            this.setToolTipText(filename);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setHorizontalAlignment(11);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont().deriveFont(12.0f));
            this.setOpaque(true);
            return this;
        }
    }

    class RecentlyOpened
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JList<String> list;

        RecentlyOpened() {
            this.setPreferredSize(new Dimension(300, 100));
            String historyItems = Cache.getProperty("RECENT_FILE");
            Vector<String> recent = new Vector<String>();
            if (historyItems != null) {
                StringTokenizer st = new StringTokenizer(historyItems, "\t");
                while (st.hasMoreTokens()) {
                    recent.addElement(st.nextToken());
                }
            }
            this.list = new JList(recent);
            this.list.setCellRenderer(new recentlyOpenedCellRenderer());
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    JalviewFileChooser.this.recentListSelectionChanged(RecentlyOpened.this.list.getSelectedValue());
                }
            });
            TitledBorder recentlyOpenedBorder = new TitledBorder(MessageManager.getString("label.recently_opened"));
            recentlyOpenedBorder.setTitleFont(recentlyOpenedBorder.getTitleFont().deriveFont(10.0f));
            this.setBorder(recentlyOpenedBorder);
            final JScrollPane scroller = new JScrollPane(this.list);
            SpringLayout layout = new SpringLayout();
            layout.putConstraint("West", (Component)scroller, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)scroller, 5, "North", (Component)this);
            scroller.setPreferredSize(new Dimension(280, 105));
            this.add(scroller);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    scroller.getHorizontalScrollBar().setValue(scroller.getHorizontalScrollBar().getMaximum());
                }
            });
        }
    }
}

