/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Console;
import jalview.datamodel.DBRefEntry;
import jalview.io.EMBLLikeFlatFile;
import jalview.io.FileParse;
import jalview.util.DBRefUtils;
import java.io.IOException;

public class EmblFlatFile
extends EMBLLikeFlatFile {
    public EmblFlatFile(FileParse fp, String sourceId) throws IOException {
        super(fp, sourceId);
    }

    @Override
    public void parse() throws IOException {
        String line = this.nextLine();
        while (line != null) {
            if (line.startsWith("ID")) {
                line = this.parseID(line);
                continue;
            }
            if (line.startsWith("DE")) {
                line = this.parseDE(line);
                continue;
            }
            if (line.startsWith("DR")) {
                line = this.parseDR(line);
                continue;
            }
            if (line.startsWith("SQ")) {
                line = this.parseSequence();
                continue;
            }
            if (line.startsWith("FT")) {
                line = this.parseFeature(line.substring(2));
                continue;
            }
            line = this.nextLine();
        }
        this.buildSequence();
    }

    String parseID(String line) throws IOException {
        String[] bits;
        String[] tokens = line.substring(2).split(";");
        String token = tokens[0].trim();
        if (!token.isEmpty()) {
            this.accession = token;
        }
        if (tokens.length > 1 && (token = tokens[1].trim()).startsWith("SV")) {
            bits = token.trim().split("\\s+");
            this.version = bits[bits.length - 1];
        }
        if (tokens.length > 6) {
            token = tokens[6].trim();
            bits = token.trim().split("\\s+");
            try {
                this.length = Integer.valueOf(bits[0]);
            }
            catch (NumberFormatException e) {
                Console.error("bad length read in flatfile, line: " + line);
            }
        }
        return this.nextLine();
    }

    String parseDE(String line) throws IOException {
        String desc = line.substring(2).trim();
        if (desc.endsWith(".")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        this.description = desc;
        while ((line = this.nextLine()) != null && line.startsWith("DE")) {
        }
        return line;
    }

    String parseDR(String line) throws IOException {
        String[] tokens = line.substring(2).split(";");
        if (tokens.length > 1) {
            String secondaryId;
            String db = tokens[0].trim();
            db = DBRefUtils.getCanonicalName(db);
            String acc = tokens[1].trim();
            if (acc.endsWith(".")) {
                acc = acc.substring(0, acc.length() - 1);
            }
            String version = "0";
            if (tokens.length <= 2 || !(secondaryId = tokens[2].trim()).isEmpty()) {
                // empty if block
            }
            this.dbrefs.add(new DBRefEntry(db, version, acc));
        }
        return this.nextLine();
    }

    @Override
    protected boolean isFeatureContinuationLine(String line) {
        return line.startsWith("FT    ");
    }
}

