/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.log.JLoggerI;
import jalview.log.JLoggerLog4j;
import jalview.log.JalviewAppender;
import jalview.util.ChannelProperties;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.text.DefaultCaret;
import org.apache.logging.log4j.core.Appender;

public class Console
extends WindowAdapter
implements WindowListener,
ActionListener,
Runnable {
    private JFrame frame;
    private JTextArea textArea;
    int byteslim = 102400;
    int bytescut = 76800;
    private Thread reader;
    private Thread reader2;
    private Thread textAppender;
    private boolean quit;
    private final PrintStream stdout = System.out;
    private final PrintStream stderr = System.err;
    private PipedInputStream pin = new PipedInputStream();
    private PipedInputStream pin2 = new PipedInputStream();
    private StringBuffer displayPipe = new StringBuffer();
    Thread errorThrower;
    Desktop parent = null;
    private int MIN_WIDTH = 300;
    private int MIN_HEIGHT = 250;
    private JComboBox<JLoggerI.LogLevel> logLevelCombo = new JComboBox();
    protected JLoggerI.LogLevel startingLogLevel = null;
    PipedOutputStream pout = null;
    PipedOutputStream perr = null;
    private String header = null;
    private boolean updateConsole = false;

    public Console() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame = this.initFrame("Java Console", screenSize.width / 2, screenSize.height / 2, -1, -1);
        this.frame.setDefaultCloseOperation(2);
        this.initConsole(true);
    }

    private void initConsole(boolean visible) {
        this.initConsole(visible, true);
    }

    private void initConsole(boolean visible, boolean redirect) {
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        final DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        final MatteBorder pausedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.textArea.getForeground());
        final Border noBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        final JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setBorder(noBorder);
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (caret.getUpdatePolicy() == 2) {
                        caret.setUpdatePolicy(1);
                        scrollPane.setBorder(pausedBorder);
                    } else {
                        caret.setUpdatePolicy(2);
                        Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                        scrollPane.setBorder(noBorder);
                    }
                }
            }
        });
        JButton clearButton = new JButton(MessageManager.getString("action.clear"));
        JButton copyToClipboardButton = new JButton(MessageManager.getString("label.copy_to_clipboard"));
        copyToClipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.copyConsoleTextToClipboard();
            }
        });
        copyToClipboardButton.addMouseListener(new MouseAdapter(){
            private Color bg;
            private Color fg;
            {
                this.bg = Console.this.textArea.getBackground();
                this.fg = Console.this.textArea.getForeground();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Console.this.textArea.setBackground(Console.this.textArea.getSelectionColor());
                Console.this.textArea.setForeground(Console.this.textArea.getSelectedTextColor());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Console.this.textArea.setBackground(this.bg);
                Console.this.textArea.setForeground(this.fg);
            }
        });
        copyToClipboardButton.setToolTipText(MessageManager.getString("label.copy_to_clipboard_tooltip"));
        JLabel logLevelLabel = new JLabel(MessageManager.getString("label.log_level") + ":");
        this.logLevelCombo.addItem(JLoggerI.LogLevel.TRACE);
        this.logLevelCombo.addItem(JLoggerI.LogLevel.DEBUG);
        this.logLevelCombo.addItem(JLoggerI.LogLevel.INFO);
        this.logLevelCombo.addItem(JLoggerI.LogLevel.WARN);
        this.startingLogLevel = jalview.bin.Console.getLogger() == null ? jalview.bin.Console.getCachedLogLevel() : jalview.bin.Console.getLogger().getLevel();
        this.setChosenLogLevelCombo();
        this.logLevelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jalview.bin.Console.log != null) {
                    jalview.bin.Console.log.setLevel((JLoggerI.LogLevel)((Object)Console.this.logLevelCombo.getSelectedItem()));
                }
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridBagLayout());
        JPanel logLevelPanel = new JPanel();
        logLevelPanel.setAlignmentX(0.0f);
        logLevelPanel.add(logLevelLabel);
        logLevelPanel.add(this.logLevelCombo);
        String logLevelTooltip = MessageManager.formatMessage("label.log_level_tooltip", this.startingLogLevel.toString());
        logLevelLabel.setToolTipText(logLevelTooltip);
        this.logLevelCombo.setToolTipText(logLevelTooltip);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.1;
        southPanel.add((Component)logLevelPanel, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.8;
        gbc.fill = 2;
        southPanel.add((Component)clearButton, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.1;
        gbc.fill = 0;
        southPanel.add((Component)copyToClipboardButton, gbc);
        southPanel.setVisible(true);
        this.frame.getContentPane().add((Component)southPanel, "South");
        this.frame.setVisible(visible);
        this.updateConsole = visible;
        this.frame.addWindowListener(this);
        clearButton.addActionListener(this);
        if (redirect) {
            this.redirectStreams();
        } else {
            this.unredirectStreams();
        }
        this.quit = false;
        this.reader = new Thread(this);
        this.reader.setDaemon(true);
        this.reader.start();
        this.reader2 = new Thread(this);
        this.reader2.setDaemon(true);
        this.reader2.start();
        this.textAppender = new Thread(this);
        this.textAppender.setDaemon(true);
        this.textAppender.start();
        this.frame.setIconImages(ChannelProperties.getIconList());
    }

    private void setChosenLogLevelCombo() {
        this.setChosenLogLevelCombo(this.startingLogLevel);
    }

    private void setChosenLogLevelCombo(JLoggerI.LogLevel setLogLevel) {
        this.logLevelCombo.setSelectedItem((Object)setLogLevel);
        if (!this.logLevelCombo.getSelectedItem().equals((Object)setLogLevel)) {
            if (setLogLevel != null && setLogLevel instanceof JLoggerI.LogLevel) {
                boolean added = false;
                for (int i = 0; i < this.logLevelCombo.getItemCount(); ++i) {
                    JLoggerI.LogLevel l = this.logLevelCombo.getItemAt(i);
                    if (l.compareTo(setLogLevel) < 0) continue;
                    this.logLevelCombo.insertItemAt(setLogLevel, i);
                    added = true;
                    break;
                }
                if (!added) {
                    this.logLevelCombo.addItem(setLogLevel);
                }
                this.logLevelCombo.setSelectedItem((Object)setLogLevel);
            } else {
                this.logLevelCombo.setSelectedItem((Object)JLoggerI.LogLevel.INFO);
            }
        }
    }

    private void copyConsoleTextToClipboard() {
        String consoleText = this.textArea.getText();
        StringSelection consoleTextSelection = new StringSelection(consoleText);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(consoleTextSelection, null);
    }

    public void redirectStreams() {
        if (this.pout == null) {
            try {
                this.pout = new PipedOutputStream(this.pin);
                System.setOut(new PrintStream(this.pout, true));
            }
            catch (IOException io) {
                this.textArea.append("Couldn't redirect STDOUT to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't redirect STDOUT to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
            try {
                this.perr = new PipedOutputStream(this.pin2);
                System.setErr(new PrintStream(this.perr, true));
            }
            catch (IOException io) {
                this.textArea.append("Couldn't redirect STDERR to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't redirect STDERR to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
        }
    }

    public void unredirectStreams() {
        if (this.pout != null) {
            try {
                System.setOut(this.stdout);
                this.pout.flush();
                this.pout.close();
                this.pin = new PipedInputStream();
                this.pout = null;
            }
            catch (IOException io) {
                this.textArea.append("Couldn't unredirect STDOUT to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't unredirect STDOUT to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
            try {
                System.setErr(this.stderr);
                this.perr.flush();
                this.perr.close();
                this.pin2 = new PipedInputStream();
                this.perr = null;
            }
            catch (IOException io) {
                this.textArea.append("Couldn't unredirect STDERR to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't unredirect STDERR to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
        }
    }

    public void test() {
        jalview.bin.Console.outPrintln("Hello World 2");
        jalview.bin.Console.outPrintln("All fonts available to Graphic2D:\n");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        for (int n = 0; n < fontNames.length; ++n) {
            jalview.bin.Console.outPrintln(fontNames[n]);
        }
        jalview.bin.Console.outPrintln("\nLets throw an error on this console");
        this.errorThrower = new Thread(this);
        this.errorThrower.setDaemon(true);
        this.errorThrower.start();
    }

    private JFrame initFrame(String string, int i, int j, int x, int y) {
        JFrame frame = new JFrame(string);
        frame.setName(string);
        if (x == -1) {
            x = i / 2;
        }
        if (y == -1) {
            y = j / 2;
        }
        frame.setBounds(x, y, i, j);
        return frame;
    }

    public Console(Desktop desktop) {
        Rectangle bounds;
        this.parent = desktop;
        Rectangle rectangle = bounds = this.parent == null ? null : this.parent.getLastKnownDimensions("JAVA_CONSOLE_");
        this.frame = bounds != null ? this.initFrame(ChannelProperties.getProperty("app_name") + " Java Console", bounds.width, bounds.height, bounds.x, bounds.y) : (this.parent != null && this.parent.getWidth() > 0 && this.parent.getHeight() > 0 ? this.initFrame(ChannelProperties.getProperty("app_name") + " Java Console", this.parent.getWidth() / 2, this.parent.getHeight() / 4, this.parent.getX(), this.parent.getY()) : this.initFrame(ChannelProperties.getProperty("app_name") + " Java Console", this.MIN_WIDTH, this.MIN_HEIGHT, 10, 10));
        this.frame.setMinimumSize(new Dimension(this.MIN_WIDTH, this.MIN_HEIGHT));
        this.initConsole(false);
        JLoggerI.LogLevel level = (JLoggerI.LogLevel)((Object)this.logLevelCombo.getSelectedItem());
        if (!Platform.isJS()) {
            JalviewAppender jappender = new JalviewAppender(level);
            JalviewAppender.setTextArea(this.textArea);
            jappender.start();
            if (jalview.bin.Console.log != null && jalview.bin.Console.log instanceof JLoggerLog4j) {
                JLoggerLog4j.addAppender(jalview.bin.Console.log, (Appender)jappender);
            }
        }
    }

    public synchronized void stopConsole() {
        this.quit = true;
        this.notifyAll();
        if (this.pout != null) {
            try {
                this.reader.join(10L);
                this.pin.close();
            }
            catch (Exception e) {
                jalview.bin.Console.debug("pin.close() error", e);
            }
            try {
                this.reader2.join(10L);
                this.pin2.close();
            }
            catch (Exception e) {
                jalview.bin.Console.debug("pin2.close() error", e);
            }
            try {
                this.textAppender.join(10L);
            }
            catch (Exception e) {
                jalview.bin.Console.debug("textAppender.join(10) error", e);
            }
        }
    }

    @Override
    public synchronized void windowClosed(WindowEvent evt) {
        this.frame.setVisible(false);
        this.closeConsoleGui();
    }

    private void closeConsoleGui() {
        this.updateConsole = false;
        if (this.parent == null) {
            this.stopConsole();
        } else {
            this.parent.showConsole(false);
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent evt) {
        this.frame.setVisible(false);
        this.closeConsoleGui();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        this.trimBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            long time;
            String input;
            while (Thread.currentThread() == this.reader) {
                if (this.pin == null || this.pin.available() == 0) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        jalview.bin.Console.debug("pin.available() error", ie);
                    }
                }
                while (this.pin.available() != 0) {
                    input = this.readLine(this.pin);
                    this.stdout.print(input);
                    time = System.nanoTime();
                    this.appendToTextArea(input);
                }
                if (!this.quit) continue;
                return;
            }
            while (Thread.currentThread() == this.reader2) {
                if (this.pin2.available() == 0) {
                    try {
                        this.wait(100L);
                        if (this.pin2.available() == 0) {
                            this.trimBuffer(false);
                        }
                    }
                    catch (InterruptedException ie) {
                        jalview.bin.Console.debug("pin.available() error", ie);
                    }
                }
                while (this.pin2.available() != 0) {
                    input = this.readLine(this.pin2);
                    this.stderr.print(input);
                    time = System.nanoTime();
                    this.appendToTextArea(input);
                }
                if (!this.quit) continue;
                return;
            }
            while (Thread.currentThread() == this.textAppender) {
                if (this.updateConsole) {
                    while (this.displayPipe.length() > 0) {
                        StringBuffer replace;
                        StringBuffer tmp = new StringBuffer();
                        StringBuffer stringBuffer = this.displayPipe;
                        synchronized (stringBuffer) {
                            replace = this.displayPipe;
                            this.displayPipe = tmp;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Console.this.textArea.append(replace.toString());
                                Console.this.trimBuffer(false);
                            }
                        });
                    }
                    if (this.displayPipe.length() == 0) {
                        try {
                            this.wait(100L);
                            if (this.displayPipe.length() == 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Console.this.trimBuffer(false);
                                    }
                                });
                            }
                        }
                        catch (InterruptedException e) {
                            jalview.bin.Console.debug("displayPipe.length() error", e);
                        }
                    }
                } else {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        jalview.bin.Console.debug("this.wait(100) error", e);
                    }
                }
                if (!this.quit) continue;
                return;
            }
        }
        catch (Exception e) {
            this.textArea.append("\nConsole reports an Internal error.");
            this.textArea.append("The error is: " + e.getMessage());
            this.stderr.println("Console reports an Internal error.\nThe error is: " + e);
        }
        if (Thread.currentThread() == this.errorThrower) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {
                jalview.bin.Console.debug("this.wait(1000) error", ie);
            }
            throw new NullPointerException(MessageManager.getString("exception.application_test_npe"));
        }
    }

    private void appendToTextArea(final String input) {
        if (!this.updateConsole) {
            return;
        }
        long time = System.nanoTime();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Console.this.displayPipe.append(input);
            }
        });
    }

    private synchronized void trimBuffer(boolean clear) {
        if (this.header == null && this.textArea.getLineCount() > 5) {
            try {
                this.header = this.textArea.getText(0, this.textArea.getLineStartOffset(5)) + "\nTruncated...\n";
            }
            catch (Exception e) {
                jalview.bin.Console.warn("textArea Exception", e);
            }
        }
        int tlength = this.textArea.getDocument().getLength();
        if (this.header != null && (clear || tlength > this.byteslim)) {
            try {
                if (!clear) {
                    long time = System.nanoTime();
                    this.textArea.replaceRange(this.header, 0, tlength - this.bytescut);
                } else {
                    this.textArea.setText(this.header);
                }
            }
            catch (Exception e) {
                jalview.bin.Console.warn("textArea Exception", e);
            }
        }
    }

    public synchronized String readLine(PipedInputStream in) throws IOException {
        int available;
        Object input = "";
        int lp = -1;
        while ((available = in.available()) != 0) {
            byte[] b = new byte[available];
            in.read(b);
            if (!((String)(input = (String)input + new String(b, 0, b.length))).endsWith("\n") && !((String)input).endsWith("\r\n") && !this.quit) continue;
        }
        return input;
    }

    public static void main(String[] arg) {
        new Console().test();
    }

    public void setVisible(boolean selected) {
        this.frame.setVisible(selected);
        if (selected) {
            this.setChosenLogLevelCombo();
            this.redirectStreams();
            this.updateConsole = true;
            this.frame.toFront();
        } else {
            if (jalview.bin.Console.log != null) {
                jalview.bin.Console.log.setLevel(this.startingLogLevel);
            }
            this.unredirectStreams();
            this.updateConsole = false;
        }
    }

    public Rectangle getBounds() {
        if (this.frame != null) {
            return this.frame.getBounds();
        }
        return null;
    }

    public void setHeader(String string) {
        this.header = string;
        if (this.header.charAt(this.header.length() - 1) != '\n') {
            this.header = this.header + "\n";
        }
        this.textArea.insert(this.header, 0);
    }

    public String getHeader() {
        return this.header;
    }
}

