/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import jalview.ext.rbvi.chimera.ChimeraCommands;
import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureCommandsI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChimeraXCommands
extends ChimeraCommands {
    private static final StructureCommand LIST_RESIDUE_ATTRIBUTES = new StructureCommand("info resattr", new String[0]);
    private static final StructureCommand CLOSE_CHIMERAX = new StructureCommand("exit", new String[0]);
    private static final StructureCommand STOP_NOTIFY_SELECTION = new StructureCommand("info notify stop selection jalview", new String[0]);
    private static final StructureCommand STOP_NOTIFY_MODELS = new StructureCommand("info notify stop models jalview", new String[0]);
    private static final StructureCommand GET_SELECTION = new StructureCommand("info selection level residue", new String[0]);
    private static final StructureCommand SHOW_BACKBONE = new StructureCommand("~display all;~ribbon;show @CA|P atoms", new String[0]);
    private static final StructureCommand FOCUS_VIEW = new StructureCommand("view", new String[0]);
    private static final StructureCommandI COLOUR_BY_CHARGE = new StructureCommand("color white;color :ASP,GLU red;color :LYS,ARG blue;color :CYS yellow", new String[0]);

    @Override
    public List<StructureCommandI> colourByCharge() {
        return Arrays.asList(COLOUR_BY_CHARGE);
    }

    @Override
    public String getResidueSpec(String residue) {
        return ":" + residue;
    }

    @Override
    public StructureCommandI colourResidues(String atomSpec, Color colour) {
        String colourCode = this.getColourString(colour);
        return new StructureCommand("color " + atomSpec + " " + colourCode, new String[0]);
    }

    @Override
    public StructureCommandI focusView() {
        return FOCUS_VIEW;
    }

    @Override
    public int getModelStartNo() {
        return 1;
    }

    @Override
    protected StructureCommandI setAttribute(String attributeName, String attributeValue, AtomSpecModel atomSpecModel) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("setattr ").append(this.getAtomSpec(atomSpecModel, StructureCommandsI.AtomSpecType.RESIDUE_ONLY));
        sb.append(" res ").append(attributeName).append(" '").append(attributeValue).append("'");
        sb.append(" create true");
        return new StructureCommand(sb.toString(), new String[0]);
    }

    @Override
    public StructureCommandI openCommandFile(String path) {
        return new StructureCommand("open " + path, new String[0]);
    }

    @Override
    public StructureCommandI saveSession(String filepath) {
        return new StructureCommand("save " + filepath + " format session", new String[0]);
    }

    @Override
    public String getAtomSpec(AtomSpecModel atomSpec, StructureCommandsI.AtomSpecType specType) {
        StringBuilder sb = new StringBuilder(128);
        boolean firstModel = true;
        for (String model : atomSpec.getModels()) {
            if (!firstModel) {
                sb.append("|");
            }
            firstModel = false;
            this.appendModel(sb, model, atomSpec);
            if (specType == StructureCommandsI.AtomSpecType.ALPHA) {
                sb.append("@CA");
            }
            if (specType != StructureCommandsI.AtomSpecType.PHOSPHATE) continue;
            sb.append("@P");
        }
        return sb.toString();
    }

    protected void appendModel(StringBuilder sb, String model, AtomSpecModel atomSpec) {
        sb.append("#").append(model);
        for (String chain : atomSpec.getChains(model)) {
            boolean firstPositionForChain = true;
            sb.append("/").append(chain.trim()).append(":");
            List<int[]> rangeList = atomSpec.getRanges(model, chain);
            boolean first = true;
            for (int[] range : rangeList) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                this.appendRange(sb, range[0], range[1], chain, firstPositionForChain, true);
            }
        }
    }

    @Override
    public List<StructureCommandI> showBackbone() {
        return Arrays.asList(SHOW_BACKBONE);
    }

    @Override
    public List<StructureCommandI> superposeStructures(AtomSpecModel ref, AtomSpecModel spec, StructureCommandsI.AtomSpecType backbone) {
        StringBuilder cmd = new StringBuilder();
        String atomSpec = this.getAtomSpec(spec, backbone);
        String refSpec = this.getAtomSpec(ref, backbone);
        cmd.append("align ").append(atomSpec).append(" toAtoms ").append(refSpec);
        cmd.append("; ribbon ");
        cmd.append(this.getAtomSpec(spec, StructureCommandsI.AtomSpecType.RESIDUE_ONLY)).append("|");
        cmd.append(this.getAtomSpec(ref, StructureCommandsI.AtomSpecType.RESIDUE_ONLY)).append("; view");
        return Arrays.asList(new StructureCommand(cmd.toString(), new String[0]));
    }

    @Override
    public StructureCommandI openSession(String filepath) {
        return new StructureCommand("open " + filepath + " format session", new String[0]);
    }

    @Override
    public StructureCommandI closeViewer() {
        return CLOSE_CHIMERAX;
    }

    @Override
    public List<StructureCommandI> startNotifications(String uri) {
        ArrayList<StructureCommandI> cmds = new ArrayList<StructureCommandI>();
        cmds.add(new StructureCommand("info notify start models jalview prefix ModelChanged url " + uri, new String[0]));
        cmds.add(new StructureCommand("info notify start selection jalview prefix SelectionChanged url " + uri, new String[0]));
        return cmds;
    }

    @Override
    public List<StructureCommandI> stopNotifications() {
        ArrayList<StructureCommandI> cmds = new ArrayList<StructureCommandI>();
        cmds.add(STOP_NOTIFY_MODELS);
        cmds.add(STOP_NOTIFY_SELECTION);
        return cmds;
    }

    @Override
    public StructureCommandI getSelectedResidues() {
        return GET_SELECTION;
    }

    @Override
    public StructureCommandI listResidueAttributes() {
        return LIST_RESIDUE_ATTRIBUTES;
    }
}

