/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.pymol;

import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureCommandsBase;
import jalview.structure.StructureCommandsI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PymolCommands
extends StructureCommandsBase {
    private static final StructureCommand FOCUS_VIEW = new StructureCommand("zoom", new String[0]);
    private static final StructureCommand CLOSE_PYMOL = new StructureCommand("quit", new String[0]);
    private static final StructureCommand COLOUR_BY_CHAIN = new StructureCommand("spectrum", "chain");
    private static final List<StructureCommandI> COLOR_BY_CHARGE = Arrays.asList(new StructureCommand("color", "white", "*"), new StructureCommand("color", "red", "resn ASP resn GLU"), new StructureCommand("color", "blue", "resn LYS resn ARG"), new StructureCommand("color", "yellow", "resn CYS"));
    private static final List<StructureCommandI> SHOW_BACKBONE = Arrays.asList(new StructureCommand("hide", "everything"), new StructureCommand("show", "ribbon"));

    @Override
    public StructureCommandI colourByChain() {
        return COLOUR_BY_CHAIN;
    }

    @Override
    public List<StructureCommandI> colourByCharge() {
        return COLOR_BY_CHARGE;
    }

    @Override
    public StructureCommandI setBackgroundColour(Color col) {
        return new StructureCommand("bg_color", this.getColourString(col));
    }

    protected String getColourString(Color c) {
        return String.format("0x%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public StructureCommandI focusView() {
        return FOCUS_VIEW;
    }

    @Override
    public List<StructureCommandI> showChains(List<String> toShow) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        commands.add(new StructureCommand("hide", "everything"));
        commands.add(new StructureCommand("show", "lines"));
        StringBuilder chains = new StringBuilder();
        for (String chain : toShow) {
            chains.append(" chain ").append(chain);
        }
        commands.add(new StructureCommand("show", "cartoon", chains.toString()));
        return commands;
    }

    @Override
    public List<StructureCommandI> superposeStructures(AtomSpecModel refAtoms, AtomSpecModel atomSpec, StructureCommandsI.AtomSpecType specType) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        String refAtomsAlphaOnly = "(" + this.getAtomSpec(refAtoms, specType) + " and (altloc '' or altloc 'a'))";
        String atomSpec2AlphaOnly = "(" + this.getAtomSpec(atomSpec, specType) + " and (altloc '' or altloc 'a'))";
        commands.add(new StructureCommand("undo_disable", new String[0]));
        commands.add(new StructureCommand("pair_fit", atomSpec2AlphaOnly, refAtomsAlphaOnly));
        commands.add(new StructureCommand("undo_enable", new String[0]));
        String refAtomsAll = this.getAtomSpec(refAtoms, StructureCommandsI.AtomSpecType.RESIDUE_ONLY);
        String atomSpec2All = this.getAtomSpec(atomSpec, StructureCommandsI.AtomSpecType.RESIDUE_ONLY);
        commands.add(new StructureCommand("show", "cartoon", refAtomsAll + " " + atomSpec2All));
        return commands;
    }

    @Override
    public StructureCommandI openCommandFile(String path) {
        return new StructureCommand("run", path);
    }

    @Override
    public StructureCommandI saveSession(String filepath) {
        return new StructureCommand("save", filepath);
    }

    @Override
    public String getAtomSpec(AtomSpecModel model, StructureCommandsI.AtomSpecType specType) {
        StringBuilder sb = new StringBuilder(64);
        boolean first = true;
        for (String modelId : model.getModels()) {
            for (String chain : model.getChains(modelId)) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                List<int[]> rangeList = model.getRanges(modelId, chain);
                chain = chain.trim();
                sb.append(modelId).append("//").append(chain).append("/");
                boolean firstRange = true;
                for (int[] range : rangeList) {
                    if (!firstRange) {
                        sb.append("+");
                    }
                    firstRange = false;
                    sb.append(String.valueOf(range[0]));
                    if (range[0] == range[1]) continue;
                    sb.append("-").append(String.valueOf(range[1]));
                }
                sb.append("/");
                if (specType == StructureCommandsI.AtomSpecType.ALPHA) {
                    sb.append("CA");
                }
                if (specType != StructureCommandsI.AtomSpecType.PHOSPHATE) continue;
                sb.append("P");
            }
        }
        return sb.toString();
    }

    @Override
    public List<StructureCommandI> showBackbone() {
        return SHOW_BACKBONE;
    }

    @Override
    protected StructureCommandI colourResidues(String atomSpec, Color colour) {
        return new StructureCommand("color", this.getColourString(colour), atomSpec);
    }

    @Override
    protected String getResidueSpec(String residue) {
        return "resn " + residue;
    }

    @Override
    public StructureCommandI loadFile(String file) {
        return new StructureCommand("load", file);
    }

    @Override
    public List<StructureCommandI> colourBySequence(Map<Object, AtomSpecModel> colourMap) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        for (Object key : colourMap.keySet()) {
            Color colour = (Color)key;
            AtomSpecModel colourData = colourMap.get(colour);
            commands.add(this.getColourCommand(colourData, colour));
        }
        return commands;
    }

    protected StructureCommandI setAttribute(String attributeName, String attributeValue, AtomSpecModel atomSpecModel) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("p.").append(attributeName).append("='").append(attributeValue).append("'");
        String atomSpec = this.getAtomSpec(atomSpecModel, StructureCommandsI.AtomSpecType.RESIDUE_ONLY);
        return new StructureCommand("iterate", atomSpec, sb.toString());
    }

    @Override
    public List<StructureCommandI> setAttributes(Map<String, Map<Object, AtomSpecModel>> featureMap) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        for (String featureType : featureMap.keySet()) {
            String attributeName = this.makeAttributeName(featureType);
            Map<Object, AtomSpecModel> values = featureMap.get(featureType);
            for (Object value : values.keySet()) {
                AtomSpecModel atomSpecModel = values.get(value);
                String featureValue = value.toString();
                featureValue = featureValue.replaceAll("\\'", "&#39;");
                StructureCommandI cmd = this.setAttribute(attributeName, featureValue, atomSpecModel);
                commands.add(cmd);
            }
        }
        return commands;
    }

    @Override
    public StructureCommandI openSession(String filepath) {
        return new StructureCommand("load", filepath, "", "0", "pse");
    }

    @Override
    public StructureCommandI closeViewer() {
        return CLOSE_PYMOL;
    }

    @Override
    public List<StructureCommandI> centerViewOn(List<AtomSpecModel> residues) {
        return null;
    }
}

