/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.HiddenCursorPosition;
import java.util.ArrayList;
import java.util.List;

public class HiddenColumnsCursor {
    private int firstColumn;
    private List<int[]> hiddenColumns = new ArrayList<int[]>();
    private HiddenCursorPosition cursorPos = new HiddenCursorPosition(0, 0);

    protected HiddenColumnsCursor() {
    }

    protected HiddenColumnsCursor(List<int[]> hiddenCols) {
        this.resetCursor(hiddenCols, 0, 0);
    }

    protected HiddenColumnsCursor(List<int[]> hiddenCols, int index, int hiddencount) {
        this.resetCursor(hiddenCols, index, hiddencount);
    }

    private void resetCursor(List<int[]> hiddenCols, int index, int hiddencount) {
        this.hiddenColumns = hiddenCols;
        if (!hiddenCols.isEmpty()) {
            this.firstColumn = this.hiddenColumns.get(0)[0];
            this.cursorPos = new HiddenCursorPosition(index, hiddencount);
        }
    }

    protected HiddenCursorPosition findRegionForColumn(int column, boolean useVisible) {
        if (this.hiddenColumns.isEmpty()) {
            return null;
        }
        int offset = useVisible ? 1 : 0;
        HiddenCursorPosition pos = this.cursorPos;
        int index = pos.getRegionIndex();
        int hiddenCount = pos.getHiddenSoFar();
        pos = column < this.firstColumn ? new HiddenCursorPosition(0, 0) : (index < this.hiddenColumns.size() && this.hiddenColumns.get(index)[0] <= column + offset * hiddenCount ? this.searchForward(pos, column, useVisible) : this.searchBackward(pos, column, useVisible));
        this.cursorPos = pos;
        return pos;
    }

    private HiddenCursorPosition searchForward(HiddenCursorPosition pos, int column, boolean useVisible) {
        HiddenCursorPosition p = pos;
        if (useVisible) {
            while (p.getRegionIndex() < this.hiddenColumns.size() && this.hiddenColumns.get(p.getRegionIndex())[0] <= column + p.getHiddenSoFar()) {
                p = this.stepForward(p);
            }
        } else {
            while (p.getRegionIndex() < this.hiddenColumns.size() && this.hiddenColumns.get(p.getRegionIndex())[1] < column) {
                p = this.stepForward(p);
            }
        }
        return p;
    }

    private HiddenCursorPosition stepForward(HiddenCursorPosition p) {
        int[] region = this.hiddenColumns.get(p.getRegionIndex());
        return new HiddenCursorPosition(p.getRegionIndex() + 1, p.getHiddenSoFar() + region[1] - region[0] + 1);
    }

    private HiddenCursorPosition searchBackward(HiddenCursorPosition p, int column, boolean useVisible) {
        int offset;
        int i = p.getRegionIndex();
        int h = p.getHiddenSoFar();
        int n = offset = useVisible ? 1 : 0;
        while (i > 0 && this.hiddenColumns.get(i - 1)[1] >= column + offset * h) {
            int[] region = this.hiddenColumns.get(--i);
            h -= region[1] - region[0] + 1;
        }
        return new HiddenCursorPosition(i, h);
    }
}

