/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactListImpl;
import jalview.datamodel.ContactListProviderI;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.GroupSet;
import jalview.datamodel.GroupSetHolder;

public class FloatContactMatrix
extends GroupSetHolder
implements ContactMatrixI {
    int maxrow = 0;
    int maxcol = 0;
    float[][] elements;
    float maxscore;

    public FloatContactMatrix(float[][] matrix) {
        for (float[] row : matrix) {
            if (row.length > this.maxcol) {
                this.maxcol = row.length;
            }
            this.maxscore = row[0];
            for (float f : row) {
                if (!(this.maxscore < f)) continue;
                this.maxscore = f;
            }
        }
        this.maxrow = matrix.length;
        this.elements = matrix;
    }

    public FloatContactMatrix(float[][] elements2, GroupSet grps2) {
        this(elements2);
        this.setGroupSet(grps2);
    }

    @Override
    public ContactListI getContactList(final int column) {
        if (column < 0 || column >= this.elements.length) {
            return null;
        }
        return new ContactListImpl(new ContactListProviderI(){

            @Override
            public int getPosition() {
                return column;
            }

            @Override
            public int getContactHeight() {
                return FloatContactMatrix.this.maxcol - 1;
            }

            @Override
            public double getContactAt(int mcolumn) {
                if (mcolumn < 0 || mcolumn >= FloatContactMatrix.this.elements[column].length) {
                    return -1.0;
                }
                return FloatContactMatrix.this.elements[column][mcolumn];
            }
        });
    }

    @Override
    public double getElementAt(int _column, int i) {
        return this.elements[_column][i];
    }

    @Override
    public float getMin() {
        return 0.0f;
    }

    @Override
    public float getMax() {
        return this.maxscore;
    }

    @Override
    public String getAnnotDescr() {
        return null;
    }

    @Override
    public String getAnnotLabel() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public int getWidth() {
        return this.maxcol;
    }

    @Override
    public int getHeight() {
        return this.maxrow;
    }
}

