/*
 * Decompiled with CFR 0.152.
 */
package jalview.controller;

import jalview.analysis.AlignmentSorter;
import jalview.analysis.Grouping;
import jalview.api.AlignViewControllerGuiI;
import jalview.api.AlignViewControllerI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.commands.JustifyLeftOrRightCommand;
import jalview.commands.OrderCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.Desktop;
import jalview.io.DataSourceType;
import jalview.io.FeaturesFile;
import jalview.schemes.ColourSchemeI;
import jalview.util.MessageManager;
import java.awt.Color;
import java.util.BitSet;
import java.util.List;

public class AlignViewController
implements AlignViewControllerI {
    AlignViewportI viewport = null;
    AlignmentViewPanel alignPanel = null;
    private AlignViewControllerGuiI avcg;

    public AlignViewController(AlignViewControllerGuiI alignFrame, AlignViewportI vp, AlignmentViewPanel ap) {
        this.avcg = alignFrame;
        this.viewport = vp;
        this.alignPanel = ap;
    }

    @Override
    public void setViewportAndAlignmentPanel(AlignViewportI vp, AlignmentViewPanel ap) {
        this.alignPanel = ap;
        this.viewport = vp;
    }

    @Override
    public boolean makeGroupsFromSelection() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        ColumnSelection cs = this.viewport.getColumnSelection();
        SequenceGroup[] gps = null;
        if (sg != null && (cs == null || cs.isEmpty())) {
            gps = Grouping.makeGroupsFrom(this.viewport.getSequenceSelection(), this.viewport.getAlignmentView(true).getSequenceStrings(this.viewport.getGapCharacter()), this.viewport.getAlignment().getGroups());
        } else if (cs != null) {
            gps = Grouping.makeGroupsFromCols(sg == null ? this.viewport.getAlignment().getSequencesArray() : sg.getSequences().toArray(new SequenceI[0]), cs, this.viewport.getAlignment().getGroups());
        }
        if (gps != null) {
            this.viewport.getAlignment().deleteAllGroups();
            this.viewport.clearSequenceColours();
            this.viewport.setSelectionGroup(null);
            ColourSchemeI colours = this.viewport.getGlobalColourScheme();
            for (int g = 0; g < gps.length; ++g) {
                Color col;
                gps[g].setshowSequenceLogo(this.viewport.isShowSequenceLogo());
                this.viewport.getAlignment().addGroup(gps[g]);
                if (colours != null) {
                    gps[g].setColourScheme(colours.getInstance(this.viewport, gps[g]));
                }
                gps[g].idColour = col = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
                this.viewport.setUpdateStructures(true);
                this.viewport.addSequenceGroup(gps[g]);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean createGroup() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg != null) {
            this.viewport.getAlignment().addGroup(sg);
            return true;
        }
        return false;
    }

    @Override
    public boolean unGroup() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg != null) {
            this.viewport.getAlignment().deleteGroup(sg);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteGroups() {
        if (this.viewport.getAlignment().getGroups() != null && this.viewport.getAlignment().getGroups().size() > 0) {
            this.viewport.getAlignment().deleteAllGroups();
            this.viewport.clearSequenceColours();
            this.viewport.setSelectionGroup(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean markColumnsContainingFeatures(boolean invert, boolean extendCurrent, boolean toggle, String featureType) {
        BitSet bs = new BitSet();
        boolean searchSelection = this.viewport.getSelectionGroup() != null && !extendCurrent;
        AnnotatedCollectionI sqcol = searchSelection ? this.viewport.getSelectionGroup() : this.viewport.getAlignment();
        int nseq = this.findColumnsWithFeature(featureType, sqcol, bs);
        ColumnSelection cs = this.viewport.getColumnSelection();
        if (cs == null) {
            cs = new ColumnSelection();
        }
        if (bs.cardinality() > 0 || invert) {
            boolean changed = cs.markColumns(bs, sqcol.getStartRes(), sqcol.getEndRes(), invert, extendCurrent, toggle);
            if (changed) {
                this.viewport.setColumnSelection(cs);
                this.alignPanel.paintAlignment(false, false);
                int columnCount = invert ? sqcol.getEndRes() - sqcol.getStartRes() + 1 - bs.cardinality() : bs.cardinality();
                this.avcg.setStatus(MessageManager.formatMessage("label.view_controller_toggled_marked", new String[]{toggle ? MessageManager.getString("label.toggled") : MessageManager.getString("label.marked"), String.valueOf(columnCount), invert ? MessageManager.getString("label.not_containing") : MessageManager.getString("label.containing"), featureType, Integer.valueOf(nseq).toString()}));
                return true;
            }
        } else {
            String key = searchSelection ? "label.no_feature_found_selection" : "label.no_feature_of_type_found";
            this.avcg.setStatus(MessageManager.formatMessage(key, new String[]{featureType}));
            if (!extendCurrent) {
                cs.clear();
                this.alignPanel.paintAlignment(false, false);
            }
        }
        return false;
    }

    int findColumnsWithFeature(String featureType, SequenceCollectionI sqcol, BitSet bs) {
        FeatureRenderer fr = this.alignPanel == null ? null : this.alignPanel.getFeatureRenderer();
        int startColumn = sqcol.getStartRes() + 1;
        int endColumn = sqcol.getEndRes() + 1;
        List<SequenceI> seqs = sqcol.getSequences();
        int nseq = 0;
        for (SequenceI sq : seqs) {
            if (sq == null) continue;
            List<SequenceFeature> sfs = sq.findFeatures(startColumn, endColumn, featureType);
            boolean found = false;
            for (SequenceFeature sf : sfs) {
                if (fr.getColour(sf) == null) continue;
                if (!found) {
                    ++nseq;
                }
                found = true;
                int sfStartCol = sq.findIndex(sf.getBegin());
                int sfEndCol = sq.findIndex(sf.getEnd());
                if (sf.isContactFeature()) {
                    if (sfStartCol >= startColumn && sfStartCol <= endColumn) {
                        bs.set(sfStartCol - 1);
                    }
                    if (sfEndCol < startColumn || sfEndCol > endColumn) continue;
                    bs.set(sfEndCol - 1);
                    continue;
                }
                if (sfStartCol < startColumn) {
                    sfStartCol = startColumn;
                }
                if (sfEndCol > endColumn) {
                    sfEndCol = endColumn;
                }
                while (sfStartCol <= sfEndCol) {
                    bs.set(sfStartCol - 1);
                    ++sfStartCol;
                }
            }
        }
        return nseq;
    }

    @Override
    public void sortAlignmentByFeatureDensity(List<String> typ) {
        String methodText = MessageManager.getString("label.sort_by_density");
        this.sortByFeatures(typ, methodText, AlignmentSorter.FEATURE_DENSITY);
    }

    protected void sortByFeatures(List<String> types, String methodText, String method) {
        int stop;
        int start;
        FeatureRenderer fr = this.alignPanel.getFeatureRenderer();
        if (types == null && fr != null) {
            types = fr.getDisplayedFeatureTypes();
        }
        if (types.isEmpty()) {
            return;
        }
        List<String> gps = null;
        if (fr != null) {
            gps = fr.getDisplayedFeatureGroups();
        }
        AlignmentI al = this.viewport.getAlignment();
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg != null) {
            start = sg.getStartRes();
            stop = sg.getEndRes();
        } else {
            start = 0;
            stop = al.getWidth();
        }
        SequenceI[] oldOrder = al.getSequencesArray();
        AlignmentSorter.sortByFeature(types, gps, start, stop, al, method);
        this.avcg.addHistoryItem(new OrderCommand(methodText, oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void sortAlignmentByFeatureScore(List<String> typ) {
        String methodText = MessageManager.getString("label.sort_by_score");
        this.sortByFeatures(typ, methodText, AlignmentSorter.FEATURE_SCORE);
    }

    @Override
    public boolean parseFeaturesFile(Object file, DataSourceType protocol, boolean relaxedIdMatching) {
        boolean featuresAdded = false;
        FeatureRenderer fr = this.alignPanel.getFeatureRenderer();
        try {
            featuresAdded = new FeaturesFile(false, file, protocol).parse(this.viewport.getAlignment().getDataset(), fr.getFeatureColours(), fr.getFeatureFilters(), false, relaxedIdMatching);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (featuresAdded) {
            this.avcg.refreshFeatureUI(true);
            if (fr != null) {
                fr.findAllFeatures(true);
            }
            if (this.avcg.getFeatureSettingsUI() != null) {
                this.avcg.getFeatureSettingsUI().discoverAllFeatureData();
            }
            this.alignPanel.paintAlignment(true, true);
        }
        return featuresAdded;
    }

    @Override
    public boolean markHighlightedColumns(boolean invert, boolean extendCurrent, boolean toggle) {
        if (!this.viewport.hasSearchResults()) {
            return false;
        }
        BitSet bs = new BitSet();
        AnnotatedCollectionI sqcol = this.viewport.getSelectionGroup() == null || extendCurrent ? this.viewport.getAlignment() : this.viewport.getSelectionGroup();
        int nseq = this.viewport.getSearchResults().markColumns(sqcol, bs);
        ColumnSelection cs = this.viewport.getColumnSelection();
        if (cs == null) {
            cs = new ColumnSelection();
        }
        if (bs.cardinality() > 0 || invert) {
            boolean changed = cs.markColumns(bs, sqcol.getStartRes(), sqcol.getEndRes(), invert, extendCurrent, toggle);
            if (changed) {
                this.viewport.setColumnSelection(cs);
                this.alignPanel.paintAlignment(false, false);
                int columnCount = invert ? sqcol.getEndRes() - sqcol.getStartRes() + 1 - bs.cardinality() : bs.cardinality();
                this.avcg.setStatus(MessageManager.formatMessage("label.view_controller_toggled_marked", new String[]{toggle ? MessageManager.getString("label.toggled") : MessageManager.getString("label.marked"), String.valueOf(columnCount), invert ? MessageManager.getString("label.not_containing") : MessageManager.getString("label.containing"), "Highlight", Integer.valueOf(nseq).toString()}));
                return true;
            }
        } else {
            this.avcg.setStatus(MessageManager.getString("label.no_highlighted_regions_marked"));
            if (!extendCurrent) {
                cs.clear();
                this.alignPanel.paintAlignment(false, false);
            }
        }
        return false;
    }

    @Override
    public boolean copyHighlightedRegionsToClipboard() {
        if (!this.viewport.hasSearchResults()) {
            return false;
        }
        SearchResultsI searchResults = this.viewport.getSearchResults();
        if (searchResults.isEmpty()) {
            return false;
        }
        List<SequenceI> seqs = searchResults.getMatchingSubSequences();
        Desktop.jalviewClipboard = new Object[]{seqs.toArray(new SequenceI[0]), this.alignPanel.getAlignment().getDataset(), null};
        this.avcg.setStatus(MessageManager.formatMessage("label.copied_sequences_to_clipboard", seqs.size()));
        return false;
    }

    @Override
    public boolean justify_Region(boolean left) {
        AlignmentI al = this.viewport.getAlignment();
        SequenceGroup reg = this.viewport.getSelectionGroup();
        int from = 0;
        int to = al.getWidth() - 1;
        List<SequenceI> seqs = al.getSequences();
        if (reg != null) {
            seqs = reg.getSequences();
            from = reg.getStartRes();
            to = reg.getEndRes();
        }
        if (to - from < 1) {
            return false;
        }
        al.padGaps();
        JustifyLeftOrRightCommand finalEdit = new JustifyLeftOrRightCommand("Justify " + (left ? "Left" : "Right"), left, seqs, from, to, al);
        this.avcg.addHistoryItem(finalEdit);
        this.viewport.notifyAlignmentChanged();
        return true;
    }
}

