/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgValues;
import jalview.bin.argparser.ArgValuesMap;
import jalview.bin.argparser.BootstrapArgs;
import jalview.bin.argparser.SubVals;
import jalview.util.ArgParserUtils;
import jalview.util.FileUtils;
import jalview.util.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArgParser {
    protected static final String SINGLEDASH = "-";
    protected static final String DOUBLEDASH = "--";
    public static final char EQUALS = '=';
    public static final String STDOUTFILENAME = "-";
    protected static final String NEGATESTRING = "no";
    protected static final String DEFAULTLINKEDIDPREFIX = "JALVIEW:";
    protected static final String MATCHALLLINKEDIDS = "*";
    protected static final String MATCHOPENEDLINKEDIDS = "open*";
    private int defaultLinkedIdCounter = 0;
    private static final String DEFAULTLINKEDIDCOUNTER = "{}";
    protected static final String OPENLINKEDIDPREFIX = "JALVIEW:";
    private int linkedIdAutoCounter = 0;
    private static final String INCREMENTLINKEDIDAUTOCOUNTER = "{++n}";
    private static final String LINKEDIDAUTOCOUNTER = "{n}";
    private static final String LINKEDIDEXTENSION = "{extension}";
    private static final String LINKEDIDBASENAME = "{basename}";
    private static final String LINKEDIDDIRNAME = "{dirname}";
    private static final String STRUCTUREEXTENSION = "{structureextension}";
    private static final String STRUCTUREBASENAME = "{structurebasename}";
    private static final String STRUCTUREDIRNAME = "{structuredirname}";
    private static final String INCREMENTONTHEFLYCOUNTER = "{++m}";
    private static final String ONTHEFLYCOUNTER = "{m}";
    private String currentStructureFilename = null;
    private int ontheflyCounter = 0;
    private String argFile = null;
    private static final String ARGFILEBASENAME = "{argfilebasename}";
    private static final String ARGFILEDIRNAME = "{argfiledirname}";
    private boolean substitutions = true;
    private boolean allLinkedIds = false;
    private boolean allStructures = false;
    protected static final Map<String, Arg> argMap = new HashMap<String, Arg>();
    protected Map<String, ArgValuesMap> linkedArgs = new HashMap<String, ArgValuesMap>();
    protected List<String> linkedOrder = new ArrayList<String>();
    protected List<String> storedLinkedIds = new ArrayList<String>();
    protected List<Arg> argList = new ArrayList<Arg>();
    private static final char ARGFILECOMMENT = '#';
    private int argIndex = 0;
    private BootstrapArgs bootstrapArgs = null;
    private boolean oldArguments = false;
    private boolean mixedArguments = false;
    private String[] mixedExamples = new String[]{null, null};

    public ArgParser(String[] args) {
        this(args, false, null);
    }

    public ArgParser(String[] args, boolean initsubstitutions, BootstrapArgs bsa) {
        this(new ArrayList<String>(Arrays.asList(args)), initsubstitutions, false, bsa);
    }

    public ArgParser(List<String> args, boolean initsubstitutions) {
        this(args, initsubstitutions, false, null);
    }

    public ArgParser(List<String> args, boolean initsubstitutions, boolean allowPrivate, BootstrapArgs bsa) {
        boolean d = false;
        boolean dd = false;
        for (String arg : args) {
            if (arg.startsWith(DOUBLEDASH)) {
                dd = true;
                if (this.mixedExamples[1] != null) continue;
                this.mixedExamples[1] = arg;
                continue;
            }
            if ((!arg.startsWith("-") || arg.equals("-")) && !arg.equals("open")) continue;
            d = true;
            if (this.mixedExamples[0] != null) continue;
            this.mixedExamples[0] = arg;
        }
        if (d) {
            if (dd) {
                this.mixedArguments = true;
            } else {
                this.oldArguments = true;
            }
        }
        if (this.oldArguments || this.mixedArguments) {
            this.parse(new ArrayList<String>(), false, false);
            return;
        }
        Console.debug("Supplied args are " + args);
        if (!dd && !Cache.getDefault("NOARGPREPROCESSING", false)) {
            ArgParserUtils.preProcessArgs(args);
            Console.debug("Preprocessed args are " + args);
        }
        this.bootstrapArgs = bsa != null ? bsa : BootstrapArgs.getBootstrapArgs(args);
        this.parse(args, initsubstitutions, allowPrivate);
    }

    private void parse(List<String> args, boolean initsubstitutions, boolean allowPrivate) {
        String arg0;
        this.substitutions = initsubstitutions;
        if (!(args.size() <= 0 || (arg0 = args.get(0)) == null || arg0.startsWith(DOUBLEDASH) || arg0.startsWith("-") || arg0.equals("open") || !new File(arg0).exists() && !HttpUtils.startsWithHttpOrHttps(arg0))) {
            args.add(0, Arg.OPEN.argString());
        }
        for (int i = 0; i < args.size(); ++i) {
            String potentialArgName;
            Arg potentialArg;
            int dashPos;
            String arg = args.get(i);
            if (!arg.startsWith(DOUBLEDASH)) continue;
            String argName = null;
            Object val = null;
            List<String> globVals = null;
            SubVals globSubVals = null;
            String linkedId = null;
            String givenLinkedId = null;
            Arg.Type type = null;
            int equalPos = arg.indexOf(61);
            if (equalPos > -1) {
                argName = arg.substring(DOUBLEDASH.length(), equalPos);
                val = arg.substring(equalPos + 1);
            } else {
                argName = arg.substring(DOUBLEDASH.length());
            }
            int idOpen = argName.indexOf(91);
            int idClose = argName.indexOf(93);
            if (idOpen > -1 && idClose == argName.length() - 1) {
                givenLinkedId = linkedId = argName.substring(idOpen + 1, idClose);
                argName = argName.substring(0, idOpen);
            }
            if ((dashPos = argName.indexOf("-")) > -1 && (potentialArg = argMap.get(potentialArgName = argName.substring(0, dashPos))) != null && potentialArg.hasOption(Arg.Opt.HASTYPE)) {
                String typeName = argName.substring(dashPos + 1);
                try {
                    type = Arg.Type.valueOf(typeName);
                }
                catch (IllegalArgumentException e) {
                    type = Arg.Type.INVALID;
                }
                argName = argName.substring(0, dashPos);
            }
            Arg a = argMap.get(argName);
            boolean negated = false;
            if (a == null) {
                if (argName.startsWith(NEGATESTRING) && argMap.containsKey(argName.substring(NEGATESTRING.length()))) {
                    argName = argName.substring(NEGATESTRING.length());
                    a = argMap.get(argName);
                    negated = true;
                } else {
                    for (Arg potentialArg2 : EnumSet.allOf(Arg.class)) {
                        if (!potentialArg2.hasOption(Arg.Opt.PREFIXKEV) || argName == null || !argName.startsWith(potentialArg2.getName()) || equalPos <= -1) continue;
                        val = argName.substring(potentialArg2.getName().length()) + "=" + (String)val;
                        argName = argName.substring(0, potentialArg2.getName().length());
                        a = potentialArg2;
                        break;
                    }
                }
            }
            if (a == null) {
                Console.error("Argument '" + arg + "' not recognised.  Exiting.");
                Jalview.exit("Invalid argument used." + System.lineSeparator() + "Use" + System.lineSeparator() + "jalview " + Arg.HELP.argString() + System.lineSeparator() + "for a usage statement.", Jalview.ExitCode.INVALID_ARGUMENT);
                continue;
            }
            if (a.hasOption(Arg.Opt.PRIVATE) && !allowPrivate) {
                Console.error("Argument '" + a.argString() + "' is private. Ignoring.");
                continue;
            }
            if (!a.hasOption(Arg.Opt.BOOLEAN) && negated) {
                Console.error("Argument '--no" + argName + "' not a boolean option. Ignoring.");
                continue;
            }
            if (!a.hasOption(Arg.Opt.STRING) && equalPos > -1) {
                Console.error("Argument '" + a.argString() + "' does not expect a value (given as '" + arg + "').  Ignoring.");
                continue;
            }
            if (!a.hasOption(Arg.Opt.LINKED) && linkedId != null) {
                Console.error("Argument '" + a.argString() + "' does not expect a linked id (given as '" + arg + "'). Ignoring.");
                continue;
            }
            if (a.hasOption(Arg.Opt.STRING)) {
                if (equalPos >= 0) {
                    if (a.hasOption(Arg.Opt.GLOB)) {
                        globSubVals = new SubVals((String)val);
                        String fileGlob = this.makeSubstitutions(globSubVals.getContent(), linkedId);
                        globVals = FileUtils.getFilenamesFromGlob(fileGlob);
                    }
                } else {
                    if (i + 1 >= args.size()) {
                        Console.error("Argument '" + a.getName() + "' requires a value, none given. Ignoring.");
                        continue;
                    }
                    if (a.hasOption(Arg.Opt.GLOB)) {
                        globVals = ArgParser.getShellGlobbedFilenameValues(a, args, i + 1);
                    } else {
                        val = args.get(i + 1);
                    }
                }
            }
            if (a == Arg.NPP) {
                ++this.linkedIdAutoCounter;
            } else if (a == Arg.SUBSTITUTIONS) {
                this.substitutions = !negated;
            } else if (a == Arg.SETARGFILE) {
                this.argFile = val;
            } else if (a == Arg.UNSETARGFILE) {
                this.argFile = null;
            } else if (a == Arg.ALL) {
                this.allLinkedIds = !negated;
            } else if (a == Arg.ALLSTRUCTURES) {
                boolean bl = this.allStructures = !negated;
            }
            if (a.hasOption(Arg.Opt.STORED)) {
                this.storedLinkedIds = new ArrayList<String>();
            }
            if (a.hasOption(Arg.Opt.INCREMENTDEFAULTCOUNTER)) {
                this.defaultLinkedId(true);
            }
            String autoCounterString = null;
            String defaultLinkedId = this.defaultLinkedId(false);
            boolean usingDefaultLinkedId = false;
            if (a.hasOption(Arg.Opt.LINKED)) {
                if (linkedId == null) {
                    if (a.hasOption(Arg.Opt.OUTPUTFILE) && a.hasOption(Arg.Opt.ALLOWMULTIID) && ((String)val).contains(MATCHALLLINKEDIDS)) {
                        linkedId = this.allLinkedIds ? MATCHALLLINKEDIDS : MATCHOPENEDLINKEDIDS;
                        val = FileUtils.convertWildcardsToPath((String)val, MATCHALLLINKEDIDS, LINKEDIDDIRNAME, LINKEDIDBASENAME);
                    } else if (this.allLinkedIds && a.hasOption(Arg.Opt.ALLOWMULTIID)) {
                        linkedId = MATCHALLLINKEDIDS;
                    }
                    if (this.allLinkedIds) {
                        givenLinkedId = linkedId;
                    } else if (a.hasOption(Arg.Opt.ALLOWMULTIID) && this.storedLinkedIds != null && this.storedLinkedIds.size() > 0) {
                        linkedId = MATCHOPENEDLINKEDIDS;
                    } else {
                        linkedId = defaultLinkedId;
                        usingDefaultLinkedId = true;
                        Console.debug("Changing linkedId to '" + linkedId + "' from " + arg);
                    }
                } else {
                    if (linkedId.contains(LINKEDIDAUTOCOUNTER)) {
                        autoCounterString = Integer.toString(this.linkedIdAutoCounter);
                        linkedId = linkedId.replace(LINKEDIDAUTOCOUNTER, autoCounterString);
                        Console.debug("Changing linkedId to '" + linkedId + "' from " + arg);
                    }
                    if (linkedId.contains(INCREMENTLINKEDIDAUTOCOUNTER)) {
                        autoCounterString = Integer.toString(++this.linkedIdAutoCounter);
                        linkedId = linkedId.replace(INCREMENTLINKEDIDAUTOCOUNTER, autoCounterString);
                        Console.debug("Changing linkedId to '" + linkedId + "' from " + arg);
                    }
                }
            }
            if (a.hasOption(Arg.Opt.NOACTION)) continue;
            ArgValuesMap avm = this.getOrCreateLinkedArgValuesMap(linkedId);
            if (a.hasOption(Arg.Opt.NODUPLICATEVALUES) && avm.hasValue(a, (String)val)) {
                Console.error("Argument '" + a.argString() + "' cannot contain a duplicate value ('" + (String)val + "'). Ignoring this and subsequent occurrences.");
                continue;
            }
            SubVals subvals = new SubVals((String)val);
            boolean addNewSubVals = false;
            String id = subvals.get("id");
            if (id != null && avm.hasId(a, id)) {
                Console.error("Argument '" + a.argString() + "' has a duplicate id ('" + id + "'). Ignoring.");
                continue;
            }
            if (this.allStructures && a.hasType(Arg.Type.STRUCTURE) && !a.hasOption(Arg.Opt.PRIMARY) && !subvals.has(Arg.ALLSTRUCTURES.getName())) {
                subvals.put(Arg.ALLSTRUCTURES.getName(), "true");
                addNewSubVals = true;
            }
            ArgValues avs = avm.getOrCreateArgValues(a);
            if (a.hasOption(Arg.Opt.STRING)) {
                if (a.hasOption(Arg.Opt.GLOB) && globVals != null && globVals.size() > 0) {
                    Enumeration<String> gve = Collections.enumeration(globVals);
                    while (gve.hasMoreElements()) {
                        String v = gve.nextElement();
                        SubVals vsv = new SubVals(globSubVals, v);
                        this.addValue(linkedId, givenLinkedId, type, avs, vsv, v, this.argIndex++, true);
                        if (!gve.hasMoreElements() || !usingDefaultLinkedId || !a.hasOption(Arg.Opt.INCREMENTDEFAULTCOUNTER)) continue;
                        linkedId = this.defaultLinkedId(true);
                        avm = this.linkedArgs.get(linkedId);
                        avs = avm.getOrCreateArgValues(a);
                    }
                } else {
                    this.addValue(linkedId, givenLinkedId, type, avs, addNewSubVals ? subvals : null, (String)val, this.argIndex, true);
                }
            } else if (a.hasOption(Arg.Opt.BOOLEAN)) {
                this.setBoolean(linkedId, givenLinkedId, type, avs, !negated, this.argIndex);
                this.setNegated(linkedId, avs, negated);
            } else if (a.hasOption(Arg.Opt.UNARY)) {
                this.setBoolean(linkedId, givenLinkedId, type, avs, true, this.argIndex);
            }
            if (!MATCHALLLINKEDIDS.equals(linkedId) && !MATCHOPENEDLINKEDIDS.equals(linkedId) || !this.linkedArgs.containsKey(linkedId)) continue;
            this.linkedArgs.remove(linkedId);
        }
    }

    private void finaliseStoringArgValue(String linkedId, ArgValues avs) {
        Arg a = avs.arg();
        this.incrementCount(linkedId, avs);
        ++this.argIndex;
        if (a.hasOption(Arg.Opt.LINKED) && !this.linkedOrder.contains(linkedId)) {
            this.linkedOrder.add(linkedId);
        }
        if (!this.argList.contains((Object)a)) {
            this.argList.add(a);
        }
    }

    private String defaultLinkedId(boolean increment) {
        String defaultLinkedId = "JALVIEW:" + Integer.toString(this.defaultLinkedIdCounter);
        if (increment) {
            while (this.linkedArgs.containsKey(defaultLinkedId)) {
                ++this.defaultLinkedIdCounter;
                defaultLinkedId = "JALVIEW:" + Integer.toString(this.defaultLinkedIdCounter);
            }
        }
        this.getOrCreateLinkedArgValuesMap(defaultLinkedId);
        return defaultLinkedId;
    }

    public String makeSubstitutions(String val, String linkedId) {
        return this.makeSubstitutions(val, linkedId, false);
    }

    public String makeSubstitutions(String val, String linkedId, boolean onthefly) {
        ArgValuesMap avm;
        String rest;
        String subvals;
        if (!this.substitutions || val == null) {
            return val;
        }
        if (val.indexOf(91) == 0 && val.indexOf(93) > 1) {
            int closeBracket = val.indexOf(93);
            if (val.length() == closeBracket) {
                return val;
            }
            subvals = val.substring(0, closeBracket + 1);
            rest = val.substring(closeBracket + 1);
        } else {
            subvals = "";
            rest = val;
        }
        if (rest.contains(LINKEDIDAUTOCOUNTER)) {
            rest = rest.replace(LINKEDIDAUTOCOUNTER, String.valueOf(this.linkedIdAutoCounter));
        }
        if (rest.contains(INCREMENTLINKEDIDAUTOCOUNTER)) {
            rest = rest.replace(INCREMENTLINKEDIDAUTOCOUNTER, String.valueOf(++this.linkedIdAutoCounter));
        }
        if (rest.contains(DEFAULTLINKEDIDCOUNTER)) {
            rest = rest.replace(DEFAULTLINKEDIDCOUNTER, String.valueOf(this.defaultLinkedIdCounter));
        }
        if ((avm = this.linkedArgs.get(linkedId)) != null) {
            if (rest.contains(LINKEDIDBASENAME)) {
                rest = rest.replace(LINKEDIDBASENAME, avm.getBasename());
            }
            if (rest.contains(LINKEDIDEXTENSION)) {
                rest = rest.replace(LINKEDIDEXTENSION, avm.getExtension());
            }
            if (rest.contains(LINKEDIDDIRNAME)) {
                rest = rest.replace(LINKEDIDDIRNAME, avm.getDirname());
            }
        }
        if (this.argFile != null) {
            if (rest.contains(ARGFILEBASENAME)) {
                rest = rest.replace(ARGFILEBASENAME, FileUtils.getBasename(new File(this.argFile)));
            }
            if (rest.contains(ARGFILEDIRNAME)) {
                rest = rest.replace(ARGFILEDIRNAME, FileUtils.getDirname(new File(this.argFile)));
            }
        }
        if (onthefly) {
            if (rest.contains(ONTHEFLYCOUNTER)) {
                rest = rest.replace(ONTHEFLYCOUNTER, String.valueOf(this.ontheflyCounter));
            }
            if (rest.contains(INCREMENTONTHEFLYCOUNTER)) {
                rest = rest.replace(INCREMENTONTHEFLYCOUNTER, String.valueOf(++this.ontheflyCounter));
            }
            if (this.currentStructureFilename != null) {
                if (rest.contains(STRUCTUREBASENAME)) {
                    rest = rest.replace(STRUCTUREBASENAME, FileUtils.getBasename(new File(this.currentStructureFilename)));
                }
                if (rest.contains(STRUCTUREDIRNAME)) {
                    rest = rest.replace(STRUCTUREDIRNAME, FileUtils.getDirname(new File(this.currentStructureFilename)));
                }
            }
        }
        return subvals + rest;
    }

    protected static List<String> getShellGlobbedFilenameValues(Arg a, List<String> args, int i) {
        ArrayList<String> vals = new ArrayList<String>();
        while (i < args.size() && !args.get(i).startsWith(DOUBLEDASH)) {
            vals.add(FileUtils.substituteHomeDir(args.remove(i)));
            if (a.hasOption(Arg.Opt.GLOB)) continue;
            break;
        }
        return vals;
    }

    public BootstrapArgs getBootstrapArgs() {
        return this.bootstrapArgs;
    }

    public boolean isSet(Arg a) {
        return a.hasOption(Arg.Opt.LINKED) ? this.isSetAtAll(a) : this.isSet(null, a);
    }

    public boolean isSetAtAll(Arg a) {
        for (String linkedId : this.linkedOrder) {
            if (!this.isSet(linkedId, a)) continue;
            return true;
        }
        return false;
    }

    public boolean isSet(String linkedId, Arg a) {
        ArgValuesMap avm = this.linkedArgs.get(linkedId);
        return avm == null ? false : avm.containsArg(a);
    }

    public boolean getBoolean(Arg a) {
        if (!a.hasOption(Arg.Opt.BOOLEAN) && !a.hasOption(Arg.Opt.UNARY)) {
            Console.warn("Getting boolean from non boolean Arg '" + a.getName() + "'.");
        }
        return a.hasOption(Arg.Opt.LINKED) ? this.getBool("", a) : this.getBool(null, a);
    }

    public boolean getBool(String linkedId, Arg a) {
        ArgValuesMap avm = this.linkedArgs.get(linkedId);
        if (avm == null) {
            return a.getDefaultBoolValue();
        }
        ArgValues avs = avm.getArgValues(a);
        return avs == null ? a.getDefaultBoolValue() : avs.getBoolean();
    }

    public List<String> getLinkedIds() {
        return this.linkedOrder;
    }

    public ArgValuesMap getLinkedArgs(String id) {
        return this.linkedArgs.get(id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UNLINKED\n");
        sb.append(ArgParser.argValuesMapToString(this.linkedArgs.get(null)));
        if (this.getLinkedIds() != null) {
            sb.append("LINKED\n");
            for (String id : this.getLinkedIds()) {
                if (id == null) continue;
                ArgValuesMap avm = this.getLinkedArgs(id);
                sb.append("ID: '").append(id).append("'\n");
                sb.append(ArgParser.argValuesMapToString(avm));
            }
        }
        return sb.toString();
    }

    private static String argValuesMapToString(ArgValuesMap avm) {
        if (avm == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Arg a : avm.getArgKeys()) {
            ArgValues v = avm.getArgValues(a);
            sb.append(v.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static ArgParser parseArgFiles(List<String> argFilenameGlobs, boolean initsubstitutions, BootstrapArgs bsa) {
        ArrayList<File> argFiles = new ArrayList<File>();
        for (String pattern : argFilenameGlobs) {
            argFiles.addAll(FileUtils.getFilesFromGlob(pattern));
        }
        return ArgParser.parseArgFileList(argFiles, initsubstitutions, bsa);
    }

    public static ArgParser parseArgFileList(List<File> argFiles, boolean initsubstitutions, BootstrapArgs bsa) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (File argFile : argFiles) {
            if (!argFile.exists()) {
                String message = Arg.ARGFILE.argString() + "=\"" + argFile.getPath() + "\": File does not exist.";
                Jalview.exit(message, Jalview.ExitCode.FILE_NOT_FOUND);
            }
            try {
                String setargfile = Arg.SETARGFILE.argString() + '=' + argFile.getCanonicalPath();
                argsList.add(setargfile);
                argsList.addAll(ArgParser.readArgFile(argFile));
                argsList.add(Arg.UNSETARGFILE.argString());
            }
            catch (IOException e) {
                String message = Arg.ARGFILE.argString() + "=\"" + argFile.getPath() + "\": File could not be read.";
                Jalview.exit(message, Jalview.ExitCode.FILE_NOT_READABLE);
            }
        }
        return new ArgParser(argsList, initsubstitutions, true, bsa);
    }

    protected static List<String> readArgFile(File argFile) {
        ArrayList<String> args = new ArrayList<String>();
        if (argFile != null && argFile.exists()) {
            try {
                for (String line : Files.readAllLines(Paths.get(argFile.getPath(), new String[0]))) {
                    if (line == null || line.length() <= 0 || line.charAt(0) == '#') continue;
                    args.add(line);
                }
            }
            catch (IOException e) {
                String message = Arg.ARGFILE.argString() + "=\"" + argFile.getPath() + "\": File could not be read.";
                Console.debug(message, e);
                Jalview.exit(message, Jalview.ExitCode.FILE_NOT_READABLE);
            }
        }
        return args;
    }

    private void addValue(String linkedId, String givenLinkedId, Arg.Type type, ArgValues avs, SubVals sv, String v, int argIndex, boolean doSubs) {
        this.argValueOperation(Op.ADDVALUE, linkedId, givenLinkedId, type, avs, sv, v, false, argIndex, doSubs);
    }

    private void setBoolean(String linkedId, String givenLinkedId, Arg.Type type, ArgValues avs, boolean b, int argIndex) {
        this.argValueOperation(Op.SETBOOLEAN, linkedId, givenLinkedId, type, avs, null, null, b, argIndex, false);
    }

    private void setNegated(String linkedId, ArgValues avs, boolean b) {
        this.argValueOperation(Op.SETNEGATED, linkedId, null, null, avs, null, null, b, 0, false);
    }

    private void incrementCount(String linkedId, ArgValues avs) {
        this.argValueOperation(Op.INCREMENTCOUNT, linkedId, null, null, avs, null, null, false, 0, false);
    }

    private void argValueOperation(Op op, String linkedId, String givenLinkedId, Arg.Type type, ArgValues avs, SubVals sv, String v, boolean b, int argIndex, boolean doSubs) {
        this.argValueOperation(op, linkedId, givenLinkedId, type, avs, sv, true, v, b, argIndex, doSubs);
    }

    private void argValueOperation(Op op, String linkedId, String givenLinkedId, Arg.Type type, ArgValues avs, SubVals sv, boolean merge, String v, boolean b, int argIndex, boolean doSubs) {
        Arg a = avs.arg();
        List<String> wildcardLinkedIds = null;
        if (a.hasOption(Arg.Opt.ALLOWMULTIID)) {
            switch (linkedId) {
                case "*": {
                    wildcardLinkedIds = this.getLinkedIds();
                    break;
                }
                case "open*": {
                    wildcardLinkedIds = this.storedLinkedIds;
                }
            }
        }
        if (linkedId != null && wildcardLinkedIds == null && a.hasOption(Arg.Opt.STORED) && !this.storedLinkedIds.contains(linkedId)) {
            this.storedLinkedIds.add(linkedId);
        }
        if (wildcardLinkedIds != null) {
            for (String matchedLinkedId : wildcardLinkedIds) {
                if (matchedLinkedId == null || MATCHALLLINKEDIDS.equals(matchedLinkedId) || MATCHOPENEDLINKEDIDS.equals(matchedLinkedId)) continue;
                ArgValuesMap avm = this.linkedArgs.get(matchedLinkedId);
                if (a.hasOption(Arg.Opt.REQUIREINPUT) && !avm.hasArgWithOption(Arg.Opt.INPUT)) continue;
                ArgValues tavs = avm.getOrCreateArgValues(a);
                switch (op) {
                    case ADDVALUE: {
                        String val = v;
                        if (sv != null) {
                            if (doSubs) {
                                sv = new SubVals(sv, val, merge);
                                val = this.makeSubstitutions(sv.getContent(), matchedLinkedId);
                            }
                            tavs.addValue(sv, type, val, argIndex, true, givenLinkedId);
                        } else {
                            if (doSubs) {
                                val = this.makeSubstitutions(v, matchedLinkedId);
                            }
                            tavs.addValue(type, val, argIndex, true, givenLinkedId);
                        }
                        this.finaliseStoringArgValue(matchedLinkedId, tavs);
                        break;
                    }
                    case SETBOOLEAN: {
                        tavs.setBoolean(type, b, argIndex, true, givenLinkedId);
                        this.finaliseStoringArgValue(matchedLinkedId, tavs);
                        break;
                    }
                    case SETNEGATED: {
                        tavs.setNegated(b, true);
                        break;
                    }
                    case INCREMENTCOUNT: {
                        tavs.incrementCount();
                        break;
                    }
                }
            }
        } else {
            switch (op) {
                case ADDVALUE: {
                    String val = v;
                    if (sv != null) {
                        if (doSubs) {
                            val = this.makeSubstitutions(v, linkedId);
                            sv = new SubVals(sv, val);
                        }
                        avs.addValue(sv, type, val, argIndex, false, givenLinkedId);
                    } else {
                        if (doSubs) {
                            val = this.makeSubstitutions(v, linkedId);
                        }
                        avs.addValue(type, val, argIndex, false, givenLinkedId);
                    }
                    this.finaliseStoringArgValue(linkedId, avs);
                    break;
                }
                case SETBOOLEAN: {
                    avs.setBoolean(type, b, argIndex, false, givenLinkedId);
                    this.finaliseStoringArgValue(linkedId, avs);
                    break;
                }
                case SETNEGATED: {
                    avs.setNegated(b, false);
                    break;
                }
                case INCREMENTCOUNT: {
                    avs.incrementCount();
                    break;
                }
            }
        }
    }

    private ArgValuesMap getOrCreateLinkedArgValuesMap(String linkedId) {
        if (this.linkedArgs.containsKey(linkedId) && this.linkedArgs.get(linkedId) != null) {
            return this.linkedArgs.get(linkedId);
        }
        this.linkedArgs.put(linkedId, new ArgValuesMap(linkedId));
        return this.linkedArgs.get(linkedId);
    }

    public boolean isOldStyle() {
        return this.oldArguments;
    }

    public boolean isMixedStyle() {
        return this.mixedArguments;
    }

    public String[] getMixedExamples() {
        return this.mixedExamples;
    }

    public void setStructureFilename(String s) {
        this.currentStructureFilename = s;
    }

    static {
        for (Arg a : EnumSet.allOf(Arg.class)) {
            for (String argName : a.getNames()) {
                if (argMap.containsKey(argName)) {
                    Console.warn("Trying to add argument name multiple times: '" + argName + "'");
                    if (argMap.get(argName) == a) continue;
                    Console.error("Trying to add argument name multiple times for different Args: '" + argMap.get(argName).getName() + ":" + argName + "' and '" + a.getName() + ":" + argName + "'");
                    continue;
                }
                argMap.put(argName, a);
            }
        }
    }

    private static enum Op {
        ADDVALUE,
        SETBOOLEAN,
        SETNEGATED,
        INCREMENTCOUNT;

    }
}

