/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.argparser.ArgDisplayComparator;
import jalview.util.ChannelProperties;
import jalview.util.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public enum Arg {
    HELP(Type.HELP, "h", "Display basic help", Opt.UNARY, Opt.BOOTSTRAP, Opt.HASTYPE, Opt.MULTIVALUE),
    VERSION(Type.CONFIG, "v", "Display the version of " + ChannelProperties.getProperty("app_name"), Opt.UNARY, Opt.BOOTSTRAP),
    HEADLESS(Type.CONFIG, "Run Jalview in headless mode. No GUI interface will be created and Jalview will quit after all arguments have been processed. Headless mode is assumed if an output file is to be generated, this can be overridden with --gui.", Opt.UNARY, Opt.BOOTSTRAP),
    GUI(Type.CONFIG, "Do not run Jalview in headless mode.  This overrides the assumption of headless mode when an output file is to be generated.", Opt.UNARY, Opt.BOOTSTRAP),
    JABAWS(Type.CONFIG, "Set a different URL to connect to a JABAWS server.", Opt.STRING, Opt.BOOTSTRAP),
    NEWS(Type.CONFIG, "Show (or don't show) the news feed.", true, Opt.BOOLEAN, Opt.BOOTSTRAP),
    SPLASH(Type.CONFIG, "Show (or don't show) the About Jalview splash screen.", true, Opt.BOOLEAN, Opt.BOOTSTRAP),
    QUESTIONNAIRE(Type.CONFIG, "Show (or don't show) the questionnaire if one is available.", true, Opt.BOOLEAN, Opt.BOOTSTRAP),
    JAVACONSOLE(Type.CONFIG, "Show (or don't show) the Java Console.", false, Opt.BOOLEAN, Opt.BOOTSTRAP),
    NOUSAGESTATS(Type.CONFIG, "Don't send initial launch usage stats.", Opt.UNARY, Opt.BOOTSTRAP),
    NOSTARTUPFILE(Type.CONFIG, "Don't show the default startup file.", Opt.UNARY, Opt.BOOTSTRAP),
    WEBSERVICEDISCOVERY(Type.CONFIG, "Attempt (or don't attempt) to connect to JABAWS web services.", true, Opt.BOOLEAN, Opt.BOOTSTRAP),
    PROPS(Type.CONFIG, "Use a file as the preferences file instead of the usual ~/" + ChannelProperties.getProperty("preferences.filename") + " file.", Opt.STRING, Opt.BOOTSTRAP),
    DEBUG(Type.CONFIG, "d", "Start Jalview in debug log level.", Opt.BOOLEAN, Opt.BOOTSTRAP),
    TRACE(Type.CONFIG, "Start Jalview in trace log level.", Opt.BOOLEAN, Opt.BOOTSTRAP, Opt.SECRET),
    QUIET(Type.CONFIG, "q", "Stop all output to STDOUT (after the Java Virtual Machine has started). Use \u2011\u2011quiet a second time to stop all output to STDERR.", Opt.UNARY, Opt.MULTIVALUE, Opt.BOOTSTRAP),
    INITSUBSTITUTIONS(Type.CONFIG, "Set \u2011\u2011substitutions to be initially enabled (or initially disabled).", true, Opt.BOOLEAN, Opt.BOOTSTRAP, Opt.NOACTION, Opt.SECRET),
    P(Type.CONFIG, "Set a Jalview preference value for this session.", Opt.PREFIXKEV, Opt.PRESERVECASE, Opt.STRING, Opt.BOOTSTRAP, Opt.MULTIVALUE, Opt.NOACTION, Opt.SECRET),
    OPEN(Type.OPENING, "Opens one or more alignment files or URLs in new alignment windows.", Opt.STRING, Opt.LINKED, Opt.INCREMENTDEFAULTCOUNTER, Opt.MULTIVALUE, Opt.GLOB, Opt.ALLOWSUBSTITUTIONS, Opt.INPUT, Opt.STORED, Opt.PRIMARY),
    APPEND(Type.OPENING, "Appends one or more alignment files or URLs to the open alignment window (or opens a new alignment if none already open).", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.GLOB, Opt.ALLOWSUBSTITUTIONS, Opt.INPUT, Opt.PRIMARY),
    TITLE(Type.OPENING, "Specifies the title for the open alignment window as string.", Opt.STRING, Opt.LINKED, Opt.ALLOWMULTIID),
    COLOUR(Type.OPENING, "color", "Applies the colour scheme to the open alignment window. Valid values include:\nclustal,\nblosum62,\npc-identity,\nzappo,\ntaylor,\ngecos-flower,\ngecos-blossom,\ngecos-sunset,\ngecos-ocean,\nhydrophobic,\nhelix-propensity,\nstrand-propensity,\nturn-propensity,\nburied-index,\nnucleotide,\nnucleotide-ambiguity,\npurine-pyrimidine,\nrna-helices,\nt-coffee-scores,\nsequence-id.\n\nNames of user defined colourschemes will also work,\nand jalview colourscheme specifications like\n--colour=\"D,E=red; K,R,H=0022FF; C,c=yellow\"", Opt.STRING, Opt.LINKED, Opt.ALLOWMULTIID),
    FEATURES(Type.OPENING, "Add a feature file or URL to the open alignment.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID),
    TREE(Type.OPENING, "Add a tree file or URL to the open alignment.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID),
    SORTBYTREE(Type.OPENING, "Enforces sorting (or not sorting) the open alignment in the order of an attached phylogenetic tree.", true, Opt.LINKED, Opt.BOOLEAN, Opt.ALLOWMULTIID),
    ANNOTATIONS(Type.OPENING, "Add an annotations file or URL to the open alignment.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID),
    SHOWANNOTATIONS(Type.OPENING, "Enforces showing (or not showing) alignment annotations.", Opt.BOOLEAN, Opt.LINKED, Opt.ALLOWMULTIID, Opt.ALLOWMULTIID),
    WRAP(Type.OPENING, "Enforces wrapped (or not wrapped) alignment formatting.", Opt.BOOLEAN, Opt.LINKED, Opt.ALLOWMULTIID, Opt.ALLOWMULTIID),
    NOSTRUCTURE(Type.OPENING, "Do not open or process any 3D structure in the \u2011\u2011open or \u2011\u2011append files.", Opt.UNARY, Opt.LINKED, Opt.ALLOWMULTIID, Opt.ALLOWMULTIID),
    STRUCTURE(Type.STRUCTURE, "Load a structure file or URL associated with a sequence in the open alignment.\nThe sequence to be associated with can be specified with a following --seqid argument, or the subval modifier seqid=ID can be used. A subval INDEX can also be used to specify the INDEX-th sequence in the open alignment.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.PRIMARY, Opt.ALLOWMULTIID),
    SEQID(Type.STRUCTURE, "Specify the sequence name for the preceding --structure to be associated with.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID),
    PAEMATRIX(Type.STRUCTURE, "Add a PAE json matrix file to the preceding --structure.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID),
    TEMPFAC(Type.STRUCTURE, "Set the type of temperature factor. Possible values are:\ndefault,\nplddt.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    STRUCTUREVIEWER(Type.STRUCTURE, "Set the structure viewer to use to open the 3D structure file specified in previous --structure to name. Possible values of name are:\nnone,\njmol,\nchimera,\nchimerax,\npymol.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    NOTEMPFAC(Type.STRUCTURE, "Do not show the temperature factor annotation for the preceding --structure.", Opt.UNARY, Opt.LINKED, Opt.ALLOWMULTIID, Opt.SECRET),
    SHOWSSANNOTATIONS(Type.STRUCTURE, null, Opt.BOOLEAN, Opt.LINKED, Opt.ALLOWMULTIID),
    IMAGE(Type.IMAGE, "Output an image of the open alignment window. Format is specified by the subval modifier, a following --type argument or guessed from the file extension. Valid formats/extensions are:\nsvg,\npng,\neps,\nhtml,\nbiojs.", Opt.STRING, Opt.LINKED, Opt.ALLOWSUBSTITUTIONS, Opt.MULTIVALUE, Opt.ALLOWMULTIID, Opt.REQUIREINPUT, Opt.OUTPUTFILE, Opt.PRIMARY),
    STRUCTUREIMAGE(new Type[]{Type.IMAGE, Type.STRUCTUREIMAGE}, "Export an image of a 3D structure opened in JMOL", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.OUTPUTFILE, Opt.ALLOWMULTIID, Opt.PRIMARY),
    TYPE(Type.IMAGE, "Set the image format for the preceding " + IMAGE.argString() + " or " + STRUCTUREIMAGE.argString() + ". Valid values are:\nsvg,\npng,\neps,\nhtml,\nbiojs.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    TEXTRENDERER(Type.IMAGE, "Sets whether text in a vector image format (SVG, HTML, EPS) should be rendered as text or vector line-art. Possible values are:\ntext,\nlineart.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    SCALE(Type.IMAGE, "Sets a scaling for bitmap image format (PNG). Should be given as a floating point number. If used in conjunction with --width and --height then the smallest scaling will be used (scale, width and height provide bounds for the image).", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    WIDTH(Type.IMAGE, "Sets a width for bitmap image format (PNG) with the height maintaining the aspect ratio. Should be given as a positive integer. If used in conjunction with --scale and --height then the smallest scaling will be used (scale, width and height provide bounds for the image).", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    HEIGHT(Type.IMAGE, "Sets a height for bitmap image format (PNG) with the width maintaining the aspect ratio. Should be given as a positive integer. If used in conjunction with --scale and --width then the smallest scaling will be used (scale, width and height provide bounds for the image).", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    IMAGECOLOUR(Type.IMAGE, "imagecolor", "Applies the colour scheme to the open alignment window for this image, otherwise the value of " + COLOUR.argString() + " (or none) will apply. Valid values are the same as " + COLOUR.argString() + ".", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    BGCOLOUR(Type.IMAGE, "bgcolor", "Applies a background colour to the structure image. Valid values are named colours known to Java or RRGGBB 6 digit hex-string.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWMULTIID),
    OUTPUT(Type.OUTPUT, "Export the open alignment to file filename. The format name is specified by the subval modifier format=name, a following --format name argument or guessed from the file extension. Valid format names (and file extensions) are:\nfasta (fa, fasta, mfa, fastq),\npfam (pfam),\nstockholm (sto, stk),\npir (pir),\nblc (blc),\namsa (amsa),\njson (json),\npileup (pileup),\nmsf (msf),\nclustal (aln),\nphylip (phy),\njalview (jvp, jar).", Opt.STRING, Opt.LINKED, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID, Opt.REQUIREINPUT, Opt.OUTPUTFILE, Opt.STDOUT, Opt.PRIMARY),
    FORMAT(Type.OUTPUT, "Sets the format for the preceding --output file. Valid formats are:\nfasta,\npfam,\nstockholm,\npir,\nblc,\namsa,\njson,\npileup,\nmsf,\nclustal,\nphylip,\njalview.", Opt.STRING, Opt.LINKED, Opt.ALLOWMULTIID),
    GROOVY(Type.PROCESS, "Process a groovy script in the file for the open alignment.", Opt.STRING, Opt.LINKED, Opt.MULTIVALUE, Opt.ALLOWSUBSTITUTIONS, Opt.ALLOWMULTIID),
    BACKUPS(Type.OUTPUT, "Enable (or disable) writing backup files when saving an \u2011\u2011output file. This applies to the current open alignment.  To apply to all \u2011\u2011output and \u2011\u2011image files, use after \u2011\u2011all.", true, Opt.BOOLEAN, Opt.LINKED, Opt.ALLOWMULTIID),
    OVERWRITE(Type.OUTPUT, "Enable (or disable) overwriting of output files without backups enabled. This applies to the current open alignment.  To apply to all \u2011\u2011output and \u2011\u2011image files, use after \u2011\u2011all.", Opt.BOOLEAN, Opt.LINKED, Opt.ALLOWMULTIID),
    CLOSE(Type.OPENING, "Close the current open alignment window. This occurs after other output arguments. This applies to the current open alignment.  To apply to all \u2011\u2011output and \u2011\u2011image files, use after \u2011\u2011all.", Opt.UNARY, Opt.LINKED, Opt.ALLOWMULTIID),
    MKDIRS(Type.OUTPUT, "Automatically create directories when outputting a file to a new directory.", Opt.UNARY, Opt.LINKED, Opt.ALLOWMULTIID),
    NEW(Type.FLOW, "Move on to a new alignment window. This will ensure --append will start a new alignment window and other linked arguments will apply to the new alignment window.", Opt.UNARY, Opt.MULTIVALUE, Opt.NOACTION, Opt.INCREMENTDEFAULTCOUNTER),
    SUBSTITUTIONS(Type.FLOW, "The following argument values allow (or don't allow) subsituting filename parts. This is initially true. Valid substitutions are:\n{basename} - the filename-without-extension of the currently --opened file (or first --appended file),\n{dirname} - the directory (folder) name of the currently --opened file (or first --appended file),\n{argfilebasename} - the filename-without-extension of the current --argfile,\n{argfiledirname} - the directory (folder) name of the current --argfile,\n{n} - the value of the index counter (starting at 0).\n{++n} - increase and substitute the value of the index counter,\n{} - the value of the current alignment window default index.", true, Opt.BOOLEAN, Opt.MULTIVALUE, Opt.NOACTION),
    ARGFILE(Type.FLOW, "Open one or more files filename and read, line-by-line, as arguments to Jalview.\nValues in an argfile should be given with an equals sign (\"=\") separator with no spaces.\nNote that if you use one or more --argfile arguments then all other non-initialising arguments will be ignored.", Opt.STRING, Opt.MULTIVALUE, Opt.BOOTSTRAP, Opt.GLOB, Opt.ALLOWSUBSTITUTIONS),
    NPP(Type.FLOW, "n++", "Increase the index counter used in argument value substitutions.", Opt.UNARY, Opt.MULTIVALUE, Opt.NOACTION),
    ALL(Type.FLOW, "Apply the following output arguments to all sets of linked arguments.", Opt.BOOLEAN, Opt.MULTIVALUE, Opt.NOACTION),
    OPENED(Type.FLOW, "Apply the following output arguments to all of the last --open'ed set of linked arguments.", Opt.BOOLEAN, Opt.MULTIVALUE, Opt.NOACTION),
    QUIT(Type.FLOW, "After all files have been opened, appended and output, quit Jalview. In \u2011\u2011headless mode this already happens.", Opt.UNARY),
    NOQUIT(Type.FLOW, "Secret arg to not quit after --headless mode for tests", Opt.UNARY, Opt.SECRET),
    ALLSTRUCTURES(Type.FLOW, "Apply the following 3D structure formatting arguments to all structures within the open alignment.", Opt.BOOLEAN, Opt.MULTIVALUE, Opt.NOACTION),
    TESTOUTPUT(Type.CONFIG, "Allow specific stdout information.  For testing purposes only.", Opt.UNARY, Opt.BOOTSTRAP, Opt.SECRET),
    SETPROP(Type.CONFIG, "Set an individual Java System property.", Opt.STRING, Opt.MULTIVALUE, Opt.BOOTSTRAP, Opt.SECRET),
    NIL(Type.FLOW, "This argument does nothing on its own, but can be used with linkedIds.", Opt.UNARY, Opt.LINKED, Opt.MULTIVALUE, Opt.NOACTION, Opt.SECRET),
    SETARGFILE(Type.FLOW, "Sets the current value of the argfilename.  Inserted before argfilecontents.", Opt.UNARY, Opt.LINKED, Opt.STRING, Opt.MULTIVALUE, Opt.PRIVATE, Opt.NOACTION),
    UNSETARGFILE(Type.FLOW, "Unsets the current value of the argfilename.  Inserted after argfile contents.", Opt.UNARY, Opt.LINKED, Opt.MULTIVALUE, Opt.PRIVATE, Opt.NOACTION),
    JVMMEMPC(Type.CONFIG, "Limit maximum heap size (memory) to PERCENT% of total physical memory detected. This defaults to 90 if total physical memory can be detected.\nThe equals sign (\"=\") separator must be used with no spaces.", Opt.NOACTION, Opt.BOOTSTRAP, Opt.STRING, Opt.LAST),
    JVMMEMMAX(Type.CONFIG, "Limit maximum heap size (memory) to MAXMEMORY. MAXMEMORY can be specified in bytes, kilobytes(k), megabytes(m), gigabytes(g) or if you're lucky enough, terabytes(t). This defaults to 32g if total physical memory can be detected, or to 8g if total physical memory cannot be detected.\nThe equals sign (\"=\") separator must be used with no spaces.", Opt.NOACTION, Opt.BOOTSTRAP, Opt.STRING, Opt.LAST);

    private final String[] argNames;
    private Opt[] argOptions;
    private boolean defaultBoolValue;
    private String description;
    private Type[] types;
    private static final String ARGDESCRIPTIONSEPARATOR = " - ";
    private static final int DESCRIPTIONINDENT = 20;

    private Arg(Type type, String description, Opt ... options) {
        this(new Type[]{type}, description, options);
    }

    private Arg(Type[] type, String description, Opt ... options) {
        this(type, null, description, false, options);
    }

    private Arg(Type type, String description, boolean defaultBoolean, Opt ... options) {
        this(new Type[]{type}, description, defaultBoolean, options);
    }

    private Arg(Type[] type, String description, boolean defaultBoolean, Opt ... options) {
        this(type, null, description, defaultBoolean, options);
    }

    private Arg(Type type, String alternativeName, String description, Opt ... options) {
        this(new Type[]{type}, alternativeName, description, options);
    }

    private Arg(Type[] type, String alternativeName, String description, Opt ... options) {
        this(type, alternativeName, description, false, options);
    }

    private Arg(Type type, String alternativeName, String description, boolean defaultBoolean, Opt ... options) {
        this(new Type[]{type}, alternativeName, description, defaultBoolean, options);
    }

    private Arg(Type[] type, String alternativeName, String description, boolean defaultBoolean, Opt ... options) {
        String[] stringArray;
        this.types = type;
        this.description = description;
        this.defaultBoolValue = defaultBoolean;
        this.setOptions(options);
        if (alternativeName != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getName();
            stringArray = stringArray2;
            stringArray2[1] = alternativeName;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.getName();
        }
        this.argNames = stringArray;
    }

    public String argString() {
        return this.argString(false);
    }

    public String negateArgString() {
        return this.argString(true);
    }

    private String argString(boolean negate) {
        StringBuilder sb = new StringBuilder("--");
        if (negate && this.hasOption(Opt.BOOLEAN)) {
            sb.append("no");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getName()).append('.').append(this.name());
        sb.append('(');
        if (this.getNames().length > 0) {
            sb.append('\"');
        }
        sb.append(String.join((CharSequence)"\", \"", this.getNames()));
        if (this.getNames().length > 0) {
            sb.append('\"');
        }
        sb.append(")\n");
        for (Type type : this.getTypes()) {
            String typeName = type.name();
            sb.append("\nType: " + typeName);
        }
        sb.append("\nOpt: ");
        List optList = Arrays.asList(this.argOptions).stream().map(opt -> opt.name()).collect(Collectors.toList());
        sb.append(String.join((CharSequence)", ", optList));
        sb.append("\n");
        return sb.toString();
    }

    public String[] getNames() {
        return this.argNames;
    }

    public String getName() {
        String name = this.hasOption(Opt.PRESERVECASE) ? this.name() : this.name().toLowerCase(Locale.ROOT);
        return name.replace('_', '-');
    }

    public final String toString() {
        return this.getName();
    }

    public boolean hasOption(Opt o) {
        if (this.argOptions == null) {
            return false;
        }
        for (Opt option : this.argOptions) {
            if (o != option) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllOptions(Opt ... opts) {
        for (Opt o : opts) {
            if (this.hasOption(o)) continue;
            return false;
        }
        return true;
    }

    protected Opt[] getOptions() {
        return this.argOptions;
    }

    protected void setOptions(Opt ... options) {
        this.argOptions = options;
    }

    protected boolean getDefaultBoolValue() {
        return this.defaultBoolValue;
    }

    public Type getFirstType() {
        return this.getTypes()[0];
    }

    public Type[] getTypes() {
        return this.types;
    }

    public boolean sharesType(Arg a) {
        return this.hasType(a.getTypes());
    }

    public boolean hasType(Type ... types) {
        HashSet<Type> typesSet = new HashSet<Type>(Arrays.asList(types));
        return this.hasType(typesSet);
    }

    public boolean hasType(Set<Type> typesSet) {
        for (Type type : this.getTypes()) {
            if (!typesSet.contains((Object)type)) continue;
            return true;
        }
        return false;
    }

    protected String getDescription() {
        return this.description;
    }

    public static String booleanArgString(Arg a) {
        StringBuilder sb = new StringBuilder(a.argString());
        if (a.hasOption(Opt.BOOLEAN)) {
            sb.append('/');
            sb.append(a.negateArgString());
        }
        return sb.toString();
    }

    public static final String usage() {
        return Arg.usage(null);
    }

    public static final void appendUsageGeneral(StringBuilder sb, int maxArgLength) {
        HashSet<Type> firstTypes = new HashSet<Type>();
        for (Arg a : EnumSet.allOf(Arg.class)) {
            if (firstTypes.contains((Object)a.getFirstType())) continue;
            firstTypes.add(a.getFirstType());
        }
        for (Type t : EnumSet.allOf(Type.class)) {
            if (t.description() == null || !firstTypes.contains((Object)t)) continue;
            StringBuilder argSb = new StringBuilder();
            argSb.append(HELP.argString()).append("-").append(t.name().toLowerCase(Locale.ROOT));
            Arg.appendArgAndDescription(sb, argSb.toString(), "Help for " + t.description(), null, maxArgLength);
            sb.append(System.lineSeparator());
        }
    }

    public static final String usage(List<Type> types) {
        StringBuilder sb = new StringBuilder();
        sb.append("usage: jalview [" + HEADLESS.argString() + "] [[" + OPEN.argString() + "/" + APPEND.argString() + "] file(s)] [args]");
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        if (types == null || types.contains(null)) {
            Arg.appendArgAndDescription(sb, null, "Display this basic help", HELP, 20);
            sb.append(System.lineSeparator());
            Arg.appendUsageGeneral(sb, 20);
        } else {
            List<Arg> args = Arg.argsSortedForDisplay(types);
            int maxArgLength = 20;
            Arg.appendArgAndDescription(sb, null, null, HELP, maxArgLength);
            sb.append(System.lineSeparator());
            if (args.contains((Object)HELP) && types.contains((Object)Type.ALL)) {
                Arg.appendUsageGeneral(sb, maxArgLength);
            }
            Iterator<Arg> argsI = args.iterator();
            Type typeSection = null;
            while (argsI.hasNext()) {
                Arg a = argsI.next();
                if (a.hasOption(Opt.PRIVATE) || a.hasOption(Opt.SECRET) || a == HELP) continue;
                if (a.getFirstType() != typeSection) {
                    typeSection = a.getFirstType();
                    String typeDescription = a.getFirstType().description();
                    if (typeDescription != null && typeDescription.length() > 0) {
                        typeDescription = typeDescription.toUpperCase(Locale.ROOT);
                        sb.append(typeDescription);
                        sb.append(System.lineSeparator());
                        sb.append(System.lineSeparator());
                    }
                }
                Arg.appendArgUsage(sb, a, maxArgLength, Platform.consoleWidth());
                if (!argsI.hasNext()) continue;
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    private static void appendArgUsage(StringBuilder sb, Arg a, int maxArgLength, int maxWidth) {
        boolean first = Arg.appendArgAndDescription(sb, null, null, a, maxArgLength);
        ArrayList<String> options = new ArrayList<String>();
        for (Opt o : EnumSet.allOf(Opt.class)) {
            if (!a.hasOption(o) || o.description() == null) continue;
            options.add(o.description());
        }
        String optDisplaySeparator = "; ";
        if (options.size() > 0) {
            int linelength = 0;
            String spacing = String.format("%-" + (maxArgLength + ARGDESCRIPTIONSEPARATOR.length()) + "s", "");
            if (first) {
                sb.append(ARGDESCRIPTIONSEPARATOR);
                linelength += maxArgLength + ARGDESCRIPTIONSEPARATOR.length();
            } else {
                sb.append(spacing);
                linelength += spacing.length();
            }
            if (options.size() > 0) {
                boolean optFirst = true;
                ListIterator optionsI = options.listIterator();
                while (optionsI.hasNext()) {
                    int descLength;
                    String desc = (String)optionsI.next();
                    if (optFirst) {
                        sb.append("(");
                        ++linelength;
                    }
                    if (linelength + (descLength = desc.length() + (optionsI.hasNext() ? "; ".length() : 0)) > maxWidth) {
                        sb.append(System.lineSeparator());
                        linelength = 0;
                        sb.append(spacing);
                        linelength += spacing.length();
                    }
                    sb.append(desc);
                    linelength += desc.length();
                    if (optionsI.hasNext()) {
                        sb.append("; ");
                        linelength += "; ".length();
                    }
                    optFirst = false;
                }
                sb.append(')');
                sb.append(System.lineSeparator());
            }
        }
    }

    public static String argDisplayString(Arg a) {
        StringBuilder argSb = new StringBuilder();
        argSb.append(a.hasOption(Opt.BOOLEAN) ? Arg.booleanArgString(a) : a.argString());
        if (a.hasOption(Opt.STRING)) {
            if (a.hasOption(Opt.PREFIXKEV)) {
                argSb.append("key=value");
            } else {
                argSb.append("=value");
            }
        }
        return argSb.toString();
    }

    public static boolean appendArgAndDescription(StringBuilder sb, String aString, String description, Arg a, int maxArgLength) {
        return Arg.appendArgAndDescription(sb, aString, description, a, maxArgLength, Platform.consoleWidth());
    }

    public static boolean appendArgAndDescription(StringBuilder sb, String aString, String description, Arg a, int maxArgLength, int maxLength) {
        if (aString == null && a != null) {
            aString = Arg.argDisplayString(a);
        }
        if (description == null && a != null) {
            description = a.getDescription();
        }
        sb.append(String.format("%-" + maxArgLength + "s", aString));
        if (aString.length() > maxArgLength) {
            sb.append(System.lineSeparator());
            sb.append(String.format("%-" + maxArgLength + "s", ""));
        }
        int descLength = maxLength - maxArgLength - ARGDESCRIPTIONSEPARATOR.length();
        Iterator descLines = null;
        if (description != null) {
            descLines = Arrays.stream(description.split("\\n")).iterator();
        }
        ArrayList<String> splitDescLinesList = new ArrayList<String>();
        while (descLines != null && descLines.hasNext()) {
            String line = (String)descLines.next();
            while (line.length() > descLength) {
                int splitIndex = line.lastIndexOf(" ", descLength);
                splitDescLinesList.add(line.substring(0, splitIndex));
                line = line.substring(splitIndex + 1);
            }
            splitDescLinesList.add(line);
        }
        Iterator splitDescLines = splitDescLinesList.iterator();
        boolean first = true;
        if (splitDescLines != null) {
            while (splitDescLines.hasNext()) {
                if (first) {
                    sb.append(ARGDESCRIPTIONSEPARATOR);
                } else {
                    sb.append(String.format("%-" + (maxArgLength + ARGDESCRIPTIONSEPARATOR.length()) + "s", ""));
                }
                sb.append((String)splitDescLines.next());
                sb.append(System.lineSeparator());
                first = false;
            }
        }
        return first;
    }

    protected static Iterator<Arg> getAllOfType(Type type) {
        return Arg.getAllOfType(type, new Opt[0]);
    }

    protected static Iterator<Arg> getAllOfType(Type type, Opt ... options) {
        Opt[] opts = options == null ? new Opt[]{} : options;
        return EnumSet.allOf(Arg.class).stream().filter(a -> {
            if (!a.hasType(type)) {
                return false;
            }
            for (Opt o : opts) {
                if (a.hasOption(o)) continue;
                return false;
            }
            return true;
        }).iterator();
    }

    private static List<Arg> argsSortedForDisplay(List<Type> types) {
        List<Arg> argsToSort;
        if (types == null || types.size() == 0 || types.contains((Object)Type.ALL)) {
            argsToSort = Arrays.asList(EnumSet.allOf(Arg.class).toArray(new Arg[0]));
        } else {
            argsToSort = new ArrayList<Arg>();
            for (Type type : types) {
                if (type == null) continue;
                Arg.getAllOfType(type).forEachRemaining(a -> argsToSort.add((Arg)((Object)a)));
            }
        }
        Collections.sort(argsToSort, new ArgDisplayComparator());
        return argsToSort;
    }

    public static enum Type {
        HELP,
        CONFIG("arguments used to configure " + ChannelProperties.getProperty("app_name") + " from startup"),
        OPENING("arguments used to open and format alignments"),
        STRUCTURE("arguments used to add and format 3D structure data"),
        PROCESS("arguments used to process an alignment once opened"),
        OUTPUT("arguments used to save data from a processed alignment"),
        IMAGE("arguments used to export an image of an alignment"),
        STRUCTUREIMAGE("arguments used to export an image of an structure"),
        FLOW("arguments that control processing of the other arguments"),
        ALL("all arguments"),
        NONE,
        INVALID;

        private String description;

        private Type() {
            this.description = null;
        }

        private Type(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }

    public static enum Opt {
        BOOLEAN("can be negated with --no..."),
        STRING("expects a value"),
        UNARY(null),
        MULTIVALUE("can be specified multiple times"),
        LINKED("is linked to an alignment"),
        NODUPLICATEVALUES("cannot have the same value more than once"),
        BOOTSTRAP("a configuration argument"),
        GLOB("can take multiple filenames with wildcards"),
        NOACTION(null),
        ALLOWSUBSTITUTIONS("values can use substitutions"),
        PRIVATE(null),
        SECRET(null),
        ALLOWMULTIID("can be used with --all"),
        INCREMENTDEFAULTCOUNTER("starts a new default alignment"),
        INPUT(null),
        REQUIREINPUT(null),
        OUTPUTFILE("output file --headless will be assumed unless --gui used"),
        STDOUT("allows the output filename '-' to mean output to STDOUT"),
        STORED(null),
        HELP("provides a help statement"),
        PRIMARY("is a primary argument for its type"),
        HASTYPE(null),
        FIRST(null),
        LAST(null),
        PREFIXKEV("prefixes key=value"),
        PRESERVECASE(null);

        private String description;

        private Opt() {
            this.description = null;
        }

        private Opt(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }
}

