/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.analytics.Plausible;
import jalview.bin.BuildDetails;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgParser;
import jalview.datamodel.PDBEntry;
import jalview.gui.Preferences;
import jalview.io.PIRFile;
import jalview.jbgui.GDesktop;
import jalview.jbgui.GPreferences;
import jalview.log.JLoggerLog4j;
import jalview.schemes.ColourSchemeLoader;
import jalview.schemes.ColourSchemes;
import jalview.schemes.UserColourScheme;
import jalview.structure.StructureImportSettings;
import jalview.urls.IdOrgSettings;
import jalview.util.ChannelProperties;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.HttpUtils;
import jalview.util.LaunchUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.sifts.SiftsSettings;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Cache {
    public static final String CASTORLOGLEVEL = "logs.Castor.level";
    public static final String AXISLOGLEVEL = "logs.Axis.level";
    public static final String JALVIEWLOGLEVEL = "logs.Jalview.level";
    public static final String BOOTSTRAP_TEST = "BOOTSTRAP_TEST";
    public static final String DEFAULT_SIFTS_DOWNLOAD_DIR = System.getProperty("user.home") + File.separatorChar + ".sifts_downloads" + File.separatorChar;
    private static final String DEFAULT_CACHE_THRESHOLD_IN_DAYS = "2";
    private static final String DEFAULT_FAIL_SAFE_PID_THRESHOLD = "30";
    private static final String ID_ORG_FILE = System.getProperty("user.home") + File.separatorChar + ".identifiers.org.ids.json";
    private static final String PDB_DOWNLOAD_FORMAT = PDBEntry.Type.MMCIF.toString();
    private static final String DEFAULT_PDB_FILE_PARSER = StructureImportSettings.StructureParser.JMOL_PARSER.toString();
    private static final DateFormat date_format = SimpleDateFormat.getDateTimeInstance(2, 2, Locale.UK);
    public static final String JALVIEW_LOGGER_NAME = "JalviewLogger";
    public static final String[] startupProxyProperties = new String[]{System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("https.proxyHost"), System.getProperty("https.proxyPort"), System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword"), System.getProperty("https.proxyUser"), System.getProperty("https.proxyPassword"), System.getProperty("http.nonProxyHosts")};
    public static final String PROXYTYPE_NONE = "none";
    public static final String PROXYTYPE_SYSTEM = "false";
    public static final String PROXYTYPE_CUSTOM = "true";
    public static char[] proxyAuthPassword = null;
    private static Map<String, String> sessionProperties = new HashMap<String, String>();
    private static boolean bypassSessionProperties = false;
    public static Properties applicationProperties = new Properties(){

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    };
    public static Properties buildProperties = new Properties();
    static String propertiesFile;
    private static final String fallbackPropertiesFile = ".jalview_properties";
    private static boolean propsAreReadOnly;
    private static final String JS_PROPERTY_PREFIX = "jalview_";
    private static int vamsasJarsArePresent;
    private static int groovyJarsArePresent;
    private static final String APPLICATION_STARTED = "Application Started";
    private static final String releaseAppbase;
    private static String getdownAppbase;
    private static String getdownDistDir;
    private static final Collection<String> bootstrapProperties;

    public static void enableSessionProperties() {
        bypassSessionProperties = false;
    }

    public static void disableSessionProperties() {
        bypassSessionProperties = true;
    }

    public static boolean isPropsAreReadOnly() {
        return propsAreReadOnly;
    }

    public static void setPropsAreReadOnly(boolean propsAreReadOnly) {
        Cache.propsAreReadOnly = propsAreReadOnly;
    }

    public static void loadProperties(String propsFile) {
        block30: {
            propertiesFile = propsFile;
            String releasePropertiesFile = null;
            boolean defaultProperties = false;
            if (propsFile == null && !propsAreReadOnly) {
                String channelPrefsFilename = ChannelProperties.getProperty("preferences.filename");
                String releasePrefsFilename = fallbackPropertiesFile;
                propertiesFile = System.getProperty("user.home") + File.separatorChar + channelPrefsFilename;
                releasePropertiesFile = System.getProperty("user.home") + File.separatorChar + releasePrefsFilename;
                defaultProperties = true;
            } else {
                propsAreReadOnly = true;
            }
            if (propertiesFile == null) {
                Platform.readInfoProperties(JS_PROPERTY_PREFIX, applicationProperties);
            } else {
                try {
                    InputStream fis;
                    try {
                        fis = HttpUtils.openStream(new URL(propertiesFile));
                        if (!Jalview.quiet()) {
                            Console.outPrintln("Loading jalview properties from : " + propertiesFile);
                            Console.outPrintln("Disabling Jalview writing to user's local properties file.");
                        }
                        propsAreReadOnly = true;
                    }
                    catch (Exception ex) {
                        fis = null;
                    }
                    if (fis == null) {
                        Object readPropertiesFile = propertiesFile;
                        if (defaultProperties && !new File(propertiesFile).exists() && new File(releasePropertiesFile).exists()) {
                            readPropertiesFile = releasePropertiesFile;
                        }
                        fis = new FileInputStream((String)readPropertiesFile);
                    }
                    applicationProperties.clear();
                    applicationProperties.load(fis);
                    Cache.deleteBuildProperties();
                    fis.close();
                }
                catch (Exception ex) {
                    if (Jalview.quiet()) break block30;
                    Console.outPrintln("Error reading properties file: " + ex);
                }
            }
        }
        String proxyType = Cache.getDefault("USE_PROXY", PROXYTYPE_SYSTEM);
        switch (proxyType) {
            case "none": {
                Cache.clearProxyProperties();
                break;
            }
            case "false": {
                Cache.resetProxyProperties();
                break;
            }
            case "true": {
                String httpHost = Cache.getDefault("PROXY_SERVER", "");
                String httpPort = Cache.getDefault("PROXY_PORT", "8080");
                String httpsHost = Cache.getDefault("PROXY_SERVER_HTTPS", httpHost);
                String httpsPort = Cache.getDefault("PROXY_PORT_HTTPS", httpPort);
                String httpUser = Cache.getDefault("PROXY_AUTH_USER", null);
                String httpsUser = Cache.getDefault("PROXY_AUTH_USER_HTTPS", httpUser);
                Cache.setProxyProperties(httpHost, httpPort, httpsHost, httpsPort, httpUser, proxyAuthPassword, httpsUser, proxyAuthPassword, "localhost");
                break;
            }
            default: {
                String message = "Incorrect PROXY_TYPE - should be 'none' (clear proxy properties), 'false' (system settings), 'true' (custom settings): " + proxyType;
                Console.warn(message);
            }
        }
        String authorDetails = Cache.resolveResourceURLFor("/authors.props");
        try {
            if (authorDetails != null) {
                URL localJarFileURL = new URL(authorDetails);
                InputStream in = localJarFileURL.openStream();
                applicationProperties.load(in);
                in.close();
            }
        }
        catch (Exception ex) {
            if (!Jalview.quiet()) {
                Console.outPrintln("Error reading author details: " + ex);
            }
            authorDetails = null;
        }
        if (authorDetails == null) {
            applicationProperties.remove("AUTHORS");
            applicationProperties.remove("AUTHORFNAMES");
            applicationProperties.remove("YEAR");
        }
        Cache.loadBuildProperties(false);
        SiftsSettings.setMapWithSifts(Cache.getDefault("MAP_WITH_SIFTS", false));
        SiftsSettings.setSiftDownloadDirectory(Cache.getDefault("sifts_download_dir", DEFAULT_SIFTS_DOWNLOAD_DIR));
        SiftsSettings.setFailSafePIDThreshold(Cache.getDefault("sifts_fail_safe_pid_threshold", DEFAULT_FAIL_SAFE_PID_THRESHOLD));
        SiftsSettings.setCacheThresholdInDays(Cache.getDefault("sifts_cache_threshold_in_days", DEFAULT_CACHE_THRESHOLD_IN_DAYS));
        IdOrgSettings.setUrl(Cache.getDefault("ID_ORG_HOSTURL", "https://www.jalview.org/services/identifiers"));
        IdOrgSettings.setDownloadLocation(ID_ORG_FILE);
        StructureImportSettings.setDefaultStructureFileFormat(Cache.getDefault("PDB_DOWNLOAD_FORMAT", PDB_DOWNLOAD_FORMAT));
        StructureImportSettings.setDefaultPDBFileParser(DEFAULT_PDB_FILE_PARSER);
        String jnlpVersion = System.getProperty("jalview.version");
        if (jnlpVersion == null && Cache.getDefault("VERSION_CHECK", true) && (System.getProperty("java.awt.headless") == null || System.getProperty("java.awt.headless").equals(PROXYTYPE_SYSTEM))) {
            class VersionChecker
            extends Thread {
                VersionChecker() {
                }

                @Override
                public void run() {
                    String remoteBuildPropertiesUrl = Cache.getAppbaseBuildProperties();
                    String orgtimeout = System.getProperty("sun.net.client.defaultConnectTimeout");
                    if (orgtimeout == null) {
                        orgtimeout = Cache.DEFAULT_FAIL_SAFE_PID_THRESHOLD;
                        Console.debug("Setting default net timeout to " + orgtimeout + " seconds.");
                    }
                    String remoteVersion = null;
                    if (remoteBuildPropertiesUrl.startsWith("http")) {
                        try {
                            System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
                            URL url = new URL(remoteBuildPropertiesUrl);
                            BufferedReader in = new BufferedReader(new InputStreamReader(HttpUtils.openStream(url)));
                            Properties remoteBuildProperties = new Properties();
                            remoteBuildProperties.load(in);
                            remoteVersion = remoteBuildProperties.getProperty("VERSION");
                        }
                        catch (Exception ex) {
                            if (!Jalview.quiet()) {
                                Console.errPrintln("Non-fatal exception when checking version at " + remoteBuildPropertiesUrl + ":");
                                Console.printStackTrace(ex);
                            }
                            remoteVersion = Cache.getProperty("VERSION");
                        }
                    }
                    System.setProperty("sun.net.client.defaultConnectTimeout", orgtimeout);
                    Cache.setProperty("LATEST_VERSION", remoteVersion);
                }
            }
            VersionChecker vc = new VersionChecker();
            vc.start();
        } else if (jnlpVersion != null) {
            Cache.setProperty("LATEST_VERSION", jnlpVersion);
        } else {
            applicationProperties.remove("LATEST_VERSION");
        }
        Cache.initUserColourSchemes(Cache.getProperty("USER_DEFINED_COLOURS"));
        PIRFile.useModellerOutput = Cache.getDefault("PIR_MODELLER", false);
    }

    private static String resolveResourceURLFor(String resourcePath) {
        String url = null;
        if (Platform.isJS() || !Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().endsWith(".jar")) {
            try {
                url = Cache.class.getResource(resourcePath).toString();
            }
            catch (Exception ex) {
                Console.errPrintln("Failed to resolve resource " + resourcePath + ": " + ex.getMessage());
            }
        } else {
            url = "jar:".concat(Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!" + resourcePath));
        }
        return url;
    }

    public static void loadBuildProperties(boolean reportVersion) {
        Object codeInstallation = Cache.getProperty("INSTALLATION");
        boolean printVersion = codeInstallation == null;
        try {
            String buildDetails = Cache.resolveResourceURLFor("/.build_properties");
            URL localJarFileURL = new URL(buildDetails);
            InputStream in = localJarFileURL.openStream();
            buildProperties.load(in);
            in.close();
            if (buildProperties.getProperty("BUILD_DATE", null) != null) {
                applicationProperties.put("BUILD_DATE", buildProperties.getProperty("BUILD_DATE"));
            }
            if (buildProperties.getProperty("INSTALLATION", null) != null) {
                applicationProperties.put("INSTALLATION", buildProperties.getProperty("INSTALLATION"));
            }
            if (buildProperties.getProperty("VERSION", null) != null) {
                applicationProperties.put("VERSION", buildProperties.getProperty("VERSION"));
            }
            if (buildProperties.getProperty("JAVA_COMPILE_VERSION", null) != null) {
                applicationProperties.put("JAVA_COMPILE_VERSION", buildProperties.getProperty("JAVA_COMPILE_VERSION"));
            }
        }
        catch (Exception ex) {
            if (!Jalview.quiet()) {
                Console.outPrintln("Error reading build details: " + ex);
            }
            applicationProperties.remove("VERSION");
        }
        String codeVersion = Cache.getProperty("VERSION");
        codeInstallation = Cache.getProperty("INSTALLATION");
        if (codeVersion == null) {
            codeVersion = "Test";
            codeInstallation = "";
        } else {
            codeInstallation = " (" + (String)codeInstallation + ")";
        }
        Cache.setProperty("VERSION", codeVersion);
        new BuildDetails(codeVersion, null, (String)codeInstallation);
        if (printVersion && reportVersion) {
            Console.outPrintln(ChannelProperties.getProperty("app_name") + " version: " + codeVersion + (String)codeInstallation);
        }
    }

    private static void deleteBuildProperties() {
        applicationProperties.remove("LATEST_VERSION");
        applicationProperties.remove("VERSION");
        applicationProperties.remove("AUTHORS");
        applicationProperties.remove("AUTHORFNAMES");
        applicationProperties.remove("YEAR");
        applicationProperties.remove("BUILD_DATE");
        applicationProperties.remove("INSTALLATION");
    }

    public static String getProperty(String key) {
        return Cache.getProperty(key, false);
    }

    public static String getProperty(String key, boolean skipSessionProperties) {
        String prop = null;
        if (!skipSessionProperties && !bypassSessionProperties) {
            prop = Cache.getSessionProperty(key);
        }
        if (prop == null) {
            prop = applicationProperties.getProperty(key);
        }
        if (prop == null && Platform.isJS()) {
            prop = applicationProperties.getProperty(Platform.getUniqueAppletID() + "_jalview_" + key);
        }
        return prop;
    }

    public static boolean getDefault(String property, boolean def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            def = Boolean.valueOf(string);
        }
        return def;
    }

    public static int getDefault(String property, int def) {
        block3: {
            String string = Cache.getProperty(property);
            if (string != null) {
                try {
                    def = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    if (Jalview.quiet()) break block3;
                    Console.errPrintln("Error parsing int property '" + property + "' with value '" + string + "'");
                }
            }
        }
        return def;
    }

    public static float getDefault(String property, float def) {
        block3: {
            String string = Cache.getProperty(property);
            if (string != null) {
                try {
                    def = Float.parseFloat(string);
                }
                catch (NumberFormatException e) {
                    if (Jalview.quiet()) break block3;
                    Console.errPrintln("Error parsing float property '" + property + "' with value '" + string + "'");
                }
            }
        }
        return def;
    }

    public static String getDefault(String property, String def) {
        String value = Cache.getProperty(property);
        return value == null ? def : value;
    }

    public static Object setProperty(String key, String obj) {
        Object oldValue;
        block4: {
            oldValue = null;
            try {
                oldValue = applicationProperties.setProperty(key, obj);
                if (!(propertiesFile == null || propsAreReadOnly || obj == null && oldValue == null || obj != null && obj.equals(oldValue))) {
                    if (sessionProperties.containsKey(key)) {
                        sessionProperties.remove(key);
                    }
                    FileOutputStream out = new FileOutputStream(propertiesFile);
                    applicationProperties.store(out, "---JalviewX Properties File---");
                    out.close();
                }
            }
            catch (Exception ex) {
                if (Jalview.quiet()) break block4;
                Console.errPrintln("Error setting property: " + key + " " + obj + "\n" + ex);
            }
        }
        return oldValue;
    }

    public static void removeProperty(String string) {
        applicationProperties.remove(string);
        Cache.saveProperties();
    }

    public static void saveProperties() {
        block3: {
            if (!propsAreReadOnly) {
                try {
                    FileOutputStream out = new FileOutputStream(propertiesFile);
                    applicationProperties.store(out, "---JalviewX Properties File---");
                    out.close();
                }
                catch (Exception ex) {
                    if (Jalview.quiet()) break block3;
                    Console.errPrintln("Error saving properties: " + ex);
                }
            }
        }
    }

    public static boolean vamsasJarsPresent() {
        if (vamsasJarsArePresent == -1) {
            try {
                if (GDesktop.class.getClassLoader().loadClass("uk.ac.vamsas.client.VorbaId") != null) {
                    Console.debug("Found Vamsas Classes (uk.ac..vamsas.client.VorbaId can be loaded)");
                    vamsasJarsArePresent = 1;
                    JLoggerLog4j lvclient = JLoggerLog4j.getLogger("uk.ac.vamsas", Console.getCachedLogLevel("logs.Vamsas.Level"));
                    JLoggerLog4j.addAppender(lvclient, Console.log, JALVIEW_LOGGER_NAME);
                    lvclient.debug(ChannelProperties.getProperty("app_name") + " Vamsas Client Debugging Output Follows.");
                }
            }
            catch (Exception e) {
                vamsasJarsArePresent = 0;
                Console.debug("Vamsas Classes are not present");
            }
        }
        return vamsasJarsArePresent > 0;
    }

    public static boolean groovyJarsPresent() {
        if (groovyJarsArePresent == -1) {
            try {
                if (Cache.class.getClassLoader().loadClass("groovy.lang.GroovyObject") != null) {
                    Console.debug("Found Groovy (groovy.lang.GroovyObject can be loaded)");
                    groovyJarsArePresent = 1;
                    JLoggerLog4j lgclient = JLoggerLog4j.getLogger("groovy", Console.getCachedLogLevel("logs.Groovy.Level"));
                    JLoggerLog4j.addAppender(lgclient, Console.log, JALVIEW_LOGGER_NAME);
                    lgclient.debug(ChannelProperties.getProperty("app_name") + " Groovy Client Debugging Output Follows.");
                }
            }
            catch (Error e) {
                groovyJarsArePresent = 0;
                Console.debug("Groovy Classes are not present", e);
            }
            catch (Exception e) {
                groovyJarsArePresent = 0;
                Console.debug("Groovy Classes are not present");
            }
        }
        return groovyJarsArePresent > 0;
    }

    public static void initAnalytics() {
        Plausible.setEnabled(true);
        String appName = ChannelProperties.getProperty("app_name") + " Desktop";
        String version = Cache.getProperty("VERSION") + "_" + Cache.getDefault("BUILD_DATE", "unknown");
        ArrayList<Object> pathParts = new ArrayList<Object>();
        pathParts.add(appName);
        pathParts.add(version);
        pathParts.add(APPLICATION_STARTED);
        String path = ("/" + String.join((CharSequence)"/", pathParts)).replace(' ', '+');
        Plausible plausible = Plausible.getInstance();
        plausible.sendEvent("application_launch", path, true, new String[0]);
    }

    public static Color getDefaultColour(String property, Color defcolour) {
        String colprop = Cache.getProperty(property);
        if (colprop == null) {
            return defcolour;
        }
        Color col = ColorUtils.parseColourString(colprop);
        if (col == null) {
            Console.warn("Couldn't parse '" + colprop + "' as a colour for " + property);
        }
        return col == null ? defcolour : col;
    }

    public static void setColourProperty(String property, Color colour) {
        Cache.setProperty(property, Format.getHexString(colour));
    }

    public static String setDateProperty(String propertyName, Date date) {
        String formatted = date_format.format(date);
        Cache.setProperty(propertyName, formatted);
        return formatted;
    }

    public static Date getDateProperty(String propertyName) {
        String val = Cache.getProperty(propertyName);
        if (val != null) {
            try {
                return date_format.parse(val);
            }
            catch (Exception ex) {
                Console.errPrintln("Invalid or corrupt date in property '" + propertyName + "' : value was '" + val + "'");
            }
        }
        return null;
    }

    public static Integer getIntegerProperty(String property) {
        String val = Cache.getProperty(property);
        if (val != null && (val = val.trim()).length() > 0) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException x) {
                Console.errPrintln("Invalid integer in property '" + property + "' (value was '" + val + "')");
            }
        }
        return null;
    }

    public static void setOrRemove(String propName, String value) {
        if (propName == null) {
            return;
        }
        if (value == null || value.trim().length() < 1) {
            applicationProperties.remove(propName);
        } else {
            applicationProperties.setProperty(propName, value);
        }
    }

    public static void initUserColourSchemes(String files) {
        if (files == null || files.length() == 0) {
            return;
        }
        StringBuffer coloursFound = new StringBuffer();
        StringTokenizer st = new StringTokenizer(files, "|");
        while (st.hasMoreElements()) {
            String file = st.nextToken();
            try {
                UserColourScheme ucs = ColourSchemeLoader.loadColourScheme(file);
                if (ucs == null) continue;
                if (coloursFound.length() > 0) {
                    coloursFound.append("|");
                }
                coloursFound.append(file);
                ColourSchemes.getInstance().registerColourScheme(ucs);
            }
            catch (Exception ex) {
                if (Jalview.quiet()) continue;
                Console.outPrintln("Error loading User ColourFile\n" + ex);
            }
        }
        if (!files.equals(coloursFound.toString())) {
            if (coloursFound.toString().length() > 1) {
                Cache.setProperty("USER_DEFINED_COLOURS", coloursFound.toString());
            } else {
                applicationProperties.remove("USER_DEFINED_COLOURS");
            }
        }
    }

    private static void appendIfNotNull(StringBuilder sb, String prefix, String value, String suffix, String defaultValue) {
        if (value == null && defaultValue == null) {
            return;
        }
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(value == null ? defaultValue : value);
        if (suffix != null) {
            sb.append(suffix);
        }
    }

    public static String getVersionDetailsForConsole() {
        boolean extra = Console.isDebugEnabled() || !"release".equals(ChannelProperties.getProperty("channel"));
        StringBuilder sb = new StringBuilder();
        sb.append(ChannelProperties.getProperty("app_name")).append(" Version: ");
        sb.append(Cache.getDefault("VERSION", "TEST"));
        sb.append("\n");
        sb.append(ChannelProperties.getProperty("app_name")).append(" Installation: ");
        sb.append(Cache.getDefault("INSTALLATION", "unknown"));
        sb.append("\n");
        Cache.appendIfNotNull(sb, "Channel: ", ChannelProperties.getProperty("channel"), "\n", null);
        sb.append("Build Date: ");
        sb.append(Cache.getDefault("BUILD_DATE", "unknown"));
        sb.append("\n");
        if (extra) {
            Cache.appendIfNotNull(sb, "Preferences file: ", propertiesFile, "\n", "unknown");
            Cache.appendIfNotNull(sb, "Log file: ", System.getProperty("installer.logfile"), "\n", "unknown");
        }
        sb.append("Java version: ");
        sb.append(System.getProperty("java.version"));
        sb.append("\n");
        if (extra) {
            Cache.appendIfNotNull(sb, "Java home: ", System.getProperty("java.home"), "\n", "unknown");
            Cache.appendIfNotNull(sb, "Java launch class: ", System.getProperty("sun.java.command"), "\n", "unknown");
            sb.append("Java platform: ");
            sb.append(System.getProperty("os.name"));
            sb.append(" ");
            sb.append(System.getProperty("os.version"));
            sb.append(" (");
            sb.append(System.getProperty("os.arch"));
            sb.append(")");
            sb.append("\n");
            LookAndFeel laf = UIManager.getLookAndFeel();
            String lafName = laf == null ? "Not obtained" : laf.getName();
            String lafClass = laf == null ? "unknown" : laf.getClass().getName();
            sb.append("Java LAF: ");
            sb.append(lafName);
            sb.append(" (");
            sb.append(lafClass);
            sb.append(")\n");
            if (LaunchUtils.getJavaVersion() > 8) {
                sb.append("Java Virtual Machine PID: ");
                sb.append(ProcessHandle.current().pid());
                sb.append("\n");
            }
        }
        Cache.appendIfNotNull(sb, "Installer version: ", System.getProperty("sys.install4jVersion"), "\n", null);
        if (extra) {
            Object installerAppdir = System.getProperty("installer.appdir");
            if (installerAppdir != null) {
                try {
                    String temp = new File((String)installerAppdir).getCanonicalPath();
                    installerAppdir = temp;
                }
                catch (IOException e) {
                    installerAppdir = "(non-canonical) " + (String)installerAppdir;
                    Console.warn("Could not get canonical path for installer appdir, leaving as is.");
                }
            }
            Cache.appendIfNotNull(sb, "Installer template version: ", System.getProperty("installer.template_version"), "\n", null);
            Cache.appendIfNotNull(sb, "Installer appdir: ", (String)installerAppdir, "\n", null);
            Cache.appendIfNotNull(sb, "Installer extrainfo: ", System.getProperty("installer.extrainfo"), "\n", null);
        }
        Cache.appendIfNotNull(sb, "Launcher version: ", System.getProperty("launcher.version"), "\n", null);
        if (extra) {
            Cache.appendIfNotNull(sb, "Launcher appdir: ", System.getProperty("launcher.appdir"), "\n", null);
            Cache.appendIfNotNull(sb, "Launcher distdir: ", System.getProperty("launcher.distdir"), "\n", null);
            Cache.appendIfNotNull(sb, "Launcher appbase: ", System.getProperty("launcher.appbase"), "\n", null);
            Cache.appendIfNotNull(sb, "Launcher script: ", System.getProperty("launcher.script"), "\n", null);
        }
        return sb.toString();
    }

    public static String getBuildDetailsForSplash() {
        return Cache.getDefault("INSTALLATION", "unknown");
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static void clearProxyProperties() {
        Cache.setProxyProperties(null, null, null, null, null, null, null, null, null);
    }

    public static void resetProxyProperties() {
        Cache.setProxyProperties(startupProxyProperties[0], startupProxyProperties[1], startupProxyProperties[2], startupProxyProperties[3], startupProxyProperties[4], startupProxyProperties[5] == null ? null : startupProxyProperties[5].toCharArray(), startupProxyProperties[6], startupProxyProperties[7] == null ? null : startupProxyProperties[7].toCharArray(), startupProxyProperties[8]);
        StringBuilder sb = new StringBuilder();
        sb.append("Setting proxy properties to: http.proxyHost=").append(startupProxyProperties[0]).append(", http.proxyPort=").append(startupProxyProperties[1]).append((String)(startupProxyProperties[4] != null && !startupProxyProperties[4].isEmpty() ? " [" + startupProxyProperties[4] + "]" : "")).append(", https.proxyHost=").append(startupProxyProperties[2]).append(", https.proxyPort=").append(startupProxyProperties[3]).append((String)(startupProxyProperties[6] != null && !startupProxyProperties[6].isEmpty() ? " [" + startupProxyProperties[6] + "]" : ""));
        Console.debug(sb.toString());
    }

    public static void setProxyPropertiesFromPreferences() {
        Cache.setProxyPropertiesFromPreferences(PROXYTYPE_SYSTEM);
    }

    public static void setProxyPropertiesFromPreferences(String previousProxyType) {
        String proxyType = Cache.getDefault("USE_PROXY", PROXYTYPE_SYSTEM);
        if (previousProxyType != null && !proxyType.equals(PROXYTYPE_CUSTOM) && proxyType.equals(previousProxyType)) {
            return;
        }
        switch (proxyType) {
            case "none": {
                if (previousProxyType.equals(proxyType)) break;
                Console.info("Setting no proxy settings");
                Cache.setProxyProperties(null, null, null, null, null, null, null, null, null);
                break;
            }
            case "true": {
                Console.info("Setting custom proxy settings");
                boolean proxyAuthSet = Cache.getDefault("PROXY_AUTH", false);
                Cache.setProxyProperties(Cache.getDefault("PROXY_SERVER", null), Cache.getDefault("PROXY_PORT", null), Cache.getDefault("PROXY_SERVER_HTTPS", null), Cache.getDefault("PROXY_PORT_HTTPS", null), proxyAuthSet ? Cache.getDefault("PROXY_AUTH_USERNAME", "") : null, (char[])(proxyAuthSet ? proxyAuthPassword : null), proxyAuthSet ? Cache.getDefault("PROXY_AUTH_USERNAME", "") : null, (char[])(proxyAuthSet ? proxyAuthPassword : null), "localhost");
                break;
            }
            default: {
                Console.info("Setting system proxy settings");
                Cache.resetProxyProperties();
            }
        }
    }

    public static void setProxyProperties(final String httpHost, final String httpPort, final String httpsHost, final String httpsPort, final String httpUser, final char[] httpPassword, final String httpsUser, final char[] httpsPassword, String nonProxyHosts) {
        Cache.setOrClearSystemProperty("http.proxyHost", httpHost);
        Cache.setOrClearSystemProperty("http.proxyPort", httpPort);
        Cache.setOrClearSystemProperty("https.proxyHost", httpsHost);
        Cache.setOrClearSystemProperty("https.proxyPort", httpsPort);
        Cache.setOrClearSystemProperty("http.proxyUser", httpUser);
        Cache.setOrClearSystemProperty("https.proxyUser", httpsUser);
        final boolean customProxySet = Cache.getDefault("USE_PROXY", PROXYTYPE_SYSTEM).equals(PROXYTYPE_CUSTOM);
        if (httpUser != null || httpsUser != null) {
            try {
                final char[] displayHttpPw = new char[httpPassword == null ? 0 : httpPassword.length];
                Arrays.fill(displayHttpPw, '*');
                Console.debug("CACHE Proxy: setting new Authenticator with httpUser='" + httpUser + "' httpPassword='" + displayHttpPw + "'");
                if (!Platform.isJS()) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                                String protocol = this.getRequestingProtocol();
                                boolean needProxyPasswordSet = false;
                                if (customProxySet && protocol.equalsIgnoreCase("http") && httpUser != null && httpUser.length() > 0 && (httpPassword == null || httpPassword.length == 0) || protocol.equalsIgnoreCase("https") && httpsUser != null && httpsUser.length() > 0 && (httpsPassword == null || httpsPassword.length == 0)) {
                                    String message = MessageManager.getString("label.proxy_password_required");
                                    Preferences.openPreferences(GPreferences.TabRef.CONNECTIONS_TAB, message);
                                    Preferences.getInstance().proxyAuthPasswordCheckHighlight(true, true);
                                } else {
                                    try {
                                        if (protocol.equalsIgnoreCase("http") && this.getRequestingHost().equalsIgnoreCase(httpHost) && this.getRequestingPort() == Integer.valueOf(httpPort).intValue()) {
                                            Console.debug("AUTHENTICATOR returning PasswordAuthentication(\"" + httpUser + "\", '" + new String(displayHttpPw) + "')");
                                            return new PasswordAuthentication(httpUser, httpPassword);
                                        }
                                        if (protocol.equalsIgnoreCase("https") && this.getRequestingHost().equalsIgnoreCase(httpsHost) && this.getRequestingPort() == Integer.valueOf(httpsPort).intValue()) {
                                            char[] displayHttpsPw = new char[httpPassword.length];
                                            Arrays.fill(displayHttpsPw, '*');
                                            Console.debug("AUTHENTICATOR returning PasswordAuthentication(\"" + httpsUser + "\", '" + displayHttpsPw + "'");
                                            return new PasswordAuthentication(httpsUser, httpsPassword);
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        Console.error("Problem with proxy port values [http:" + httpPort + ", https:" + httpsPort + "]");
                                    }
                                    Console.debug("AUTHENTICATOR after trying to get PasswordAuthentication");
                                }
                            }
                            Console.debug("AUTHENTICATOR returning null");
                            return null;
                        }
                    });
                }
                Console.debug("AUTHENTICATOR setting property 'jdk.http.auth.tunneling.disabledSchemes' to \"\"");
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            }
            catch (SecurityException e) {
                Console.error("Could not set default Authenticator");
                Console.debug(Cache.getStackTraceString(e));
            }
        } else if (!Platform.isJS()) {
            Console.debug("AUTHENTICATOR setting default Authenticator to null");
            Authenticator.setDefault(null);
        }
        Console.debug("AUTHENTICATOR setting property 'http.nonProxyHosts' to \"" + nonProxyHosts + "\"");
        Cache.setOrClearSystemProperty("http.nonProxyHosts", nonProxyHosts);
    }

    public static void setOrClearSystemProperty(String key, char[] value) {
        Cache.setOrClearSystemProperty(key, value == null ? null : new String(value));
    }

    public static void setOrClearSystemProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private static void setGetdownAppbase() {
        String distDir;
        if (getdownAppbase != null) {
            return;
        }
        String appbase = System.getProperty("launcher.appbase");
        if (appbase == null) {
            appbase = System.getProperty("getdownappbase");
        }
        if ((distDir = System.getProperty("launcher.distdir")) == null) {
            distDir = System.getProperty("getdowndistdir");
        }
        if (appbase == null) {
            appbase = buildProperties.getProperty("GETDOWNAPPBASE");
            distDir = buildProperties.getProperty("GETDOWNAPPDISTDIR");
        }
        if (appbase == null) {
            appbase = releaseAppbase;
            distDir = "release";
        }
        if (appbase.endsWith("/")) {
            appbase = appbase.substring(0, appbase.length() - 1);
        }
        if (distDir == null) {
            distDir = appbase.equals(releaseAppbase) ? "release" : "alt";
        }
        getdownAppbase = appbase;
        getdownDistDir = distDir;
    }

    public static String getGetdownAppbase() {
        Cache.setGetdownAppbase();
        return getdownAppbase;
    }

    public static String getAppbaseBuildProperties() {
        String appbase = Cache.getGetdownAppbase();
        return appbase + "/" + getdownDistDir + "/build_properties";
    }

    public static Properties bootstrapProperties(String filename) {
        Properties bootstrapProps = new Properties();
        File file = null;
        if (filename != null) {
            file = new File(filename);
        }
        if (file == null || !file.exists()) {
            if (file != null) {
                Console.errPrintln("Could not load bootstrap preferences file '" + file.getPath() + "'");
            }
            String channelPrefsFilename = ChannelProperties.getProperty("preferences.filename");
            String propertiesFilename = System.getProperty("user.home") + File.separatorChar + channelPrefsFilename;
            Console.errPrintln("Using default properties file '" + propertiesFilename + "'");
            file = new File(propertiesFilename);
        }
        if (file == null || !file.exists()) {
            String releasePrefsFilename = fallbackPropertiesFile;
            String releasePropertiesFilename = System.getProperty("user.home") + File.separatorChar + releasePrefsFilename;
            Console.errPrintln("Falling back to properties file '" + releasePropertiesFilename + "'");
            file = new File(releasePropertiesFilename);
        }
        if (!file.exists()) {
            Console.errPrintln("Could not load bootstrap preferences file '" + file.getPath() + "'");
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(file.getAbsoluteFile());
            Properties props = new Properties();
            props.load(in);
            for (String prop : bootstrapProperties) {
                if (!props.containsKey(prop)) continue;
                bootstrapProps.put(prop, props.getProperty(prop));
            }
        }
        catch (FileNotFoundException e) {
            Console.errPrintln("Could not find bootstrap preferences file '" + file.getAbsolutePath() + "'");
        }
        catch (IOException e) {
            Console.errPrintln("IOException when loading bootstrap preferences file '" + file.getAbsolutePath() + "'");
        }
        return bootstrapProps;
    }

    public static void setSessionProperty(String key, String val) {
        if (key != null) {
            sessionProperties.put(key, val);
        }
    }

    public static String getSessionProperty(String key) {
        return key == null ? null : sessionProperties.get(key);
    }

    public static boolean getArgCacheDefault(Arg a, String pref, boolean def) {
        ArgParser ap = Jalview.getInstance().getArgParser();
        return ap.isSet(a) ? ap.getBoolean(a) : Cache.getDefault(pref, def);
    }

    static {
        propsAreReadOnly = Platform.isJS();
        vamsasJarsArePresent = -1;
        groovyJarsArePresent = -1;
        if (!Platform.isJS()) {
            Float specversion = Float.valueOf(Float.parseFloat(System.getProperty("java.specification.version")));
            releaseAppbase = specversion.floatValue() < 9.0f ? "https://www.jalview.org/getdown/release/1.8" : "https://www.jalview.org/getdown/release/11";
        } else {
            getdownAppbase = releaseAppbase = "https://www.jalview.org/jalview-js";
            getdownDistDir = "/swingjs/j2s";
        }
        bootstrapProperties = new ArrayList<String>(Arrays.asList(JALVIEWLOGLEVEL, BOOTSTRAP_TEST));
    }
}

