/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AlignmentUtils;
import jalview.api.ComplexAlignFile;
import jalview.api.FeaturesSourceI;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AppletJmol;
import jalview.appletgui.JVDialog;
import jalview.appletgui.SplitFrame;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import jalview.io.TCoffeeScoreFile;
import jalview.json.binding.biojson.v1.ColourSchemeMapper;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.TCoffeeColourScheme;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import mc_view.AppletPDBViewer;

public class CutAndPasteTransfer
extends Panel
implements ActionListener,
MouseListener {
    boolean pdbImport = false;
    boolean treeImport = false;
    boolean annotationImport = false;
    SequenceI seq;
    AlignFrame alignFrame;
    AlignmentFileReaderI source = null;
    protected TextArea textarea = new TextArea();
    Button accept = new Button("New Window");
    Button addSequences = new Button("Add to Current Alignment");
    Button cancel = new Button("Close");
    protected Panel buttonPanel = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();

    public CutAndPasteTransfer(boolean forImport, AlignFrame alignFrame) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alignFrame = alignFrame;
        if (!forImport) {
            this.buttonPanel.setVisible(false);
        }
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String text) {
        this.textarea.setText(text);
    }

    public void setPDBImport(SequenceI seq) {
        this.seq = seq;
        this.accept.setLabel(MessageManager.getString("action.accept"));
        this.addSequences.setVisible(false);
        this.pdbImport = true;
    }

    public void setTreeImport() {
        this.treeImport = true;
        this.accept.setLabel(MessageManager.getString("action.accept"));
        this.addSequences.setVisible(false);
    }

    public void setAnnotationImport() {
        this.annotationImport = true;
        this.accept.setLabel(MessageManager.getString("action.accept"));
        this.addSequences.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.accept) {
            this.ok(true);
        } else if (evt.getSource() == this.addSequences) {
            this.ok(false);
        } else if (evt.getSource() == this.cancel) {
            this.cancel();
        }
    }

    protected void ok(boolean newWindow) {
        String text = this.getText();
        int length = text.length();
        this.textarea.append("\n");
        if (this.textarea.getText().length() == length) {
            String warning = "\n\n#################################################\nWARNING!! THIS IS THE MAXIMUM SIZE OF TEXTAREA!!\n\nCAN'T INPUT FULL ALIGNMENT\n\nYOU MUST DELETE THIS WARNING TO CONTINUE\n\nMAKE SURE LAST SEQUENCE PASTED IS COMPLETE\n#################################################\n";
            this.textarea.setText(text.substring(0, text.length() - warning.length()) + warning);
            this.textarea.setCaretPosition(text.length());
        }
        if (this.pdbImport) {
            this.openPdbViewer(text);
        } else if (this.treeImport) {
            if (!this.loadTree()) {
                return;
            }
        } else if (this.annotationImport) {
            this.loadAnnotations();
        } else if (this.alignFrame != null) {
            this.loadAlignment(text, newWindow, this.alignFrame.getAlignViewport());
        }
        if (this.getParent() instanceof Frame) {
            ((Frame)this.getParent()).setVisible(false);
        } else {
            ((Dialog)this.getParent()).setVisible(false);
        }
    }

    protected boolean loadTree() {
        try {
            NewickFile fin = new NewickFile(this.textarea.getText(), DataSourceType.PASTE);
            fin.parse();
            if (fin.getTree() != null) {
                this.alignFrame.loadTree(fin, "Pasted tree file");
                return true;
            }
        }
        catch (Exception ex) {
            this.textarea.setText(MessageManager.formatMessage("label.could_not_parse_newick_file", ex.getMessage()));
            return false;
        }
        return false;
    }

    protected void loadAlignment(String text, boolean newWindow, AlignViewport viewport) {
        AlignmentI al = null;
        try {
            FileFormatI format = new IdentifyFile().identify(text, DataSourceType.PASTE);
            AppletFormatAdapter afa = new AppletFormatAdapter(this.alignFrame.alignPanel);
            al = afa.readFile(text, DataSourceType.PASTE, format);
            this.source = afa.getAlignFile();
            if (al != null) {
                al.setDataset(null);
                boolean allowSplitFrame = this.alignFrame.viewport.applet.getDefaultParameter("enableSplitFrame", false);
                if (allowSplitFrame && this.openSplitFrame(al, format)) {
                    return;
                }
                if (newWindow) {
                    AlignFrame af;
                    if (this.source instanceof ComplexAlignFile) {
                        HiddenColumns colSel = ((ComplexAlignFile)((Object)this.source)).getHiddenColumns();
                        SequenceI[] hiddenSeqs = ((ComplexAlignFile)((Object)this.source)).getHiddenSequences();
                        boolean showSeqFeatures = ((ComplexAlignFile)((Object)this.source)).isShowSeqFeatures();
                        String colourSchemeName = ((ComplexAlignFile)((Object)this.source)).getGlobalColourScheme();
                        af = new AlignFrame(al, hiddenSeqs, colSel, this.alignFrame.viewport.applet, "Cut & Paste input - " + format, false);
                        af.getAlignViewport().setShowSequenceFeatures(showSeqFeatures);
                        ColourSchemeI cs = ColourSchemeMapper.getJalviewColourScheme(colourSchemeName, al);
                        if (cs != null) {
                            af.changeColour(cs);
                        }
                    } else {
                        af = new AlignFrame(al, this.alignFrame.viewport.applet, "Cut & Paste input - " + format, false);
                        if (this.source instanceof FeaturesSourceI) {
                            af.getAlignViewport().setShowSequenceFeatures(true);
                        }
                    }
                    af.statusBar.setText(MessageManager.getString("label.successfully_pasted_annotation_to_alignment"));
                } else {
                    this.alignFrame.addSequences(al.getSequencesArray());
                    this.alignFrame.statusBar.setText(MessageManager.getString("label.successfully_pasted_alignment_file"));
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected boolean openSplitFrame(AlignmentI al, FileFormatI format) {
        AlignmentI dna;
        AlignmentI thisAlignment = this.alignFrame.getAlignViewport().getAlignment();
        if (thisAlignment.isNucleotide() == al.isNucleotide()) {
            return false;
        }
        AlignmentI protein = thisAlignment.isNucleotide() ? al : thisAlignment;
        boolean mapped = AlignmentUtils.mapProteinAlignmentToCdna(protein, dna = thisAlignment.isNucleotide() ? thisAlignment : al);
        if (!mapped) {
            return false;
        }
        String title = MessageManager.getString("label.open_split_window");
        JVDialog dialog = new JVDialog((Frame)this.getParent(), title, true, 100, 400);
        dialog.ok.setLabel(MessageManager.getString("action.yes"));
        dialog.cancel.setLabel(MessageManager.getString("action.no"));
        Panel question = new Panel(new BorderLayout());
        String text = MessageManager.getString("label.open_split_window?");
        question.add((Component)new Label(text, 1), "Center");
        dialog.setMainPanel(question);
        dialog.setVisible(true);
        dialog.toFront();
        if (!dialog.accept) {
            return false;
        }
        al.alignAs(thisAlignment);
        JalviewLite applet = this.alignFrame.viewport.applet;
        AlignFrame copyFrame = new AlignFrame(this.alignFrame.viewport.getAlignment(), applet, this.alignFrame.getTitle(), false, false);
        AlignFrame newFrame = new AlignFrame(al, this.alignFrame.viewport.applet, "Cut & Paste input - " + format, false, false);
        AlignFrame dnaFrame = al.isNucleotide() ? newFrame : copyFrame;
        AlignFrame proteinFrame = al.isNucleotide() ? copyFrame : newFrame;
        SplitFrame sf = new SplitFrame(dnaFrame, proteinFrame);
        sf.addToDisplay(false, applet);
        return true;
    }

    protected void loadAnnotations() {
        TCoffeeScoreFile tcf = null;
        try {
            tcf = new TCoffeeScoreFile(this.textarea.getText(), DataSourceType.PASTE);
            if (tcf.isValid()) {
                if (tcf.annotateAlignment(this.alignFrame.viewport.getAlignment(), true)) {
                    this.alignFrame.tcoffeeColour.setEnabled(true);
                    this.alignFrame.alignPanel.fontChanged();
                    this.alignFrame.changeColour(new TCoffeeColourScheme(this.alignFrame.viewport.getAlignment()));
                    this.alignFrame.statusBar.setText(MessageManager.getString("label.successfully_pasted_tcoffee_scores_to_alignment"));
                } else {
                    this.alignFrame.statusBar.setText(MessageManager.formatMessage("label.failed_add_tcoffee_scores", tcf.getWarningMessage() != null ? tcf.getWarningMessage() : ""));
                }
            } else {
                tcf = null;
            }
        }
        catch (Exception x) {
            tcf = null;
        }
        if (tcf == null) {
            if (new AnnotationFile().annotateAlignmentView(this.alignFrame.viewport, this.textarea.getText(), DataSourceType.PASTE)) {
                this.alignFrame.alignPanel.fontChanged();
                this.alignFrame.alignPanel.setScrollValues(0, 0);
                this.alignFrame.statusBar.setText(MessageManager.getString("label.successfully_pasted_annotation_to_alignment"));
            } else if (!this.alignFrame.parseFeaturesFile(this.textarea.getText(), DataSourceType.PASTE)) {
                this.alignFrame.statusBar.setText(MessageManager.getString("label.couldnt_parse_pasted_text_as_valid_annotation_feature_GFF_tcoffee_file"));
            }
        }
    }

    protected void openPdbViewer(String text) {
        PDBEntry pdb = new PDBEntry();
        pdb.setFile(text);
        if (this.alignFrame.alignPanel.av.applet.jmolAvailable) {
            new AppletJmol(pdb, new SequenceI[]{this.seq}, null, this.alignFrame.alignPanel, DataSourceType.PASTE);
        } else {
            new AppletPDBViewer(pdb, new SequenceI[]{this.seq}, null, this.alignFrame.alignPanel, DataSourceType.PASTE);
        }
    }

    protected void cancel() {
        this.textarea.setText("");
        if (this.getParent() instanceof Frame) {
            ((Frame)this.getParent()).setVisible(false);
        } else {
            ((Dialog)this.getParent()).setVisible(false);
        }
    }

    private void jbInit() throws Exception {
        this.textarea.setFont(new Font("Monospaced", 0, 10));
        this.textarea.setText(MessageManager.getString("label.paste_your_alignment_file"));
        this.textarea.addMouseListener(this);
        this.setLayout(this.borderLayout1);
        this.accept.addActionListener(this);
        this.addSequences.addActionListener(this);
        this.cancel.addActionListener(this);
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.accept, null);
        this.buttonPanel.add(this.addSequences);
        this.buttonPanel.add((Component)this.cancel, null);
        this.add((Component)this.textarea, "Center");
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.textarea.getText().startsWith(MessageManager.getString("label.paste_your"))) {
            this.textarea.setText("");
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }
}

