/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.AllTestSuit;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.LimitExceededException;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import compbio.ws.server.RNAalifoldWS;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestRNAalifoldWS {
    SequenceAnnotation<RNAalifoldWS> foldws;

    @BeforeTest(groups={"webservices"})
    void initConnection() {
        try {
            JABAService client = Jws2Client.connect("http://localhost:8080/jabaws", Services.RNAalifoldWS);
            this.foldws = (SequenceAnnotation)client;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"webservices"})
    public void testFold() throws FileNotFoundException, IOException, UnknownFileFormatException {
        Alignment aln = ClustalAlignmentUtil.readClustalFile(new FileInputStream(AllTestSuit.test_input_aln));
        List<FastaSequence> fsl = aln.getSequences();
        try {
            ArrayList options = new ArrayList();
            options.add(this.foldws.getRunnerOptions().getArgumentByOptionName("--mis"));
            options.add(this.foldws.getRunnerOptions().getArgumentByOptionName("-p"));
            options.add(this.foldws.getRunnerOptions().getArgumentByOptionName("--MEA"));
            System.out.println("TestRNAalifoldWS: print options: " + ((Object)options).toString());
            String jobId = this.foldws.customAnalize(fsl, options);
            System.out.println("J: " + jobId);
            RNAStructScoreManager result = (RNAStructScoreManager)this.foldws.getAnnotation(jobId);
            OutputStreamWriter writer = new OutputStreamWriter(System.out);
            result.writeOut(writer);
            Assert.assertNotNull((Object)result);
        }
        catch (UnsupportedRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (LimitExceededException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (JobSubmissionException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (ResultNotAvailableException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

