/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.FastaSequenceGenerator;
import compbio.util.FileUtil;
import java.io.IOException;
import java.util.List;

public class FastaGeneratorManager {
    public static void main(String[] args) throws IOException {
        FastaSequenceGenerator fgen = new FastaSequenceGenerator(FastaSequenceGenerator.SeqType.PROTEIN, 50);
        List<FastaSequence> fslist = fgen.generateFasta(400);
        FastaGeneratorManager.writeToFile(fslist, "SmallProtein.fasta");
        fgen = new FastaSequenceGenerator(FastaSequenceGenerator.SeqType.PROTEIN, 200);
        fslist = fgen.generateFasta(500);
        FastaGeneratorManager.writeToFile(fslist, "200x500Protein.fasta");
        fgen = new FastaSequenceGenerator(FastaSequenceGenerator.SeqType.DNA, 1000);
        fslist = fgen.generateFasta(3000);
        FastaGeneratorManager.writeToFile(fslist, "1000x3000Dna.fasta");
        fgen = new FastaSequenceGenerator(FastaSequenceGenerator.SeqType.DNA, 50000);
        fslist = fgen.generateFasta(300);
        FastaGeneratorManager.writeToFile(fslist, "50000x300Dna.fasta");
        System.out.println("Done");
    }

    static void writeToFile(List<FastaSequence> fastalist, String filepath) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (FastaSequence fs : fastalist) {
            sb.append(fs.getOnelineFasta() + "\n");
        }
        FileUtil.writeToFile(sb.toString(), filepath);
    }
}

