/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import java.io.Serializable;

public class SAMRecordCoordinateComparator
implements SAMRecordComparator,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.fileOrderCompare(samRecord1, samRecord2);
        if (cmp != 0) {
            return cmp;
        }
        if (samRecord1.getReadNegativeStrandFlag() == samRecord2.getReadNegativeStrandFlag()) {
            cmp = samRecord1.getReadName().compareTo(samRecord2.getReadName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compareInts(samRecord1.getFlags(), samRecord2.getFlags());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compareInts(samRecord1.getMappingQuality(), samRecord2.getMappingQuality());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compareInts(samRecord1.getMateReferenceIndex(), samRecord2.getMateReferenceIndex());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compareInts(samRecord1.getMateAlignmentStart(), samRecord2.getMateAlignmentStart());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compareInts(samRecord1.getInferredInsertSize(), samRecord2.getInferredInsertSize());
            return cmp;
        }
        return samRecord1.getReadNegativeStrandFlag() ? 1 : -1;
    }

    private int compareInts(int i1, int i2) {
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
        if (null == samRecord1.getHeader() || null == samRecord2.getHeader()) {
            throw new IllegalArgumentException("Records must have non-null SAMFileHeaders to be compared");
        }
        int refIndex1 = samRecord1.getReferenceIndex();
        int refIndex2 = samRecord2.getReferenceIndex();
        if (refIndex1 == -1) {
            return refIndex2 == -1 ? 0 : 1;
        }
        if (refIndex2 == -1) {
            return -1;
        }
        int cmp = refIndex1 - refIndex2;
        if (cmp != 0) {
            return cmp;
        }
        return samRecord1.getAlignmentStart() - samRecord2.getAlignmentStart();
    }
}

