/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.GenomicIndexUtil;
import java.util.Arrays;
import java.util.Objects;

public class LinearIndex {
    public static final int MAX_LINEAR_INDEX_SIZE = GenomicIndexUtil.MAX_LINEAR_INDEX_SIZE;
    public static final int BAM_LIDX_SHIFT = 14;
    private final int mReferenceSequence;
    private final int mIndexStart;
    private final long[] mIndexEntries;

    public LinearIndex(int referenceSequence, int indexStart, long[] indexEntries) {
        this.mReferenceSequence = referenceSequence;
        this.mIndexStart = indexStart;
        this.mIndexEntries = indexEntries;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public int size() {
        return this.mIndexEntries.length;
    }

    public long get(int index) {
        return this.mIndexEntries[index - this.mIndexStart];
    }

    public static int convertToLinearIndexOffset(int contigPos) {
        int indexPos = contigPos <= 0 ? 0 : contigPos - 1;
        return indexPos >> 14;
    }

    public long getMinimumOffset(int startPos) {
        int start = startPos <= 0 ? 0 : startPos - 1;
        int regionLinearBin = start >> 14;
        long minimumOffset = 0L;
        if (regionLinearBin - this.mIndexStart < this.mIndexEntries.length) {
            minimumOffset = this.mIndexEntries[regionLinearBin - this.mIndexStart];
        }
        return minimumOffset;
    }

    public long[] getIndexEntries() {
        return this.mIndexEntries;
    }

    public int getIndexStart() {
        return this.mIndexStart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinearIndex that = (LinearIndex)o;
        return this.mReferenceSequence == that.mReferenceSequence && this.mIndexStart == that.mIndexStart && Arrays.equals(this.mIndexEntries, that.mIndexEntries);
    }

    public int hashCode() {
        int result = Objects.hash(this.mReferenceSequence, this.mIndexStart);
        result = 31 * result + Arrays.hashCode(this.mIndexEntries);
        return result;
    }
}

