/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Digest {
    public static final int VERSION = 2;
    protected HashMap<String, String> _digests = new HashMap();
    protected String _metaDigest = "";
    protected static final String FILE_NAME = "digest";
    protected static final String FILE_SUFFIX = ".txt";
    protected File dfile = null;

    public static String digestFile(int version) {
        String infix = version > 1 ? String.valueOf(version) : "";
        return FILE_NAME + infix + FILE_SUFFIX;
    }

    public static String sigAlgorithm(int version) {
        switch (version) {
            case 1: {
                return "SHA1withRSA";
            }
            case 2: {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Invalid digest version " + version);
    }

    public static void createDigest(int version, List<Resource> resources, File output) throws IOException {
        ExecutorService exec = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        final ConcurrentHashMap digests = new ConcurrentHashMap();
        final LinkedBlockingQueue completed = new LinkedBlockingQueue();
        final int fversion = version;
        long start = System.currentTimeMillis();
        HashSet<Resource> pending = new HashSet<Resource>(resources);
        for (final Resource rsrc : resources) {
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageDigest md = Digest.getMessageDigest(fversion);
                        digests.put(rsrc, rsrc.computeDigest(fversion, md, null));
                        completed.add(rsrc);
                    }
                    catch (Throwable t) {
                        completed.add(new IOException("Error computing digest for: " + rsrc).initCause(t));
                    }
                }
            });
        }
        exec.shutdown();
        try {
            while (pending.size() > 0) {
                Object done = completed.poll(600L, TimeUnit.SECONDS);
                if (done instanceof IOException) {
                    throw (IOException)done;
                }
                if (done instanceof Resource) {
                    pending.remove((Resource)done);
                    continue;
                }
                throw new AssertionError((Object)("What is this? " + done));
            }
        }
        catch (InterruptedException ie) {
            throw new IOException("Timeout computing digests. Wow.");
        }
        StringBuilder data = new StringBuilder();
        try (FileOutputStream fos = new FileOutputStream(output);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter pout = new PrintWriter(osw);){
            for (Resource rsrc : resources) {
                String path = rsrc.getPath();
                String digest = (String)digests.get(rsrc);
                Digest.note(data, path, digest);
                pout.println(path + " = " + digest);
            }
            MessageDigest md = Digest.getMessageDigest(version);
            byte[] contents = data.toString().getBytes(StandardCharsets.UTF_8);
            String filename = Digest.digestFile(version);
            pout.println(filename + " = " + StringUtil.hexlate(md.digest(contents)));
        }
        long elapsed = System.currentTimeMillis() - start;
        Log.log.debug("Computed digests [rsrcs=" + resources.size() + ", time=" + elapsed + "ms]", new Object[0]);
    }

    public static MessageDigest getMessageDigest(int version) {
        String algo = version > 1 ? "SHA-256" : "MD5";
        try {
            return MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("JVM does not support " + algo + ". Gurp!");
        }
    }

    public Digest(File appdir, boolean strictComments) throws IOException {
        this(appdir, 2, strictComments);
    }

    public Digest(File appdir, int version, boolean strictComments) throws IOException {
        byte[] contents;
        MessageDigest md;
        String hash;
        String filename = Digest.digestFile(version);
        StringBuilder data = new StringBuilder();
        this.dfile = new File(appdir, filename);
        Config.ParseOpts opts = Config.createOpts(false);
        opts.strictComments = strictComments;
        opts.biasToKey = true;
        for (String[] pair : Config.parsePairs(this.dfile, opts)) {
            if (pair[0].equals(filename)) {
                this._metaDigest = pair[1];
                break;
            }
            this._digests.put(pair[0], pair[1]);
            Digest.note(data, pair[0], pair[1]);
        }
        if (!(hash = StringUtil.hexlate((md = Digest.getMessageDigest(version)).digest(contents = data.toString().getBytes(StandardCharsets.UTF_8)))).equals(this._metaDigest)) {
            String err = MessageUtil.tcompose("m.invalid_digest_file", this._metaDigest, hash);
            throw new IOException(err);
        }
    }

    public String getMetaDigest() {
        return this._metaDigest;
    }

    public boolean validateResource(Resource resource, ProgressObserver obs) {
        try {
            String chash = resource.computeDigest(2, Digest.getMessageDigest(2), obs);
            String ehash = this._digests.get(resource.getPath());
            if (chash.equals(ehash)) {
                return true;
            }
            Log.log.info("Resource failed digest check", "rsrc", resource, "computed", chash, "expected", ehash);
        }
        catch (Throwable t) {
            Log.log.info("Resource failed digest check", "rsrc", resource, "error", t);
        }
        return false;
    }

    public String getDigest(Resource resource) {
        return this._digests.get(resource.getPath());
    }

    public File getFile() {
        return this.dfile;
    }

    protected static void note(StringBuilder data, String path, String digest) {
        data.append(path).append(" = ").append(digest).append("\n");
    }
}

