/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VARNAConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2853916694420964233L;
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 9;
    public static final double MAX_ZOOM = 60.0;
    public static final double MIN_ZOOM = 0.5;
    public static final double DEFAULT_ZOOM = 1.0;
    public static final double MAX_AMOUNT = 2.0;
    public static final double MIN_AMOUNT = 1.01;
    public static final double DEFAULT_AMOUNT = 1.2;
    public static final double DEFAULT_BP_THICKNESS = 1.0;
    public static final double DEFAULT_DIST_NUMBERS = 3.0;
    public static final int DEFAULT_PERIOD = 10;
    public static final Color DEFAULT_TITLE_COLOR = Color.black;
    public static final Color DEFAULT_BACKBONE_COLOR = Color.DARK_GRAY.brighter();
    public static final Color DEFAULT_BOND_COLOR = Color.blue;
    public static final Color DEFAULT_SPECIAL_BASE_COLOR = Color.green.brighter();
    public static final Color DEFAULT_DASH_BASE_COLOR = Color.yellow.brighter();
    public static final double DEFAULT_BASE_OUTLINE_THICKNESS = 1.5;
    public static final Color BASE_OUTLINE_COLOR_DEFAULT = Color.DARK_GRAY.brighter();
    public static final Color BASE_INNER_COLOR_DEFAULT = new Color(242, 242, 242);
    public static final Color BASE_NUMBER_COLOR_DEFAULT = Color.DARK_GRAY;
    public static final Color BASE_NAME_COLOR_DEFAULT = Color.black;
    public static final Color DEFAULT_HOVER_COLOR = new Color(230, 230, 230);
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 18);
    public static final Font DEFAULT_BASE_FONT = new Font("SansSerif", 0, 18);
    public static final Font DEFAULT_NUMBERS_FONT = new Font("SansSerif", 1, 18);
    public static final Font DEFAULT_MESSAGE_FONT = Font.decode("dialog-PLAIN-25");
    public static final Color DEFAULT_MESSAGE_COLOR = new Color(230, 230, 230);
    public static final BP_STYLE DEFAULT_BP_STYLE = BP_STYLE.LW;
    public static final ModeleColorMap DEFAULT_COLOR_MAP = ModeleColorMap.defaultColorMap();
    public static final Color DEFAULT_COLOR_MAP_OUTLINE = Color.gray;
    public static final double DEFAULT_BP_INCREMENT = 0.65;
    public static double DEFAULT_COLOR_MAP_WIDTH = 120.0;
    public static double DEFAULT_COLOR_MAP_HEIGHT = 30.0;
    public static double DEFAULT_COLOR_MAP_X_OFFSET = 40.0;
    public static double DEFAULT_COLOR_MAP_Y_OFFSET = 0.0;
    public static int DEFAULT_COLOR_MAP_STRIPE_WIDTH = 2;
    public static int DEFAULT_COLOR_MAP_FONT_SIZE = 20;
    public static Color DEFAULT_COLOR_MAP_FONT_COLOR = Color.gray.darker();
    public static double DEFAULT_SPACE_BETWEEN_BASES = 1.0;
    public static String XML_VAR_DRAW_OUTLINE = "drawoutline";
    public static String XML_VAR_FILL_BASE = "fillbase";
    public static String XML_VAR_AUTO_FIT = "autofit";
    public static String XML_VAR_AUTO_CENTER = "autocenter";
    public static String XML_VAR_MODIFIABLE = "modifiable";
    public static String XML_VAR_ERRORS = "errors";
    public static String XML_VAR_SPECIAL_BASES = "specialbases";
    public static String XML_VAR_DASH_BASES = "dashbases";
    public static String XML_VAR_USE_BASE_BPS = "usebasebps";
    public static String XML_VAR_DRAW_NC = "drawnc";
    public static String XML_VAR_DRAW_NON_PLANAR = "drawnonplanar";
    public static String XML_VAR_SHOW_WARNINGS = "warnings";
    public static String XML_VAR_COMPARISON_MODE = "comparison";
    public static String XML_VAR_FLAT = "flat";
    public static String XML_VAR_DRAW_BACKGROUND = "drawbackground";
    public static String XML_VAR_COLOR_MAP = "drawcm";
    public static String XML_VAR_DRAW_BACKBONE = "drawbackbone";
    public static String XML_VAR_CM_HEIGHT = "cmh";
    public static String XML_VAR_CM_WIDTH = "cmw";
    public static String XML_VAR_CM_X_OFFSET = "cmx";
    public static String XML_VAR_CM_Y_OFFSET = "cmy";
    public static String XML_VAR_DEFAULT_ZOOM = "defaultzoom";
    public static String XML_VAR_ZOOM_AMOUNT = "zoominc";
    public static String XML_VAR_BP_THICKNESS = "bpthick";
    public static String XML_VAR_BASE_THICKNESS = "basethick";
    public static String XML_VAR_DIST_NUMBERS = "distnumbers";
    public static String XML_VAR_NUM_PERIOD = "numperiod";
    public static String XML_VAR_MAIN_BP_STYLE = "bpstyle";
    public static String XML_VAR_CM = "cm";
    public static String XML_VAR_BACKBONE_COLOR = "backbonecol";
    public static String XML_VAR_HOVER_COLOR = "hovercol";
    public static String XML_VAR_BACKGROUND_COLOR = "backgroundcol";
    public static String XML_VAR_BOND_COLOR = "bondcol";
    public static String XML_VAR_TITLE_COLOR = "titlecol";
    public static String XML_VAR_SPECIAL_BASES_COLOR = "specialco";
    public static String XML_VAR_DASH_BASES_COLOR = "dashcol";
    public static String XML_VAR_SPACE_BETWEEN_BASES = "spacebetweenbases";
    public static String XML_VAR_TITLE_FONT = "titlefont";
    public static String XML_VAR_NUMBERS_FONT = "numbersfont";
    public static String XML_VAR_FONT_BASES = "basefont";
    public static String XML_VAR_CM_CAPTION = "cmcaption";
    public static String XML_VAR_TITLE = "title";
    public boolean _drawOutlineBases = true;
    public boolean _fillBases = true;
    public boolean _autoFit = true;
    public boolean _autoCenter = true;
    public boolean _modifiable = true;
    public boolean _errorsOn = false;
    public boolean _colorSpecialBases = false;
    public boolean _colorDashBases = false;
    public boolean _useBaseColorsForBPs = false;
    public boolean _drawnNonCanonicalBP = true;
    public boolean _drawnNonPlanarBP = true;
    public boolean _showWarnings = false;
    public boolean _comparisonMode = false;
    public boolean _flatExteriorLoop = true;
    public boolean _drawBackground = false;
    public boolean _drawColorMap = false;
    public boolean _drawBackbone = true;
    public double _colorMapHeight = DEFAULT_COLOR_MAP_HEIGHT;
    public double _colorMapWidth = DEFAULT_COLOR_MAP_WIDTH;
    public double _colorMapXOffset = DEFAULT_COLOR_MAP_X_OFFSET;
    public double _colorMapYOffset = DEFAULT_COLOR_MAP_Y_OFFSET;
    public double _zoom = 1.0;
    public double _zoomAmount = 1.2;
    public double _bpThickness = 1.0;
    public double _baseThickness = 1.5;
    public double _distNumbers = 3.0;
    public double _spaceBetweenBases = DEFAULT_SPACE_BETWEEN_BASES;
    public int _numPeriod = 10;
    public BP_STYLE _mainBPStyle = DEFAULT_BP_STYLE;
    public ModeleColorMap _cm = DEFAULT_COLOR_MAP;
    public Color _backboneColor = DEFAULT_BACKBONE_COLOR;
    public Color _hoverColor = DEFAULT_HOVER_COLOR;
    public Color _backgroundColor = DEFAULT_BACKGROUND_COLOR;
    public Color _bondColor = DEFAULT_BOND_COLOR;
    public Color _titleColor = DEFAULT_TITLE_COLOR;
    public Color _specialBasesColor = DEFAULT_SPECIAL_BASE_COLOR;
    public Color _dashBasesColor = DEFAULT_DASH_BASE_COLOR;
    public Font _titleFont = DEFAULT_TITLE_FONT;
    public Font _numbersFont = DEFAULT_NUMBERS_FONT;
    public Font _fontBasesGeneral = DEFAULT_BASE_FONT;
    public String _colorMapCaption = "";
    public static String XML_ELEMENT_NAME = "config";

    public static String getFullName() {
        return "VARNA 3.9";
    }

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_DRAW_OUTLINE, "CDATA", "" + this._drawOutlineBases);
        attributesImpl.addAttribute("", "", XML_VAR_FILL_BASE, "CDATA", "" + this._fillBases);
        attributesImpl.addAttribute("", "", XML_VAR_AUTO_FIT, "CDATA", "" + this._autoFit);
        attributesImpl.addAttribute("", "", XML_VAR_AUTO_CENTER, "CDATA", "" + this._autoCenter);
        attributesImpl.addAttribute("", "", XML_VAR_MODIFIABLE, "CDATA", "" + this._modifiable);
        attributesImpl.addAttribute("", "", XML_VAR_ERRORS, "CDATA", "" + this._errorsOn);
        attributesImpl.addAttribute("", "", XML_VAR_SPECIAL_BASES, "CDATA", "" + this._colorSpecialBases);
        attributesImpl.addAttribute("", "", XML_VAR_DASH_BASES, "CDATA", "" + this._colorDashBases);
        attributesImpl.addAttribute("", "", XML_VAR_USE_BASE_BPS, "CDATA", "" + this._useBaseColorsForBPs);
        attributesImpl.addAttribute("", "", XML_VAR_DRAW_NC, "CDATA", "" + this._drawnNonCanonicalBP);
        attributesImpl.addAttribute("", "", XML_VAR_DRAW_NON_PLANAR, "CDATA", "" + this._drawnNonPlanarBP);
        attributesImpl.addAttribute("", "", XML_VAR_SHOW_WARNINGS, "CDATA", "" + this._showWarnings);
        attributesImpl.addAttribute("", "", XML_VAR_COMPARISON_MODE, "CDATA", "" + this._comparisonMode);
        attributesImpl.addAttribute("", "", XML_VAR_FLAT, "CDATA", "" + this._flatExteriorLoop);
        attributesImpl.addAttribute("", "", XML_VAR_DRAW_BACKGROUND, "CDATA", "" + this._drawBackground);
        attributesImpl.addAttribute("", "", XML_VAR_COLOR_MAP, "CDATA", "" + this._drawColorMap);
        attributesImpl.addAttribute("", "", XML_VAR_DRAW_BACKBONE, "CDATA", "" + this._drawBackbone);
        attributesImpl.addAttribute("", "", XML_VAR_CM_HEIGHT, "CDATA", "" + this._colorMapHeight);
        attributesImpl.addAttribute("", "", XML_VAR_CM_WIDTH, "CDATA", "" + this._colorMapWidth);
        attributesImpl.addAttribute("", "", XML_VAR_CM_X_OFFSET, "CDATA", "" + this._colorMapXOffset);
        attributesImpl.addAttribute("", "", XML_VAR_CM_Y_OFFSET, "CDATA", "" + this._colorMapYOffset);
        attributesImpl.addAttribute("", "", XML_VAR_DEFAULT_ZOOM, "CDATA", "" + this._zoom);
        attributesImpl.addAttribute("", "", XML_VAR_ZOOM_AMOUNT, "CDATA", "" + this._zoomAmount);
        attributesImpl.addAttribute("", "", XML_VAR_BP_THICKNESS, "CDATA", "" + this._bpThickness);
        attributesImpl.addAttribute("", "", XML_VAR_BASE_THICKNESS, "CDATA", "" + this._baseThickness);
        attributesImpl.addAttribute("", "", XML_VAR_DIST_NUMBERS, "CDATA", "" + this._distNumbers);
        attributesImpl.addAttribute("", "", XML_VAR_SPACE_BETWEEN_BASES, "CDATA", "" + this._spaceBetweenBases);
        attributesImpl.addAttribute("", "", XML_VAR_NUM_PERIOD, "CDATA", "" + this._numPeriod);
        attributesImpl.addAttribute("", "", XML_VAR_MAIN_BP_STYLE, "CDATA", "" + this._mainBPStyle.getOpt());
        attributesImpl.addAttribute("", "", XML_VAR_BACKBONE_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._backboneColor));
        attributesImpl.addAttribute("", "", XML_VAR_HOVER_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._hoverColor));
        attributesImpl.addAttribute("", "", XML_VAR_BACKGROUND_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._backgroundColor));
        attributesImpl.addAttribute("", "", XML_VAR_BOND_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._bondColor));
        attributesImpl.addAttribute("", "", XML_VAR_TITLE_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._titleColor));
        attributesImpl.addAttribute("", "", XML_VAR_SPECIAL_BASES_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._specialBasesColor));
        attributesImpl.addAttribute("", "", XML_VAR_DASH_BASES_COLOR, "CDATA", XMLUtils.toHTMLNotation(this._dashBasesColor));
        attributesImpl.addAttribute("", "", XML_VAR_CM, "CDATA", this._cm.getParamEncoding());
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        XMLUtils.toXML(transformerHandler, this._titleFont, XML_VAR_TITLE_FONT);
        XMLUtils.toXML(transformerHandler, this._numbersFont, XML_VAR_NUMBERS_FONT);
        XMLUtils.toXML(transformerHandler, this._fontBasesGeneral, XML_VAR_FONT_BASES);
        XMLUtils.exportCDATAElem(transformerHandler, XML_VAR_CM_CAPTION, this._colorMapCaption);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public void loadFromXMLAttributes(Attributes attributes) {
        this._drawOutlineBases = Boolean.parseBoolean(attributes.getValue(XML_VAR_DRAW_OUTLINE));
        this._fillBases = Boolean.parseBoolean(attributes.getValue(XML_VAR_FILL_BASE));
        this._autoFit = Boolean.parseBoolean(attributes.getValue(XML_VAR_AUTO_FIT));
        this._autoCenter = Boolean.parseBoolean(attributes.getValue(XML_VAR_AUTO_CENTER));
        this._modifiable = Boolean.parseBoolean(attributes.getValue(XML_VAR_MODIFIABLE));
        this._errorsOn = Boolean.parseBoolean(attributes.getValue(XML_VAR_ERRORS));
        this._colorSpecialBases = Boolean.parseBoolean(attributes.getValue(XML_VAR_SPECIAL_BASES));
        this._colorDashBases = Boolean.parseBoolean(attributes.getValue(XML_VAR_DASH_BASES));
        this._useBaseColorsForBPs = Boolean.parseBoolean(attributes.getValue(XML_VAR_USE_BASE_BPS));
        this._drawnNonCanonicalBP = Boolean.parseBoolean(attributes.getValue(XML_VAR_DRAW_NC));
        this._drawnNonPlanarBP = Boolean.parseBoolean(attributes.getValue(XML_VAR_DRAW_NON_PLANAR));
        this._showWarnings = Boolean.parseBoolean(attributes.getValue(XML_VAR_SHOW_WARNINGS));
        this._comparisonMode = Boolean.parseBoolean(attributes.getValue(XML_VAR_COMPARISON_MODE));
        this._flatExteriorLoop = Boolean.parseBoolean(attributes.getValue(XML_VAR_FLAT));
        this._drawBackground = Boolean.parseBoolean(attributes.getValue(XML_VAR_DRAW_BACKGROUND));
        this._drawColorMap = Boolean.parseBoolean(attributes.getValue(XML_VAR_COLOR_MAP));
        this._drawBackbone = Boolean.parseBoolean(attributes.getValue(XML_VAR_DRAW_BACKBONE));
        this._colorMapHeight = Double.parseDouble(attributes.getValue(XML_VAR_CM_HEIGHT));
        this._colorMapWidth = Double.parseDouble(attributes.getValue(XML_VAR_CM_WIDTH));
        this._colorMapXOffset = Double.parseDouble(attributes.getValue(XML_VAR_CM_X_OFFSET));
        this._colorMapYOffset = Double.parseDouble(attributes.getValue(XML_VAR_CM_Y_OFFSET));
        this._zoom = Double.parseDouble(attributes.getValue(XML_VAR_DEFAULT_ZOOM));
        this._zoomAmount = Double.parseDouble(attributes.getValue(XML_VAR_ZOOM_AMOUNT));
        this._bpThickness = Double.parseDouble(attributes.getValue(XML_VAR_BP_THICKNESS));
        this._baseThickness = Double.parseDouble(attributes.getValue(XML_VAR_BASE_THICKNESS));
        this._distNumbers = Double.parseDouble(attributes.getValue(XML_VAR_DIST_NUMBERS));
        this._spaceBetweenBases = XMLUtils.getDouble(attributes, XML_VAR_SPACE_BETWEEN_BASES, DEFAULT_SPACE_BETWEEN_BASES);
        this._numPeriod = Integer.parseInt(attributes.getValue(XML_VAR_NUM_PERIOD));
        this._mainBPStyle = BP_STYLE.getStyle(attributes.getValue(XML_VAR_MAIN_BP_STYLE));
        this._backboneColor = Color.decode(attributes.getValue(XML_VAR_BACKBONE_COLOR));
        this._hoverColor = Color.decode(attributes.getValue(XML_VAR_HOVER_COLOR));
        this._backgroundColor = Color.decode(attributes.getValue(XML_VAR_BACKGROUND_COLOR));
        this._bondColor = Color.decode(attributes.getValue(XML_VAR_BOND_COLOR));
        this._titleColor = Color.decode(attributes.getValue(XML_VAR_TITLE_COLOR));
        this._specialBasesColor = Color.decode(attributes.getValue(XML_VAR_SPECIAL_BASES_COLOR));
        this._dashBasesColor = Color.decode(attributes.getValue(XML_VAR_DASH_BASES_COLOR));
        this._cm = ModeleColorMap.parseColorMap(attributes.getValue(XML_VAR_CM));
    }

    public VARNAConfig clone() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return (VARNAConfig)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot clone class [" + this.getClass().getName() + "] via serialization: " + exception.toString());
        }
    }

    public static enum BP_STYLE implements Serializable
    {
        NONE,
        SIMPLE,
        RNAVIZ,
        LW,
        LW_ALT;


        public String toString() {
            switch (this) {
                case LW: {
                    return "Leontis/Westhof (Centered)";
                }
                case SIMPLE: {
                    return "Line";
                }
                case RNAVIZ: {
                    return "Circles";
                }
                case NONE: {
                    return "None";
                }
                case LW_ALT: {
                    return "Leontis/Westhof (End)";
                }
            }
            return "Unspecified";
        }

        public String getOpt() {
            switch (this) {
                case NONE: {
                    return "none";
                }
                case SIMPLE: {
                    return "simple";
                }
                case LW: {
                    return "lw";
                }
                case RNAVIZ: {
                    return "rnaviz";
                }
                case LW_ALT: {
                    return "lwalt";
                }
            }
            return "x";
        }

        public static BP_STYLE getStyle(String string) {
            for (BP_STYLE bP_STYLE : BP_STYLE.values()) {
                if (!string.toLowerCase().equals(bP_STYLE.getOpt().toLowerCase())) continue;
                return bP_STYLE;
            }
            return null;
        }
    }
}

