/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.bspt.PointIterator;
import org.jmol.viewer.Viewer;

public class BZone {
    static String[] bzColors = new String[]{"red", "green", "skyblue", "orange", "yellow", "indigo", "violet"};
    boolean bzDrawPointsAndEdges = false;
    boolean bzSavePmeshes = false;
    private Lst<BZone> bzones = null;
    private P3 bzGamma = new P3();
    private Lst<P3> bzFaceCenters = null;
    private Lst<P3> bzLatticePts = null;
    private P3[] bzLatticePtsAll = null;
    private Lst<P3> bzPlanePts = null;
    private Lst<BZone> subzones = null;
    private boolean isWignerSeitz;
    private Viewer vwr;
    private JmolScriptEvaluator eval;
    private String id;
    private int index;
    private String color;
    private Lst<P3> latticePts;
    private Lst<P3> newLatticePts;
    private Lst<P3> newPlanePts;
    private Lst<P4> planes;
    private Lst<P4> newPlanes;
    private float volume = 0.0f;
    private int zoneIndex;
    private P3 offset;
    private P3 center;
    private Lst<P4> planesUnused;
    private Lst<P3> ptsUnused;
    private Lst<Object> pmeshes;
    private Lst<Double> areas;
    private Lst<P3[]> faces;
    private Lst<int[]> faceIndices;
    private Lst<P3> faceCenters;
    private double totalArea;
    private static P3 ptInner = P3.new3(Float.NaN, 0.0f, 0.0f);
    private Object[] ret = new Object[1];
    private String polyid;
    private P3[] pts;

    public BZone setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.eval = vwr.eval;
        return this;
    }

    public void createBZ(int zone, Object[] array, boolean isK, String id, float scale) {
        if (this.vwr == null) {
            return;
        }
        if (array != null) {
            this.demoBZ(array, isK);
        } else {
            this.createAllBZs(zone, true, id, scale);
        }
    }

    public void createWS(String id) {
        if (this.vwr == null) {
            return;
        }
        this.createAllBZs(-1, false, id, 1.0f);
    }

    private void createAllBZs(int n, boolean discardPrev, String id, float scale) {
        this.cmd("unitcell reset");
        this.cmd("unitcell primitive");
        if (n < 0) {
            n = -n;
            this.isWignerSeitz = true;
        } else {
            if (n == 0) {
                n = 1;
            }
            if (Float.isNaN(scale)) {
                scale = 2.0f;
            }
            this.cmd("unitcell 'reciprocal' " + scale);
        }
        this.cmd("polyhedra pbz* delete");
        this.cmd("pmesh fbz* delete");
        if (!this.isWignerSeitz) {
            this.cmd("axes unitcell; axes on; axes scale 2.0;axes 0.01;axes labels \"b1\" \"b2\" \"b3\" \"\"");
        }
        this.bzones = new Lst();
        this.bzLatticePts = new Lst();
        this.bzPlanePts = new Lst();
        this.bzFaceCenters = new Lst();
        boolean wasPrecise = this.vwr.getBoolean(603979874);
        this.vwr.setBooleanProperty("legacyJavaFloat", true);
        this.getLatticePoints(n);
        this.bzones.addLast(null);
        for (int i = 1; i <= n; ++i) {
            this.bzones.add(i, this.newBZ(i));
            this.createNextBZ((BZone)this.bzones.get(i), (BZone)this.bzones.get(i - 1), id);
            if (!discardPrev || i <= 1) continue;
            this.cmd("polyhedra id \"pbz" + (i - 1) + "_*\" delete");
        }
        this.vwr.setBooleanProperty("legacyJavaFloat", wasPrecise);
        if (this.bzSavePmeshes) {
            this.cmd("polyhedra * off;pmesh * on;");
        }
    }

    private void createNextBZ(BZone zone, BZone zonePrev, String id) {
        this.getNewLatticePoints(zone);
        if (this.bzDrawPointsAndEdges) {
            this.drawZoneCenters(zone);
        }
        this.getSubzones(zone, zonePrev);
        for (int i = 0; i < zone.subzones.size(); ++i) {
            BZone subzone = (BZone)zone.subzones.get(i);
            if (!this.getSubzonePmeshes(subzone)) continue;
            if (this.bzDrawPointsAndEdges) {
                this.drawSubzonePolygons(subzone);
            }
            this.createSubzonePolyhedron(subzone, id);
        }
        this.finalizeZone(zone);
    }

    private BZone newSubZone(BZone zone, String id, int index) {
        BZone subzone = new BZone();
        subzone.index = index;
        subzone.id = zone.id + id + index + "_";
        subzone.zoneIndex = zone.index;
        subzone.newLatticePts = zone.newLatticePts;
        subzone.planes = new Lst();
        subzone.latticePts = new Lst();
        subzone.planesUnused = new Lst();
        subzone.ptsUnused = new Lst();
        subzone.pmeshes = new Lst();
        subzone.areas = new Lst();
        subzone.faces = new Lst();
        subzone.faceIndices = new Lst();
        subzone.faceCenters = new Lst();
        subzone.volume = 0.0f;
        subzone.color = zone.color;
        subzone.offset = new P3();
        subzone.center = new P3();
        zone.subzones.addLast(subzone);
        return subzone;
    }

    private void getSubzones(BZone zone, BZone zonePrev) {
        if (zone.index == 1) {
            BZone subzone = this.newSubZone(zone, "", 1);
            subzone.latticePts = zone.newLatticePts;
            subzone.planes = zone.newPlanes;
            return;
        }
        for (int i = 0; i < zonePrev.subzones.size(); ++i) {
            int j0;
            Lst<P4> planesNew = zone.newPlanes;
            Lst<P3> ptsNew = zone.newLatticePts;
            BZone prev = (BZone)zonePrev.subzones.get(i);
            Lst<P4> planesPrev = prev.planes;
            Lst<P3> ptsPrev = prev.latticePts;
            Lst<P4> planesUnusedPrev = prev.planesUnused;
            Lst<P3> ptsUnusedPrev = prev.ptsUnused;
            Lst<P3> centersPrev = prev.faceCenters;
            String id = prev.id.substring(4);
            for (int j = j0 = zonePrev.index == 1 ? 0 : 1; j < planesPrev.size(); ++j) {
                if (j0 == 1 && this.within(0.01f, (P3)centersPrev.get(j), this.bzFaceCenters).size() > 1) continue;
                BZone subzone = this.newSubZone(zone, id, j + 1);
                this.addBZ(subzone.planes, subzone.latticePts, planesPrev, ptsPrev, j);
                this.addBZ(subzone.planes, subzone.latticePts, planesUnusedPrev, ptsUnusedPrev, -1);
                this.addBZ(subzone.planes, subzone.latticePts, planesNew, ptsNew, -1);
            }
        }
    }

    private void addBZ(Lst<P4> planes, Lst<P3> pts, Lst<P4> planes0, Lst<P3> pts0, int j) {
        if (j >= 0) {
            P4 pt4 = P4.newPt((P4)planes0.get(j));
            pt4.scale4(-1.0f);
            planes.addLast(pt4);
            pts.addLast((P3)pts0.get(j));
        }
        int n = planes0.size();
        for (int k = 0; k < n; ++k) {
            if (k == j) continue;
            planes.addLast((P4)planes0.get(k));
            pts.addLast((P3)pts0.get(k));
        }
    }

    private void getNewLatticePoints(BZone zone) {
        Lst unusedPts = new Lst();
        Lst unusedLatticePts = new Lst();
        Lst<P3> centers = zone.newPlanePts;
        Lst<P3> zoneLPs = zone.newLatticePts;
        Lst<P4> planes = zone.newPlanes;
        for (int i = 0; i < this.bzPlanePts.size(); ++i) {
            Lst<P3> al;
            Lst<P3> ap;
            P3 p = (P3)this.bzPlanePts.get(i);
            P3 center = P3.newP(p);
            center.scale(0.5f);
            float radius = 0.501f * p.length();
            Lst<P3> inSphere = this.within(radius, center, this.bzPlanePts);
            if (inSphere.size() == 1) {
                ap = centers;
                al = zoneLPs;
                planes.addLast(this.plane(this.bzGamma, p, 1.0f));
            } else {
                ap = unusedPts;
                al = unusedLatticePts;
            }
            ap.addLast(p);
            al.addLast((P3)this.bzLatticePts.get(i));
        }
        this.bzPlanePts = unusedPts;
        this.bzLatticePts = unusedLatticePts;
    }

    private P4 plane(P3 pt1, P3 pt2, float f) {
        V3 norm = V3.newVsub(pt2, pt1);
        P3 pt3 = new P3();
        pt3.scaleAdd2(f, norm, pt1);
        P4 plane = new P4();
        Measure.getPlaneThroughPoint(pt3, norm, plane);
        return plane;
    }

    private Lst<P3> within(float radius, P3 center, Lst<P3> pts) {
        Lst<P3> ret = new Lst<P3>();
        float r2 = radius * radius;
        int n = pts.size();
        for (int i = 0; i < n; ++i) {
            P3 pt = (P3)pts.get(i);
            if (!(center.distanceSquared(pt) < r2)) continue;
            ret.addLast(pt);
        }
        return ret;
    }

    private BZone newBZ(int i) {
        BZone bzone = new BZone();
        bzone.id = "bz" + i + "_";
        bzone.index = i;
        bzone.color = this.bzColor(i);
        bzone.subzones = new Lst();
        bzone.newLatticePts = new Lst();
        bzone.newPlanePts = new Lst();
        bzone.newPlanes = new Lst();
        bzone.volume = 0.0f;
        return bzone;
    }

    private String bzColor(int i) {
        return bzColors[(i - 1) % bzColors.length];
    }

    private void getLatticePoints(int n) {
        int[][] minmax = new int[3][3];
        P3 pt = new P3();
        float[] abc = new float[]{this.newPoint(1, 0, 0, pt).length(), this.newPoint(0, 1, 0, pt).length(), this.newPoint(0, 0, 1, pt).length()};
        float abcmax = Math.max(abc[0], Math.max(abc[1], abc[2]));
        for (int i = 0; i < 3; ++i) {
            int m = (int)((float)n * abcmax / abc[i]);
            minmax[i] = new int[]{-m, m};
        }
        Lst<P3> pts = new Lst<P3>();
        for (int i = minmax[0][0]; i <= minmax[0][1]; ++i) {
            for (int j = minmax[1][0]; j <= minmax[1][1]; ++j) {
                for (int k = minmax[2][0]; k <= minmax[2][1]; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    P3 lppt = this.newPoint(i, j, k, new P3());
                    pts.addLast(P3.newP(lppt));
                    this.bzLatticePts.addLast(lppt);
                    P3 ppt = P3.newP(lppt);
                    ppt.scale(0.5f);
                    this.bzPlanePts.addLast(ppt);
                    System.out.println("draw ID 'pt" + i + j + k + "' " + lppt);
                }
            }
        }
        this.bzLatticePtsAll = pts.toArray(new P3[pts.size()]);
    }

    private P3 newPoint(int i, int j, int k, P3 pt) {
        pt.x = i;
        pt.y = j;
        pt.z = k;
        this.vwr.toCartesian(pt, false);
        return pt;
    }

    private void cmd(String cmd) {
        System.out.println(cmd);
        try {
            this.eval.runScript(cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void demoBZ(Object[] array, boolean isK) {
    }

    private boolean getSubzonePmeshes(BZone subzone) {
        this.planes = subzone.planes;
        this.latticePts = subzone.latticePts;
        this.planesUnused = subzone.planesUnused;
        this.ptsUnused = subzone.ptsUnused;
        this.faces = subzone.faces;
        this.faceCenters = subzone.faceCenters;
        int nPlanes = this.planes.size();
        Lst<P4> planesUsed = new Lst<P4>();
        Lst<P3> ptsUsed = new Lst<P3>();
        double totalArea = 0.0;
        for (int i = 0; i < nPlanes; ++i) {
            String pid = "f" + subzone.id + i;
            this.cmd("pmesh ID " + pid + " silent resolution 0.001 boundingbox {-2/1 -2/1 -2/1} {2/1 2/1 2/1} plane   " + this.toScript((P4)this.planes.get(i)) + " off");
            double area = 0.0;
            for (int j = 0; j < nPlanes; ++j) {
                if (j == i) continue;
                this.cmd("pmesh slab plane " + this.toScript((P4)this.planes.get(j)));
                double[] a = (double[])this.getProperty(pid, "area");
                double d = area = a == null ? 0.0 : a[0];
                if (area == 0.0) break;
                totalArea += area;
            }
            P3 a = null;
            P3[] face = null;
            if (area > 0.0) {
                face = (P3[])this.getProperty(pid, "face");
                a = this.average(face);
                if (i == 0 && this.within(0.01f, a, this.bzFaceCenters).size() >= 2) {
                    area = 0.0;
                    totalArea = 0.0;
                    i = nPlanes;
                }
            }
            if (area > 0.0) {
                this.faces.addLast(this.cleanFace(face));
                this.faceCenters.addLast(a);
                this.bzFaceCenters.addLast(a);
                if (this.bzSavePmeshes) {
                    subzone.pmeshes.addLast(pid);
                } else {
                    this.cmd("pmesh ID " + pid + " delete");
                }
                planesUsed.addLast((P4)this.planes.get(i));
                ptsUsed.addLast((P3)this.latticePts.get(i));
                subzone.areas.addLast(area);
            } else {
                this.cmd("pmesh ID " + pid + " delete");
                this.planesUnused.addLast((P4)this.planes.get(i));
                this.ptsUnused.addLast((P3)this.latticePts.get(i));
            }
            subzone.planes = planesUsed;
            subzone.latticePts = ptsUsed;
        }
        subzone.totalArea = totalArea;
        return totalArea > 0.0;
    }

    private String toScript(P4 p4) {
        return "{" + p4.x + " " + p4.y + " " + p4.z + " " + p4.w + "}";
    }

    private Object getProperty(String name, String key) {
        Object[] data = new Object[3];
        int shapeID = this.vwr.shm.getShapeIdFromObjectName(name);
        if (shapeID >= 0) {
            data[0] = name;
            this.vwr.shm.getShapePropertyData(shapeID, "index", data);
            if (data[1] != null && !key.equals("index")) {
                int index = (Integer)data[1];
                data[1] = this.vwr.shm.getShapePropertyIndex(shapeID, key.intern(), index);
            }
        }
        return data[1];
    }

    private void createSubzonePolyhedron(BZone subzone, String id) {
        int i;
        if (id == null) {
            id = "p" + subzone.id;
        }
        subzone.polyid = id;
        P3[] apts = this.join(subzone.faces);
        P3[] pts = this.cleanFace(apts);
        subzone.pts = pts;
        subzone.center = this.average(pts);
        subzone.offset = this.closest(subzone.center, this.bzLatticePtsAll);
        Lst<int[]> ifaces = subzone.faceIndices = new Lst();
        Lst<P3[]> faces = subzone.faces;
        int n = faces.size();
        for (i = 0; i < n; ++i) {
            ifaces.addLast(this.faceIndices((P3[])faces.get(i), pts));
        }
        i = ifaces.size();
        while (--i >= 0) {
            if (((int[])ifaces.get(i)).length >= 3) continue;
            subzone.faces.removeItemAt(i);
            subzone.faceIndices.removeItemAt(i);
            subzone.faceCenters.removeItemAt(i);
            subzone.planes.removeItemAt(i);
        }
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        p.put("id", id);
        p.put("center", subzone.center);
        Lst<P3> lst = new Lst<P3>();
        int n2 = pts.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            lst.addLast(pts[i2]);
        }
        p.put("vertices", lst);
        p.put("faces", ifaces);
        p.put("color", subzone.color);
        this.vwr.setShapeProperty(21, "init", Boolean.TRUE);
        this.vwr.setShapeProperty(21, "info", p);
        this.vwr.setShapeProperty(21, "generate", null);
        this.vwr.setShapeProperty(21, "init", Boolean.FALSE);
        if (this.bzDrawPointsAndEdges) {
            this.cmd("color $" + id + " translucent");
            this.cmd("draw pts points " + pts + " dots nofill nomesh");
        }
    }

    private int[] faceIndices(P3[] p3s, P3[] pts) {
        PointIterator.withinDistPoints(0.0f, null, pts, p3s, this.ret);
        return (int[])this.ret[0];
    }

    private P3 closest(P3 center, P3[] ap3) {
        PointIterator.withinDistPoints(0.0f, center, ap3, null, this.ret);
        return (P3)this.ret[0];
    }

    private P3[] cleanFace(P3[] face) {
        PointIterator.withinDistPoints(0.01f, ptInner, face, null, this.ret);
        Lst l = (Lst)this.ret[0];
        return l.toArray(new P3[l.size()]);
    }

    private P3 average(P3[] face) {
        P3 a = new P3();
        int i = face.length;
        while (--i >= 0) {
            a.add(face[i]);
        }
        a.scale(1.0f / (float)face.length);
        return a;
    }

    private P3[] join(Lst<P3[]> faces) {
        int n = 0;
        int i = faces.size();
        while (--i >= 0) {
            n += ((P3[])faces.get(i)).length;
        }
        P3[] pts = new P3[n];
        n = 0;
        int i2 = faces.size();
        while (--i2 >= 0) {
            P3[] face = (P3[])faces.get(i2);
            int j = face.length;
            while (--j >= 0) {
                pts[n++] = face[j];
            }
        }
        return pts;
    }

    private void drawZoneCenters(BZone zone) {
    }

    private void drawSubzonePolygons(BZone subzone) {
    }

    private void finalizeZone(BZone zone) {
        int i = zone.subzones.size();
        while (--i >= 0) {
            if (((BZone)zone.subzones.get((int)i)).totalArea != 0.0) continue;
            zone.subzones.removeItemAt(i);
        }
    }
}

