/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.awt.Toolkit;
import java.awt.event.InvocationEvent;

public abstract class JSThread
extends Thread {
    public static final int INIT = 0;
    public static final int LOOP = 1;
    public static final int DONE = 2;
    public static int threadCount = 0;
    protected boolean isJS = false;

    public JSThread() {
        this((ThreadGroup)null, "JSThread-" + ++threadCount);
    }

    public JSThread(String name) {
        this((ThreadGroup)null, name);
    }

    public JSThread(ThreadGroup group, String name) {
        super(group, name);
    }

    @Override
    public void run() {
        this.run1(0);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    protected abstract boolean myInit();

    protected abstract boolean isLooping();

    protected abstract boolean myLoop();

    protected abstract void whenDone();

    protected abstract int getDelayMillis();

    protected abstract void onException(Exception var1);

    protected abstract void doFinally();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run1(int state) {
        boolean executeFinally = true;
        try {
            block13: while (!JSThread.interrupted()) {
                switch (state) {
                    case 0: {
                        if (!this.myInit()) {
                            return;
                        }
                        state = 1;
                        continue block13;
                    }
                    case 1: {
                        if (!this.isLooping()) {
                            state = 2;
                            continue block13;
                        }
                        if (!this.myLoop() || !this.sleepAndReturn(this.getDelayMillis(), state)) continue block13;
                        executeFinally = false;
                        return;
                    }
                    case 2: {
                        this.whenDone();
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
            state = 2;
        }
        finally {
            if (executeFinally) {
                this.doFinally();
            }
        }
    }

    protected boolean sleepAndReturn(int delay, final int state) throws InterruptedException {
        if (!this.isJS) {
            JSThread.sleep(delay);
            return false;
        }
        final JSThread me = this;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                me.run1(state);
            }
        };
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new InvocationEvent((Object)me, r));
        return true;
    }
}

