/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import uk.ac.vamsas.objects.core.Alignment;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.utils.Format;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;
import uk.ac.vamsas.objects.utils.Seq;
import uk.ac.vamsas.objects.utils.SeqSet;

public class SeqAln
extends Alignment {
    public static Sequence[] ReadClustalFile(InputStream os) throws Exception {
        System.err.println("NOT FULLY IMPLEMENTED!");
        Pattern nonGap = Pattern.compile("[A-Z*0-9]", 2);
        String gapchars = "";
        int gapchar = 45;
        int i = 0;
        boolean flag = false;
        Vector<String> headers = new Vector<String>();
        Hashtable<String, StringBuffer> seqhash = new Hashtable<String, StringBuffer>();
        Sequence[] seqs = null;
        int noSeqs = 0;
        try {
            String line;
            BufferedReader ins = new BufferedReader(new InputStreamReader(os));
            while ((line = ins.readLine()) != null) {
                StringBuffer tempseq;
                if (line.indexOf(" ") == 0) continue;
                StringTokenizer str = new StringTokenizer(line, " ");
                String id = "";
                if (!str.hasMoreTokens()) continue;
                id = str.nextToken();
                if (id.equals("CLUSTAL")) {
                    flag = true;
                    continue;
                }
                if (!flag) continue;
                if (seqhash.containsKey(id)) {
                    tempseq = (StringBuffer)seqhash.get(id);
                } else {
                    tempseq = new StringBuffer();
                    seqhash.put(id, tempseq);
                }
                if (!headers.contains(id)) {
                    headers.addElement(id);
                }
                tempseq.append(str.nextToken());
            }
        }
        catch (IOException e) {
            throw new Exception("Exception parsing clustal file ", e);
        }
        if (flag) {
            noSeqs = headers.size();
            seqs = new Sequence[headers.size()];
            for (i = 0; i < headers.size(); ++i) {
                Sequence newSeq;
                if (seqhash.get(headers.elementAt(i)) == null) {
                    throw new Exception("Bizarreness! Can't find sequence for " + headers.elementAt(i));
                }
                seqs[i] = newSeq = Seq.newSequence(headers.elementAt(i).toString(), seqhash.get(headers.elementAt(i).toString()).toString(), "info:iubmb.org/aminoacids", 0, 0);
            }
        }
        return seqs;
    }

    public static void WriteClustalWAlignment(OutputStream os, Alignment seqAl) throws IOException {
        int i;
        System.err.println("NOT FULLY IMPLEMENTED!");
        AlignmentSequence[] s = seqAl.getAlignmentSequence();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
        out.write("CLUSTAL\n\n");
        int max = 0;
        int maxid = 0;
        for (i = 0; i < s.length && s[i] != null; ++i) {
            String tmp = s[i].getId();
            if (s[i].getSequence().length() > max) {
                max = s[i].getSequence().length();
            }
            if (tmp.length() <= maxid) continue;
            maxid = tmp.length();
        }
        if (maxid < 15) {
            maxid = 15;
        }
        ++maxid;
        int len = 60;
        int nochunks = max / len + 1;
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                out.write(new Format("%-" + maxid + "s").form(s[j].getId() + " "));
                int start = i * len;
                int end = start + len;
                if (end < s[j].getSequence().length() && start < s[j].getSequence().length()) {
                    out.write(s[j].getSequence().substring(start, end) + "\n");
                    continue;
                }
                if (start >= s[j].getSequence().length()) continue;
                out.write(s[j].getSequence().substring(start) + "\n");
            }
            out.write("\n");
        }
    }

    public static Alignment make_Alignment(Entry origin, Sequence[] seqs) throws Exception {
        System.err.println("NOT FULLY IMPLEMENTED!");
        Alignment al = new Alignment();
        al.setProvenance(ProvenanceStuff.newProvenance(origin));
        Pattern nonGap = Pattern.compile("[A-Z*0-9]", 2);
        boolean gapsset = false;
        char gapchar = '-';
        int seqLength = 0;
        int nseq = seqs.length;
        for (int i = 0; i < nseq; ++i) {
            String seq = seqs[i].getSequence();
            String gaps = nonGap.matcher(seq).replaceAll("");
            if (seqLength == 0) {
                seqLength = seq.length();
            } else if (seqLength != seq.length()) {
                throw new Exception(i + "th Sequence (>" + seqs[i].getId() + ") is not aligned.\n");
            }
            if (gaps != null && gaps.length() > 0) {
                if (!gapsset) {
                    gapchar = gaps.charAt(0);
                }
                int gc = gaps.length();
                for (int c = 0; c < gc; ++c) {
                    if (gapchar == gaps.charAt(c)) continue;
                    throw new IOException("Inconsistent gap characters in sequence " + i + ": '" + seq + "'");
                }
            }
            AlignmentSequence sq = new AlignmentSequence();
            sq.setSequence(seq);
            sq.setName(seqs[i].getId());
            sq.setRefid(seqs[i].getVorbaId());
            sq.setStart(seqs[i].getStart());
            sq.setEnd(seqs[i].getEnd());
            al.addAlignmentSequence(sq);
        }
        al.setGapChar(String.valueOf(gapchar));
        return al;
    }

    public static Alignment read_FastaAlignment(InputStream os, Entry entry) throws Exception {
        Sequence[] seqs;
        System.err.println("NOT FULLY IMPLEMENTED!");
        try {
            seqs = SeqSet.read_SeqFasta(os);
            if (seqs == null) {
                throw new Exception("Empty alignment stream!\n");
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid fasta alignment\n", e);
        }
        return SeqAln.make_Alignment(entry, seqs);
    }

    public static Alignment read_ClustalAlignment(InputStream os, Entry entry) throws Exception {
        Sequence[] seqs;
        try {
            seqs = SeqAln.ReadClustalFile(os);
            if (seqs == null) {
                throw new Exception("Empty alignment stream!\n");
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid fasta alignment\n", e);
        }
        System.err.println("NOT FULLY IMPLEMENTED!");
        return SeqAln.make_Alignment(entry, seqs);
    }
}

