/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.epsgraphics;

import jalview.util.MessageManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Map;
import org.jibble.epsgraphics.EpsDocument;
import org.jibble.epsgraphics.EpsException;

public class EpsGraphics2D
extends Graphics2D
implements AutoCloseable {
    public static final String VERSION = "0.8.8";
    private Color _color;
    private Color _backgroundColor;
    private Paint _paint;
    private Composite _composite;
    private BasicStroke _stroke;
    private Font _font;
    private Shape _clip;
    private AffineTransform _clipTransform;
    private AffineTransform _transform;
    private boolean _accurateTextMode;
    private EpsDocument _document;
    private static FontRenderContext _fontRenderContext = new FontRenderContext(null, false, true);

    public EpsGraphics2D() {
        this("Untitled");
    }

    public EpsGraphics2D(String title) {
        this._document = new EpsDocument(title);
        this._backgroundColor = Color.white;
        this._clip = null;
        this._transform = new AffineTransform();
        this._clipTransform = new AffineTransform();
        this._accurateTextMode = true;
        this.setColor(Color.black);
        this.setPaint(Color.black);
        this.setComposite(AlphaComposite.getInstance(1));
        this.setFont(Font.decode(null));
        this.setStroke(new BasicStroke());
    }

    public EpsGraphics2D(String title, File file, int minX, int minY, int maxX, int maxY) throws IOException {
        this(title, new FileOutputStream(file), minX, minY, maxX, maxY);
    }

    public EpsGraphics2D(String title, OutputStream outputStream, int minX, int minY, int maxX, int maxY) throws IOException {
        this(title);
        this._document = new EpsDocument(title, outputStream, minX, minY, maxX, maxY);
    }

    protected EpsGraphics2D(EpsGraphics2D g) {
        this._document = g._document;
        this._backgroundColor = g._backgroundColor;
        this._clip = g._clip;
        this._clipTransform = (AffineTransform)g._clipTransform.clone();
        this._transform = (AffineTransform)g._transform.clone();
        this._color = g._color;
        this._paint = g._paint;
        this._composite = g._composite;
        this._font = g._font;
        this._stroke = g._stroke;
        this._accurateTextMode = g._accurateTextMode;
    }

    private void methodNotSupported() {
        EpsException e = new EpsException(MessageManager.formatMessage("exception.eps_method_not_supported", new String[]{VERSION}));
        e.printStackTrace(System.err);
    }

    public void setAccurateTextMode(boolean b) {
        this._accurateTextMode = b;
    }

    public boolean getAccurateTextMode() {
        return this._accurateTextMode;
    }

    public void flush() throws IOException {
        this._document.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this._document.close();
    }

    private void append(String line) {
        this._document.append(this, line);
    }

    private Point2D transform(float x, float y) {
        Point2D result = new Point2D.Float(x, y);
        result = this._transform.transform(result, result);
        result.setLocation(result.getX(), -result.getY());
        return result;
    }

    private void draw(Shape s, String action) {
        if (s != null) {
            if (!this._transform.isIdentity()) {
                s = this._transform.createTransformedShape(s);
            }
            if (!action.equals("clip")) {
                Rectangle2D shapeBounds;
                Rectangle2D visibleBounds = shapeBounds = s.getBounds2D();
                if (this._clip != null) {
                    Rectangle2D clipBounds = this._clip.getBounds2D();
                    visibleBounds = shapeBounds.createIntersection(clipBounds);
                }
                float lineRadius = this._stroke.getLineWidth() / 2.0f;
                float minX = (float)visibleBounds.getMinX() - lineRadius;
                float minY = (float)visibleBounds.getMinY() - lineRadius;
                float maxX = (float)visibleBounds.getMaxX() + lineRadius;
                float maxY = (float)visibleBounds.getMaxY() + lineRadius;
                this._document.updateBounds(minX, -minY);
                this._document.updateBounds(maxX, -maxY);
            }
            this.append("newpath");
            int type = 0;
            float[] coords = new float[6];
            PathIterator it = s.getPathIterator(null);
            float x0 = 0.0f;
            float y0 = 0.0f;
            int count = 0;
            while (!it.isDone()) {
                type = it.currentSegment(coords);
                float x1 = coords[0];
                float y1 = -coords[1];
                float x2 = coords[2];
                float y2 = -coords[3];
                float x3 = coords[4];
                float y3 = -coords[5];
                if (type == 4) {
                    this.append("closepath");
                    ++count;
                } else if (type == 3) {
                    this.append(x1 + " " + y1 + " " + x2 + " " + y2 + " " + x3 + " " + y3 + " curveto");
                    ++count;
                    x0 = x3;
                    y0 = y3;
                } else if (type == 1) {
                    this.append(x1 + " " + y1 + " lineto");
                    ++count;
                    x0 = x1;
                    y0 = y1;
                } else if (type == 0) {
                    this.append(x1 + " " + y1 + " moveto");
                    ++count;
                    x0 = x1;
                    y0 = y1;
                } else if (type == 2) {
                    float _x1 = x0 + 0.6666667f * (x1 - x0);
                    float _y1 = y0 + 0.6666667f * (y1 - y0);
                    float _x2 = x1 + 0.33333334f * (x2 - x1);
                    float _y2 = y1 + 0.33333334f * (y2 - y1);
                    float _x3 = x2;
                    float _y3 = y2;
                    this.append(_x1 + " " + _y1 + " " + _x2 + " " + _y2 + " " + _x3 + " " + _y3 + " curveto");
                    ++count;
                    x0 = _x3;
                    y0 = _y3;
                } else if (type == 0 || type == 1) {
                    // empty if block
                }
                it.next();
            }
            this.append(action);
            this.append("newpath");
        }
    }

    private String toHexString(int n) {
        String result = Integer.toString(n, 16);
        while (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Color originalColor = this.getColor();
        Stroke originalStroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f));
        if (raised) {
            this.setColor(originalColor.brighter());
        } else {
            this.setColor(originalColor.darker());
        }
        this.drawLine(x, y, x + width, y);
        this.drawLine(x, y, x, y + height);
        if (raised) {
            this.setColor(originalColor.darker());
        } else {
            this.setColor(originalColor.brighter());
        }
        this.drawLine(x + width, y + height, x, y + height);
        this.drawLine(x + width, y + height, x + width, y);
        this.setColor(originalColor);
        this.setStroke(originalStroke);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Color originalColor = this.getColor();
        if (raised) {
            this.setColor(originalColor.brighter());
        } else {
            this.setColor(originalColor.darker());
        }
        this.draw(new Rectangle(x, y, width, height), "fill");
        this.setColor(originalColor);
        this.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void draw(Shape s) {
        this.draw(s, "stroke");
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform at = this.getTransform();
        this.transform(xform);
        boolean st = this.drawImage(img, 0, 0, obs);
        this.setTransform(at);
        return st;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(img, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] names = img.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            properties.put(names[i], img.getProperty(names[i]));
        }
        ColorModel cm = img.getColorModel();
        WritableRaster wr = img.copyData(null);
        BufferedImage img1 = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        AffineTransform at = AffineTransform.getTranslateInstance(img.getMinX(), img.getMinY());
        at.preConcatenate(xform);
        this.drawImage(img1, at, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (s != null && s.length() > 0) {
            AttributedString as = new AttributedString(s);
            as.addAttribute(TextAttribute.FONT, this.getFont());
            this.drawString(as.getIterator(), x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.getAccurateTextMode()) {
            TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
            Shape shape = layout.getOutline(AffineTransform.getTranslateInstance(x, y));
            this.draw(shape, "fill");
        } else {
            this.append("newpath");
            Point2D location = this.transform(x, y);
            this.append(location.getX() + " " + location.getY() + " moveto");
            StringBuffer buffer = new StringBuffer();
            char ch = iterator.first();
            while (ch != '\uffff') {
                if (ch == '(' || ch == ')') {
                    buffer.append('\\');
                }
                buffer.append(ch);
                ch = iterator.next();
            }
            this.append("(" + buffer.toString() + ") show");
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape shape = g.getOutline(x, y);
        this.draw(shape, "fill");
    }

    @Override
    public void fill(Shape s) {
        this.draw(s, "fill");
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return s.intersects(rect);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        for (int i = 0; i < gds.length; ++i) {
            GraphicsDevice gd = gds[i];
            GraphicsConfiguration[] gcs = gd.getConfigurations();
            if (gcs.length <= 0) continue;
            return gcs[0];
        }
        return gc;
    }

    @Override
    public void setComposite(Composite comp) {
        this._composite = comp;
    }

    @Override
    public void setPaint(Paint paint) {
        this._paint = paint;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    @Override
    public void setStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            this._stroke = (BasicStroke)s;
            this.append(this._stroke.getLineWidth() + " setlinewidth");
            float miterLimit = this._stroke.getMiterLimit();
            if (miterLimit < 1.0f) {
                miterLimit = 1.0f;
            }
            this.append(miterLimit + " setmiterlimit");
            this.append(this._stroke.getLineJoin() + " setlinejoin");
            this.append(this._stroke.getEndCap() + " setlinecap");
            StringBuffer dashes = new StringBuffer();
            dashes.append("[ ");
            float[] dashArray = this._stroke.getDashArray();
            if (dashArray != null) {
                for (int i = 0; i < dashArray.length; ++i) {
                    dashes.append(dashArray[i] + " ");
                }
            }
            dashes.append("]");
            this.append(dashes.toString() + " 0 setdash");
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    @Override
    public void rotate(double theta) {
        this.rotate(theta, 0.0, 0.0);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    @Override
    public void transform(AffineTransform Tx) {
        this._transform.concatenate(Tx);
        this.setTransform(this.getTransform());
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this._transform = Tx == null ? new AffineTransform() : new AffineTransform(Tx);
        this.setStroke(this.getStroke());
        this.setFont(this.getFont());
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    @Override
    public Paint getPaint() {
        return this._paint;
    }

    @Override
    public Composite getComposite() {
        return this._composite;
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._backgroundColor = color;
    }

    @Override
    public Color getBackground() {
        return this._backgroundColor;
    }

    @Override
    public Stroke getStroke() {
        return this._stroke;
    }

    @Override
    public void clip(Shape s) {
        if (this._clip == null) {
            this.setClip(s);
        } else {
            Area area = new Area(this._clip);
            area.intersect(new Area(s));
            this.setClip(area);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return _fontRenderContext;
    }

    @Override
    public Graphics create() {
        return new EpsGraphics2D(this);
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.clipRect(0, 0, width, height);
        return g;
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    @Override
    public void setColor(Color c) {
        if (c == null) {
            c = Color.black;
        }
        this._color = c;
        this.append((float)c.getRed() / 255.0f + " " + (float)c.getGreen() / 255.0f + " " + (float)c.getBlue() / 255.0f + " setrgbcolor");
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
        this.methodNotSupported();
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            font = Font.decode(null);
        }
        this._font = font;
        this.append("/" + this._font.getPSName() + " findfont " + this._font.getSize() + " scalefont setfont");
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics g = image.getGraphics();
        return g.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        if (this._clip == null) {
            return null;
        }
        Rectangle rect = this.getClip().getBounds();
        return rect;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        if (this._clip == null) {
            return null;
        }
        try {
            AffineTransform t = this._transform.createInverse();
            t.concatenate(this._clipTransform);
            return t.createTransformedShape(this._clip);
        }
        catch (Exception e) {
            throw new EpsException(MessageManager.formatMessage("exception.eps_unable_to_get_inverse_matrix", new String[]{this._transform.toString()}));
        }
    }

    @Override
    public void setClip(Shape clip) {
        if (clip != null) {
            if (this._document.isClipSet()) {
                this.append("grestore");
                this.append("gsave");
            } else {
                this._document.setClipSet(true);
                this.append("gsave");
            }
            this.draw(clip, "clip");
            this._clip = clip;
            this._clipTransform = (AffineTransform)this._transform.clone();
        } else {
            if (this._document.isClipSet()) {
                this.append("grestore");
                this._document.setClipSet(false);
            }
            this._clip = null;
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.methodNotSupported();
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float shape = new Line2D.Float(x1, y1, x2, y2);
        this.draw(shape);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape, "fill");
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color originalColor = this.getColor();
        this.setColor(this.getBackground());
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape, "fill");
        this.setColor(originalColor);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.draw(shape);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.draw(shape, "fill");
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float shape = new Ellipse2D.Float(x, y, width, height);
        this.draw(shape);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float shape = new Ellipse2D.Float(x, y, width, height);
        this.draw(shape, "fill");
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float shape = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(shape);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float shape = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2);
        this.draw(shape, "fill");
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xPoints[0], yPoints[0]);
            for (int i = 1; i < nPoints; ++i) {
                path.lineTo(xPoints[i], yPoints[i]);
            }
            this.draw(path);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon shape = new Polygon(xPoints, yPoints, nPoints);
        this.draw(shape);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon shape = new Polygon(xPoints, yPoints, nPoints);
        this.draw(shape, "fill");
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.draw(p, "fill");
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        String string = new String(data, offset, length);
        this.drawString(string, x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        String string = new String(data, offset, length);
        this.drawString(string, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, Color.white, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, Color.white, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        return this.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, Color.white, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (dx1 >= dx2) {
            throw new IllegalArgumentException("dx1 >= dx2");
        }
        if (sx1 >= sx2) {
            throw new IllegalArgumentException("sx1 >= sx2");
        }
        if (dy1 >= dy2) {
            throw new IllegalArgumentException("dy1 >= dy2");
        }
        if (sy1 >= sy2) {
            throw new IllegalArgumentException("sy1 >= sy2");
        }
        this.append("gsave");
        int width = sx2 - sx1;
        int height = sy2 - sy1;
        int destWidth = dx2 - dx1;
        int destHeight = dy2 - dy1;
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img, sx1, sy1, sx2 - sx1, sy2 - sy1, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        AffineTransform matrix = new AffineTransform(this._transform);
        matrix.translate(dx1, dy1);
        matrix.scale((double)destWidth / (double)width, (double)destHeight / (double)height);
        double[] m = new double[6];
        try {
            matrix = matrix.createInverse();
        }
        catch (Exception e) {
            throw new EpsException(MessageManager.formatMessage("exception.eps_unable_to_get_inverse_matrix", new String[]{matrix.toString()}));
        }
        matrix.scale(1.0, -1.0);
        matrix.getMatrix(m);
        this.append(width + " " + height + " 8 [" + m[0] + " " + m[1] + " " + m[2] + " " + m[3] + " " + m[4] + " " + m[5] + "]");
        Color oldColor = this.getColor();
        this.setColor(this.getBackground());
        this.fillRect(dx1, dy1, destWidth, destHeight);
        this.setColor(oldColor);
        this.append("{currentfile 3 " + width + " mul string readhexstring pop} bind");
        this.append("false 3 colorimage");
        StringBuffer line = new StringBuffer();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = new Color(pixels[x + width * y]);
                line.append(this.toHexString(color.getRed()) + this.toHexString(color.getGreen()) + this.toHexString(color.getBlue()));
                if (line.length() <= 64) continue;
                this.append(line.toString());
                line = new StringBuffer();
            }
        }
        if (line.length() > 0) {
            this.append(line.toString());
        }
        this.append("grestore");
        return true;
    }

    @Override
    public void dispose() {
        this._document = null;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this._document.write(writer);
            this._document.flush();
            this._document.close();
        }
        catch (IOException e) {
            throw new EpsException(e.toString());
        }
        return writer.toString();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        if (this._clip == null) {
            return true;
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        return this.hit(rect, this._clip, true);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        if (this._clip == null) {
            return r;
        }
        Rectangle rect = this.getClipBounds();
        r.setLocation((int)rect.getX(), (int)rect.getY());
        r.setSize((int)rect.getWidth(), (int)rect.getHeight());
        return r;
    }
}

