/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest.params;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.ws.params.OptionI;
import jalview.ws.params.simple.Option;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class SeqVector
extends InputType {
    String sep;
    InputType.molType type;

    public SeqVector() {
        super(new Class[]{AlignmentI.class});
    }

    @Override
    public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException {
        StringBuffer idvector = new StringBuffer();
        boolean list = false;
        for (SequenceI seq : rj.getSequencesForInput(this.token, this.type)) {
            if (list) {
                idvector.append(this.sep);
            }
            idvector.append(seq.getSequenceAsString());
        }
        return new StringBody(idvector.toString());
    }

    @Override
    public List<String> getURLEncodedParameter() {
        ArrayList<String> prms = new ArrayList<String>();
        super.addBaseParams(prms);
        prms.add("sep='" + this.sep + "'");
        if (this.type != null) {
            prms.add("type='" + (Object)((Object)this.type) + "'");
        }
        return prms;
    }

    @Override
    public String getURLtokenPrefix() {
        return "SEQS";
    }

    @Override
    public boolean configureProperty(String tok, String val, StringBuffer warnings) {
        if (tok.startsWith("sep")) {
            this.sep = val;
            return true;
        }
        if (tok.startsWith("type")) {
            try {
                this.type = InputType.molType.valueOf(val);
                return true;
            }
            catch (Exception x) {
                warnings.append("Invalid molecule type '" + val + "'. Must be one of (");
                for (InputType.molType v : InputType.molType.values()) {
                    warnings.append(" " + (Object)((Object)v));
                }
                warnings.append(")\n");
            }
        }
        return false;
    }

    @Override
    public List<OptionI> getOptions() {
        List<OptionI> lst = this.getBaseOptions();
        lst.add(new Option("sep", "Separator character between elements of vector", true, ",", this.sep, Arrays.asList(" ", ",", ";", "\t", "|"), null));
        lst.add(this.createMolTypeOption("type", "Sequence type", false, this.type, InputType.molType.MIX));
        return lst;
    }
}

