/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest.params;

import jalview.analysis.AlignmentSorter;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.util.QuickSort;
import jalview.ws.params.OptionI;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws.params.simple.Option;
import jalview.ws.rest.AlignmentProcessor;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class SeqGroupIndexVector
extends InputType
implements AlignmentProcessor {
    public String sep = ",";
    public int minsize = 1;
    InputType.molType type;

    public SeqGroupIndexVector() {
        super(new Class[]{AlignmentI.class});
    }

    @Override
    public AlignmentI prepareAlignment(AlignmentI al) {
        AlignmentSorter.sortByGroup(al);
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException {
        List<SequenceGroup> sgs;
        StringBuffer idvector = new StringBuffer();
        boolean list = false;
        AlignmentI al = rj.getAlignmentForInput(this.token, this.type);
        ArrayList<int[]> gl = new ArrayList<int[]>();
        int p = 0;
        int lowest = al.getHeight();
        int highest = 0;
        List<SequenceGroup> list2 = sgs = al.getGroups();
        synchronized (list2) {
            for (SequenceGroup sg : sgs) {
                if (sg.getSize() < this.minsize) {
                    throw new NoValidInputDataException(MessageManager.formatMessage("exception.notvaliddata_group_contains_less_than_min_seqs", new String[]{Integer.valueOf(this.minsize).toString()}));
                }
                int[] se = null;
                SequenceI[] sequenceIArray = sg.getSequencesInOrder(al);
                int n = sequenceIArray.length;
                for (int i = 0; i < n; ++i) {
                    SequenceI sq = sequenceIArray[i];
                    p = al.findIndex(sq);
                    if (lowest > p) {
                        lowest = p;
                    }
                    if (highest < p) {
                        highest = p;
                    }
                    if (se == null) {
                        se = new int[]{p, p};
                        continue;
                    }
                    if (p < se[0]) {
                        se[0] = p;
                    }
                    if (p <= se[1]) continue;
                    se[1] = p;
                }
                if (se == null) continue;
                gl.add(se);
            }
        }
        if (gl.size() > 0) {
            if (lowest - 1 > this.minsize) {
                gl.add(0, new int[]{0, lowest - 2});
            }
            if (al.getHeight() - 1 - highest > this.minsize) {
                gl.add(new int[]{highest + 1, al.getHeight() - 1});
            }
        } else {
            gl.add(new int[]{0, al.getHeight() - 1});
        }
        if (this.min >= 0 && gl.size() < this.min) {
            throw new NoValidInputDataException("Not enough sequence groups for input. Need at least " + this.min + " groups (including ungrouped regions).");
        }
        if (this.max > 0 && gl.size() > this.max) {
            throw new NoValidInputDataException("Too many sequence groups for input. Need at most " + this.max + " groups (including ungrouped regions).");
        }
        int[][] vals = (int[][])gl.toArray((T[])new int[gl.size()][]);
        int[] srt = new int[gl.size()];
        for (int i = 0; i < vals.length; ++i) {
            srt[i] = vals[i][0];
        }
        QuickSort.sort(srt, (Object[])vals);
        list = false;
        int last = vals[0][0] - 1;
        for (int[] range : vals) {
            if (range[1] <= last) continue;
            if (list) {
                idvector.append(this.sep);
            }
            idvector.append(range[1] - last);
            last = range[1];
            list = true;
        }
        return new StringBody(idvector.toString());
    }

    public void setMinsize(int i) {
        this.minsize = this.minsize >= 1 ? i : 1;
    }

    @Override
    public List<String> getURLEncodedParameter() {
        ArrayList<String> prms = new ArrayList<String>();
        super.addBaseParams(prms);
        prms.add("minsize='" + this.minsize + "'");
        prms.add("sep='" + this.sep + "'");
        if (this.type != null) {
            prms.add("type='" + (Object)((Object)this.type) + "'");
        }
        return prms;
    }

    @Override
    public String getURLtokenPrefix() {
        return "PARTITION";
    }

    @Override
    public boolean configureProperty(String tok, String val, StringBuffer warnings) {
        if (tok.startsWith("sep")) {
            this.sep = val;
            return true;
        }
        if (tok.startsWith("minsize")) {
            try {
                this.minsize = Integer.valueOf(val);
                if (this.minsize >= 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            warnings.append("Invalid minsize value '" + val + "'. Must be a positive integer.\n");
        }
        if (tok.startsWith("type")) {
            try {
                this.type = InputType.molType.valueOf(val);
                return true;
            }
            catch (Exception x) {
                warnings.append("Invalid molecule type '" + val + "'. Must be one of (");
                for (InputType.molType v : InputType.molType.values()) {
                    warnings.append(" " + (Object)((Object)v));
                }
                warnings.append(")\n");
            }
        }
        return false;
    }

    @Override
    public List<OptionI> getOptions() {
        List<OptionI> lst = this.getBaseOptions();
        lst.add(new Option("sep", "Separator character between elements of vector", true, ",", this.sep, Arrays.asList(" ", ",", ";", "\t", "|"), null));
        lst.add(new IntegerParameter("minsize", "Minimum size of partition allowed by service", true, 1, this.minsize, 1, 0));
        lst.add(this.createMolTypeOption("type", "Sequence type", false, this.type, InputType.molType.MIX));
        return lst;
    }
}

