/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import ext.vamsas.SeqSearchI;
import ext.vamsas.SeqSearchServiceLocator;
import ext.vamsas.SeqSearchServiceSoapBindingStub;
import ext.vamsas.ServiceHandle;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.util.MessageManager;
import jalview.ws.jws1.SeqSearchWSThread;
import jalview.ws.jws1.WS1Client;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SeqSearchWSClient
extends WS1Client {
    SeqSearchI server;
    AlignFrame alignFrame;
    private static Hashtable dbParamsForEndpoint = new Hashtable();

    public SeqSearchWSClient(ServiceHandle sh, String altitle, AlignmentView msa, String db, AlignmentI seqdataset, AlignFrame _alignFrame) {
        this.alignFrame = _alignFrame;
        if (!sh.getAbstractName().equals(this.getServiceActionKey())) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.service_called_is_not_seq_search_service", new String[]{sh.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
            return;
        }
        this.wsInfo = this.setWebService(sh);
        if (this.wsInfo == null) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.seq_search_service_is_unknown", new String[]{sh.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
            return;
        }
        this.startSeqSearchClient(altitle, msa, db, seqdataset);
    }

    public SeqSearchWSClient(ServiceHandle sh) {
        this.setWebService(sh, true);
    }

    public SeqSearchWSClient() {
    }

    private void startSeqSearchClient(String altitle, AlignmentView msa, String db, AlignmentI seqdataset) {
        if (!this.locateWebService()) {
            return;
        }
        String visdb = db == null || db == "" ? "default" : db;
        boolean profileSearch = msa.getSequences().length > 2;
        this.wsInfo.setProgressText("Searching " + visdb + (!profileSearch ? " with sequence " + msa.getSequences()[0].getRefSeq().getName() : " with profile") + " from " + altitle + "\nJob details\n");
        String jobtitle = this.WebServiceName + (this.WebServiceName.indexOf("earch") > -1 ? " " : " search ") + " of " + visdb + (!profileSearch ? " with sequence " + msa.getSequences()[0].getRefSeq().getName() : " with profile") + " from " + altitle;
        SeqSearchWSThread ssthread = new SeqSearchWSThread(this.server, this.WsURL, this.wsInfo, this.alignFrame, this.WebServiceName, jobtitle, msa, db, seqdataset);
        this.wsInfo.setthisService(ssthread);
        ssthread.start();
    }

    private boolean locateWebService() {
        SeqSearchServiceLocator loc = new SeqSearchServiceLocator();
        try {
            this.server = loc.getSeqSearchService(new URL(this.WsURL));
            ((SeqSearchServiceSoapBindingStub)this.server).setTimeout(60000);
        }
        catch (Exception ex) {
            this.wsInfo.setProgressText("Serious! " + this.WebServiceName + " Service location failed\nfor URL :" + this.WsURL + "\n" + ex.getMessage());
            this.wsInfo.setStatus(64);
            ex.printStackTrace();
            return false;
        }
        loc.getEngine().setOption("axis", (Object)"1");
        return true;
    }

    protected String getServiceActionKey() {
        return "SeqSearch";
    }

    protected String getServiceActionDescription() {
        return "Sequence Database Search";
    }

    public String[] getSupportedDatabases() throws Exception {
        if (dbParamsForEndpoint.containsKey(this.WsURL)) {
            return (String[])dbParamsForEndpoint.get(this.WsURL);
        }
        if (!this.locateWebService()) {
            throw new Exception(MessageManager.formatMessage("exception.cannot_contact_service_endpoint_at", new String[]{this.WsURL}));
        }
        String database = this.server.getDatabase();
        if (database == null) {
            dbParamsForEndpoint.put(this.WsURL, new String[0]);
            return null;
        }
        StringTokenizer en = new StringTokenizer(database.trim(), ",| ");
        String[] dbs = new String[en.countTokens()];
        for (int i = 0; i < dbs.length; ++i) {
            dbs[i++] = en.nextToken().trim();
        }
        dbParamsForEndpoint.put(this.WsURL, dbs);
        return dbs;
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, final ServiceHandle sh, final AlignFrame af) {
        Hashtable<String, Component> dbsrchs = new Hashtable<String, Component>();
        Vector<JMenu> newdbsrch = new Vector<JMenu>();
        Component[] entries = wsmenu.getComponents();
        for (int i = 0; entries != null && i < entries.length; ++i) {
            if (!(entries[i] instanceof JMenu)) continue;
            dbsrchs.put(entries[i].getName(), entries[i]);
        }
        JMenu defmenu = (JMenu)dbsrchs.get("Default Database");
        if (defmenu == null) {
            defmenu = new JMenu("Default Database");
            dbsrchs.put("Default Database", defmenu);
            newdbsrch.addElement(defmenu);
        }
        String[] dbs = null;
        try {
            dbs = new SeqSearchWSClient(sh).getSupportedDatabases();
        }
        catch (Exception e) {
            Console.warn("Database list request failed, so disabling SeqSearch Service client " + sh.getName() + " at " + sh.getEndpointURL(), e);
            return;
        }
        JMenuItem method = new JMenuItem(sh.getName());
        defmenu.add(method);
        method.setToolTipText(sh.getEndpointURL());
        method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentView msa = af.gatherSeqOrMsaForSecStrPrediction();
                new SeqSearchWSClient(sh, af.getTitle(), msa, null, af.getViewport().getAlignment().getDataset(), af);
            }
        });
        for (int db = 0; dbs != null && db < dbs.length; ++db) {
            JMenu dbmenu = (JMenu)dbsrchs.get(dbs[db]);
            if (dbmenu == null) {
                dbmenu = new JMenu(dbs[db]);
                dbsrchs.put(dbs[db], dbmenu);
                newdbsrch.addElement(dbmenu);
            }
            method = new JMenuItem(sh.getName());
            dbmenu.add(method);
            method.setToolTipText(sh.getEndpointURL());
            final String searchdb = dbs[db];
            method.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignmentView msa = af.gatherSeqOrMsaForSecStrPrediction();
                    new SeqSearchWSClient(sh, af.getTitle(), msa, searchdb, af.getViewport().getAlignment().getDataset(), af);
                }
            });
        }
        Enumeration e = newdbsrch.elements();
        while (e.hasMoreElements()) {
            Object el = e.nextElement();
            if (el instanceof JMenu) {
                wsmenu.add((JMenu)el);
                continue;
            }
            wsmenu.add((JMenuItem)el);
        }
    }
}

