/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.datamodel.alphafold;

import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.FloatContactMatrix;
import jalview.datamodel.GroupSet;
import jalview.datamodel.SequenceDummy;
import jalview.datamodel.SequenceI;
import jalview.io.FileFormatException;
import jalview.util.MapList;
import jalview.util.MapUtils;
import jalview.ws.datamodel.alphafold.MappableContactMatrix;
import jalview.ws.dbsources.EBIAlfaFold;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class PAEContactMatrix
extends MappableContactMatrix<PAEContactMatrix>
implements ContactMatrixI {
    public static final String PAEMATRIX = "PAE_MATRIX";

    public PAEContactMatrix(SequenceI _refSeq, Map<String, Object> pae_obj) throws FileFormatException {
        this.setRefSeq(_refSeq);
        if (!MapUtils.containsAKey(pae_obj, "predicted_aligned_error", "pae")) {
            this.parse_version_1_pAE(pae_obj);
            return;
        }
        this.parse_version_2_pAE(pae_obj);
    }

    public PAEContactMatrix(SequenceI _refSeq, float[][] matrix) {
        this.mappedMatrix = new FloatContactMatrix(matrix);
        this.setRefSeq(_refSeq);
    }

    public PAEContactMatrix(SequenceI newRefSeq, MapList newFromMapList, float[][] elements2, GroupSet grps2) {
        this(newRefSeq, new FloatContactMatrix(elements2, grps2));
        this.toSeq = newFromMapList;
    }

    public PAEContactMatrix(SequenceI _refSeq, ContactMatrixI floatContactMatrix) {
        this.mappedMatrix = floatContactMatrix;
        this.setRefSeq(_refSeq);
    }

    public PAEContactMatrix(SequenceI _refSeq, MapList newFromMapList, ContactMatrixI floatContactMatrix) {
        this.mappedMatrix = floatContactMatrix;
        this.setRefSeq(_refSeq);
        this.toSeq = newFromMapList;
    }

    @Override
    protected PAEContactMatrix newMappableContactMatrix(SequenceI newRefSeq, MapList newFromMapList) {
        return new PAEContactMatrix(newRefSeq, newFromMapList, this.mappedMatrix);
    }

    private void parse_version_2_pAE(Map<String, Object> pae_obj) {
        float maxscore = -1.0f;
        try {
            maxscore = ((Double)MapUtils.getFirst(pae_obj, "max_predicted_aligned_error", "max_pae")).floatValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List scoreRows = (List)MapUtils.getFirst(pae_obj, "predicted_aligned_error", "pae");
        float[][] elements = new float[scoreRows.size()][scoreRows.size()];
        int row = 0;
        int col = 0;
        for (List scoreRow : scoreRows) {
            for (Object d : scoreRow) {
                elements[col][row] = d instanceof Double ? (float)((Double)d).longValue() : (float)((Long)d).longValue();
                if (maxscore < elements[col][row]) {
                    maxscore = elements[col][row];
                }
                ++col;
            }
            ++row;
            col = 0;
        }
        this.mappedMatrix = new FloatContactMatrix(elements);
    }

    private void parse_version_1_pAE(Map<String, Object> pae_obj) {
        Iterator rows = ((List)pae_obj.get("residue1")).iterator();
        Iterator cols = ((List)pae_obj.get("residue2")).iterator();
        int maxrow = -1;
        int maxcol = -1;
        while (rows.hasNext()) {
            int row = ((Long)rows.next()).intValue();
            int col = ((Long)cols.next()).intValue();
            if (maxrow < row) {
                maxrow = row;
            }
            if (maxcol >= col) continue;
            maxcol = col;
        }
        rows = ((List)pae_obj.get("residue1")).iterator();
        cols = ((List)pae_obj.get("residue2")).iterator();
        Iterator scores = ((List)pae_obj.get("distance")).iterator();
        float[][] elements = new float[maxcol][maxrow];
        while (scores.hasNext()) {
            float escore = ((Double)scores.next()).floatValue();
            int row = ((Long)rows.next()).intValue();
            int col = ((Long)cols.next()).intValue();
            if (maxrow < row) {
                maxrow = row;
            }
            if (maxcol < col) {
                maxcol = col;
            }
            elements[col - 1][row - 1] = escore;
        }
        this.mappedMatrix = new FloatContactMatrix(elements);
    }

    @Override
    public String getAnnotDescr() {
        return "Predicted Alignment Error" + (this.refSeq == null ? "" : " for " + this.refSeq.getName());
    }

    @Override
    public String getAnnotLabel() {
        StringBuilder label = new StringBuilder("PAE Matrix");
        return label.toString();
    }

    @Override
    public String getType() {
        return PAEMATRIX;
    }

    public static void validateContactMatrixFile(String fileName) throws FileFormatException, IOException {
        FileInputStream infile = null;
        try {
            infile = new FileInputStream(new File(fileName));
        }
        catch (Throwable t) {
            new IOException("Couldn't open " + fileName, t);
        }
        JSONObject paeDict = null;
        try {
            paeDict = EBIAlfaFold.parseJSONtoPAEContactMatrix(infile);
        }
        catch (Throwable t) {
            new FileFormatException("Couldn't parse " + fileName + " as a JSON dict or array containing a dict");
        }
        PAEContactMatrix matrix = new PAEContactMatrix((SequenceI)new SequenceDummy("Predicted"), paeDict);
        if (matrix.getWidth() <= 0) {
            throw new FileFormatException("No data in PAE matrix read from '" + fileName + "'");
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

