/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.gui.WebserviceInfo;
import jalview.ws.AWsJob;

public class JobStateSummary {
    int running = 0;
    int queuing = 0;
    int finished = 0;
    int error = 0;
    int serror = 0;
    int cancelled = 0;
    int results = 0;

    public void updateJobPanelState(WebserviceInfo wsInfo, String OutputHeader, AWsJob j) {
        if (j.cancelled) {
            ++this.cancelled;
            j.subjobComplete = true;
            wsInfo.setStatus(j.jobnum, 3);
            return;
        }
        if (j.submitted) {
            String stat;
            String progheader = "";
            if (j.isRunning()) {
                ++this.running;
                wsInfo.setStatus(j.jobnum, 1);
            } else if (j.isQueued()) {
                ++this.queuing;
                wsInfo.setStatus(j.jobnum, 0);
            } else if (j.isFinished()) {
                ++this.finished;
                j.subjobComplete = true;
                if (j.hasResults()) {
                    ++this.results;
                }
                wsInfo.setStatus(j.jobnum, 2);
            } else if (j.isFailed()) {
                progheader = progheader + "Job failed.\n";
                j.subjobComplete = true;
                wsInfo.setStatus(j.jobnum, 4);
                ++this.error;
            } else if (j.isServerError()) {
                ++this.serror;
                j.subjobComplete = true;
                wsInfo.setStatus(j.jobnum, 5);
            } else if (j.isBroken()) {
                progheader = progheader + "Job was broken.\n";
                ++this.error;
                j.subjobComplete = true;
                wsInfo.setStatus(j.jobnum, 4);
            }
            StringBuffer output = new StringBuffer();
            if (OutputHeader != null) {
                output.append(OutputHeader);
            }
            if (progheader != null) {
                output.append(progheader);
            }
            if (j.hasStatus() && (stat = j.getStatus()) != null) {
                output.append(stat);
            }
            wsInfo.setProgressText(j.jobnum, output.toString());
        } else if (j.submitted && j.subjobComplete) {
            if (j.allowedServerExceptions == 0) {
                ++this.serror;
            } else if (!j.hasResults()) {
                ++this.error;
            }
        }
    }
}

