/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.viewmodel.ViewportProperties;

public class ViewportRanges
extends ViewportProperties {
    public static final String STARTRES = "startres";
    public static final String ENDRES = "endres";
    public static final String STARTSEQ = "startseq";
    public static final String ENDSEQ = "endseq";
    public static final String STARTRESANDSEQ = "startresandseq";
    public static final String MOVE_VIEWPORT = "move_viewport";
    private boolean wrappedMode = false;
    private int startRes = 0;
    private int endRes;
    private int startSeq;
    private int endSeq;
    private AlignmentI al;

    public ViewportRanges(AlignmentI alignment) {
        this.endRes = alignment.getWidth() - 1;
        this.startSeq = 0;
        this.endSeq = alignment.getHeight() - 1;
        this.al = alignment;
    }

    public int getAbsoluteAlignmentWidth() {
        return this.al.getWidth();
    }

    public int getAbsoluteAlignmentHeight() {
        return this.al.getHeight() + this.al.getHiddenSequences().getSize();
    }

    public int getVisibleAlignmentWidth() {
        return this.al.getVisibleWidth();
    }

    public int getVisibleAlignmentHeight() {
        return this.al.getHeight();
    }

    public void setStartRes(int res) {
        int width = this.getViewportWidth();
        this.setStartEndRes(res, res + width - 1);
    }

    public void setStartEndRes(int start, int end) {
        int[] oldvalues = this.updateStartEndRes(start, end);
        int oldstartres = oldvalues[0];
        int oldendres = oldvalues[1];
        this.changeSupport.firePropertyChange(STARTRES, oldstartres, this.startRes);
        if (oldstartres == this.startRes) {
            this.changeSupport.firePropertyChange(ENDRES, oldendres, this.endRes);
        }
    }

    private int[] updateStartEndRes(int start, int end) {
        int oldstartres = this.startRes;
        int lastColumn = this.getVisibleAlignmentWidth() - 1;
        this.startRes = !this.wrappedMode && start > lastColumn ? Math.max(lastColumn, 0) : (start < 0 ? 0 : start);
        int oldendres = this.endRes;
        this.endRes = end < 0 ? 0 : (!this.wrappedMode && end > lastColumn ? Math.max(lastColumn, 0) : end);
        return new int[]{oldstartres, oldendres};
    }

    public void setStartSeq(int seq) {
        int startseq = seq;
        int height = this.getViewportHeight();
        if (startseq + height - 1 > this.getVisibleAlignmentHeight() - 1) {
            startseq = this.getVisibleAlignmentHeight() - height;
        }
        this.setStartEndSeq(startseq, startseq + height - 1);
    }

    public void setStartEndSeq(int start, int end) {
        int[] oldvalues = this.updateStartEndSeq(start, end);
        int oldstartseq = oldvalues[0];
        int oldendseq = oldvalues[1];
        this.changeSupport.firePropertyChange(STARTSEQ, oldstartseq, this.startSeq);
        if (oldstartseq == this.startSeq) {
            this.changeSupport.firePropertyChange(ENDSEQ, oldendseq, this.endSeq);
        }
    }

    private int[] updateStartEndSeq(int start, int end) {
        int oldstartseq = this.startSeq;
        int visibleHeight = this.getVisibleAlignmentHeight();
        this.startSeq = start > visibleHeight - 1 ? Math.max(visibleHeight - 1, 0) : (start < 0 ? 0 : start);
        int oldendseq = this.endSeq;
        this.endSeq = end >= visibleHeight ? Math.max(visibleHeight - 1, 0) : (end < 0 ? 0 : end);
        return new int[]{oldstartseq, oldendseq};
    }

    public void setEndSeq(int seq) {
        this.setStartEndSeq(Math.max(0, seq + 1 - this.getViewportHeight()), seq);
    }

    public void setStartResAndSeq(int res, int seq) {
        int width = this.getViewportWidth();
        int[] oldresvalues = this.updateStartEndRes(res, res + width - 1);
        int startseq = seq;
        int height = this.getViewportHeight();
        if (startseq + height - 1 > this.getVisibleAlignmentHeight() - 1) {
            startseq = this.getVisibleAlignmentHeight() - height;
        }
        int[] oldseqvalues = this.updateStartEndSeq(startseq, startseq + height - 1);
        int[] old = new int[]{oldresvalues[0], oldseqvalues[0]};
        int[] newresseq = new int[]{this.startRes, this.startSeq};
        this.changeSupport.firePropertyChange(STARTRESANDSEQ, old, newresseq);
    }

    public int getStartRes() {
        return this.startRes;
    }

    public int getEndRes() {
        return this.endRes;
    }

    public int getStartSeq() {
        return this.startSeq;
    }

    public int getEndSeq() {
        return this.endSeq;
    }

    public void setViewportWidth(int w) {
        this.setStartEndRes(this.startRes, this.startRes + w - 1);
    }

    public void setViewportHeight(int h) {
        this.setStartEndSeq(this.startSeq, this.startSeq + h - 1);
    }

    public void setViewportStartAndWidth(int start, int w) {
        int vpstart = start;
        if (vpstart < 0) {
            vpstart = 0;
        }
        if (!this.wrappedMode && w <= this.getVisibleAlignmentWidth() && vpstart + w - 1 > this.getVisibleAlignmentWidth() - 1) {
            vpstart = this.getVisibleAlignmentWidth() - w;
        }
        this.setStartEndRes(vpstart, vpstart + w - 1);
    }

    public void setViewportStartAndHeight(int start, int h) {
        int vpstart = start;
        int visHeight = this.getVisibleAlignmentHeight();
        if (vpstart < 0) {
            vpstart = 0;
        } else if (h <= visHeight && vpstart + h > visHeight) {
            vpstart = visHeight - h;
        }
        this.setStartEndSeq(vpstart, vpstart + h - 1);
    }

    public int getViewportWidth() {
        return this.endRes - this.startRes + 1;
    }

    public int getViewportHeight() {
        return this.endSeq - this.startSeq + 1;
    }

    public boolean scrollUp(boolean up) {
        if (up) {
            if (this.wrappedMode) {
                this.pageUp();
            } else {
                if (this.startSeq < 1) {
                    return false;
                }
                this.setStartSeq(this.startSeq - 1);
            }
        } else if (this.wrappedMode) {
            this.pageDown();
        } else {
            if (this.endSeq >= this.getVisibleAlignmentHeight() - 1) {
                return false;
            }
            this.setStartSeq(this.startSeq + 1);
        }
        return true;
    }

    public boolean scrollRight(boolean right) {
        if (!right) {
            if (this.startRes < 1) {
                return false;
            }
            this.setStartRes(this.startRes - 1);
        } else {
            if (this.endRes >= this.getVisibleAlignmentWidth() - 1) {
                return false;
            }
            this.setStartRes(this.startRes + 1);
        }
        return true;
    }

    public boolean scrollToWrappedVisible(int res) {
        int newStartRes = this.calcWrappedStartResidue(res);
        if (newStartRes == this.startRes) {
            return false;
        }
        this.setStartRes(newStartRes);
        return true;
    }

    private int calcWrappedStartResidue(int res) {
        int newStartRes;
        int oldStartRes = this.startRes;
        int width = this.getViewportWidth();
        boolean up = res < oldStartRes;
        int widthsToScroll = Math.abs((res - oldStartRes) / width);
        if (up) {
            ++widthsToScroll;
        }
        int residuesToScroll = width * widthsToScroll;
        int n = newStartRes = up ? oldStartRes - residuesToScroll : oldStartRes + residuesToScroll;
        if (newStartRes < 0) {
            newStartRes = 0;
        }
        return newStartRes;
    }

    public void scrollToVisible(int x, int y) {
        while (y < this.startSeq) {
            this.scrollUp(true);
        }
        while (y > this.endSeq) {
            this.scrollUp(false);
        }
        HiddenColumns hidden = this.al.getHiddenColumns();
        while (x < hidden.visibleToAbsoluteColumn(this.startRes) && this.scrollRight(false)) {
        }
        while (x > hidden.visibleToAbsoluteColumn(this.endRes) && this.scrollRight(true)) {
        }
    }

    public boolean setViewportLocation(int x, int y) {
        boolean changedLocation = false;
        int visX = this.al.getHiddenColumns().absoluteToVisibleColumn(x);
        int visY = this.al.getHiddenSequences().findIndexWithoutHiddenSeqs(y);
        if (this.startRes > visX || visX > this.endRes || this.startSeq > visY && visY > this.endSeq) {
            int[] newresseq;
            int[] old = new int[]{this.startRes, this.startSeq};
            if (this.wrappedMode) {
                int newstartres = this.calcWrappedStartResidue(visX);
                this.setStartRes(newstartres);
                newresseq = new int[]{this.startRes, this.startSeq};
            } else {
                int newstartres = visX;
                int width = this.getViewportWidth();
                if (newstartres + width - 1 > this.getVisibleAlignmentWidth() - 1) {
                    newstartres = this.getVisibleAlignmentWidth() - width;
                }
                this.updateStartEndRes(newstartres, newstartres + width - 1);
                int newstartseq = visY;
                int height = this.getViewportHeight();
                if (newstartseq + height - 1 > this.getVisibleAlignmentHeight() - 1) {
                    newstartseq = this.getVisibleAlignmentHeight() - height;
                }
                this.updateStartEndSeq(newstartseq, newstartseq + height - 1);
                newresseq = new int[]{this.startRes, this.startSeq};
            }
            changedLocation = true;
            this.changeSupport.firePropertyChange(MOVE_VIEWPORT, old, newresseq);
        }
        return changedLocation;
    }

    public void pageUp() {
        if (this.wrappedMode) {
            this.setStartRes(Math.max(0, this.getStartRes() - this.getViewportWidth()));
        } else {
            this.setViewportStartAndHeight(this.startSeq - (this.endSeq - this.startSeq), this.getViewportHeight());
        }
    }

    public void pageDown() {
        if (this.wrappedMode) {
            int newStart = this.getStartRes() + Math.max(this.getViewportHeight(), this.getViewportWidth());
            if (newStart < this.getVisibleAlignmentWidth()) {
                this.setStartRes(newStart);
            }
        } else {
            this.setViewportStartAndHeight(this.endSeq, this.getViewportHeight());
        }
    }

    public void setWrappedMode(boolean wrapped) {
        this.wrappedMode = wrapped;
    }

    public boolean isWrappedMode() {
        return this.wrappedMode;
    }

    public int getWrappedScrollPosition(int topLeftColumn) {
        int w = this.getViewportWidth();
        int scroll = topLeftColumn / w;
        return scroll += topLeftColumn % w > 0 ? 1 : 0;
    }

    public int getWrappedMaxScroll(int topLeftColumn) {
        int scrollPosition = this.getWrappedScrollPosition(topLeftColumn);
        int columnsRemaining = this.getVisibleAlignmentWidth() - topLeftColumn;
        int width = this.getViewportWidth();
        int widthsRemaining = columnsRemaining / width + (columnsRemaining % width > 0 ? 1 : 0) - 1;
        int maxScroll = scrollPosition + widthsRemaining;
        return maxScroll;
    }
}

