/*
 * Decompiled with CFR 0.152.
 */
package jalview.util.matcher;

import jalview.util.MessageManager;

public enum Condition {
    Contains(false, true, "Contains"),
    NotContains(false, true, "NotContains"),
    Matches(false, true, "Matches"),
    NotMatches(false, true, "NotMatches"),
    Present(false, false, "Present"),
    NotPresent(false, false, "NotPresent"),
    EQ(true, true, "EQ"),
    NE(true, true, "NE"),
    LT(true, true, "LT"),
    LE(true, true, "LE"),
    GT(true, true, "GT"),
    GE(true, true, "GE");

    private boolean numeric;
    private boolean needsAPattern;
    private String stableName;

    public static Condition fromString(String stableName) {
        for (Condition c : Condition.values()) {
            if (!c.stableName.equalsIgnoreCase(stableName)) continue;
            return c;
        }
        return null;
    }

    private Condition(boolean isNumeric, boolean needsPattern, String stablename) {
        this.numeric = isNumeric;
        this.needsAPattern = needsPattern;
        this.stableName = stablename;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean needsAPattern() {
        return this.needsAPattern;
    }

    public String getStableName() {
        return this.stableName;
    }

    public String toString() {
        return MessageManager.getStringOrReturn("label.matchCondition_", this.name());
    }
}

