/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.awt.Color;
import java.io.PrintStream;
import java.util.Arrays;

public class Format {
    private int width;
    private int precision;
    private String pre;
    private String post;
    private boolean leading_zeroes;
    private boolean show_plus;
    private boolean alternate;
    private boolean show_space;
    private boolean left_align;
    private char fmt;
    private final String formatString;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String s) {
        this.formatString = s;
        this.width = 0;
        this.precision = -1;
        this.pre = "";
        this.post = "";
        this.leading_zeroes = false;
        this.show_plus = false;
        this.alternate = false;
        this.show_space = false;
        this.left_align = false;
        this.fmt = (char)32;
        int length = s.length();
        int parse_state = 0;
        int i = 0;
        while (parse_state == 0) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == '%') {
                if (i >= length - 1) throw new IllegalArgumentException();
                if (s.charAt(i + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++i;
                } else {
                    parse_state = 1;
                }
            } else {
                this.pre = this.pre + s.charAt(i);
            }
            ++i;
        }
        while (parse_state == 1) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == ' ') {
                this.show_space = true;
            } else if (s.charAt(i) == '-') {
                this.left_align = true;
            } else if (s.charAt(i) == '+') {
                this.show_plus = true;
            } else if (s.charAt(i) == '0') {
                this.leading_zeroes = true;
            } else if (s.charAt(i) == '#') {
                this.alternate = true;
            } else {
                parse_state = 2;
                --i;
            }
            ++i;
        }
        while (parse_state == 2) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parse_state = 3;
                this.precision = 0;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        while (parse_state == 3) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        if (parse_state == 4) {
            if (i >= length) {
                parse_state = 5;
            } else {
                this.fmt = s.charAt(i);
            }
            ++i;
        }
        if (i >= length) return;
        this.post = s.substring(i, length);
    }

    public static String getHexString(Color color) {
        String b;
        String g;
        String r = Integer.toHexString(color.getRed());
        if (r.length() < 2) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(color.getGreen())).length() < 2) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(color.getBlue())).length() < 2) {
            b = "0" + b;
        }
        return r + g + b;
    }

    public static void print(PrintStream s, String fmt, double x) {
        s.print(new Format(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, long x) {
        s.print(new Format(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, char x) {
        s.print(new Format(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, String x) {
        s.print(new Format(fmt).form(x));
    }

    public static int atoi(String s) {
        return (int)Format.atol(s);
    }

    public static long atol(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '0') {
            if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                return Format.parseLong(s.substring(i + 2), 16);
            }
            return Format.parseLong(s, 8);
        }
        return Format.parseLong(s, 10);
    }

    private static long parseLong(String s, int base) {
        int i;
        int sign = 1;
        long r = 0L;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch < 48 + base) {
                r = r * (long)base + (long)ch - 48L;
            } else if ('A' <= ch && ch < 65 + base - 10) {
                r = r * (long)base + (long)ch - 65L + 10L;
            } else if ('a' <= ch && ch < 97 + base - 10) {
                r = r * (long)base + (long)ch - 97L + 10L;
            } else {
                return r * (long)sign;
            }
            ++i;
        }
        return r * (long)sign;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String s) {
        int i;
        int sign = 1;
        double r = 0.0;
        double p = 1.0;
        boolean state = false;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * 10.0 + (double)ch - 48.0;
                } else if (state) {
                    r += (p /= 10.0) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E') return (double)sign * r;
                long e = (int)Format.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        return (double)sign * r;
    }

    public String form(double x) {
        String r;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        if (this.fmt == 'f') {
            r = this.fixed_format(x);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.exp_format(x);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(long x) {
        String r;
        int s = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (x < 0L) {
                r = ("" + x).substring(1);
                s = -1;
            } else {
                r = "" + x;
                s = 1;
            }
        } else if (this.fmt == 'o') {
            r = Format.convert(x, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            r = Format.convert(x, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            r = Format.convert(x, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String r = "" + c;
        return this.pad(r);
    }

    public String form(String s) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] chars = new char[n];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    private static String convert(long x, int n, int m, String d) {
        if (x == 0L) {
            return "0";
        }
        String r = "";
        while (x != 0L) {
            r = d.charAt((int)(x & (long)m)) + r;
            x >>>= n;
        }
        return r;
    }

    private String pad(String r) {
        String p = Format.repeat(' ', this.width - r.length());
        if (this.left_align) {
            return this.pre + r + p + this.post;
        }
        return this.pre + p + r + this.post;
    }

    private String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.show_plus) {
                p = "+";
            } else if (this.show_space) {
                p = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && r.length() > 0 && r.charAt(0) != '0') {
            p = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            p = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            p = "0X";
        }
        int w = 0;
        if (this.leading_zeroes) {
            w = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        return p + Format.repeat('0', w - p.length() - r.length()) + r;
    }

    private String fixed_format(double d) {
        boolean removeTrailing;
        boolean bl = removeTrailing = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        if (this.precision == 0) {
            return (long)(d + 0.5) + (removeTrailing ? "" : ".");
        }
        long whole = (long)d;
        double fr = d - (double)whole;
        if (fr >= 1.0 || fr < 0.0) {
            return this.exp_format(d);
        }
        double factor = 1.0;
        String leading_zeroes = "";
        for (int i = 1; i <= this.precision && factor <= 9.223372036854776E18; factor *= 10.0, ++i) {
            leading_zeroes = leading_zeroes + "0";
        }
        long l = (long)(factor * fr + 0.5);
        if ((double)l >= factor) {
            l = 0L;
            ++whole;
        }
        String z = leading_zeroes + l;
        z = "." + z.substring(z.length() - this.precision, z.length());
        if (removeTrailing) {
            int t;
            for (t = z.length() - 1; t >= 0 && z.charAt(t) == '0'; --t) {
            }
            if (t >= 0 && z.charAt(t) == '.') {
                --t;
            }
            z = z.substring(0, t + 1);
        }
        return whole + z;
    }

    private String exp_format(double d) {
        double dd;
        String f = "";
        int e = 0;
        if (d != 0.0) {
            for (dd = d; dd > 10.0; dd /= 10.0) {
                ++e;
            }
            while (dd < 1.0) {
                --e;
                dd *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixed_format(d);
        }
        f = f + this.fixed_format(dd);
        f = this.fmt == 'e' || this.fmt == 'g' ? f + "e" : f + "E";
        String p = "000";
        if (e >= 0) {
            f = f + "+";
            p = p + e;
        } else {
            f = f + "-";
            p = p + -e;
        }
        return f + p.substring(p.length() - 3, p.length());
    }

    public String toString() {
        return this.formatString;
    }

    public static void appendPercentage(StringBuilder sb, float value, int dp) {
        double d = value;
        long factor = 1L;
        for (int i = 0; i < dp; ++i) {
            factor *= 10L;
        }
        d *= (double)factor;
        value = (float)((d += 0.5) / (double)factor);
        sb.append((long)value);
        if (dp > 0) {
            sb.append(".");
            while (dp > 0) {
                value -= (float)((int)value);
                sb.append((int)(value *= 10.0f));
                --dp;
            }
        }
    }
}

