/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.bin.Console;
import jalview.urls.IdOrgSettings;
import jalview.urls.UrlLinkDisplay;
import jalview.urls.UrlProviderImpl;
import jalview.util.JSONUtils;
import jalview.util.UrlLink;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.json.simple.parser.ParseException;

public class IdentifiersUrlProvider
extends UrlProviderImpl {
    private static final String LOCAL_KEY = "Local";
    private static final String ID_ORG_KEY = "identifiers.org";
    private HashMap<String, UrlLink> urls = this.readIdentifiers(IdOrgSettings.getDownloadLocation());
    private ArrayList<String> selectedUrls = new ArrayList();

    public IdentifiersUrlProvider(String cachedUrlList) {
        this.checkSelectionMatchesUrls(cachedUrlList);
    }

    private HashMap<String, UrlLink> readIdentifiers(String idFileName) {
        HashMap<String, UrlLink> idData = new HashMap<String, UrlLink>();
        String errorMessage = null;
        try {
            FileReader reader = new FileReader(idFileName);
            String key = "";
            Map obj = (Map)JSONUtils.parse(reader);
            if (obj.containsKey(ID_ORG_KEY)) {
                key = ID_ORG_KEY;
            } else if (obj.containsKey(LOCAL_KEY)) {
                key = LOCAL_KEY;
            } else {
                Console.outPrintln("Unexpected key returned from identifiers jalview service");
                return idData;
            }
            List jsonarray = (List)obj.get(key);
            for (int i = 0; i < jsonarray.size(); ++i) {
                Map item = (Map)jsonarray.get(i);
                String url = (String)item.get("url") + "/" + "$" + "DB_ACCESSION" + "$";
                UrlLink link = new UrlLink((String)item.get("name"), url, (String)item.get("prefix"));
                idData.put((String)item.get("id"), link);
            }
        }
        catch (IOException | ParseException e) {
            errorMessage = e.toString();
            idData.clear();
        }
        if (errorMessage != null) {
            Console.errPrintln("IdentifiersUrlProvider: cannot read " + idFileName + ": " + errorMessage);
        }
        return idData;
    }

    private void checkSelectionMatchesUrls(String cachedUrlList) {
        StringTokenizer st = new StringTokenizer(cachedUrlList, "|");
        while (st.hasMoreElements()) {
            String id = st.nextToken();
            if (!this.isMiriamId(id) || !this.urls.containsKey(id)) continue;
            this.selectedUrls.add(id);
        }
        this.setPrimaryUrl(this.primaryUrl);
    }

    @Override
    public boolean setPrimaryUrl(String id) {
        this.primaryUrl = this.urls.containsKey(id) ? id : null;
        return this.urls.containsKey(id);
    }

    @Override
    public String writeUrlsAsString(boolean selected) {
        if (!selected) {
            return "";
        }
        StringBuffer links = new StringBuffer();
        if (!this.selectedUrls.isEmpty()) {
            for (String k : this.selectedUrls) {
                links.append(k);
                links.append("|");
            }
            links.setLength(links.length() - 1);
        }
        return links.toString();
    }

    @Override
    public List<String> getLinksForMenu() {
        ArrayList<String> links = new ArrayList<String>();
        for (String key : this.selectedUrls) {
            links.add(this.urls.get(key).toStringWithTarget());
        }
        return links;
    }

    @Override
    public List<UrlLinkDisplay> getLinksForTable() {
        return super.getLinksForTable(this.urls, this.selectedUrls, false);
    }

    @Override
    public void setUrlData(List<UrlLinkDisplay> links) {
        this.selectedUrls = new ArrayList();
        for (UrlLinkDisplay link : links) {
            if (!this.isMiriamId(link.getId()) || !this.urls.containsKey(link.getId())) continue;
            if (link.getIsSelected()) {
                this.selectedUrls.add(link.getId());
            }
            if (!link.getIsPrimary()) continue;
            this.setPrimaryUrl(link.getId());
        }
    }

    @Override
    public String getPrimaryUrl(String seqid) {
        return super.getPrimaryUrl(seqid, this.urls);
    }

    @Override
    public String getPrimaryUrlId() {
        return this.primaryUrl;
    }

    @Override
    public String getPrimaryTarget(String seqid) {
        return null;
    }

    @Override
    public String choosePrimaryUrl() {
        return null;
    }

    @Override
    public boolean contains(String id) {
        return this.urls.containsKey(id);
    }
}

