/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.urls.UrlLinkDisplay;
import jalview.urls.UrlProviderImpl;
import jalview.util.MessageManager;
import jalview.util.UrlLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CustomUrlProvider
extends UrlProviderImpl {
    private static final String SRS_LABEL = "SRS";
    private HashMap<String, UrlLink> selectedUrls;
    private HashMap<String, UrlLink> nonselectedUrls;

    public CustomUrlProvider(String inMenuUrlList, String storedUrlList) {
        try {
            this.selectedUrls = this.parseUrlStrings(inMenuUrlList);
            this.nonselectedUrls = this.parseUrlStrings(storedUrlList);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage() + "\nError parsing sequence links");
        }
    }

    public CustomUrlProvider(Map<String, String> inMenuUrlList, Map<String, String> storedUrlList) {
        try {
            this.selectedUrls = this.parseUrlList(inMenuUrlList);
            this.nonselectedUrls = this.parseUrlList(storedUrlList);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage() + "\nError parsing sequence links");
        }
    }

    private HashMap<String, UrlLink> parseUrlStrings(String urlStrings) {
        HashMap<String, UrlLink> urls = new HashMap<String, UrlLink>();
        StringTokenizer st = new StringTokenizer(urlStrings, "|");
        while (st.hasMoreElements()) {
            String name = st.nextToken().trim();
            if (this.isMiriamId(name)) continue;
            String url = st.nextToken();
            int rxstart = url.indexOf("$DB_ACCESSION$");
            if (rxstart == -1) {
                rxstart = url.indexOf("$SEQUENCE_ID$");
            }
            while (rxstart == -1 && url.indexOf("/=$") == -1 && st.hasMoreTokens()) {
                url = url + "|" + st.nextToken();
            }
            url = url.trim();
            urls.put(name, new UrlLink(name, url, name));
        }
        this.upgradeOldLinks(urls);
        return urls;
    }

    private HashMap<String, UrlLink> parseUrlList(Map<String, String> urlList) {
        HashMap<String, UrlLink> urls = new HashMap<String, UrlLink>();
        if (urlList == null) {
            return urls;
        }
        for (Map.Entry<String, String> pair : urlList.entrySet()) {
            urls.put(pair.getKey(), new UrlLink(pair.getKey(), pair.getValue(), pair.getKey()));
        }
        this.upgradeOldLinks(urls);
        return urls;
    }

    private void upgradeOldLinks(HashMap<String, UrlLink> urls) {
        boolean upgrade = false;
        if (urls.containsKey(SRS_LABEL)) {
            urls.remove(SRS_LABEL);
            upgrade = true;
        }
        if (urls.containsKey("EMBL-EBI Search")) {
            urls.remove("EMBL-EBI Search");
            upgrade = true;
        }
        if (upgrade) {
            UrlLink link = new UrlLink("EMBL-EBI Search|https://www.ebi.ac.uk/ebisearch/search.ebi?db=allebi&query=$SEQUENCE_ID$");
            link.setLabel("EMBL-EBI Search");
            urls.put("EMBL-EBI Search", link);
        }
    }

    @Override
    public List<String> getLinksForMenu() {
        ArrayList<String> links = new ArrayList<String>();
        for (Map.Entry<String, UrlLink> pair : this.selectedUrls.entrySet()) {
            links.add(pair.getValue().toString());
        }
        return links;
    }

    @Override
    public List<UrlLinkDisplay> getLinksForTable() {
        ArrayList<Object> displayLinks = new ArrayList();
        displayLinks = this.getLinksForTable(this.selectedUrls, true);
        displayLinks.addAll(this.getLinksForTable(this.nonselectedUrls, false));
        return displayLinks;
    }

    private ArrayList<UrlLinkDisplay> getLinksForTable(HashMap<String, UrlLink> urlList, boolean selected) {
        return super.getLinksForTable(urlList, null, selected);
    }

    @Override
    public boolean setPrimaryUrl(String id) {
        this.primaryUrl = this.selectedUrls.containsKey(id) ? id : (this.nonselectedUrls.containsKey(id) ? id : null);
        return this.primaryUrl != null;
    }

    @Override
    public String writeUrlsAsString(boolean selected) {
        StringBuffer links = new StringBuffer();
        HashMap<String, UrlLink> urls = selected ? this.selectedUrls : this.nonselectedUrls;
        if (urls.size() > 0) {
            for (Map.Entry<String, UrlLink> entry : urls.entrySet()) {
                links.append(entry.getValue().toString());
                links.append("|");
            }
            links.setLength(links.length() - 1);
        } else {
            urls.clear();
        }
        return links.toString();
    }

    @Override
    public String getPrimaryUrl(String seqid) {
        String result = super.getPrimaryUrl(seqid, this.selectedUrls);
        if (result == null) {
            result = super.getPrimaryUrl(seqid, this.nonselectedUrls);
        }
        return result;
    }

    @Override
    public String getPrimaryUrlId() {
        return this.primaryUrl;
    }

    @Override
    public String getPrimaryTarget(String seqid) {
        return this.selectedUrls.get(this.primaryUrl).getTarget();
    }

    @Override
    public void setUrlData(List<UrlLinkDisplay> links) {
        HashMap<String, UrlLink> unselurls = new HashMap<String, UrlLink>();
        HashMap<String, UrlLink> selurls = new HashMap<String, UrlLink>();
        for (UrlLinkDisplay link : links) {
            if (this.isMiriamId(link.getId())) continue;
            if (unselurls.containsKey(link.getId()) || selurls.containsKey(link.getId())) {
                throw new IllegalArgumentException(MessageManager.formatMessage("exception.url_cannot_have_duplicate_id", link.getId()));
            }
            if (link.getIsSelected()) {
                selurls.put(link.getId(), new UrlLink(link.getDescription(), link.getUrl(), link.getDescription()));
            } else {
                unselurls.put(link.getId(), new UrlLink(link.getDescription(), link.getUrl(), link.getDescription()));
            }
            if (!link.getIsPrimary()) continue;
            this.setPrimaryUrl(link.getId());
        }
        this.nonselectedUrls = unselurls;
        this.selectedUrls = selurls;
    }

    @Override
    public String choosePrimaryUrl() {
        if (!this.nonselectedUrls.containsKey("EMBL-EBI Search") && !this.selectedUrls.containsKey("EMBL-EBI Search")) {
            UrlLink link = new UrlLink("EMBL-EBI Search|https://www.ebi.ac.uk/ebisearch/search.ebi?db=allebi&query=$SEQUENCE_ID$");
            link.setLabel("EMBL-EBI Search");
            this.selectedUrls.put("EMBL-EBI Search", link);
        }
        this.primaryUrl = "EMBL-EBI Search";
        return "EMBL-EBI Search";
    }

    @Override
    public boolean contains(String id) {
        return this.selectedUrls.containsKey(id) || this.nonselectedUrls.containsKey(id);
    }
}

