/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.analysis.Conservation;
import jalview.api.ViewStyleI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.ProfileI;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.ColourSchemeI;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.Map;

public class ResidueShader
implements ResidueShaderI {
    private static final int INITIAL_CONSERVATION = 30;
    private ColourSchemeI colourScheme;
    private ProfilesI consensus;
    private ProfilesI ssConsensus;
    private boolean conservationColouring;
    private char[] conservation;
    private int pidThreshold;
    private boolean ignoreGaps;
    private int conservationIncrement = 30;

    public ProfilesI getSsConsensus() {
        return this.ssConsensus;
    }

    @Override
    public void setSsConsensus(ProfilesI ssConsensus) {
        this.ssConsensus = ssConsensus;
    }

    public ResidueShader(ColourSchemeI cs) {
        this.colourScheme = cs;
    }

    public ResidueShader() {
    }

    public ResidueShader(ViewStyleI viewStyle) {
        this();
        this.setConservationApplied(viewStyle.isConservationColourSelected());
    }

    public ResidueShader(ResidueShader rs) {
        this.colourScheme = rs.colourScheme;
        this.consensus = rs.consensus;
        this.conservation = rs.conservation;
        this.conservationColouring = rs.conservationColouring;
        this.conservationIncrement = rs.conservationIncrement;
        this.ignoreGaps = rs.ignoreGaps;
        this.pidThreshold = rs.pidThreshold;
        this.ssConsensus = rs.ssConsensus;
    }

    @Override
    public void setConsensus(ProfilesI cons) {
        this.consensus = cons;
    }

    @Override
    public boolean conservationApplied() {
        return this.conservationColouring;
    }

    @Override
    public void setConservationApplied(boolean conservationApplied) {
        this.conservationColouring = conservationApplied;
    }

    @Override
    public void setConservation(Conservation cons) {
        if (cons == null) {
            this.conservationColouring = false;
            this.conservation = null;
        } else {
            this.conservationColouring = true;
            this.conservation = cons.getConsSequence().getSequenceAsString().toCharArray();
        }
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        if (this.colourScheme != null) {
            this.colourScheme.alignmentChanged(alignment, hiddenReps);
        }
    }

    @Override
    public void setThreshold(int consensusThreshold, boolean ignoreGaps) {
        this.pidThreshold = consensusThreshold;
        this.ignoreGaps = ignoreGaps;
    }

    @Override
    public void setConservationInc(int i) {
        this.conservationIncrement = i;
    }

    @Override
    public int getConservationInc() {
        return this.conservationIncrement;
    }

    @Override
    public int getThreshold() {
        return this.pidThreshold;
    }

    @Override
    public Color findColour(char symbol, int position, SequenceI seq) {
        if (this.colourScheme == null) {
            return Color.white;
        }
        ProfileI profile = this.consensus == null ? null : this.consensus.get(position);
        String modalResidue = profile == null ? null : profile.getModalResidue();
        float pid = profile == null ? 0.0f : profile.getPercentageIdentity(this.ignoreGaps);
        Color colour = this.colourScheme.findColour(symbol, position, seq, modalResidue, pid);
        if (!Comparison.isGap(symbol)) {
            colour = this.adjustColour(symbol, position, colour);
        }
        return colour;
    }

    @Override
    public Color findSSColour(char symbol, int position, SequenceI seq) {
        if (this.colourScheme == null) {
            return Color.white;
        }
        ProfileI profile = this.ssConsensus == null ? null : this.ssConsensus.get(position);
        String modalSS = profile == null ? null : profile.getModalSS();
        float pid = profile == null ? 0.0f : profile.getSSPercentageIdentity(this.ignoreGaps);
        Color colour = this.colourScheme.findColour(symbol, position, seq, modalSS, pid);
        if (!Comparison.isGap(symbol)) {
            colour = this.adjustColour(symbol, position, colour);
        }
        return colour;
    }

    protected Color adjustColour(char symbol, int column, Color colour) {
        if (!this.aboveThreshold(symbol, column)) {
            colour = Color.white;
        }
        if (this.conservationColouring) {
            colour = this.applyConservation(colour, column);
        }
        return colour;
    }

    protected boolean aboveThreshold(char residue, int column) {
        if (this.pidThreshold == 0) {
            return true;
        }
        if ('a' <= residue && residue <= 'z') {
            residue = (char)(residue - 32);
        }
        if (this.consensus == null) {
            return false;
        }
        ProfileI profile = this.consensus.get(column);
        return profile != null && profile.getModalResidue().contains(String.valueOf(residue)) && profile.getPercentageIdentity(this.ignoreGaps) >= (float)this.pidThreshold;
    }

    protected Color applyConservation(Color currentColour, int column) {
        if (this.conservation == null || this.conservation.length <= column) {
            return currentColour;
        }
        char conservationScore = this.conservation[column];
        if (conservationScore == '*' || conservationScore == '+' || conservationScore == '\n' || conservationScore == '\u000b') {
            return currentColour;
        }
        if (Comparison.isGap(conservationScore)) {
            return Color.white;
        }
        float bleachFactor = (float)(11 - (conservationScore - 48)) / 10.0f;
        return ColorUtils.bleachColour(currentColour, bleachFactor *= (float)this.conservationIncrement / 20.0f);
    }

    @Override
    public ColourSchemeI getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void setColourScheme(ColourSchemeI cs) {
        this.colourScheme = cs;
    }
}

