/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueColourFinder;
import jalview.renderer.ResidueShaderI;
import jalview.util.Comparison;
import java.awt.Color;

public class OverviewResColourFinder
extends ResidueColourFinder {
    Color gapColour;
    Color residueColour;
    Color hiddenColour;

    @Deprecated
    public OverviewResColourFinder() {
        this(Color.lightGray, Color.white, Color.darkGray.darker());
    }

    public OverviewResColourFinder(Color gaps, Color residues, Color hidden) {
        this.gapColour = gaps;
        this.residueColour = residues;
        this.hiddenColour = hidden;
    }

    @Override
    public Color getBoxColour(ResidueShaderI shader, SequenceI seq, int i) {
        Color resBoxColour = this.residueColour;
        char currentChar = seq.getCharAt(i);
        if (shader.getColourScheme() != null) {
            resBoxColour = Comparison.isGap(currentChar) && !shader.getColourScheme().hasGapColour() ? this.gapColour : shader.findColour(currentChar, i, seq);
        } else if (Comparison.isGap(currentChar)) {
            resBoxColour = this.gapColour;
        }
        return resBoxColour;
    }

    @Override
    protected Color getResidueBoxColour(boolean showBoxes, ResidueShaderI shader, SequenceGroup[] allGroups, SequenceI seq, int i) {
        SequenceGroup currentSequenceGroup = this.getCurrentSequenceGroup(allGroups, i);
        ResidueShaderI currentShader = currentSequenceGroup != null ? currentSequenceGroup.getGroupColourScheme() : shader;
        return this.getBoxColour(currentShader, seq, i);
    }

    public Color getHiddenColour() {
        return this.hiddenColour;
    }

    public Color getGapColour() {
        return this.gapColour;
    }

    public Color getResidueColour() {
        return this.residueColour;
    }
}

