/*
 * Decompiled with CFR 0.152.
 */
package jalview.json.binding.biojson.v1;

import com.github.reinert.jjschema.Attributes;
import java.util.Map;
import java.util.Vector;

public class SequenceFeaturesPojo {
    @Attributes(required=true, description="Start residue position for the sequence feature")
    private int xStart;
    @Attributes(required=true, description="End residue position for the sequence feature")
    private int xEnd;
    @Attributes(required=true, minItems=1, maxItems=0x7FFFFFFFL, description="Reference to the sequence in the alignment<br> (more like a foreign key)")
    private String sequenceRef;
    @Attributes(required=true, description="The name or type of the SequenceFeature")
    private String type;
    @Attributes(required=false, description="Score")
    private Float score;
    @Attributes(required=false, description="Description for the feature")
    private String description;
    @Attributes(required=false, description="Additional metadata for the feature")
    private Map<String, Object> otherDetails;
    @Attributes(required=false, description="Fill colour")
    private String fillColor;
    @Attributes(required=true, description="Feature group")
    private String featureGroup;
    @Attributes(required=false, description="URL links associated to the feature")
    private Vector<String> links;

    public SequenceFeaturesPojo() {
    }

    public SequenceFeaturesPojo(String sequenceRef) {
        this.sequenceRef = sequenceRef;
    }

    public String getFillColor() {
        return "#" + this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    public int getXstart() {
        return this.xStart;
    }

    public void setXstart(int xStart) {
        this.xStart = xStart;
    }

    public int getXend() {
        return this.xEnd;
    }

    public void setXend(int xend) {
        this.xEnd = xend;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getOtherDetails() {
        return this.otherDetails;
    }

    public void setOtherDetails(Map<String, Object> otherDetails) {
        this.otherDetails = otherDetails;
    }

    public Vector<String> getLinks() {
        return this.links;
    }

    public void setLinks(Vector<String> links) {
        this.links = links;
    }

    public String getFeatureGroup() {
        return this.featureGroup;
    }

    public void setFeatureGroup(String featureGroup) {
        this.featureGroup = featureGroup;
    }

    public String getSequenceRef() {
        return this.sequenceRef;
    }

    public void setSequenceRef(String sequenceRef) {
        this.sequenceRef = sequenceRef;
    }
}

