/*
 * Decompiled with CFR 0.152.
 */
package jalview.json.binding.biojs;

import jalview.json.binding.biojs.BioJSReleasePojo;
import jalview.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.simple.parser.ParseException;

public class BioJSRepositoryPojo {
    private String description;
    private String latestReleaseVersion;
    private Collection<BioJSReleasePojo> releases = new ArrayList<BioJSReleasePojo>();

    public BioJSRepositoryPojo() {
    }

    public BioJSRepositoryPojo(String jsonString) {
        try {
            this.parse(jsonString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void parse(String jsonString) throws ParseException {
        Objects.requireNonNull(jsonString, "Supplied jsonString must not be null");
        Map JsonObj = (Map)JSONUtils.parse(jsonString);
        this.description = (String)JsonObj.get("description");
        this.latestReleaseVersion = (String)JsonObj.get("latestReleaseVersion");
        List repositoriesJsonArray = (List)JsonObj.get("releases");
        for (Map repoObj : repositoriesJsonArray) {
            BioJSReleasePojo repo = new BioJSReleasePojo();
            repo.setType((String)repoObj.get("type"));
            repo.setUrl((String)repoObj.get("url"));
            repo.setVersion((String)repoObj.get("version"));
            this.getReleases().add(repo);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLatestReleaseVersion() {
        return this.latestReleaseVersion;
    }

    public void setLatestReleaseVersion(String latestReleaseVersion) {
        this.latestReleaseVersion = latestReleaseVersion;
    }

    public Collection<BioJSReleasePojo> getReleases() {
        return this.releases;
    }

    public void setReleases(Collection<BioJSReleasePojo> releases) {
        this.releases = releases;
    }
}

