/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.MemorySetting;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.service.pdb.PDBFTSRestClient;
import jalview.gui.Desktop;
import jalview.gui.JalviewBooleanRadioButtons;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.StructureViewer;
import jalview.io.BackupFilenameParts;
import jalview.io.BackupFilesPresetEntry;
import jalview.io.IntKeyStringValueEntry;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class GPreferences
extends JPanel {
    private static final Font LABEL_FONT = JvSwingUtils.getLabelFont();
    private static final Font LABEL_FONT_ITALIC = JvSwingUtils.getLabelFont(false, true);
    private static final Font LABEL_FONT_BOLD = JvSwingUtils.getLabelFont(true, false);
    protected JCheckBox fullScreen = new JCheckBox();
    protected JCheckBox openoverv = new JCheckBox();
    protected JCheckBox seqLimit = new JCheckBox();
    protected JCheckBox rightAlign = new JCheckBox();
    protected JComboBox<String> fontSizeCB = new JComboBox();
    protected JComboBox<String> fontStyleCB = new JComboBox();
    protected JComboBox<String> fontNameCB = new JComboBox();
    protected JCheckBox showOccupancy = new JCheckBox();
    protected JCheckBox showUnconserved = new JCheckBox();
    protected JCheckBox idItalics = new JCheckBox();
    protected JCheckBox smoothFont = new JCheckBox();
    protected JCheckBox scaleProteinToCdna = new JCheckBox();
    protected JComboBox<String> gapSymbolCB = new JComboBox();
    protected JCheckBox wrap = new JCheckBox();
    protected JComboBox<String> sortby = new JComboBox();
    protected JComboBox<String> sortAnnBy = new JComboBox();
    protected JComboBox<String> sortAutocalc = new JComboBox();
    protected JCheckBox startupCheckbox = new JCheckBox();
    protected JTextField startupFileTextfield = new JTextField();
    protected JCheckBox annotations = new JCheckBox();
    protected JCheckBox quality = new JCheckBox();
    protected JCheckBox conservation = new JCheckBox();
    protected JCheckBox identity = new JCheckBox();
    protected JCheckBox ssConsensus = new JCheckBox();
    protected JCheckBox showGroupConsensus = new JCheckBox();
    protected JCheckBox showGroupConservation = new JCheckBox();
    protected JCheckBox showConsensHistogram = new JCheckBox();
    protected JCheckBox showConsensLogo = new JCheckBox();
    protected JCheckBox showDbRefTooltip = new JCheckBox();
    protected JCheckBox showNpTooltip = new JCheckBox();
    protected JPanel structureTab;
    protected JCheckBox structFromPdb = new JCheckBox();
    protected JCheckBox addSecondaryStructure = new JCheckBox();
    protected JCheckBox addTempFactor = new JCheckBox();
    protected JComboBox<String> structViewer = new JComboBox();
    protected JLabel structureViewerPathLabel;
    protected JTextField structureViewerPath = new JTextField();
    protected ButtonGroup mappingMethod = new ButtonGroup();
    protected JRadioButton siftsMapping = new JRadioButton();
    protected JRadioButton nwMapping = new JRadioButton();
    protected JPanel minColour = new JPanel();
    protected JPanel maxColour = new JPanel();
    protected JComboBox<String> protColour = new JComboBox();
    protected JComboBox<String> nucColour = new JComboBox();
    protected JPanel gapColour = new JPanel();
    protected JPanel hiddenColour = new JPanel();
    protected JCheckBox useLegacyGap;
    protected JCheckBox showHiddenAtStart;
    protected JLabel gapLabel;
    protected JPanel connectTab;
    protected JTable linkUrlTable = new JTable();
    protected JButton editLink = new JButton();
    protected JButton deleteLink = new JButton();
    protected JTextField filterTB = new JTextField();
    protected JButton doReset = new JButton();
    protected JButton userOnly = new JButton();
    protected JLabel httpLabel = new JLabel();
    protected JLabel httpsLabel = new JLabel();
    protected JLabel portLabel = new JLabel();
    protected JLabel serverLabel = new JLabel();
    protected JLabel portLabel2 = new JLabel();
    protected JLabel serverLabel2 = new JLabel();
    protected JLabel proxyAuthUsernameLabel = new JLabel();
    protected JLabel proxyAuthPasswordLabel = new JLabel();
    protected JLabel passwordNotStoredLabel = new JLabel();
    protected JTextField proxyServerHttpTB = new JTextField();
    protected JTextField proxyPortHttpTB = new JTextField();
    protected JTextField proxyServerHttpsTB = new JTextField();
    protected JTextField proxyPortHttpsTB = new JTextField();
    protected JCheckBox proxyAuth = new JCheckBox();
    protected JTextField proxyAuthUsernameTB = new JTextField();
    protected JPasswordField proxyAuthPasswordPB = new JPasswordField();
    protected ButtonGroup proxyType = new ButtonGroup();
    protected JRadioButton noProxy = new JRadioButton();
    protected JRadioButton systemProxy = new JRadioButton();
    protected JRadioButton customProxy = new JRadioButton();
    protected JButton applyProxyButton = new JButton();
    protected JCheckBox usagestats = new JCheckBox();
    protected JCheckBox questionnaire = new JCheckBox();
    protected JCheckBox versioncheck = new JCheckBox();
    protected JComboBox<Object> epsRendering = new JComboBox();
    protected JComboBox<Object> htmlRendering = new JComboBox();
    protected JComboBox<Object> svgRendering = new JComboBox();
    protected JLabel userIdWidthlabel = new JLabel();
    protected JCheckBox autoIdWidth = new JCheckBox();
    protected JTextField userIdWidth = new JTextField();
    protected JCheckBox blcjv = new JCheckBox();
    protected JCheckBox pileupjv = new JCheckBox();
    protected JCheckBox clustaljv = new JCheckBox();
    protected JCheckBox msfjv = new JCheckBox();
    protected JCheckBox fastajv = new JCheckBox();
    protected JCheckBox pfamjv = new JCheckBox();
    protected JCheckBox pirjv = new JCheckBox();
    protected JCheckBox modellerOutput = new JCheckBox();
    protected JCheckBox embbedBioJSON = new JCheckBox();
    protected JCheckBox autoCalculateConsCheck = new JCheckBox();
    protected JCheckBox padGaps = new JCheckBox();
    protected JCheckBox sortByTree = new JCheckBox();
    protected JPanel wsTab = new JPanel();
    protected JCheckBox enableBackupFiles = new JCheckBox();
    protected JPanel presetsPanel = new JPanel();
    protected JLabel presetsComboLabel = new JLabel();
    protected JCheckBox customiseCheckbox = new JCheckBox();
    protected JButton revertButton = new JButton();
    protected JComboBox<Object> backupfilesPresetsCombo = new JComboBox();
    private int backupfilesPresetsComboLastSelected = 0;
    protected JPanel suffixPanel = new JPanel();
    protected JPanel keepfilesPanel = new JPanel();
    protected JPanel exampleFilesPanel = new JPanel();
    protected JTextField suffixTemplate = new JTextField(null, 8);
    protected JLabel suffixTemplateLabel = new JLabel();
    protected JLabel suffixDigitsLabel = new JLabel();
    protected JSpinner suffixDigitsSpinner = new JSpinner();
    protected JalviewBooleanRadioButtons suffixReverse = new JalviewBooleanRadioButtons();
    protected JalviewBooleanRadioButtons backupfilesKeepAll = new JalviewBooleanRadioButtons();
    public JSpinner backupfilesRollMaxSpinner = new JSpinner();
    protected JLabel oldBackupFilesLabel = new JLabel();
    protected JalviewBooleanRadioButtons backupfilesConfirmDelete = new JalviewBooleanRadioButtons();
    protected JTextArea backupfilesExampleLabel = new JTextArea();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private JLabel messageLabel = new JLabel("", 0);
    protected JCheckBox customiseMemorySetting = new JCheckBox();
    protected JLabel exampleMemoryLabel = new JLabel();
    protected JTextArea exampleMemoryMessageTextArea = new JTextArea();
    protected JLabel maxMemoryLabel = new JLabel();
    protected JLabel jvmMemoryPercentLabel = new JLabel();
    protected JSlider jvmMemoryPercentSlider = new JSlider();
    protected JLabel jvmMemoryPercentDisplay = new JLabel();
    protected JLabel jvmMemoryMaxLabel = new JLabel();
    protected JTextField jvmMemoryMaxTextField = new JTextField(null, 8);
    protected JComboBox<Object> lafCombo = new JComboBox();

    public GPreferences() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.messageLabel, "North");
        JPanel okCancelPanel = this.initOkCancelPanel();
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)okCancelPanel, "South");
        this.tabbedPane.add((Component)this.initVisualTab(), MessageManager.getString("label.visual"));
        this.tabbedPane.add((Component)this.initColoursTab(), MessageManager.getString("label.colours"));
        this.tabbedPane.add((Component)this.initOverviewTab(), MessageManager.getString("label.overview"));
        this.tabbedPane.add((Component)this.initStructureTab(), MessageManager.getString("label.structure"));
        this.tabbedPane.add((Component)this.initConnectionsTab(), MessageManager.getString("label.connections"));
        if (!Platform.isJS()) {
            this.tabbedPane.add((Component)this.initBackupsTab(), MessageManager.getString("label.backups"));
        }
        this.tabbedPane.add((Component)this.initLinksTab(), MessageManager.getString("label.urllinks"));
        this.tabbedPane.add((Component)this.initOutputTab(), MessageManager.getString("label.output"));
        this.tabbedPane.add((Component)this.initEditingTab(), MessageManager.getString("label.editing"));
        this.tabbedPane.add((Component)this.initStartupTab(), MessageManager.getString("label.startup"));
        if (!Platform.isJS()) {
            this.wsTab.setLayout(new BorderLayout());
            this.tabbedPane.add((Component)this.wsTab, MessageManager.getString("label.web_services"));
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){
            private Component lastTab;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.lastTab == GPreferences.this.structureTab && GPreferences.this.tabbedPane.getSelectedComponent() != GPreferences.this.structureTab && !GPreferences.this.validateStructure()) {
                    GPreferences.this.tabbedPane.setSelectedComponent(GPreferences.this.structureTab);
                    return;
                }
                this.lastTab = GPreferences.this.tabbedPane.getSelectedComponent();
                GPreferences.this.clearMessage();
            }
        });
    }

    public void setMessage(String message) {
        if (message != null) {
            this.messageLabel.setText(message);
            this.messageLabel.setFont(LABEL_FONT_BOLD);
            this.messageLabel.setForeground(Color.RED.darker());
            this.messageLabel.revalidate();
            this.messageLabel.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    public void clearMessage() {
        if (this.messageLabel.getText() != null && this.messageLabel.getText().length() > 0) {
            this.messageLabel.setText("");
            this.messageLabel.revalidate();
            this.messageLabel.repaint();
            this.revalidate();
            this.repaint();
        }
    }

    public void selectTab(TabRef selectTab) {
        switch (selectTab) {
            case CONNECTIONS_TAB: {
                this.tabbedPane.setSelectedComponent(this.connectTab);
                break;
            }
            case STRUCTURE_TAB: {
                this.tabbedPane.setSelectedComponent(this.structureTab);
                break;
            }
        }
    }

    private JPanel initEditingTab() {
        JPanel editingTab = new JPanel();
        editingTab.setLayout(null);
        this.autoCalculateConsCheck.setFont(LABEL_FONT);
        this.autoCalculateConsCheck.setText(MessageManager.getString("label.autocalculate_consensus"));
        this.autoCalculateConsCheck.setBounds(new Rectangle(21, 52, 209, 23));
        this.padGaps.setFont(LABEL_FONT);
        this.padGaps.setText(MessageManager.getString("label.pad_gaps_when_editing"));
        this.padGaps.setBounds(new Rectangle(22, 94, 168, 23));
        this.sortByTree.setFont(LABEL_FONT);
        this.sortByTree.setText(MessageManager.getString("label.sort_with_new_tree"));
        this.sortByTree.setToolTipText(MessageManager.getString("label.any_trees_calculated_or_loaded_alignment_automatically_sort"));
        this.sortByTree.setBounds(new Rectangle(22, 136, 168, 23));
        editingTab.add(this.autoCalculateConsCheck);
        editingTab.add(this.padGaps);
        editingTab.add(this.sortByTree);
        return editingTab;
    }

    private JPanel initOutputTab() {
        JPanel outputTab = new JPanel();
        outputTab.setLayout(null);
        JLabel epsLabel = new JLabel(MessageManager.formatMessage("label.rendering_style", "EPS"));
        epsLabel.setFont(LABEL_FONT);
        epsLabel.setHorizontalAlignment(4);
        epsLabel.setBounds(new Rectangle(9, 31, 160, 24));
        this.epsRendering.setFont(LABEL_FONT);
        this.epsRendering.setBounds(new Rectangle(174, 34, 187, 21));
        JLabel htmlLabel = new JLabel(MessageManager.formatMessage("label.rendering_style", "HTML"));
        htmlLabel.setFont(LABEL_FONT);
        htmlLabel.setHorizontalAlignment(4);
        htmlLabel.setBounds(new Rectangle(9, 55, 160, 24));
        this.htmlRendering.setFont(LABEL_FONT);
        this.htmlRendering.setBounds(new Rectangle(174, 58, 187, 21));
        JLabel svgLabel = new JLabel(MessageManager.formatMessage("label.rendering_style", "SVG"));
        svgLabel.setFont(LABEL_FONT);
        svgLabel.setHorizontalAlignment(4);
        svgLabel.setBounds(new Rectangle(9, 79, 160, 24));
        this.svgRendering.setFont(LABEL_FONT);
        this.svgRendering.setBounds(new Rectangle(174, 82, 187, 21));
        JLabel jLabel1 = new JLabel();
        jLabel1.setFont(LABEL_FONT);
        jLabel1.setHorizontalAlignment(0);
        jLabel1.setText(MessageManager.getString("label.append_start_end"));
        jLabel1.setFont(LABEL_FONT);
        this.fastajv.setFont(LABEL_FONT);
        this.fastajv.setHorizontalAlignment(2);
        this.clustaljv.setText(MessageManager.getString("label.clustal") + "     ");
        this.blcjv.setText(MessageManager.getString("label.blc") + "     ");
        this.fastajv.setText(MessageManager.getString("label.fasta") + "     ");
        this.msfjv.setText(MessageManager.getString("label.msf") + "     ");
        this.pfamjv.setText(MessageManager.getString("label.pfam") + "     ");
        this.pileupjv.setText(MessageManager.getString("label.pileup") + "     ");
        this.msfjv.setFont(LABEL_FONT);
        this.msfjv.setHorizontalAlignment(2);
        this.pirjv.setText(MessageManager.getString("label.pir") + "     ");
        JPanel jPanel11 = new JPanel();
        jPanel11.setFont(LABEL_FONT);
        TitledBorder titledBorder2 = new TitledBorder(MessageManager.getString("label.file_output"));
        jPanel11.setBorder(titledBorder2);
        jPanel11.setBounds(new Rectangle(30, 120, 196, 182));
        GridLayout gridLayout3 = new GridLayout();
        jPanel11.setLayout(gridLayout3);
        gridLayout3.setRows(8);
        this.blcjv.setFont(LABEL_FONT);
        this.blcjv.setHorizontalAlignment(2);
        this.clustaljv.setFont(LABEL_FONT);
        this.clustaljv.setHorizontalAlignment(2);
        this.pfamjv.setFont(LABEL_FONT);
        this.pfamjv.setHorizontalAlignment(2);
        this.pileupjv.setFont(LABEL_FONT);
        this.pileupjv.setHorizontalAlignment(2);
        this.pirjv.setFont(LABEL_FONT);
        this.pirjv.setHorizontalAlignment(2);
        this.autoIdWidth.setFont(LABEL_FONT);
        this.autoIdWidth.setText(MessageManager.getString("label.automatically_set_id_width"));
        this.autoIdWidth.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.adjusts_width_generated_eps_png")));
        this.autoIdWidth.setBounds(new Rectangle(228, 144, 320, 23));
        this.autoIdWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.autoIdWidth_actionPerformed();
            }
        });
        this.userIdWidthlabel.setFont(LABEL_FONT);
        this.userIdWidthlabel.setText(MessageManager.getString("label.figure_id_column_width"));
        this.userIdWidth.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.manually_specify_width_left_column")));
        this.userIdWidthlabel.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.manually_specify_width_left_column")));
        this.userIdWidthlabel.setBounds(new Rectangle(236, 168, 320, 23));
        this.userIdWidth.setFont(JvSwingUtils.getTextAreaFont());
        this.userIdWidth.setText("");
        this.userIdWidth.setBounds(new Rectangle(232, 192, 84, 23));
        this.userIdWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.userIdWidth_actionPerformed();
            }
        });
        this.modellerOutput.setFont(LABEL_FONT);
        this.modellerOutput.setText(MessageManager.getString("label.use_modeller_output"));
        this.modellerOutput.setBounds(new Rectangle(228, 274, 320, 23));
        this.embbedBioJSON.setFont(LABEL_FONT);
        this.embbedBioJSON.setText(MessageManager.getString("label.embbed_biojson"));
        this.embbedBioJSON.setBounds(new Rectangle(228, 248, 250, 23));
        jPanel11.add(jLabel1);
        jPanel11.add(this.blcjv);
        jPanel11.add(this.clustaljv);
        jPanel11.add(this.fastajv);
        jPanel11.add(this.msfjv);
        jPanel11.add(this.pfamjv);
        jPanel11.add(this.pileupjv);
        jPanel11.add(this.pirjv);
        outputTab.add(this.autoIdWidth);
        outputTab.add(this.userIdWidth);
        outputTab.add(this.userIdWidthlabel);
        outputTab.add(this.modellerOutput);
        if (!Platform.isJS()) {
            outputTab.add(this.embbedBioJSON);
            outputTab.add(epsLabel);
            outputTab.add(this.epsRendering);
            outputTab.add(htmlLabel);
            outputTab.add(this.htmlRendering);
            outputTab.add(svgLabel);
            outputTab.add(this.svgRendering);
        }
        outputTab.add(jPanel11);
        return outputTab;
    }

    private JPanel initConnectionsTab() {
        this.connectTab = new JPanel();
        this.connectTab.setLayout(new GridBagLayout());
        JPanel proxyPanel = this.initConnTabProxyPanel();
        this.initConnTabCheckboxes();
        this.connectTab.add((Component)proxyPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 5, 12), 4, 10));
        this.connectTab.add((Component)this.usagestats, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 5, 5), 70, 1));
        this.connectTab.add((Component)this.questionnaire, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 5, 10), 70, 1));
        this.connectTab.add((Component)this.versioncheck, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 5, 5), 70, 1));
        this.versioncheck.setVisible(false);
        JPanel spacePanel = new JPanel();
        this.connectTab.add((Component)spacePanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 70, 1));
        return this.connectTab;
    }

    private JPanel initLinksTab() {
        JPanel linkTab = new JPanel();
        linkTab.setLayout(new GridBagLayout());
        this.linkUrlTable.getTableHeader().setReorderingAllowed(false);
        this.linkUrlTable.setFillsViewportHeight(true);
        this.linkUrlTable.setAutoResizeMode(4);
        this.linkUrlTable.setAutoCreateRowSorter(true);
        this.linkUrlTable.setSelectionMode(0);
        JRadioButton temp = new JRadioButton();
        this.linkUrlTable.setRowHeight(temp.getMinimumSize().height);
        JScrollPane linkScrollPane = new JScrollPane(this.linkUrlTable);
        linkScrollPane.setBorder(null);
        JPanel linkPanel = new JPanel(new GridBagLayout());
        linkPanel.setBorder(new TitledBorder(MessageManager.getString("label.url_linkfrom_sequence_id")));
        JPanel buttonPanel = this.initLinkTabUrlButtons();
        GridBagConstraints linkConstraints1 = new GridBagConstraints();
        linkConstraints1.insets = new Insets(0, 0, 5, 0);
        linkConstraints1.gridx = 0;
        linkConstraints1.gridy = 0;
        linkConstraints1.weightx = 1.0;
        linkConstraints1.fill = 2;
        linkTab.add((Component)buttonPanel, linkConstraints1);
        GridBagConstraints linkConstraints2 = new GridBagConstraints();
        linkConstraints2.insets = new Insets(0, 0, 5, 5);
        linkConstraints2.gridx = 0;
        linkConstraints2.gridy = 1;
        linkConstraints2.weightx = 1.0;
        linkConstraints2.weighty = 1.0;
        linkConstraints2.fill = 1;
        linkTab.add((Component)linkScrollPane, linkConstraints2);
        JPanel filterPanel = this.initLinkTabFilterPanel();
        GridBagConstraints linkConstraints3 = new GridBagConstraints();
        linkConstraints3.insets = new Insets(0, 0, 0, 5);
        linkConstraints3.gridx = 0;
        linkConstraints3.gridy = 2;
        linkConstraints3.weightx = 1.0;
        linkConstraints3.fill = 2;
        linkTab.add((Component)filterPanel, linkConstraints3);
        return linkTab;
    }

    private JPanel initLinkTabFilterPanel() {
        JLabel filterLabel = new JLabel(MessageManager.getString("label.filter"));
        filterLabel.setFont(LABEL_FONT);
        filterLabel.setHorizontalAlignment(4);
        filterLabel.setHorizontalTextPosition(10);
        this.filterTB.setFont(LABEL_FONT);
        this.filterTB.setText("");
        this.doReset.setText(MessageManager.getString("action.showall"));
        this.userOnly.setText(MessageManager.getString("action.customfilter"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder(new TitledBorder("Filter"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        filterPanel.add((Component)filterLabel, gbc);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 1;
        gbc1.gridwidth = 2;
        gbc1.fill = 2;
        gbc1.anchor = 17;
        gbc1.weightx = 1.0;
        filterPanel.add((Component)this.filterTB, gbc1);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 3;
        gbc2.fill = 0;
        gbc2.anchor = 17;
        filterPanel.add((Component)this.doReset, gbc2);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 4;
        gbc3.fill = 0;
        gbc3.anchor = 17;
        filterPanel.add((Component)this.userOnly, gbc3);
        return filterPanel;
    }

    private JPanel initLinkTabUrlButtons() {
        JButton newLink = new JButton();
        newLink.setText(MessageManager.getString("action.new"));
        this.editLink.setText(MessageManager.getString("action.edit"));
        this.deleteLink.setText(MessageManager.getString("action.delete"));
        this.editLink.setEnabled(false);
        this.deleteLink.setEnabled(false);
        newLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.newLink_actionPerformed(e);
            }
        });
        this.editLink.setText(MessageManager.getString("action.edit"));
        this.editLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.editLink_actionPerformed(e);
            }
        });
        this.deleteLink.setText(MessageManager.getString("action.delete"));
        this.deleteLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.deleteLink_actionPerformed(e);
            }
        });
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(new TitledBorder("Edit links"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        buttonPanel.add((Component)newLink, gbc);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 1;
        gbc1.gridy = 0;
        gbc1.fill = 0;
        buttonPanel.add((Component)this.editLink, gbc1);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 2;
        gbc2.gridy = 0;
        gbc2.fill = 0;
        buttonPanel.add((Component)this.deleteLink, gbc2);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 3;
        gbc3.gridy = 0;
        gbc3.fill = 2;
        gbc3.weightx = 1.0;
        JPanel spacePanel = new JPanel();
        spacePanel.setBorder(null);
        buttonPanel.add((Component)spacePanel, gbc3);
        return buttonPanel;
    }

    private JPanel initConnTabProxyPanel() {
        this.serverLabel.setText(MessageManager.getString("label.host") + ": ");
        this.serverLabel.setHorizontalAlignment(4);
        this.serverLabel.setFont(LABEL_FONT);
        this.serverLabel2.setText(MessageManager.getString("label.host") + ": ");
        this.serverLabel2.setHorizontalAlignment(4);
        this.serverLabel2.setFont(LABEL_FONT);
        this.proxyServerHttpTB.setFont(LABEL_FONT);
        this.proxyServerHttpTB.setColumns(40);
        this.proxyPortHttpTB.setFont(LABEL_FONT);
        this.proxyPortHttpTB.setColumns(4);
        this.proxyServerHttpsTB.setFont(LABEL_FONT);
        this.proxyServerHttpsTB.setColumns(40);
        this.proxyPortHttpsTB.setFont(LABEL_FONT);
        this.proxyPortHttpsTB.setColumns(4);
        this.proxyAuthUsernameTB.setFont(LABEL_FONT);
        this.proxyAuthUsernameTB.setColumns(30);
        DocumentListener d = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GPreferences.this.applyProxyButtonEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GPreferences.this.applyProxyButtonEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GPreferences.this.applyProxyButtonEnabled(true);
            }
        };
        this.proxyServerHttpTB.getDocument().addDocumentListener(d);
        this.proxyPortHttpTB.getDocument().addDocumentListener(d);
        this.proxyServerHttpsTB.getDocument().addDocumentListener(d);
        this.proxyPortHttpsTB.getDocument().addDocumentListener(d);
        this.proxyAuthUsernameTB.getDocument().addDocumentListener(d);
        this.proxyAuthPasswordPB.setFont(LABEL_FONT);
        this.proxyAuthPasswordPB.setColumns(30);
        this.proxyAuthPasswordPB.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GPreferences.this.proxyAuthPasswordCheckHighlight(true);
                GPreferences.this.applyProxyButtonEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GPreferences.this.proxyAuthPasswordCheckHighlight(true);
                GPreferences.this.applyProxyButtonEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GPreferences.this.proxyAuthPasswordCheckHighlight(true);
                GPreferences.this.applyProxyButtonEnabled(true);
            }
        });
        this.portLabel.setFont(LABEL_FONT);
        this.portLabel.setHorizontalAlignment(4);
        this.portLabel.setText(MessageManager.getString("label.port") + ": ");
        this.portLabel2.setFont(LABEL_FONT);
        this.portLabel2.setHorizontalAlignment(4);
        this.portLabel2.setText(MessageManager.getString("label.port") + ": ");
        this.httpLabel.setText("HTTP");
        this.httpLabel.setFont(LABEL_FONT_BOLD);
        this.httpLabel.setHorizontalAlignment(2);
        this.httpsLabel.setText("HTTPS");
        this.httpsLabel.setFont(LABEL_FONT_BOLD);
        this.httpsLabel.setHorizontalAlignment(2);
        this.proxyAuthUsernameLabel.setText(MessageManager.getString("label.username") + ": ");
        this.proxyAuthUsernameLabel.setFont(LABEL_FONT);
        this.proxyAuthUsernameLabel.setHorizontalAlignment(4);
        this.proxyAuthPasswordLabel.setText(MessageManager.getString("label.password") + ": ");
        this.proxyAuthPasswordLabel.setFont(LABEL_FONT);
        this.proxyAuthPasswordLabel.setHorizontalAlignment(4);
        this.passwordNotStoredLabel.setText("(" + MessageManager.getString("label.not_stored") + ")");
        this.passwordNotStoredLabel.setFont(LABEL_FONT_ITALIC);
        this.passwordNotStoredLabel.setHorizontalAlignment(2);
        this.noProxy.setFont(LABEL_FONT);
        this.noProxy.setHorizontalAlignment(2);
        this.noProxy.setText(MessageManager.getString("label.no_proxy"));
        this.systemProxy.setFont(LABEL_FONT);
        this.systemProxy.setHorizontalAlignment(2);
        this.systemProxy.setText(MessageManager.formatMessage("label.system_proxy", this.displayUserHostPort(Cache.startupProxyProperties[4], Cache.startupProxyProperties[0], Cache.startupProxyProperties[1]), this.displayUserHostPort(Cache.startupProxyProperties[6], Cache.startupProxyProperties[2], Cache.startupProxyProperties[3])));
        this.customProxy.setFont(LABEL_FONT);
        this.customProxy.setHorizontalAlignment(2);
        this.customProxy.setText(MessageManager.getString("label.use_proxy_server") + ":");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.proxyType_actionPerformed();
            }
        };
        this.noProxy.addActionListener(al);
        this.systemProxy.addActionListener(al);
        this.customProxy.addActionListener(al);
        this.proxyType.add(this.noProxy);
        this.proxyType.add(this.systemProxy);
        this.proxyType.add(this.customProxy);
        this.proxyAuth.setFont(LABEL_FONT);
        this.proxyAuth.setHorizontalAlignment(2);
        this.proxyAuth.setText(MessageManager.getString("label.auth_required"));
        this.proxyAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.proxyAuth_actionPerformed();
            }
        });
        this.setCustomProxyEnabled();
        JPanel proxyPanel = new JPanel();
        TitledBorder titledBorder1 = new TitledBorder(MessageManager.getString("label.proxy_servers"));
        proxyPanel.setBorder(titledBorder1);
        proxyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        GridBagConstraints c = new GridBagConstraints();
        JPanel ptPanel = new JPanel();
        ptPanel.setLayout(new GridBagLayout());
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 2;
        ptPanel.add((Component)this.noProxy, c);
        ++c.gridy;
        ptPanel.add((Component)this.systemProxy, c);
        ++c.gridy;
        ptPanel.add((Component)this.customProxy, c);
        gbc.gridy = 0;
        proxyPanel.add((Component)ptPanel, gbc);
        JPanel hpPanel = new JPanel();
        hpPanel.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.1;
        c.anchor = 21;
        hpPanel.add((Component)this.httpLabel, c);
        ++c.gridx;
        c.weightx = 0.1;
        c.anchor = 22;
        hpPanel.add((Component)this.serverLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.anchor = 21;
        hpPanel.add((Component)this.proxyServerHttpTB, c);
        ++c.gridx;
        c.weightx = 0.1;
        c.anchor = 22;
        hpPanel.add((Component)this.portLabel, c);
        ++c.gridx;
        c.weightx = 0.2;
        c.anchor = 21;
        hpPanel.add((Component)this.proxyPortHttpTB, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 21;
        hpPanel.add((Component)this.httpsLabel, c);
        ++c.gridx;
        c.anchor = 22;
        hpPanel.add((Component)this.serverLabel2, c);
        ++c.gridx;
        c.anchor = 21;
        hpPanel.add((Component)this.proxyServerHttpsTB, c);
        ++c.gridx;
        c.anchor = 22;
        hpPanel.add((Component)this.portLabel2, c);
        ++c.gridx;
        c.anchor = 21;
        hpPanel.add((Component)this.proxyPortHttpsTB, c);
        ++gbc.gridy;
        proxyPanel.add((Component)hpPanel, gbc);
        if (!Platform.isJS()) {
            ++gbc.gridy;
            proxyPanel.add((Component)this.proxyAuth, gbc);
            JPanel upPanel = new JPanel();
            upPanel.setLayout(new GridBagLayout());
            c.gridy = 0;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.4;
            c.anchor = 22;
            upPanel.add((Component)this.proxyAuthUsernameLabel, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.anchor = 21;
            upPanel.add((Component)this.proxyAuthUsernameTB, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.4;
            c.anchor = 22;
            upPanel.add((Component)this.proxyAuthPasswordLabel, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.anchor = 21;
            upPanel.add((Component)this.proxyAuthPasswordPB, c);
            ++c.gridx;
            c.weightx = 0.4;
            c.anchor = 21;
            upPanel.add((Component)this.passwordNotStoredLabel, c);
            ++gbc.gridy;
            proxyPanel.add((Component)upPanel, gbc);
        }
        this.applyProxyButton.setText(MessageManager.getString("action.apply"));
        this.applyProxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.saveProxySettings();
                GPreferences.this.applyProxyButton.setEnabled(false);
            }
        });
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 22;
        proxyPanel.add((Component)this.applyProxyButton, gbc);
        return proxyPanel;
    }

    public void proxyAuthPasswordCheckHighlight(boolean enabled) {
        this.proxyAuthPasswordCheckHighlight(enabled, false);
    }

    public void proxyAuthPasswordCheckHighlight(boolean enabled, boolean grabFocus) {
        if (enabled && this.proxyType.isSelected(this.customProxy.getModel()) && this.proxyAuth.isSelected() && !this.proxyAuthUsernameTB.getText().isEmpty() && this.proxyAuthPasswordPB.getDocument().getLength() == 0) {
            if (grabFocus) {
                this.proxyAuthPasswordPB.grabFocus();
            }
            this.proxyAuthPasswordPB.setBackground(Color.PINK);
        } else {
            this.proxyAuthPasswordPB.setBackground(Color.WHITE);
        }
    }

    public void applyProxyButtonEnabled(boolean enabled) {
        this.applyProxyButton.setEnabled(enabled);
    }

    public void saveProxySettings() {
    }

    private String displayUserHostPort(String user, String host, String port) {
        boolean portBlank;
        boolean hostBlank = host == null || host.isEmpty();
        boolean bl = portBlank = port == null || port.isEmpty();
        if (hostBlank && portBlank) {
            return MessageManager.getString("label.none");
        }
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            sb.append(user.isEmpty() || user.indexOf(" ") > -1 ? '\"' + user + '\"' : user);
            sb.append("@");
        }
        sb.append(hostBlank ? "" : host);
        if (!portBlank) {
            sb.append(":");
            sb.append(port);
        }
        return sb.toString();
    }

    private void initConnTabCheckboxes() {
        this.usagestats.setText(MessageManager.getString("label.send_usage_statistics"));
        this.usagestats.setFont(LABEL_FONT);
        this.usagestats.setHorizontalAlignment(4);
        this.usagestats.setHorizontalTextPosition(10);
        this.questionnaire.setText(MessageManager.getString("label.check_for_questionnaires"));
        this.questionnaire.setFont(LABEL_FONT);
        this.questionnaire.setHorizontalAlignment(4);
        this.questionnaire.setHorizontalTextPosition(10);
        this.versioncheck.setText(MessageManager.getString("label.check_for_latest_version"));
        this.versioncheck.setFont(LABEL_FONT);
        this.versioncheck.setHorizontalAlignment(4);
        this.versioncheck.setHorizontalTextPosition(10);
    }

    private JPanel initOkCancelPanel() {
        JButton ok = new JButton();
        ok.setText(MessageManager.getString("action.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.ok_actionPerformed(e);
            }
        });
        JButton cancel = new JButton();
        cancel.setText(MessageManager.getString("action.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.cancel_actionPerformed(e);
            }
        });
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.add(ok);
        okCancelPanel.add(cancel);
        return okCancelPanel;
    }

    private JPanel initColoursTab() {
        JPanel coloursTab = new JPanel();
        coloursTab.setBorder(new TitledBorder(MessageManager.getString("action.open_new_alignment")));
        coloursTab.setLayout(new FlowLayout());
        JLabel mincolourLabel = new JLabel();
        mincolourLabel.setFont(LABEL_FONT);
        mincolourLabel.setHorizontalAlignment(4);
        mincolourLabel.setText(MessageManager.getString("label.min_colour"));
        this.minColour.setFont(LABEL_FONT);
        this.minColour.setBorder(BorderFactory.createEtchedBorder());
        this.minColour.setPreferredSize(new Dimension(40, 20));
        this.minColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GPreferences.this.minColour_actionPerformed(GPreferences.this.minColour);
            }
        });
        JLabel maxcolourLabel = new JLabel();
        maxcolourLabel.setFont(LABEL_FONT);
        maxcolourLabel.setHorizontalAlignment(4);
        maxcolourLabel.setText(MessageManager.getString("label.max_colour"));
        this.maxColour.setFont(LABEL_FONT);
        this.maxColour.setBorder(BorderFactory.createEtchedBorder());
        this.maxColour.setPreferredSize(new Dimension(40, 20));
        this.maxColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GPreferences.this.maxColour_actionPerformed(GPreferences.this.maxColour);
            }
        });
        this.protColour.setFont(LABEL_FONT);
        this.protColour.setBounds(new Rectangle(172, 225, 155, 21));
        JLabel protColourLabel = new JLabel();
        protColourLabel.setFont(LABEL_FONT);
        protColourLabel.setHorizontalAlignment(2);
        protColourLabel.setText(MessageManager.getString("label.prot_alignment_colour") + " ");
        JvSwingUtils.addtoLayout(coloursTab, MessageManager.getString("label.default_colour_scheme_for_alignment"), protColourLabel, this.protColour);
        this.nucColour.setFont(LABEL_FONT);
        this.nucColour.setBounds(new Rectangle(172, 240, 155, 21));
        JLabel nucColourLabel = new JLabel();
        nucColourLabel.setFont(LABEL_FONT);
        nucColourLabel.setHorizontalAlignment(2);
        nucColourLabel.setText(MessageManager.getString("label.nuc_alignment_colour") + " ");
        JvSwingUtils.addtoLayout(coloursTab, MessageManager.getString("label.default_colour_scheme_for_alignment"), nucColourLabel, this.nucColour);
        JPanel annotationShding = new JPanel();
        annotationShding.setBorder(new TitledBorder(MessageManager.getString("label.annotation_shading_default")));
        annotationShding.setLayout(new GridLayout(1, 2));
        JvSwingUtils.addtoLayout(annotationShding, MessageManager.getString("label.default_minimum_colour_annotation_shading"), mincolourLabel, this.minColour);
        JvSwingUtils.addtoLayout(annotationShding, MessageManager.getString("label.default_maximum_colour_annotation_shading"), maxcolourLabel, this.maxColour);
        coloursTab.add(annotationShding);
        return coloursTab;
    }

    private JPanel initOverviewTab() {
        JPanel overviewPanel = new JPanel();
        overviewPanel.setBorder(new TitledBorder(MessageManager.getString("label.overview_settings")));
        this.gapColour.setFont(LABEL_FONT);
        this.gapColour.setBorder(BorderFactory.createEtchedBorder(Color.white, Color.lightGray));
        this.gapColour.setPreferredSize(new Dimension(40, 20));
        this.gapColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GPreferences.this.gapColour_actionPerformed(GPreferences.this.gapColour);
            }
        });
        this.hiddenColour.setFont(LABEL_FONT);
        this.hiddenColour.setBorder(BorderFactory.createEtchedBorder(Color.white, Color.lightGray));
        this.hiddenColour.setPreferredSize(new Dimension(40, 20));
        this.hiddenColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GPreferences.this.hiddenColour_actionPerformed(GPreferences.this.hiddenColour);
            }
        });
        this.useLegacyGap = new JCheckBox(MessageManager.getString("label.ov_legacy_gap"));
        this.useLegacyGap.setFont(LABEL_FONT);
        this.useLegacyGap.setHorizontalAlignment(2);
        this.useLegacyGap.setVerticalTextPosition(1);
        this.gapLabel = new JLabel(MessageManager.getString("label.gap_colour"));
        this.gapLabel.setFont(LABEL_FONT);
        this.gapLabel.setHorizontalAlignment(2);
        this.gapLabel.setVerticalTextPosition(1);
        this.showHiddenAtStart = new JCheckBox(MessageManager.getString("label.ov_show_hide_default"));
        this.showHiddenAtStart.setFont(LABEL_FONT);
        this.showHiddenAtStart.setHorizontalAlignment(2);
        this.showHiddenAtStart.setVerticalTextPosition(1);
        JLabel hiddenLabel = new JLabel(MessageManager.getString("label.hidden_colour"));
        hiddenLabel.setFont(LABEL_FONT);
        hiddenLabel.setHorizontalAlignment(2);
        hiddenLabel.setVerticalTextPosition(1);
        this.useLegacyGap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.useLegacyGaps_actionPerformed(e);
            }
        });
        overviewPanel.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 2;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 1.0;
        c1.ipady = 20;
        c1.anchor = 23;
        overviewPanel.add((Component)this.useLegacyGap, c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.gridx = 1;
        c2.gridy = 0;
        c2.insets = new Insets(0, 15, 0, 10);
        overviewPanel.add((Component)this.gapLabel, c2);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.gridx = 2;
        c3.gridy = 0;
        c3.insets = new Insets(0, 0, 0, 15);
        overviewPanel.add((Component)this.gapColour, c3);
        GridBagConstraints c4 = new GridBagConstraints();
        c4.fill = 2;
        c4.gridx = 0;
        c4.gridy = 1;
        c4.weightx = 1.0;
        overviewPanel.add((Component)this.showHiddenAtStart, c4);
        GridBagConstraints c5 = new GridBagConstraints();
        c5.fill = 2;
        c5.gridx = 1;
        c5.gridy = 1;
        c5.insets = new Insets(0, 15, 0, 10);
        overviewPanel.add((Component)hiddenLabel, c5);
        GridBagConstraints c6 = new GridBagConstraints();
        c6.fill = 2;
        c6.gridx = 2;
        c6.gridy = 1;
        c6.insets = new Insets(0, 0, 0, 15);
        overviewPanel.add((Component)this.hiddenColour, c6);
        JButton resetButton = new JButton(MessageManager.getString("label.reset_to_defaults"));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.resetOvDefaults_actionPerformed(e);
            }
        });
        GridBagConstraints c7 = new GridBagConstraints();
        c7.fill = 0;
        c7.gridx = 0;
        c7.gridy = 2;
        c7.insets = new Insets(10, 0, 0, 0);
        c7.anchor = 17;
        overviewPanel.add((Component)resetButton, c7);
        JPanel spacePanel = new JPanel();
        overviewPanel.add((Component)spacePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        return overviewPanel;
    }

    private JPanel initStructureTab() {
        this.structureTab = new JPanel();
        this.structureTab.setBorder(new TitledBorder(MessageManager.getString("label.structure_options")));
        this.structureTab.setLayout(null);
        int width = 420;
        int height = 22;
        int lineSpacing = 25;
        int ypos = 15;
        this.structFromPdb.setFont(LABEL_FONT);
        this.structFromPdb.setText(MessageManager.getString("label.struct_from_pdb"));
        this.structFromPdb.setBounds(new Rectangle(5, ypos, 420, 22));
        this.structFromPdb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = GPreferences.this.structFromPdb.isSelected();
                GPreferences.this.addSecondaryStructure.setEnabled(selected);
                GPreferences.this.addTempFactor.setEnabled(selected);
            }
        });
        this.structureTab.add(this.structFromPdb);
        this.addSecondaryStructure.setFont(LABEL_FONT);
        this.addSecondaryStructure.setText(MessageManager.getString("label.autoadd_secstr"));
        this.addSecondaryStructure.setBounds(new Rectangle(25, ypos += 25, 420, 22));
        this.structureTab.add(this.addSecondaryStructure);
        this.addTempFactor.setFont(LABEL_FONT);
        this.addTempFactor.setText(MessageManager.getString("label.autoadd_temp"));
        this.addTempFactor.setBounds(new Rectangle(25, ypos += 25, 420, 22));
        this.structureTab.add(this.addTempFactor);
        JLabel viewerLabel = new JLabel();
        viewerLabel.setFont(LABEL_FONT);
        viewerLabel.setHorizontalAlignment(2);
        viewerLabel.setText(MessageManager.getString("label.structure_viewer"));
        viewerLabel.setBounds(new Rectangle(10, ypos += 25, 220, 22));
        this.structureTab.add(viewerLabel);
        this.structViewer.setFont(LABEL_FONT);
        this.structViewer.setBounds(new Rectangle(190, ypos, 120, 22));
        for (StructureViewer.ViewerType v : EnumSet.allOf(StructureViewer.ViewerType.class)) {
            this.structViewer.addItem(v.name());
        }
        this.structViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.structureViewer_actionPerformed((String)GPreferences.this.structViewer.getSelectedItem());
            }
        });
        this.structureTab.add(this.structViewer);
        this.structureViewerPathLabel = new JLabel();
        this.structureViewerPathLabel.setFont(LABEL_FONT);
        this.structureViewerPathLabel.setHorizontalAlignment(2);
        this.structureViewerPathLabel.setText(MessageManager.formatMessage("label.viewer_path", "Chimera(X)"));
        this.structureViewerPathLabel.setBounds(new Rectangle(10, ypos += 25, 170, 22));
        this.structureViewerPathLabel.setEnabled(false);
        this.structureTab.add(this.structureViewerPathLabel);
        this.structureViewerPath.setFont(LABEL_FONT);
        this.structureViewerPath.setText("");
        this.structureViewerPath.setEnabled(false);
        String tooltip = JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.viewer_path_tip"));
        this.structureViewerPath.setToolTipText(tooltip);
        this.structureViewerPath.setBounds(new Rectangle(190, ypos, 290, 22));
        this.structureViewerPath.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String chosen;
                if (GPreferences.this.structureViewerPath.isEnabled() && e.getClickCount() == 2 && (chosen = GPreferences.this.openFileChooser()) != null) {
                    GPreferences.this.structureViewerPath.setText(chosen);
                }
            }
        });
        this.structureTab.add(this.structureViewerPath);
        ypos += 25;
        this.nwMapping.setFont(LABEL_FONT);
        this.nwMapping.setText(MessageManager.getString("label.nw_mapping"));
        this.siftsMapping.setFont(LABEL_FONT);
        this.siftsMapping.setText(MessageManager.getString("label.sifts_mapping"));
        this.mappingMethod.add(this.nwMapping);
        this.mappingMethod.add(this.siftsMapping);
        JPanel mappingPanel = new JPanel();
        mappingPanel.setFont(LABEL_FONT);
        TitledBorder mmTitledBorder = new TitledBorder(MessageManager.getString("label.mapping_method"));
        mmTitledBorder.setTitleFont(LABEL_FONT);
        mappingPanel.setBorder(mmTitledBorder);
        mappingPanel.setBounds(new Rectangle(10, ypos, 472, 45));
        mappingPanel.setLayout(new GridLayout());
        mappingPanel.add(this.nwMapping);
        mappingPanel.add(this.siftsMapping);
        this.structureTab.add(mappingPanel);
        ypos += 25;
        FTSDataColumnPreferences docFieldPref = new FTSDataColumnPreferences(FTSDataColumnPreferences.PreferenceSource.PREFERENCES, PDBFTSRestClient.getInstance());
        docFieldPref.setBounds(new Rectangle(10, ypos += 25, 470, 120));
        this.structureTab.add(docFieldPref);
        if (Platform.isJS()) {
            this.structureViewerPathLabel.setVisible(false);
            this.structureViewerPath.setVisible(false);
            viewerLabel.setVisible(false);
            this.structViewer.setVisible(false);
        }
        return this.structureTab;
    }

    protected void structureViewer_actionPerformed(String selectedItem) {
    }

    protected String openFileChooser() {
        String choice = null;
        JFileChooser chooser = new JFileChooser();
        if (Platform.isMac()) {
            chooser.putClientProperty("JFileChooser.appBundleIsTraversable", true);
        }
        chooser.setDialogTitle(MessageManager.getString("label.open_local_file"));
        chooser.setToolTipText(MessageManager.getString("action.open"));
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            choice = chooser.getSelectedFile().getPath();
        }
        return choice;
    }

    protected boolean validateStructure(FocusEvent e) {
        if (!this.validateStructure()) {
            e.getComponent().requestFocusInWindow();
            return false;
        }
        return true;
    }

    protected boolean validateStructure() {
        return false;
    }

    private JPanel initVisualTab() {
        JPanel visualTab = new JPanel();
        visualTab.setBorder(new TitledBorder(MessageManager.getString("action.open_new_alignment")));
        visualTab.setLayout(null);
        this.fullScreen.setFont(LABEL_FONT);
        this.fullScreen.setHorizontalAlignment(4);
        this.fullScreen.setHorizontalTextPosition(2);
        this.fullScreen.setText(MessageManager.getString("label.maximize_window"));
        this.quality.setEnabled(false);
        this.quality.setFont(LABEL_FONT);
        this.quality.setHorizontalAlignment(4);
        this.quality.setHorizontalTextPosition(2);
        this.quality.setSelected(true);
        this.quality.setText(MessageManager.getString("label.quality"));
        this.conservation.setEnabled(false);
        this.conservation.setFont(LABEL_FONT);
        this.conservation.setHorizontalAlignment(4);
        this.conservation.setHorizontalTextPosition(2);
        this.conservation.setSelected(true);
        this.conservation.setText(MessageManager.getString("label.conservation"));
        this.identity.setEnabled(false);
        this.identity.setFont(LABEL_FONT);
        this.identity.setHorizontalAlignment(4);
        this.identity.setHorizontalTextPosition(2);
        this.identity.setSelected(true);
        this.identity.setText(MessageManager.getString("label.consensus"));
        this.ssConsensus.setEnabled(false);
        this.ssConsensus.setFont(LABEL_FONT);
        this.ssConsensus.setHorizontalAlignment(4);
        this.ssConsensus.setHorizontalTextPosition(2);
        this.ssConsensus.setSelected(false);
        this.ssConsensus.setText(MessageManager.getString("label.ssConsensus"));
        this.showOccupancy.setFont(LABEL_FONT);
        this.showOccupancy.setEnabled(false);
        this.showOccupancy.setHorizontalAlignment(4);
        this.showOccupancy.setHorizontalTextPosition(2);
        this.showOccupancy.setSelected(true);
        this.showOccupancy.setText(MessageManager.getString("label.occupancy"));
        JLabel showGroupbits = new JLabel();
        showGroupbits.setFont(LABEL_FONT);
        showGroupbits.setHorizontalAlignment(4);
        showGroupbits.setHorizontalTextPosition(2);
        showGroupbits.setText(MessageManager.getString("action.show_group") + ":");
        JLabel showConsensbits = new JLabel();
        showConsensbits.setFont(LABEL_FONT);
        showConsensbits.setHorizontalAlignment(4);
        showConsensbits.setHorizontalTextPosition(2);
        showConsensbits.setText(MessageManager.getString("label.consensus") + ":");
        this.showConsensHistogram.setEnabled(false);
        this.showConsensHistogram.setFont(LABEL_FONT);
        this.showConsensHistogram.setHorizontalAlignment(4);
        this.showConsensHistogram.setHorizontalTextPosition(2);
        this.showConsensHistogram.setSelected(true);
        this.showConsensHistogram.setText(MessageManager.getString("label.histogram"));
        this.showConsensLogo.setEnabled(false);
        this.showConsensLogo.setFont(LABEL_FONT);
        this.showConsensLogo.setHorizontalAlignment(4);
        this.showConsensLogo.setHorizontalTextPosition(2);
        this.showConsensLogo.setSelected(true);
        this.showConsensLogo.setText(MessageManager.getString("label.logo"));
        this.showGroupConsensus.setEnabled(false);
        this.showGroupConsensus.setFont(LABEL_FONT);
        this.showGroupConsensus.setHorizontalAlignment(4);
        this.showGroupConsensus.setHorizontalTextPosition(2);
        this.showGroupConsensus.setSelected(true);
        this.showGroupConsensus.setText(MessageManager.getString("label.consensus"));
        this.showGroupConservation.setEnabled(false);
        this.showGroupConservation.setFont(LABEL_FONT);
        this.showGroupConservation.setHorizontalAlignment(4);
        this.showGroupConservation.setHorizontalTextPosition(2);
        this.showGroupConservation.setSelected(true);
        this.showGroupConservation.setText(MessageManager.getString("label.conservation"));
        this.showNpTooltip.setEnabled(true);
        this.showNpTooltip.setFont(LABEL_FONT);
        this.showNpTooltip.setHorizontalAlignment(4);
        this.showNpTooltip.setHorizontalTextPosition(2);
        this.showNpTooltip.setSelected(true);
        this.showNpTooltip.setText(MessageManager.getString("label.non_positional_features"));
        this.showDbRefTooltip.setEnabled(true);
        this.showDbRefTooltip.setFont(LABEL_FONT);
        this.showDbRefTooltip.setHorizontalAlignment(4);
        this.showDbRefTooltip.setHorizontalTextPosition(2);
        this.showDbRefTooltip.setSelected(true);
        this.showDbRefTooltip.setText(MessageManager.getString("label.database_references"));
        this.annotations.setFont(LABEL_FONT);
        this.annotations.setHorizontalAlignment(4);
        this.annotations.setHorizontalTextPosition(2);
        this.annotations.setSelected(true);
        this.annotations.setText(MessageManager.getString("label.show_annotations"));
        this.annotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.annotations_actionPerformed(e);
            }
        });
        this.identity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.annotations_actionPerformed(e);
            }
        });
        this.showGroupConsensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.annotations_actionPerformed(e);
            }
        });
        this.showUnconserved.setFont(LABEL_FONT);
        this.showUnconserved.setHorizontalAlignment(4);
        this.showUnconserved.setHorizontalTextPosition(2);
        this.showUnconserved.setSelected(true);
        this.showUnconserved.setText(MessageManager.getString("action.show_unconserved"));
        this.showUnconserved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.showunconserved_actionPerformed(e);
            }
        });
        this.seqLimit.setFont(LABEL_FONT);
        this.seqLimit.setHorizontalAlignment(4);
        this.seqLimit.setHorizontalTextPosition(2);
        this.seqLimit.setText(MessageManager.getString("label.full_sequence_id"));
        this.smoothFont.setFont(LABEL_FONT);
        this.smoothFont.setHorizontalAlignment(4);
        this.smoothFont.setHorizontalTextPosition(10);
        this.smoothFont.setText(MessageManager.getString("label.smooth_font"));
        this.scaleProteinToCdna.setFont(LABEL_FONT);
        this.scaleProteinToCdna.setHorizontalAlignment(4);
        this.scaleProteinToCdna.setHorizontalTextPosition(10);
        this.scaleProteinToCdna.setText(MessageManager.getString("label.scale_protein_to_cdna"));
        this.scaleProteinToCdna.setToolTipText(MessageManager.getString("label.scale_protein_to_cdna_tip"));
        JLabel gapLabel = new JLabel();
        gapLabel.setFont(LABEL_FONT);
        gapLabel.setHorizontalAlignment(4);
        gapLabel.setText(MessageManager.getString("label.gap_symbol") + " ");
        JLabel fontLabel = new JLabel();
        fontLabel.setFont(LABEL_FONT);
        fontLabel.setHorizontalAlignment(4);
        fontLabel.setText(MessageManager.getString("label.font"));
        this.fontSizeCB.setFont(LABEL_FONT);
        this.fontSizeCB.setBounds(new Rectangle(320, 112, 65, 23));
        this.fontStyleCB.setFont(LABEL_FONT);
        this.fontStyleCB.setBounds(new Rectangle(382, 112, 80, 23));
        this.fontNameCB.setFont(LABEL_FONT);
        this.fontNameCB.setBounds(new Rectangle(172, 112, 147, 23));
        this.gapSymbolCB.setFont(LABEL_FONT);
        this.gapSymbolCB.setBounds(new Rectangle(172, 215, 69, 23));
        DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
        dlcr.setHorizontalAlignment(0);
        this.gapSymbolCB.setRenderer(dlcr);
        this.startupCheckbox.setText(MessageManager.getString("action.open_file"));
        this.startupCheckbox.setFont(LABEL_FONT);
        this.startupCheckbox.setHorizontalAlignment(4);
        this.startupCheckbox.setHorizontalTextPosition(2);
        this.startupCheckbox.setSelected(true);
        this.startupFileTextfield.setFont(LABEL_FONT);
        this.startupFileTextfield.setBounds(new Rectangle(172, 310, 330, 20));
        String tooltip = JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.double_click_to_browse"));
        this.startupFileTextfield.setToolTipText(tooltip);
        this.startupFileTextfield.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    GPreferences.this.startupFileTextfield_mouseClicked();
                }
            }
        });
        this.sortby.setFont(LABEL_FONT);
        this.sortby.setBounds(new Rectangle(172, 260, 155, 21));
        JLabel sortLabel = new JLabel();
        sortLabel.setFont(LABEL_FONT);
        sortLabel.setHorizontalAlignment(4);
        sortLabel.setText(MessageManager.getString("label.sort_by"));
        this.sortAnnBy.setFont(LABEL_FONT);
        this.sortAnnBy.setBounds(new Rectangle(172, 285, 110, 21));
        JLabel sortAnnLabel = new JLabel();
        sortAnnLabel.setFont(LABEL_FONT);
        sortAnnLabel.setHorizontalAlignment(4);
        sortAnnLabel.setText(MessageManager.getString("label.sort_ann_by"));
        this.sortAutocalc.setFont(LABEL_FONT);
        this.sortAutocalc.setBounds(new Rectangle(290, 285, 165, 21));
        JPanel annsettingsPanel = new JPanel();
        annsettingsPanel.setBounds(new Rectangle(173, 13, 320, 101));
        annsettingsPanel.setLayout(new FlowLayout(0, 0, 0));
        annsettingsPanel.setBorder(new EtchedBorder());
        visualTab.add(annsettingsPanel);
        EmptyBorder jb = new EmptyBorder(1, 1, 4, 5);
        this.annotations.setBorder(jb);
        this.showOccupancy.setBorder(jb);
        this.quality.setBorder(jb);
        this.conservation.setBorder(jb);
        this.identity.setBorder(jb);
        this.ssConsensus.setBorder(jb);
        showConsensbits.setBorder(jb);
        showGroupbits.setBorder(jb);
        this.showGroupConsensus.setBorder(jb);
        this.showGroupConservation.setBorder(jb);
        this.showConsensHistogram.setBorder(jb);
        this.showConsensLogo.setBorder(jb);
        JPanel autoAnnotSettings = new JPanel();
        annsettingsPanel.add(autoAnnotSettings);
        autoAnnotSettings.setLayout(new GridLayout(0, 2));
        autoAnnotSettings.add(this.annotations);
        autoAnnotSettings.add(this.quality);
        autoAnnotSettings = new JPanel();
        annsettingsPanel.add(autoAnnotSettings);
        autoAnnotSettings.setLayout(new GridLayout(0, 1));
        autoAnnotSettings.add(this.ssConsensus);
        autoAnnotSettings = new JPanel();
        annsettingsPanel.add(autoAnnotSettings);
        autoAnnotSettings.setLayout(new GridLayout(0, 3));
        autoAnnotSettings.add(this.conservation);
        autoAnnotSettings.add(this.identity);
        autoAnnotSettings.add(this.showOccupancy);
        autoAnnotSettings.add(showGroupbits);
        autoAnnotSettings.add(this.showGroupConservation);
        autoAnnotSettings.add(this.showGroupConsensus);
        autoAnnotSettings.add(showConsensbits);
        autoAnnotSettings.add(this.showConsensHistogram);
        autoAnnotSettings.add(this.showConsensLogo);
        JPanel tooltipSettings = new JPanel();
        tooltipSettings.setBorder(new TitledBorder(MessageManager.getString("label.sequence_id_tooltip")));
        tooltipSettings.setBounds(173, 140, 220, 62);
        tooltipSettings.setLayout(new GridLayout(2, 1));
        tooltipSettings.add(this.showDbRefTooltip);
        tooltipSettings.add(this.showNpTooltip);
        visualTab.add(tooltipSettings);
        this.wrap.setFont(LABEL_FONT);
        this.wrap.setHorizontalAlignment(11);
        this.wrap.setHorizontalTextPosition(10);
        this.wrap.setText(MessageManager.getString("label.wrap_alignment"));
        this.rightAlign.setFont(LABEL_FONT);
        this.rightAlign.setForeground(Color.black);
        this.rightAlign.setHorizontalAlignment(4);
        this.rightAlign.setHorizontalTextPosition(2);
        this.rightAlign.setText(MessageManager.getString("label.right_align_ids"));
        this.idItalics.setFont(LABEL_FONT_ITALIC);
        this.idItalics.setHorizontalAlignment(4);
        this.idItalics.setHorizontalTextPosition(10);
        this.idItalics.setText(MessageManager.getString("label.sequence_name_italics"));
        this.openoverv.setFont(LABEL_FONT);
        this.openoverv.setActionCommand(MessageManager.getString("label.open_overview"));
        this.openoverv.setHorizontalAlignment(4);
        this.openoverv.setHorizontalTextPosition(2);
        this.openoverv.setText(MessageManager.getString("label.open_overview"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBounds(new Rectangle(7, 17, 158, 310));
        jPanel2.setLayout(new GridLayout(14, 1));
        jPanel2.add(this.fullScreen);
        jPanel2.add(this.openoverv);
        jPanel2.add(this.seqLimit);
        jPanel2.add(this.rightAlign);
        jPanel2.add(fontLabel);
        jPanel2.add(this.showUnconserved);
        jPanel2.add(this.idItalics);
        jPanel2.add(this.smoothFont);
        jPanel2.add(this.scaleProteinToCdna);
        jPanel2.add(gapLabel);
        jPanel2.add(this.wrap);
        jPanel2.add(sortLabel);
        jPanel2.add(sortAnnLabel);
        jPanel2.add(this.startupCheckbox);
        visualTab.add(jPanel2);
        visualTab.add(this.startupFileTextfield);
        visualTab.add(this.sortby);
        visualTab.add(this.sortAnnBy);
        visualTab.add(this.sortAutocalc);
        visualTab.add(this.gapSymbolCB);
        visualTab.add(this.fontNameCB);
        visualTab.add(this.fontSizeCB);
        visualTab.add(this.fontStyleCB);
        if (Platform.isJS()) {
            this.startupCheckbox.setVisible(false);
            this.startupFileTextfield.setVisible(false);
        }
        return visualTab;
    }

    protected void loadLastSavedBackupsOptions() {
        BackupFilesPresetEntry savedPreset = BackupFilesPresetEntry.getSavedBackupEntry();
        this.enableBackupFiles.setSelected(Cache.getDefault("BACKUPFILES_ENABLED", !Platform.isJS()));
        BackupFilesPresetEntry backupfilesCustomEntry = BackupFilesPresetEntry.createBackupFilesPresetEntry(Cache.getDefault("BACKUPFILES_CUSTOM", null));
        if (backupfilesCustomEntry == null) {
            backupfilesCustomEntry = BackupFilesPresetEntry.backupfilesPresetEntriesValues.get(1);
        }
        BackupFilesPresetEntry.backupfilesPresetEntriesValues.put(0, backupfilesCustomEntry);
        this.setComboIntStringKey(this.backupfilesPresetsCombo, Cache.getDefault("BACKUPFILES_PRESET", 1));
        this.backupsSetOptions(savedPreset);
        this.backupsOptionsSetEnabled();
        this.updateBackupFilesExampleLabel();
    }

    protected void loadLastSavedMemorySettings() {
        this.customiseMemorySetting.setSelected(Cache.getDefault("MEMORY_CUSTOMISED_SETTINGS", false));
        this.jvmMemoryPercentSlider.setValue(Cache.getDefault(MemorySetting.MEMORY_JVMMEMPC, 90));
        this.jvmMemoryMaxTextField.setText(Cache.getDefault(MemorySetting.MEMORY_JVMMEMMAX, "32g"));
    }

    private boolean warnAboutSuffixReverseChange() {
        BackupFilesPresetEntry bfpe = BackupFilesPresetEntry.getSavedBackupEntry();
        boolean savedSuffixReverse = bfpe.reverse;
        int savedSuffixDigits = bfpe.digits;
        String savedSuffixTemplate = bfpe.suffix;
        boolean nowSuffixReverse = this.suffixReverse.isSelected();
        int nowSuffixDigits = GPreferences.getSpinnerInt(this.suffixDigitsSpinner, 3);
        String nowSuffixTemplate = this.suffixTemplate.getText();
        return nowSuffixReverse != savedSuffixReverse && nowSuffixDigits == savedSuffixDigits && nowSuffixTemplate != null && nowSuffixTemplate.equals(savedSuffixTemplate);
    }

    private JPanel initStartupTab() {
        JPanel startupTab = new JPanel();
        startupTab.setBorder(new TitledBorder(MessageManager.getString("label.memory")));
        startupTab.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 23;
        gbc.fill = 0;
        this.initMemoryPanel();
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.gridy = 0;
        gbc.gridx = 0;
        JLabel memoryText = new JLabel();
        memoryText.setFont(LABEL_FONT_ITALIC);
        memoryText.setText(MessageManager.getString("label.memory_setting_text"));
        startupTab.add((Component)memoryText, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        JPanel exampleMemoryPanel = new JPanel();
        exampleMemoryPanel.setLayout(new BoxLayout(exampleMemoryPanel, 1));
        exampleMemoryPanel.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.memory_example_tooltip")));
        JLabel exampleTextLabel = new JLabel();
        exampleTextLabel.setText(MessageManager.getString("label.memory_example_text"));
        exampleTextLabel.setForeground(Color.GRAY);
        exampleTextLabel.setFont(LABEL_FONT);
        exampleMemoryPanel.add(exampleTextLabel);
        exampleMemoryPanel.add(this.exampleMemoryLabel);
        exampleMemoryPanel.setBackground(Color.WHITE);
        exampleMemoryPanel.setBorder(BorderFactory.createEtchedBorder());
        startupTab.add((Component)exampleMemoryPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        startupTab.add((Component)this.customiseMemorySetting, gbc);
        gbc.gridy += 2;
        gbc.gridx = 0;
        startupTab.add((Component)this.maxMemoryLabel, gbc);
        gbc.gridy += 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        startupTab.add((Component)this.jvmMemoryPercentLabel, gbc);
        ++gbc.gridx;
        startupTab.add((Component)this.jvmMemoryPercentSlider, gbc);
        ++gbc.gridx;
        startupTab.add((Component)this.jvmMemoryPercentDisplay, gbc);
        gbc.gridwidth = 3;
        ++gbc.gridy;
        gbc.gridx = 0;
        startupTab.add((Component)this.jvmMemoryMaxLabel, gbc);
        ++gbc.gridx;
        startupTab.add((Component)this.jvmMemoryMaxTextField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        this.exampleMemoryMessageTextArea.setBackground(startupTab.getBackground());
        JScrollPane sp = new JScrollPane(this.exampleMemoryMessageTextArea);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(21);
        startupTab.add((Component)sp, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.gridx = 100;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        startupTab.add((Component)new JPanel(), gbc);
        this.setMemoryPercentDisplay();
        this.memoryOptionsSetEnabled();
        return startupTab;
    }

    private void initMemoryPanel() {
        this.customiseMemorySetting.setFont(LABEL_FONT_BOLD);
        this.customiseMemorySetting.setText(MessageManager.getString("label.customise_memory_settings"));
        this.customiseMemorySetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.memoryOptionsSetEnabled();
            }
        });
        this.loadLastSavedMemorySettings();
        this.exampleMemoryLabel.setFont(LABEL_FONT_BOLD);
        this.exampleMemoryLabel.setBackground(Color.WHITE);
        this.maxMemoryLabel = new JLabel(MessageManager.getString("label.maximum_memory_used"));
        this.maxMemoryLabel.setFont(LABEL_FONT_BOLD);
        this.jvmMemoryPercentLabel.setFont(LABEL_FONT);
        this.jvmMemoryPercentLabel.setText(MessageManager.getString("label.percent_of_physical_memory"));
        this.jvmMemoryPercentSlider.setPaintLabels(true);
        this.jvmMemoryPercentSlider.setPaintTicks(true);
        this.jvmMemoryPercentSlider.setPaintTrack(true);
        this.jvmMemoryPercentSlider.setMajorTickSpacing(50);
        this.jvmMemoryPercentSlider.setMinorTickSpacing(10);
        this.jvmMemoryPercentSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GPreferences.this.setMemoryPercentDisplay();
            }
        });
        this.jvmMemoryPercentDisplay.setFont(LABEL_FONT);
        this.setMemoryPercentDisplay();
        this.jvmMemoryMaxLabel.setFont(LABEL_FONT);
        this.jvmMemoryMaxLabel.setText(MessageManager.getString("label.maximum_memory"));
        this.initMemoryMaxTextField();
        this.exampleMemoryMessageTextArea.setFont(LABEL_FONT_ITALIC);
        this.exampleMemoryMessageTextArea.setForeground(Color.GRAY);
        this.exampleMemoryMessageTextArea.setEditable(false);
        this.exampleMemoryMessageTextArea.setLineWrap(true);
        this.exampleMemoryMessageTextArea.setWrapStyleWord(true);
        this.exampleMemoryMessageTextArea.setText(" ");
        this.exampleMemoryMessageTextArea.setRows(2);
        this.exampleMemoryMessageTextArea.setColumns(40);
        this.setExampleMemoryLabel();
    }

    private void initMemoryMaxTextField() {
        this.jvmMemoryMaxTextField.setToolTipText(MessageManager.getString("label.maximum_memory_tooltip"));
        this.jvmMemoryMaxTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GPreferences.this.validateMemoryMaxTextField();
                GPreferences.this.setExampleMemoryLabel();
            }
        });
        this.jvmMemoryMaxTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                GPreferences.this.validateMemoryMaxTextField();
                GPreferences.this.setExampleMemoryLabel();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char c = Character.toLowerCase(e.getKeyChar());
                String text = GPreferences.this.jvmMemoryMaxTextField.getText();
                String suffixes = "tgmkb";
                int pos = GPreferences.this.jvmMemoryMaxTextField.getCaretPosition();
                int suffixPos = StringUtils.firstCharPosIgnoreCase(text, suffixes);
                if (('0' > c || c > '9' || suffixPos != -1 && pos > suffixPos) && (suffixes.indexOf(Character.toLowerCase(c)) < 0 || pos != text.length() || suffixPos != -1)) {
                    e.consume();
                }
            }
        });
    }

    private boolean isMemoryMaxTextFieldValid() {
        return MemorySetting.isValidMemoryString(this.jvmMemoryMaxTextField.getText());
    }

    private void validateMemoryMaxTextField() {
        if (this.isMemoryMaxTextFieldValid()) {
            this.jvmMemoryMaxTextField.setBackground(Color.WHITE);
        } else {
            this.jvmMemoryMaxTextField.setBackground(Color.PINK);
        }
    }

    private void setMemoryPercentDisplay() {
        this.jvmMemoryPercentDisplay.setText(this.jvmMemoryPercentSlider.getValue() + "%");
        this.setExampleMemoryLabel();
    }

    private void setExampleMemoryLabel() {
        boolean selected = this.customiseMemorySetting.isSelected();
        int jvmmempc = this.jvmMemoryPercentSlider.getValue();
        String jvmmemmax = this.jvmMemoryMaxTextField.getText();
        long mem = selected && 0 <= jvmmempc && jvmmempc <= 100 && MemorySetting.isValidMemoryString(jvmmemmax) ? MemorySetting.getMemorySetting(jvmmemmax, String.valueOf(jvmmempc), false, true) : MemorySetting.getMemorySetting(null, null, false, true);
        this.exampleMemoryLabel.setText(MemorySetting.memoryLongToString(mem));
        String message = MemorySetting.getAdjustmentMessage();
        this.exampleMemoryMessageTextArea.setText(MessageManager.getString("label.adjustments_for_this_computer") + ": " + (message == null ? MessageManager.getString("label.none") : message));
    }

    private void memoryOptionsSetEnabled() {
        boolean enabled = this.customiseMemorySetting.isSelected();
        this.maxMemoryLabel.setEnabled(enabled);
        this.jvmMemoryPercentLabel.setEnabled(enabled);
        this.jvmMemoryPercentSlider.setEnabled(enabled);
        this.jvmMemoryPercentDisplay.setEnabled(enabled);
        this.jvmMemoryMaxLabel.setEnabled(enabled);
        this.jvmMemoryMaxTextField.setEnabled(enabled);
        this.exampleMemoryMessageTextArea.setEnabled(enabled);
        this.setExampleMemoryLabel();
    }

    private JPanel initBackupsTab() {
        JPanel backupsTab = new JPanel();
        backupsTab.setBorder(new TitledBorder(MessageManager.getString("label.backup_files")));
        backupsTab.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 23;
        gbc.fill = 0;
        this.initBackupsTabPresetsPanel();
        this.initBackupsTabSuffixPanel();
        this.initBackupsTabKeepFilesPanel();
        this.initBackupsTabFilenameExamplesPanel();
        this.enableBackupFiles.setFont(LABEL_FONT_BOLD);
        this.enableBackupFiles.setText(MessageManager.getString("label.enable_backupfiles"));
        this.enableBackupFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.backupsOptionsSetEnabled();
            }
        });
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        backupsTab.add((Component)this.enableBackupFiles, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 24;
        gbc.fill = 1;
        backupsTab.add((Component)this.exampleFilesPanel, gbc);
        gbc.gridheight = 1;
        gbc.anchor = 23;
        gbc.fill = 0;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        backupsTab.add((Component)new JPanel(), gbc);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        backupsTab.add((Component)this.presetsPanel, gbc);
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        backupsTab.add((Component)this.keepfilesPanel, gbc);
        ++gbc.gridy;
        backupsTab.add((Component)this.suffixPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        backupsTab.add((Component)new JPanel(), gbc);
        this.backupsOptionsSetEnabled();
        return backupsTab;
    }

    private JPanel initBackupsTabPresetsPanel() {
        String title = MessageManager.getString("label.schemes");
        this.presetsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 512;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.presetsComboLabel = new JLabel(title + ":");
        this.presetsPanel.add((Component)this.presetsComboLabel, gbc);
        List<Object> entries = Arrays.asList((Object[])BackupFilesPresetEntry.backupfilesPresetEntries);
        List<String> tooltips = Arrays.asList(BackupFilesPresetEntry.backupfilesPresetEntryDescriptions);
        this.backupfilesPresetsCombo = JvSwingUtils.buildComboWithTooltips(entries, tooltips);
        this.backupfilesPresetsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int key = GPreferences.this.getComboIntStringKey(GPreferences.this.backupfilesPresetsCombo);
                if (!GPreferences.this.customiseCheckbox.isSelected()) {
                    GPreferences.this.backupfilesPresetsComboLastSelected = key;
                }
                if (key == 0) {
                    if (GPreferences.this.customiseCheckbox.isSelected()) {
                        GPreferences.this.backupfilesCustomOptionsSetEnabled();
                    } else {
                        GPreferences.this.backupsTabUpdatePresets();
                        GPreferences.this.backupfilesCustomOptionsSetEnabled();
                    }
                } else {
                    GPreferences.this.customiseCheckbox.setSelected(false);
                    GPreferences.this.backupsTabUpdatePresets();
                    GPreferences.this.backupfilesCustomOptionsSetEnabled();
                }
            }
        });
        gbc.gridx = 1;
        this.presetsPanel.add(this.backupfilesPresetsCombo, gbc);
        this.revertButton.setText(MessageManager.getString("label.cancel_changes"));
        this.revertButton.setToolTipText(MessageManager.getString("label.cancel_changes_description"));
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.backupsSetOptions(BackupFilesPresetEntry.backupfilesPresetEntriesValues.get(0));
                GPreferences.this.backupfilesCustomOptionsSetEnabled();
            }
        });
        this.revertButton.setFont(LABEL_FONT);
        this.customiseCheckbox.setFont(LABEL_FONT);
        this.customiseCheckbox.setText(MessageManager.getString("label.customise"));
        this.customiseCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currently = GPreferences.this.getComboIntStringKey(GPreferences.this.backupfilesPresetsCombo);
                if (GPreferences.this.customiseCheckbox.isSelected()) {
                    GPreferences.this.backupfilesPresetsComboLastSelected = currently;
                    GPreferences.this.setComboIntStringKey(GPreferences.this.backupfilesPresetsCombo, 0);
                } else {
                    GPreferences.this.setComboIntStringKey(GPreferences.this.backupfilesPresetsCombo, GPreferences.this.backupfilesPresetsComboLastSelected);
                }
                GPreferences.this.backupfilesCustomOptionsSetEnabled();
            }
        });
        this.customiseCheckbox.setToolTipText(MessageManager.getString("label.customise_description"));
        gbc.gridx = 0;
        ++gbc.gridy;
        this.presetsPanel.add((Component)this.customiseCheckbox, gbc);
        gbc.gridx = 1;
        this.presetsPanel.add((Component)this.revertButton, gbc);
        return this.presetsPanel;
    }

    private JPanel initBackupsTabFilenameExamplesPanel() {
        String title = MessageManager.getString("label.scheme_examples");
        TitledBorder tb = new TitledBorder(title);
        this.exampleFilesPanel.setBorder(tb);
        this.exampleFilesPanel.setLayout(new GridBagLayout());
        this.backupfilesExampleLabel.setEditable(false);
        this.backupfilesExampleLabel.setBackground(this.exampleFilesPanel.getBackground());
        this.updateBackupFilesExampleLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 23;
        this.exampleFilesPanel.add((Component)this.backupfilesExampleLabel, gbc);
        return this.exampleFilesPanel;
    }

    private void backupsTabUpdatePresets() {
        IntKeyStringValueEntry entry = (IntKeyStringValueEntry)this.backupfilesPresetsCombo.getSelectedItem();
        int key = entry.k;
        String value = entry.v;
        if (BackupFilesPresetEntry.backupfilesPresetEntriesValues.containsKey(key)) {
            this.backupsSetOptions(BackupFilesPresetEntry.backupfilesPresetEntriesValues.get(key));
        } else {
            Console.error("Preset '" + value + "' [key:" + key + "] not implemented");
        }
        this.updateBackupFilesExampleLabel();
    }

    protected int getComboIntStringKey(JComboBox<Object> backupfilesPresetsCombo2) {
        IntKeyStringValueEntry e;
        try {
            e = (IntKeyStringValueEntry)backupfilesPresetsCombo2.getSelectedItem();
        }
        catch (Exception ex) {
            Console.error("Problem casting Combo entry to IntKeyStringValueEntry.");
            e = null;
        }
        return e != null ? e.k : 0;
    }

    protected void setComboIntStringKey(JComboBox<Object> backupfilesPresetsCombo2, int key) {
        for (int i = 0; i < backupfilesPresetsCombo2.getItemCount(); ++i) {
            IntKeyStringValueEntry e;
            try {
                e = (IntKeyStringValueEntry)backupfilesPresetsCombo2.getItemAt(i);
            }
            catch (Exception ex) {
                Console.error("Problem casting Combo entry to IntKeyStringValueEntry. Skipping item. ");
                continue;
            }
            if (e.k != key) continue;
            backupfilesPresetsCombo2.setSelectedIndex(i);
            break;
        }
    }

    private JPanel initBackupsTabSuffixPanel() {
        this.suffixPanel.setBorder(new TitledBorder(MessageManager.getString("label.backup_filename_strategy")));
        this.suffixPanel.setLayout(new GridBagLayout());
        this.suffixTemplateLabel.setText(MessageManager.getString("label.append_to_filename"));
        this.suffixTemplateLabel.setHorizontalAlignment(2);
        this.suffixTemplateLabel.setFont(LABEL_FONT);
        String tooltip = JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.append_to_filename_tooltip"));
        this.suffixTemplate.setToolTipText(tooltip);
        this.suffixTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.updateBackupFilesExampleLabel();
                GPreferences.this.backupfilesCustomOptionsSetEnabled();
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
            }
        });
        this.suffixTemplate.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                GPreferences.this.updateBackupFilesExampleLabel();
                GPreferences.this.backupfilesCustomOptionsSetEnabled();
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == ':' || c == '/' || c == '\\') {
                    e.consume();
                }
            }
        });
        this.suffixDigitsLabel.setText(MessageManager.getString("label.index_digits"));
        this.suffixDigitsLabel.setHorizontalAlignment(2);
        this.suffixDigitsLabel.setFont(LABEL_FONT);
        ChangeListener c = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
                GPreferences.this.updateBackupFilesExampleLabel();
            }
        };
        this.setIntegerSpinner(this.suffixDigitsSpinner, 1, 6, 3, c);
        this.suffixReverse.setLabels(MessageManager.getString("label.reverse_roll"), MessageManager.getString("label.increment_index"));
        this.suffixReverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean okay = true;
                if (GPreferences.this.warnAboutSuffixReverseChange()) {
                    okay = GPreferences.this.confirmSuffixReverseChange();
                }
                if (okay) {
                    GPreferences.this.backupfilesRevertButtonSetEnabled(true);
                    GPreferences.this.updateBackupFilesExampleLabel();
                } else {
                    boolean savedSuffixReverse = BackupFilesPresetEntry.getSavedBackupEntry().reverse;
                    GPreferences.this.suffixReverse.setSelected(savedSuffixReverse);
                }
            }
        });
        GridBagConstraints sgbc = new GridBagConstraints();
        sgbc.anchor = 17;
        sgbc.gridx = 0;
        sgbc.gridy = 0;
        sgbc.gridwidth = 1;
        sgbc.gridheight = 1;
        sgbc.weightx = 1.0;
        sgbc.weighty = 0.0;
        sgbc.fill = 0;
        this.suffixPanel.add((Component)this.suffixTemplateLabel, sgbc);
        sgbc.gridx = 1;
        sgbc.fill = 2;
        this.suffixPanel.add((Component)this.suffixTemplate, sgbc);
        sgbc.gridy = 1;
        sgbc.gridx = 0;
        sgbc.fill = 0;
        this.suffixPanel.add((Component)this.suffixDigitsLabel, sgbc);
        sgbc.gridx = 1;
        sgbc.fill = 2;
        this.suffixPanel.add((Component)this.suffixDigitsSpinner, sgbc);
        sgbc.gridx = 0;
        sgbc.gridy = 2;
        sgbc.gridwidth = 0;
        sgbc.fill = 2;
        this.suffixPanel.add((Component)this.suffixReverse.getFalseButton(), sgbc);
        sgbc.gridy = 3;
        this.suffixPanel.add((Component)this.suffixReverse.getTrueButton(), sgbc);
        return this.suffixPanel;
    }

    private boolean confirmSuffixReverseChange() {
        boolean ret = false;
        String warningMessage = MessageManager.getString("label.warning_confirm_change_reverse");
        int confirm = JvOptionPane.showConfirmDialog(Desktop.desktop, warningMessage, MessageManager.getString("label.change_increment_decrement"), 0, 2);
        ret = confirm == 0;
        return ret;
    }

    private JPanel initBackupsTabKeepFilesPanel() {
        this.keepfilesPanel.setBorder(new TitledBorder(MessageManager.getString("label.keep_files")));
        this.keepfilesPanel.setLayout(new GridBagLayout());
        this.backupfilesKeepAll.setLabels(MessageManager.getString("label.keep_all_backup_files"), MessageManager.getString("label.keep_only_this_number_of_backup_files"));
        this.backupfilesKeepAll.addTrueActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
                GPreferences.this.updateBackupFilesExampleLabel();
            }
        });
        this.backupfilesKeepAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
                GPreferences.this.keepRollMaxOptionsEnabled();
                GPreferences.this.updateBackupFilesExampleLabel();
            }
        });
        ChangeListener c = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
                GPreferences.this.updateBackupFilesExampleLabel();
            }
        };
        this.setIntegerSpinner(this.backupfilesRollMaxSpinner, 1, 999, 4, true, c);
        this.backupfilesConfirmDelete.setLabels(MessageManager.getString("label.always_ask"), MessageManager.getString("label.auto_delete"));
        this.backupfilesConfirmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPreferences.this.backupfilesRevertButtonSetEnabled(true);
            }
        });
        this.keepRollMaxOptionsEnabled();
        GridBagConstraints kgbc = new GridBagConstraints();
        kgbc.anchor = 17;
        kgbc.gridx = 0;
        kgbc.gridy = 0;
        kgbc.gridwidth = 0;
        kgbc.gridheight = 1;
        kgbc.weightx = 1.0;
        kgbc.weighty = 0.0;
        kgbc.fill = 2;
        this.keepfilesPanel.add((Component)this.backupfilesKeepAll.getTrueButton(), kgbc);
        kgbc.gridy = 1;
        kgbc.gridx = 0;
        kgbc.gridwidth = -1;
        this.keepfilesPanel.add((Component)this.backupfilesKeepAll.getFalseButton(), kgbc);
        kgbc.gridx = 1;
        kgbc.gridwidth = 0;
        this.keepfilesPanel.add((Component)this.backupfilesRollMaxSpinner, kgbc);
        kgbc.gridy = 2;
        kgbc.insets = new Insets(0, 20, 0, 0);
        kgbc.gridx = 0;
        kgbc.gridwidth = 0;
        kgbc.fill = 2;
        kgbc.weightx = 1.0;
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        this.oldBackupFilesLabel.setText(MessageManager.getString("label.autodelete_old_backup_files"));
        this.oldBackupFilesLabel.setFont(LABEL_FONT);
        this.oldBackupFilesLabel.setHorizontalAlignment(2);
        jp.add(this.oldBackupFilesLabel);
        jp.add(this.backupfilesConfirmDelete.getTrueButton());
        jp.add(this.backupfilesConfirmDelete.getFalseButton());
        this.keepfilesPanel.add((Component)jp, kgbc);
        return this.keepfilesPanel;
    }

    protected void updateBackupFilesExampleLabel() {
        int remainingLines;
        String oldest;
        String newest;
        int index;
        int max;
        int min;
        int exampleindex = 12;
        String base = MessageManager.getString("label.filename") + ".fa";
        if (base == null || base.length() == 0) {
            base = "file_name.fa";
        }
        boolean reverse = this.suffixReverse.isSelected();
        boolean keepAll = this.backupfilesKeepAll.isSelected();
        int rollMax = 4;
        String suffix = this.suffixTemplate.getText();
        int digits = 3;
        this.backupfilesExampleLabel.setFont(LABEL_FONT_ITALIC);
        if (suffix == null || suffix.length() == 0) {
            this.backupfilesExampleLabel.setText(MessageManager.getString("label.no_backup_files"));
            this.backupfilesExampleLabel.setFont(LABEL_FONT_BOLD);
            return;
        }
        rollMax = GPreferences.getSpinnerInt(this.backupfilesRollMaxSpinner, 4);
        int n = rollMax = rollMax < 1 ? 1 : rollMax;
        if (suffix.indexOf("%n") == -1) {
            rollMax = 1;
        }
        digits = (digits = GPreferences.getSpinnerInt(this.suffixDigitsSpinner, 3)) < 1 ? 1 : digits;
        int lowersurround = 2;
        int uppersurround = 0;
        StringBuilder exampleSB = new StringBuilder();
        boolean firstLine = true;
        int lineNumber = 0;
        if (reverse) {
            min = 1;
            max = keepAll ? exampleindex : rollMax;
            for (index = min; index <= max; ++index) {
                if (index == min + lowersurround && index < max - uppersurround - 1) {
                    exampleSB.append("\n...");
                    ++lineNumber;
                    continue;
                }
                if (index > min + lowersurround && index < max - uppersurround) continue;
                if (firstLine) {
                    firstLine = false;
                } else {
                    exampleSB.append("\n");
                    ++lineNumber;
                }
                exampleSB.append(BackupFilenameParts.getBackupFilename(index, base, suffix, digits));
                if (min == max) continue;
                if (index == min) {
                    newest = MessageManager.getString("label.braced_newest");
                    if (newest == null || newest.length() <= 0) continue;
                    exampleSB.append(" " + newest);
                    continue;
                }
                if (index != max || (oldest = MessageManager.getString("label.braced_oldest")) == null || oldest.length() <= 0) continue;
                exampleSB.append(" " + oldest);
            }
        } else {
            min = keepAll || exampleindex - rollMax < 0 ? 1 : exampleindex - rollMax + 1;
            max = exampleindex;
            for (index = min; index <= max; ++index) {
                if (index == min + lowersurround && index < max - uppersurround - 1) {
                    exampleSB.append("\n...");
                    ++lineNumber;
                    continue;
                }
                if (index > min + lowersurround && index < max - uppersurround) continue;
                if (firstLine) {
                    firstLine = false;
                } else {
                    exampleSB.append("\n");
                    ++lineNumber;
                }
                exampleSB.append(BackupFilenameParts.getBackupFilename(index, base, suffix, digits));
                if (min == max) continue;
                if (index == min) {
                    oldest = MessageManager.getString("label.braced_oldest");
                    if (oldest == null || oldest.length() <= 0) continue;
                    exampleSB.append(" " + oldest);
                    continue;
                }
                if (index != max || (newest = MessageManager.getString("label.braced_newest")) == null || newest.length() <= 0) continue;
                exampleSB.append(" " + newest);
            }
        }
        if ((remainingLines = lowersurround + uppersurround + 1 - lineNumber) > 0) {
            for (int i = 0; i < remainingLines; ++i) {
                exampleSB.append("\n ");
                ++lineNumber;
            }
        }
        this.backupfilesExampleLabel.setText(exampleSB.toString());
    }

    protected void setIntegerSpinner(JSpinner s, int min, int max, int def, boolean useExistingVal, ChangeListener c) {
        int i = def;
        if (useExistingVal) {
            try {
                i = (Integer)s.getValue();
            }
            catch (Exception e) {
                Console.error("Exception casting the initial value of s.getValue()");
            }
        }
        this.setIntegerSpinner(s, min, max, i, c);
    }

    protected void setIntegerSpinner(JSpinner s, int min, int max, int def, ChangeListener c) {
        if (def > max) {
            max = def;
        }
        if (def < min) {
            def = min;
        }
        SpinnerNumberModel sModel = new SpinnerNumberModel(def, min, max, 1);
        s.setModel(sModel);
        s.addChangeListener(c);
    }

    protected static int getSpinnerInt(JSpinner s, int def) {
        int i = def;
        try {
            s.commitEdit();
            i = (Integer)s.getValue();
        }
        catch (Exception e) {
            Console.error("Failed casting (Integer) JSpinner s.getValue()");
        }
        return i;
    }

    private void keepRollMaxOptionsEnabled() {
        boolean enabled = this.backupfilesKeepAll.isEnabled() && !this.backupfilesKeepAll.isSelected();
        this.oldBackupFilesLabel.setEnabled(enabled);
        this.backupfilesRollMaxSpinner.setEnabled(enabled);
        this.backupfilesConfirmDelete.setEnabled(enabled);
    }

    private void backupfilesKeepAllSetEnabled(boolean tryEnabled) {
        boolean enabled = tryEnabled && this.enableBackupFiles.isSelected() && this.customiseCheckbox.isSelected() && this.suffixTemplate.getText().indexOf("%n") > -1;
        this.keepfilesPanel.setEnabled(enabled);
        this.backupfilesKeepAll.setEnabled(enabled);
        this.oldBackupFilesLabel.setEnabled(enabled);
        this.keepRollMaxOptionsEnabled();
    }

    private void backupfilesSuffixTemplateDigitsSetEnabled() {
        boolean enabled = this.suffixTemplate.isEnabled() && this.suffixTemplate.getText().indexOf("%n") > -1;
        this.suffixDigitsLabel.setEnabled(enabled);
        this.suffixDigitsSpinner.setEnabled(enabled);
        this.suffixReverse.setEnabled(enabled);
    }

    private void backupfilesSuffixTemplateSetEnabled(boolean tryEnabled) {
        boolean enabled = tryEnabled && this.enableBackupFiles.isSelected() && this.customiseCheckbox.isSelected();
        this.suffixPanel.setEnabled(enabled);
        this.suffixTemplateLabel.setEnabled(enabled);
        this.suffixTemplate.setEnabled(enabled);
        this.backupfilesSuffixTemplateDigitsSetEnabled();
    }

    private void backupfilesRevertButtonSetEnabled(boolean tryEnabled) {
        boolean enabled = tryEnabled && this.enableBackupFiles.isSelected() && this.customiseCheckbox.isSelected() && this.backupfilesCustomChanged();
        this.revertButton.setEnabled(enabled);
    }

    private boolean backupfilesCustomChanged() {
        BackupFilesPresetEntry current;
        BackupFilesPresetEntry custom = BackupFilesPresetEntry.backupfilesPresetEntriesValues.get(0);
        return !custom.equals(current = this.getBackupfilesCurrentEntry());
    }

    protected BackupFilesPresetEntry getBackupfilesCurrentEntry() {
        String suffix = this.suffixTemplate.getText();
        int digits = GPreferences.getSpinnerInt(this.suffixDigitsSpinner, 3);
        boolean reverse = this.suffixReverse.isSelected();
        boolean keepAll = this.backupfilesKeepAll.isSelected();
        int rollMax = GPreferences.getSpinnerInt(this.backupfilesRollMaxSpinner, 3);
        boolean confirmDelete = this.backupfilesConfirmDelete.isSelected();
        BackupFilesPresetEntry bfpe = new BackupFilesPresetEntry(suffix, digits, reverse, keepAll, rollMax, confirmDelete);
        return bfpe;
    }

    protected void backupfilesCustomOptionsSetEnabled() {
        boolean enabled = this.customiseCheckbox.isSelected();
        this.backupfilesRevertButtonSetEnabled(enabled);
        this.backupfilesSuffixTemplateSetEnabled(enabled);
        this.backupfilesKeepAllSetEnabled(enabled);
    }

    private void backupfilesSummarySetEnabled() {
        boolean enabled = this.enableBackupFiles.isSelected();
        this.backupfilesExampleLabel.setEnabled(enabled);
        this.exampleFilesPanel.setEnabled(enabled);
    }

    private void backupfilesPresetsSetEnabled() {
        boolean enabled = this.enableBackupFiles.isSelected();
        this.presetsPanel.setEnabled(enabled);
        this.presetsComboLabel.setEnabled(enabled);
        this.backupfilesPresetsCombo.setEnabled(enabled);
        this.customiseCheckbox.setEnabled(enabled);
        this.revertButton.setEnabled(enabled);
    }

    protected void backupsOptionsSetEnabled() {
        this.backupfilesPresetsSetEnabled();
        this.backupfilesSummarySetEnabled();
        this.backupfilesCustomOptionsSetEnabled();
    }

    protected void backupsSetOptions(String suffix, int digits, boolean reverse, boolean keepAll, int rollMax, boolean confirmDelete) {
        this.suffixTemplate.setText(suffix);
        this.suffixDigitsSpinner.setValue(digits);
        this.suffixReverse.setSelected(reverse);
        this.backupfilesKeepAll.setSelected(keepAll);
        this.backupfilesRollMaxSpinner.setValue(rollMax);
        this.backupfilesConfirmDelete.setSelected(confirmDelete);
    }

    protected void backupsSetOptions(BackupFilesPresetEntry p) {
        this.backupsSetOptions(p.suffix, p.digits, p.reverse, p.keepAll, p.rollMax, p.confirmDelete);
    }

    protected void autoIdWidth_actionPerformed() {
    }

    protected void userIdWidth_actionPerformed() {
    }

    protected void maxColour_actionPerformed(JPanel panel) {
    }

    protected void minColour_actionPerformed(JPanel panel) {
    }

    protected void gapColour_actionPerformed(JPanel panel) {
    }

    protected void hiddenColour_actionPerformed(JPanel panel) {
    }

    protected void showunconserved_actionPerformed(ActionEvent e) {
    }

    protected void useLegacyGaps_actionPerformed(ActionEvent e) {
    }

    protected void resetOvDefaults_actionPerformed(ActionEvent e) {
    }

    public void ok_actionPerformed(ActionEvent e) {
    }

    public void cancel_actionPerformed(ActionEvent e) {
    }

    public void annotations_actionPerformed(ActionEvent e) {
    }

    public void startupFileTextfield_mouseClicked() {
    }

    public void newLink_actionPerformed(ActionEvent e) {
    }

    public void editLink_actionPerformed(ActionEvent e) {
    }

    public void deleteLink_actionPerformed(ActionEvent e) {
    }

    public void linkURLList_keyTyped(KeyEvent e) {
    }

    public void setProxyAuthEnabled() {
        boolean enabled = this.proxyAuth.isSelected() && this.proxyAuth.isEnabled();
        this.proxyAuthUsernameLabel.setEnabled(enabled);
        this.proxyAuthPasswordLabel.setEnabled(enabled);
        this.passwordNotStoredLabel.setEnabled(enabled);
        this.proxyAuthUsernameTB.setEnabled(enabled);
        this.proxyAuthPasswordPB.setEnabled(enabled);
    }

    public void setCustomProxyEnabled() {
        boolean enabled = this.customProxy.isSelected();
        this.portLabel.setEnabled(enabled);
        this.serverLabel.setEnabled(enabled);
        this.portLabel2.setEnabled(enabled);
        this.serverLabel2.setEnabled(enabled);
        this.httpLabel.setEnabled(enabled);
        this.httpsLabel.setEnabled(enabled);
        this.proxyServerHttpTB.setEnabled(enabled);
        this.proxyPortHttpTB.setEnabled(enabled);
        this.proxyServerHttpsTB.setEnabled(enabled);
        this.proxyPortHttpsTB.setEnabled(enabled);
        this.proxyAuth.setEnabled(enabled);
        this.setProxyAuthEnabled();
    }

    public void proxyType_actionPerformed() {
        this.setCustomProxyEnabled();
        this.proxyAuthPasswordCheckHighlight(true);
        this.applyProxyButtonEnabled(true);
    }

    public void proxyAuth_actionPerformed() {
        this.setProxyAuthEnabled();
        this.proxyAuthPasswordCheckHighlight(true);
        this.applyProxyButtonEnabled(true);
    }

    public class RadioButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JRadioButton button = new JRadioButton();

        public RadioButtonEditor() {
            this.button.setHorizontalAlignment(0);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RadioButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button.setSelected((Boolean)value);
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.isSelected();
        }
    }

    public class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        public RadioButtonRenderer() {
            this.setHorizontalAlignment(0);
            this.setToolTipText(MessageManager.getString("label.urltooltip"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected((Boolean)value);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    public static enum TabRef {
        CONNECTIONS_TAB,
        STRUCTURE_TAB;

    }
}

