/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.analysis.SequenceIdMatcher;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.Comparison;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TCoffeeScoreFile
extends AlignFile {
    static final Color[] colors = new Color[]{new Color(102, 102, 255), new Color(0, 255, 0), new Color(102, 255, 0), new Color(204, 255, 0), new Color(255, 255, 0), new Color(255, 204, 0), new Color(255, 153, 0), new Color(255, 102, 0), new Color(255, 51, 0), new Color(255, 34, 0)};
    public static final String TCOFFEE_SCORE = "TCoffeeScore";
    static Pattern SCORES_WITH_RESIDUE_NUMS = Pattern.compile("^\\d+\\s([^\\s]+)\\s+\\d+$");
    Header header;
    LinkedHashMap<String, StringBuilder> scores;
    Integer fWidth;

    public TCoffeeScoreFile(Object inFile, DataSourceType fileSourceType) throws IOException {
        super(inFile, fileSourceType);
    }

    public TCoffeeScoreFile(FileParse source) throws IOException {
        super(source);
    }

    public int getHeight() {
        return this.scores != null && this.scores.size() > 0 ? this.scores.size() - 1 : 0;
    }

    public int getWidth() {
        return this.fWidth != null ? this.fWidth : 0;
    }

    public String getScoresFor(String id) {
        return this.scores != null && this.scores.containsKey(id) ? this.scores.get(id).toString() : "";
    }

    public List<String> getScoresList() {
        if (this.scores == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(this.scores.size());
        for (Map.Entry<String, StringBuilder> it : this.scores.entrySet()) {
            result.add(it.getValue().toString());
        }
        return result;
    }

    public byte[][] getScoresArray() {
        if (this.scores == null) {
            return null;
        }
        byte[][] result = new byte[this.scores.size()][];
        int rowCount = 0;
        for (Map.Entry<String, StringBuilder> it : this.scores.entrySet()) {
            String line = it.getValue().toString();
            byte[] seqValues = new byte[line.length()];
            int c = line.length();
            for (int j = 0; j < c; ++j) {
                byte val = (byte)(line.charAt(j) - 48);
                seqValues[j] = val >= 0 && val <= 9 ? (int)val : -1;
            }
            result[rowCount++] = seqValues;
        }
        return result;
    }

    @Override
    public void parse() throws IOException {
        Block block;
        this.header = TCoffeeScoreFile.readHeader(this);
        if (this.header == null) {
            this.error = true;
            return;
        }
        this.scores = new LinkedHashMap();
        for (Map.Entry<String, Integer> entry : this.header.scores.entrySet()) {
            this.scores.put(entry.getKey(), new StringBuilder());
        }
        while ((block = TCoffeeScoreFile.readBlock(this, this.header.scores.size())) != null) {
            for (Map.Entry entry : block.items.entrySet()) {
                StringBuilder scoreStringBuilder = this.scores.get(entry.getKey());
                if (scoreStringBuilder == null) {
                    this.error = true;
                    this.errormessage = String.format("Invalid T-Coffee score file: Sequence ID '%s' is not declared in header section", entry.getKey());
                    return;
                }
                scoreStringBuilder.append((String)entry.getValue());
            }
        }
        for (StringBuilder stringBuilder : this.scores.values()) {
            if (this.fWidth == null) {
                this.fWidth = stringBuilder.length();
                continue;
            }
            if (this.fWidth.intValue() == stringBuilder.length()) continue;
            this.error = true;
            this.errormessage = "Invalid T-Coffee score file: All the score sequences must have the same length";
            return;
        }
    }

    static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static Header readHeader(FileParse reader) throws IOException {
        Header result = null;
        try {
            String line;
            result = new Header();
            result.head = reader.nextLine();
            while ((line = reader.nextLine()) != null) {
                if (!line.startsWith("SCORE=")) continue;
                result.score = TCoffeeScoreFile.parseInt(line.substring(6).trim());
                break;
            }
            if ((line = reader.nextLine()) == null || !"*".equals(line.trim())) {
                TCoffeeScoreFile.error(reader, "Invalid T-COFFEE score format (NO BAD/AVG/GOOD header)");
                return null;
            }
            line = reader.nextLine();
            if (line == null || !"BAD AVG GOOD".equals(line.trim())) {
                TCoffeeScoreFile.error(reader, "Invalid T-COFFEE score format (NO BAD/AVG/GOOD header)");
                return null;
            }
            line = reader.nextLine();
            if (line == null || !"*".equals(line.trim())) {
                TCoffeeScoreFile.error(reader, "Invalid T-COFFEE score format (NO BAD/AVG/GOOD header)");
                return null;
            }
            while ((line = reader.nextLine()) != null && !"".equals(line)) {
                int p = line.indexOf(":");
                if (p == -1) continue;
                String id = line.substring(0, p).trim();
                int val = TCoffeeScoreFile.parseInt(line.substring(p + 1).trim());
                if ("".equals(id)) continue;
                result.scores.put(id, val);
            }
            if (result == null) {
                TCoffeeScoreFile.error(reader, "T-COFFEE score file had no per-sequence scores");
            }
        }
        catch (IOException e) {
            TCoffeeScoreFile.error(reader, "Unexpected problem parsing T-Coffee score ascii file");
            throw e;
        }
        return result;
    }

    private static void error(FileParse reader, String errm) {
        reader.error = true;
        reader.errormessage = reader.errormessage == null ? errm : reader.errormessage + "\n" + errm;
    }

    static Block readBlock(FileParse reader, int size) throws IOException {
        String line;
        Block result = new Block(size);
        while ((line = reader.nextLine()) != null && "".equals(line.trim())) {
        }
        if (line == null) {
            return null;
        }
        while (!"".equals(line.trim())) {
            int p = line.indexOf(" ");
            if (p == -1) {
                if (reader.warningMessage == null) {
                    reader.warningMessage = "";
                }
                reader.warningMessage = reader.warningMessage + "Possible parsing error - expected to find a space in line: '" + line + "'\n";
            } else {
                String id = line.substring(0, p).trim();
                String val = line.substring(p + 1).trim();
                Matcher m = SCORES_WITH_RESIDUE_NUMS.matcher(val);
                if (m.matches()) {
                    val = m.group(1);
                }
                result.items.put(id, val);
            }
            if ((line = reader.nextLine()) != null) continue;
        }
        return result;
    }

    public boolean annotateAlignment(AlignmentI al, boolean matchids) {
        if (al.getHeight() != this.getHeight() || al.getWidth() != this.getWidth()) {
            String info = String.format("align w: %s, h: %s; score: w: %s; h: %s ", al.getWidth(), al.getHeight(), this.getWidth(), this.getHeight());
            this.warningMessage = "Alignment shape does not match T-Coffee score file shape -- " + info;
            return false;
        }
        boolean added = false;
        int i = 0;
        SequenceIdMatcher sidmatcher = new SequenceIdMatcher(al.getSequencesArray());
        byte[][] scoreMatrix = this.getScoresArray();
        for (Map.Entry<String, StringBuilder> id : this.scores.entrySet()) {
            byte[] srow = scoreMatrix[i];
            SequenceI s = matchids ? sidmatcher.findIdMatch(id.getKey()) : al.getSequenceAt(i);
            if (s == null && ++i != this.scores.size() && !id.getKey().equals("cons")) {
                System.err.println("No " + (matchids ? "match " : " sequences left ") + " for TCoffee score set : " + id.getKey());
                continue;
            }
            int jSize = al.getWidth() < srow.length ? al.getWidth() : srow.length;
            Annotation[] annotations = new Annotation[al.getWidth()];
            for (int j = 0; j < jSize; ++j) {
                byte val = srow[j];
                if (s != null && Comparison.isGap(s.getCharAt(j))) {
                    annotations[j] = null;
                    if (val <= 0) continue;
                    Console.errPrintln("Warning: non-zero value for positional T-COFFEE score for gap at " + j + " in sequence " + s.getName());
                    continue;
                }
                annotations[j] = new Annotation(s == null ? "" + val : null, s == null ? "" + val : null, '\u0000', (float)val * 1.0f, val >= 0 && val < colors.length ? colors[val] : Color.white);
            }
            AlignmentAnnotation aa = al.findOrCreateAnnotation(TCOFFEE_SCORE, TCOFFEE_SCORE, false, s, null);
            if (s != null) {
                aa.label = "T-COFFEE";
                aa.description = "" + id.getKey();
                aa.annotations = annotations;
                aa.visible = false;
                aa.belowAlignment = false;
                aa.setScore(this.header.getScoreFor(id.getKey()));
                aa.createSequenceMapping(s, s.getStart(), true);
                s.addAlignmentAnnotation(aa);
                aa.adjustForAlignment();
            } else {
                aa.graph = 0;
                aa.label = "T-COFFEE";
                aa.description = "TCoffee column reliability score";
                aa.annotations = annotations;
                aa.belowAlignment = true;
                aa.visible = true;
                aa.setScore(this.header.getScoreAvg());
            }
            aa.showAllColLabels = true;
            aa.validateRangeAndDisplay();
            added = true;
        }
        return added;
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        return "Not valid.";
    }

    static class Block {
        int size;
        Map<String, String> items;

        public Block(int size) {
            this.size = size;
            this.items = new HashMap<String, String>(size);
        }

        String getScoresFor(String id) {
            return this.items.get(id);
        }

        String getConsensus() {
            return this.items.get("cons");
        }
    }

    static class Header {
        String head;
        int score;
        LinkedHashMap<String, Integer> scores = new LinkedHashMap();

        Header() {
        }

        public int getScoreAvg() {
            return this.score;
        }

        public int getScoreFor(String ID) {
            return this.scores.containsKey(ID) ? this.scores.get(ID) : -1;
        }
    }
}

