/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.io.JPredFile;
import jalview.util.MessageManager;
import java.util.Locale;

public class JnetAnnotationMaker {
    public static void add_annotation(JPredFile prediction, AlignmentI al, int firstSeq, boolean noMsa) throws Exception {
        JnetAnnotationMaker.add_annotation(prediction, al, firstSeq, noMsa, null);
    }

    public static void add_annotation(JPredFile prediction, AlignmentI al, int firstSeq, boolean noMsa, int[] delMap) throws Exception {
        AlignmentAnnotation annot;
        int i = 0;
        SequenceI[] preds = prediction.getSeqsAsArray();
        SequenceI seqRef = al.getSequenceAt(firstSeq);
        int width = preds[0].getLength();
        int[] gapmap = al.getSequenceAt(firstSeq).gapMap();
        if (delMap != null && delMap.length > width || delMap == null && gapmap.length != width) {
            throw new Exception(MessageManager.formatMessage("exception.number_of_residues_in_query_sequence_differ_from_prediction", new String[]{delMap == null ? "" : MessageManager.getString("label.mapped"), al.getSequenceAt(firstSeq).getName(), al.getSequenceAt(firstSeq).getSequenceAsString(), Integer.valueOf(width).toString()}));
        }
        Annotation[] annotations = null;
        int existingAnnotations = 0;
        if (al.getAlignmentAnnotation() != null) {
            existingAnnotations = al.getAlignmentAnnotation().length;
        }
        Annotation[] sol = new Annotation[al.getWidth()];
        boolean firstsol = true;
        while (i < preds.length) {
            String id = preds[i].getName().toUpperCase(Locale.ROOT);
            if (id.startsWith("LUPAS") || id.startsWith("JNET") || id.startsWith("JPRED")) {
                if (id.startsWith("JNETSOL")) {
                    float amnt = id.endsWith("25") ? 3.0f : (id.endsWith("5") ? 6.0f : 9.0f);
                    for (int spos = 0; spos < width; ++spos) {
                        int sposw;
                        int n = sposw = delMap == null ? gapmap[spos] : gapmap[delMap[spos]];
                        if (firstsol) {
                            sol[sposw] = new Annotation(0.0f);
                        }
                        if (preds[i].getCharAt(spos) != 'B' || sol[sposw].value != 0.0f && !(sol[sposw].value < amnt)) continue;
                        sol[sposw].value = amnt;
                    }
                    firstsol = false;
                } else {
                    int j;
                    annotations = new Annotation[al.getWidth()];
                    if (id.equals("JNETPRED") || id.equals("JNETPSSM") || id.equals("JNETFREQ") || id.equals("JNETHMM") || id.equals("JNETALIGN") || id.equals("JPRED")) {
                        if (delMap == null) {
                            for (j = 0; j < width; ++j) {
                                annotations[gapmap[j]] = new Annotation("", "", preds[i].getCharAt(j), 0.0f);
                            }
                        } else {
                            for (j = 0; j < width; ++j) {
                                annotations[gapmap[delMap[j]]] = new Annotation("", "", preds[i].getCharAt(j), 0.0f);
                            }
                        }
                    } else if (id.equals("JNETCONF")) {
                        if (delMap == null) {
                            for (j = 0; j < width; ++j) {
                                float value = Float.valueOf(preds[i].getCharAt(j) + "").floatValue();
                                annotations[gapmap[j]] = new Annotation(preds[i].getCharAt(j) + "", "", preds[i].getCharAt(j), value);
                            }
                        } else {
                            for (j = 0; j < width; ++j) {
                                float value = Float.valueOf(preds[i].getCharAt(j) + "").floatValue();
                                annotations[gapmap[delMap[j]]] = new Annotation(preds[i].getCharAt(j) + "", "", preds[i].getCharAt(j), value);
                            }
                        }
                    } else if (delMap == null) {
                        for (j = 0; j < width; ++j) {
                            annotations[gapmap[j]] = new Annotation(preds[i].getCharAt(j) + "", "", ' ', 0.0f);
                        }
                    } else {
                        for (j = 0; j < width; ++j) {
                            annotations[gapmap[delMap[j]]] = new Annotation(preds[i].getCharAt(j) + "", "", ' ', 0.0f);
                        }
                    }
                    annot = id.equals("JNETCONF") ? new AlignmentAnnotation(preds[i].getName(), "JPred Output", annotations, 0.0f, 10.0f, 1) : new AlignmentAnnotation(preds[i].getName(), "JPred Output", annotations);
                    if (seqRef != null) {
                        annot.createSequenceMapping(seqRef, 1, true);
                        seqRef.addAlignmentAnnotation(annot);
                    }
                    al.addAnnotation(annot);
                    al.setAnnotationIndex(annot, al.getAlignmentAnnotation().length - existingAnnotations - 1);
                }
                if (noMsa) {
                    al.deleteSequence(preds[i]);
                }
            }
            ++i;
        }
        if (!firstsol) {
            annot = new AlignmentAnnotation("Jnet Burial", "<html>Prediction of Solvent Accessibility<br/>levels are<ul><li>0 - Exposed</li><li>3 - 25% or more S.A. accessible</li><li>6 - 5% or more S.A. accessible</li><li>9 - Buried (<5% exposed)</li></ul>", sol, 0.0f, 9.0f, 1);
            annot.validateRangeAndDisplay();
            if (seqRef != null) {
                annot.createSequenceMapping(seqRef, 1, true);
                seqRef.addAlignmentAnnotation(annot);
            }
            al.addAnnotation(annot);
            al.setAnnotationIndex(annot, al.getAlignmentAnnotation().length - existingAnnotations - 1);
        }
    }
}

