/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Console;
import jalview.io.BackupFilenameParts;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.util.MessageManager;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileView;

public class JalviewFileView
extends FileView {
    private static Map<String, String> extensions;
    private static Map<String, ImageIcon> icons;

    private void loadExtensions() {
        extensions = new HashMap<String, String>();
        for (FileFormatI ff : FileFormats.getInstance().getFormats()) {
            String desc = ff.getName() + " file";
            String exts = ff.getExtensions();
            for (String ext : exts.split(",")) {
                ext = ext.trim().toLowerCase(Locale.ROOT);
                extensions.put(ext, desc + ("jar".equals(ext) ? " (old)" : ""));
            }
        }
    }

    @Override
    public String getTypeDescription(File f) {
        String extension = JalviewFileView.getExtension(f);
        String type = this.getDescriptionForExtension(extension);
        if (extension != null && extensions.containsKey(extension)) {
            type = extensions.get(extension).toString();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDescriptionForExtension(String extension) {
        JalviewFileView jalviewFileView = this;
        synchronized (jalviewFileView) {
            if (extensions == null) {
                this.loadExtensions();
            }
        }
        return extensions.get(extension);
    }

    @Override
    public Icon getIcon(File f) {
        String extension = JalviewFileView.getExtension(f);
        ImageIcon icon = null;
        String type = this.getDescriptionForExtension(extension);
        if (type == null) {
            for (String ext : extensions.keySet()) {
                BackupFilenameParts bfp;
                if (!f.getName().contains(ext) || !(bfp = BackupFilenameParts.currentBackupFilenameParts(f.getName(), ext, true)).isBackupFile()) continue;
                extension = ext;
                type = this.getDescriptionForExtension(extension) + MessageManager.getString("label.backup");
                break;
            }
        }
        if (type != null) {
            icon = this.getImageIcon("/images/file.png");
        }
        return icon;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase(Locale.ROOT);
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageIcon getImageIcon(String filePath) {
        JalviewFileView jalviewFileView = this;
        synchronized (jalviewFileView) {
            if (icons == null) {
                icons = new HashMap<String, ImageIcon>();
            }
            if (!icons.containsKey(filePath)) {
                ImageIcon icon = null;
                URL imgURL = JalviewFileView.class.getResource(filePath);
                if (imgURL != null) {
                    icon = new ImageIcon(imgURL);
                } else {
                    Console.errPrintln("JalviewFileView.createImageIcon: Couldn't find file: " + filePath);
                }
                icons.put(filePath, icon);
            }
        }
        return icons.get(filePath);
    }
}

