/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.EMBLLikeFlatFile;
import jalview.io.FileParse;
import java.io.IOException;

public class GenBankFile
extends EMBLLikeFlatFile {
    private static final String DEFINITION = "DEFINITION";

    public GenBankFile(FileParse fp, String sourceId) throws IOException {
        super(fp, sourceId);
    }

    @Override
    public void parse() throws IOException {
        String line = this.nextLine();
        while (line != null) {
            if (line.startsWith("LOCUS")) {
                line = this.parseLocus(line);
                continue;
            }
            if (line.startsWith(DEFINITION)) {
                line = this.parseDefinition(line);
                continue;
            }
            if (line.startsWith("ACCESSION")) {
                this.accession = line.split("\\s+")[1];
                line = this.nextLine();
                continue;
            }
            if (line.startsWith("VERSION")) {
                line = this.parseVersion(line);
                continue;
            }
            if (line.startsWith("ORIGIN")) {
                line = this.parseSequence();
                continue;
            }
            if (line.startsWith("FEATURES")) {
                line = this.nextLine();
                while (line.startsWith(" ")) {
                    line = this.parseFeature(line);
                }
                continue;
            }
            line = this.nextLine();
        }
        this.buildSequence();
    }

    String parseLocus(String line) throws IOException {
        String[] tokens = line.split("\\s+");
        if (tokens.length < 2 || !"LOCUS".equals(tokens[0])) {
            return this.nextLine();
        }
        String token = tokens[1].trim();
        if (!token.isEmpty()) {
            this.accession = token;
        }
        return this.nextLine();
    }

    String parseDefinition(String line) throws IOException {
        String desc = line.substring(DEFINITION.length()).trim();
        if (desc.endsWith(".")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        while ((line = this.nextLine()) != null && line.startsWith(" ")) {
            desc = desc + line.trim();
        }
        this.description = desc;
        return line;
    }

    String parseVersion(String line) throws IOException {
        String[] tokens = line.split("\\s+");
        if (tokens.length > 1 && (tokens = tokens[1].split("\\.")).length > 1) {
            this.version = tokens[1];
        }
        return this.nextLine();
    }

    @Override
    protected boolean isFeatureContinuationLine(String line) {
        return line.startsWith("      ");
    }
}

