/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui.structurechooser;

import jalview.bin.Console;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.core.FTSRestRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class TDBResultAnalyser {
    private static List<String> EXP_CATEGORIES = Arrays.asList("EXPERIMENTALLY DETERMINED", "DEEP-LEARNING", "AB-INITIO", "TEMPLATE-BASED", "CONFORMATIONAL ENSEMBLE");
    private SequenceI seq;
    private Collection<FTSData> collectedResults;
    private FTSRestRequest lastTdbRequest;
    private int idx_ups;
    private int idx_upe;
    private int idx_mcat;
    private int idx_mqual;
    private int idx_mqualtype;
    private int idx_resol;
    private String filter = null;
    private String sourceFilter = null;
    private int idx_mprov;

    public TDBResultAnalyser(SequenceI seq, Collection<FTSData> collectedResults, FTSRestRequest lastTdbRequest, String fieldToFilterBy, String string) {
        this.seq = seq;
        this.collectedResults = collectedResults;
        this.lastTdbRequest = lastTdbRequest;
        this.filter = fieldToFilterBy;
        this.sourceFilter = string;
        this.idx_ups = lastTdbRequest.getFieldIndex("Uniprot Start");
        this.idx_upe = lastTdbRequest.getFieldIndex("Uniprot End");
        this.idx_mcat = lastTdbRequest.getFieldIndex("Model Category");
        this.idx_mprov = lastTdbRequest.getFieldIndex("Provider");
        this.idx_mqual = lastTdbRequest.getFieldIndex("Confidence");
        this.idx_resol = lastTdbRequest.getFieldIndex("Resolution");
        this.idx_mqualtype = lastTdbRequest.getFieldIndex("Confidence Score Type");
    }

    public final int scoreCategory(String cat) {
        if (cat == null) {
            return 0;
        }
        String upper_cat = cat.toUpperCase(Locale.ROOT);
        int idx = EXP_CATEGORIES.indexOf(upper_cat);
        if (idx == -1) {
            Console.outPrintln("Unknown category: '" + cat + "'");
            EXP_CATEGORIES.add(upper_cat);
            idx = EXP_CATEGORIES.size() - 1;
        }
        return -EXP_CATEGORIES.size() - idx;
    }

    public List<FTSData> getFilteredResponse() {
        ArrayList<FTSData> filteredResponse = new ArrayList<FTSData>();
        for (FTSData row : this.collectedResults) {
            if (row.getSummaryData() == null || row.getSummaryData()[this.idx_ups] == null) continue;
            int up_s = (Integer)row.getSummaryData()[this.idx_ups];
            int up_e = (Integer)row.getSummaryData()[this.idx_upe];
            String provider = (String)row.getSummaryData()[this.idx_mprov];
            String mcat = (String)row.getSummaryData()[this.idx_mcat];
            int scorecat = this.scoreCategory(mcat);
            if (this.sourceFilter != null && !this.sourceFilter.equals(provider) || this.seq != row.getSummaryData()[0] || up_e <= this.seq.getStart() || up_s >= this.seq.getEnd()) continue;
            filteredResponse.add(row);
        }
        Collections.sort(filteredResponse, new Comparator<FTSData>(){

            @Override
            public int compare(FTSData o1, FTSData o2) {
                Object[] o1data = o1.getSummaryData();
                Object[] o2data = o2.getSummaryData();
                int o1_s = (Integer)o1data[TDBResultAnalyser.this.idx_ups];
                int o1_e = (Integer)o1data[TDBResultAnalyser.this.idx_upe];
                int o1_cat = TDBResultAnalyser.this.scoreCategory((String)o1data[TDBResultAnalyser.this.idx_mcat]);
                String o1_prov = ((String)o1data[TDBResultAnalyser.this.idx_mprov]).toUpperCase(Locale.ROOT);
                int o2_s = (Integer)o2data[TDBResultAnalyser.this.idx_ups];
                int o2_e = (Integer)o2data[TDBResultAnalyser.this.idx_upe];
                int o2_cat = TDBResultAnalyser.this.scoreCategory((String)o2data[TDBResultAnalyser.this.idx_mcat]);
                String o2_prov = ((String)o2data[TDBResultAnalyser.this.idx_mprov]).toUpperCase(Locale.ROOT);
                String o1_qualtype = (String)o1data[TDBResultAnalyser.this.idx_mqualtype];
                String o2_qualtype = (String)o2data[TDBResultAnalyser.this.idx_mqualtype];
                if (o1_cat == o2_cat) {
                    if (o1_s == o2_s) {
                        int o1_xtent = o1_e - o1_s;
                        int o2_xtent = o2_e - o2_s;
                        if (o1_xtent == o2_xtent) {
                            if (o1_cat == TDBResultAnalyser.this.scoreCategory((String)EXP_CATEGORIES.get(0))) {
                                if (o1_prov.equals(o2_prov)) {
                                    if ("PDBE".equals(o1_prov)) {
                                        if (this.eitherNull(TDBResultAnalyser.this.idx_resol, o1data, o2data)) {
                                            return this.nonNullFirst(TDBResultAnalyser.this.idx_resol, o1data, o2data);
                                        }
                                        double o1_res = (Double)o1data[TDBResultAnalyser.this.idx_resol];
                                        double o2_res = (Double)o2data[TDBResultAnalyser.this.idx_resol];
                                        return o2_res < o1_res ? 1 : (o2_res == o1_res ? 0 : -1);
                                    }
                                    return 0;
                                }
                                return "PDBE".equals(o1_prov) ? -1 : ("PDBE".equals(o2_prov) ? 1 : 0);
                            }
                            if (this.eitherNull(TDBResultAnalyser.this.idx_mqualtype, o1data, o2data)) {
                                return this.nonNullFirst(TDBResultAnalyser.this.idx_mqualtype, o1data, o2data);
                            }
                            if (!o1_qualtype.equals(o2_qualtype)) {
                                return "pLDDT".equals(o1_qualtype) ? -1 : ("pLDDT".equals(o2_qualtype) ? 1 : 0);
                            }
                            if (this.eitherNull(TDBResultAnalyser.this.idx_mqual, o1data, o2data)) {
                                return this.nonNullFirst(TDBResultAnalyser.this.idx_mqual, o1data, o2data);
                            }
                            double o1_mq = (Double)o1data[TDBResultAnalyser.this.idx_mqual];
                            double o2_mq = (Double)o2data[TDBResultAnalyser.this.idx_mqual];
                            int res = o2_mq < o1_mq ? 1 : (o2_mq == o1_mq ? 0 : -1);
                            return "pLDDT".equals(o1_qualtype) ? -res : res;
                        }
                        return o1_xtent - o2_xtent;
                    }
                    return o1_s - o2_s;
                }
                if (o2_cat > 0 && o1_cat > 0) {
                    return "ALPHAFOLD DB".equals(o1_prov) ? -1 : ("ALPHAFOLD DB".equals(o2_prov) ? 1 : 0);
                }
                return o2_cat - o1_cat;
            }

            private int nonNullFirst(int idx_resol, Object[] o1data, Object[] o2data) {
                return o1data[idx_resol] == o2data[idx_resol] ? 0 : (o1data[idx_resol] != null ? -1 : 1);
            }

            private boolean eitherNull(int idx_resol, Object[] o1data, Object[] o2data) {
                return o1data[idx_resol] == null || o2data[idx_resol] == null;
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        });
        return filteredResponse;
    }

    public List<FTSData> selectStructures(List<FTSData> filteredStructures) {
        ArrayList<FTSData> selected = new ArrayList<FTSData>();
        BitSet cover = new BitSet();
        cover.set(this.seq.getStart(), this.seq.getEnd());
        for (FTSData structure : filteredStructures) {
            Object[] odata = structure.getSummaryData();
            int o1_s = (Integer)odata[this.idx_ups];
            int o1_e = (Integer)odata[this.idx_upe];
            int o1_cat = this.scoreCategory((String)odata[this.idx_mcat]);
            BitSet scover = new BitSet();
            scover.set(o1_s, o1_e);
            scover.and(cover);
            if (scover.cardinality() <= 4) continue;
            selected.add(structure);
            cover.andNot(scover);
        }
        if (selected.size() == 0) {
            return selected;
        }
        Collections.sort(selected, new Comparator<FTSData>(){

            @Override
            public int compare(FTSData o1, FTSData o2) {
                Object[] o1data = o1.getSummaryData();
                Object[] o2data = o2.getSummaryData();
                int o1_xt = (Integer)o1data[TDBResultAnalyser.this.idx_upe] - (Integer)o1data[TDBResultAnalyser.this.idx_ups];
                int o1_cat = TDBResultAnalyser.this.scoreCategory((String)o1data[TDBResultAnalyser.this.idx_mcat]);
                int o2_xt = (Integer)o2data[TDBResultAnalyser.this.idx_upe] - (Integer)o2data[TDBResultAnalyser.this.idx_ups];
                int o2_cat = TDBResultAnalyser.this.scoreCategory((String)o2data[TDBResultAnalyser.this.idx_mcat]);
                return o2_xt - o1_xt;
            }
        });
        if (this.filter.equals("3d_beacons_first_best_coverage")) {
            return selected.subList(0, 1);
        }
        return selected;
    }
}

