/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignmentSorter;
import jalview.analysis.AverageDistanceTree;
import jalview.analysis.NJTree;
import jalview.analysis.TreeBuilder;
import jalview.analysis.TreeModel;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.commands.CommandI;
import jalview.commands.OrderCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.NodeTransformI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.FontChooser;
import jalview.gui.ImageExporter;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.TreeCanvas;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.NewickFile;
import jalview.io.exceptions.ImageOutputException;
import jalview.jbgui.GTreePanel;
import jalview.util.DBRefUtils;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jibble.epsgraphics.EpsGraphics2D;

public class TreePanel
extends GTreePanel {
    String treeType;
    String scoreModelName;
    String treeTitle;
    SimilarityParamsI similarityParams;
    private TreeCanvas treeCanvas;
    TreeModel tree;
    private AlignViewport av;
    boolean columnWise = false;
    AlignmentAnnotation assocAnnotation = null;

    public TreePanel(AlignmentPanel ap, String type, String modelName, SimilarityParamsI options) {
        this.setFrameIcon(null);
        this.similarityParams = options;
        this.initTreePanel(ap, type, modelName, null, null);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile newtree, String theTitle, AlignmentView inputData) {
        this.setFrameIcon(null);
        this.treeTitle = theTitle;
        this.initTreePanel(alignPanel, null, null, newtree, inputData);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile fin, AlignmentAnnotation aa, String title) {
        this.columnWise = true;
        this.assocAnnotation = aa;
        this.setFrameIcon(null);
        this.treeTitle = title;
        this.initTreePanel(alignPanel, null, null, fin, null);
    }

    public boolean isColumnWise() {
        return this.columnWise;
    }

    public AlignmentAnnotation getAssocAnnotation() {
        return this.assocAnnotation;
    }

    public AlignmentI getAlignment() {
        return this.getTreeCanvas().getViewport().getAlignment();
    }

    public AlignmentViewport getViewPort() {
        return this.getTreeCanvas().getViewport();
    }

    void initTreePanel(AlignmentPanel ap, String type, String modelName, NewickFile newTree, AlignmentView inputData) {
        this.av = ap.av;
        this.treeType = type;
        this.scoreModelName = modelName;
        this.treeCanvas = new TreeCanvas(this, ap, this.scrollPane);
        this.scrollPane.setViewportView(this.treeCanvas);
        if (this.columnWise) {
            this.bootstrapMenu.setVisible(false);
            this.placeholdersMenu.setState(false);
            this.placeholdersMenu.setVisible(false);
            this.fitToWindow.setState(false);
            this.sortAssocViews.setVisible(false);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        TreePanel.this.treeCanvas.clearSelectedLeaves();
                        e.consume();
                    }
                }
            }
        });
        PaintRefresher.Register(this, ap.av.getSequenceSetId());
        this.buildAssociatedViewMenu();
        final PropertyChangeListener listener = this.addAlignmentListener();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                if (TreePanel.this.av != null) {
                    TreePanel.this.av.removePropertyChangeListener(listener);
                }
                TreePanel.this.releaseReferences();
            }
        });
        TreeLoader tl = new TreeLoader(newTree, inputData);
        tl.start();
    }

    public void releaseReferences() {
        this.tree = null;
        this.treeCanvas.tree = null;
        this.treeCanvas.nodeHash = null;
        this.treeCanvas.nameHash = null;
    }

    protected PropertyChangeListener addAlignmentListener() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    if (TreePanel.this.tree == null) {
                        Console.outPrintln("tree is null");
                        return;
                    }
                    if (evt.getNewValue() == null) {
                        Console.outPrintln("new alignment sequences vector value is null");
                    }
                    TreePanel.this.tree.updatePlaceHolders((List)evt.getNewValue());
                    ((TreePanel)TreePanel.this).treeCanvas.nameHash.clear();
                    TreePanel.this.repaint();
                }
            }
        };
        this.av.addPropertyChangeListener(listener);
        return listener;
    }

    @Override
    public void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        if (aps.length == 1 && this.getTreeCanvas().getAssociatedPanel() == aps[0]) {
            this.associateLeavesMenu.setVisible(false);
            return;
        }
        this.associateLeavesMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateLeavesMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        int iSize = aps.length;
        final TreePanel thisTreePanel = this;
        for (int i = 0; i < iSize; ++i) {
            final AlignmentPanel ap = aps[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ap.av.getViewName(), ap == this.treeCanvas.getAssociatedPanel());
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ((TreePanel)TreePanel.this).treeCanvas.applyToAllViews = false;
                    TreePanel.this.treeCanvas.setAssociatedPanel(ap);
                    TreePanel.this.treeCanvas.setViewport(ap.av);
                    PaintRefresher.Register(thisTreePanel, ap.av.getSequenceSetId());
                }
            });
            this.associateLeavesMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem(MessageManager.getString("label.all_views"));
        buttonGroup.add(itemf);
        itemf.setSelected(this.treeCanvas.applyToAllViews);
        itemf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((TreePanel)TreePanel.this).treeCanvas.applyToAllViews = itemf.isSelected();
            }
        });
        this.associateLeavesMenu.add(itemf);
    }

    public void showDistances(boolean b) {
        this.treeCanvas.setShowDistances(b);
        this.distanceMenu.setSelected(b);
    }

    public void showBootstrap(boolean b) {
        this.treeCanvas.setShowBootstrap(b);
        this.bootstrapMenu.setSelected(b);
    }

    public void showPlaceholders(boolean b) {
        this.placeholdersMenu.setState(b);
        this.treeCanvas.setMarkPlaceholders(b);
    }

    public TreeModel getTree() {
        return this.tree;
    }

    @Override
    public void textbox_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        String newTitle = this.getPanelTitle();
        NewickFile fout = new NewickFile(this.tree.getTopNode());
        try {
            cap.setText(fout.print(this.tree.hasBootstrap(), this.tree.hasDistances(), this.tree.hasRootDistance()));
            Desktop.addInternalFrame(cap, newTitle, 500, 100);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("generating newick tree file", oom);
            cap.dispose();
        }
    }

    @Override
    public void saveAsNewick_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_tree_as_newick"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            try {
                NewickFile fout = new NewickFile(this.tree.getTopNode());
                String output = fout.print(this.tree.hasBootstrap(), this.tree.hasDistances(), this.tree.hasRootDistance());
                PrintWriter out = new PrintWriter(new FileWriter(choice));
                out.println(output);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void printMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.startPrinting();
    }

    @Override
    public void originalSeqData_actionPerformed(ActionEvent e) {
        AlignmentView originalData = this.tree.getOriginalData();
        if (originalData == null) {
            Console.info("Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] alAndColsel = originalData.getAlignmentAndHiddenColumns(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            AlignmentI dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignmentI alignmentI = dataset = this.av != null && this.av.getAlignment() != null ? this.av.getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame((AlignmentI)al, (HiddenColumns)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, MessageManager.formatMessage("label.original_data_for_params", this.title), 700, 500);
        }
    }

    @Override
    public void fitToWindow_actionPerformed(ActionEvent e) {
        this.treeCanvas.fitToWindow = this.fitToWindow.isSelected();
        this.repaint();
    }

    @Override
    public void sortByTree_actionPerformed() {
        if (this.treeCanvas.applyToAllViews) {
            final ArrayList<CommandI> commands = new ArrayList<CommandI>();
            for (AlignmentPanel ap : PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId())) {
                commands.add(this.sortAlignmentIn(ap.av.getAlignPanel()));
            }
            this.av.getAlignPanel().alignFrame.addHistoryItem(new CommandI(){

                @Override
                public void undoCommand(AlignmentI[] views) {
                    for (CommandI tsort : commands) {
                        tsort.undoCommand(views);
                    }
                }

                @Override
                public int getSize() {
                    return commands.size();
                }

                @Override
                public String getDescription() {
                    return "Tree Sort (many views)";
                }

                @Override
                public void doCommand(AlignmentI[] views) {
                    for (CommandI tsort : commands) {
                        tsort.doCommand(views);
                    }
                }
            });
            for (AlignmentPanel ap : PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId())) {
                ap.alignFrame.updateEditMenuBar();
            }
        } else {
            this.treeCanvas.getAssociatedPanel().alignFrame.addHistoryItem(this.sortAlignmentIn(this.treeCanvas.getAssociatedPanel()));
        }
    }

    public CommandI sortAlignmentIn(AlignmentPanel ap) {
        AlignViewport viewport = ap.av;
        SequenceI[] oldOrder = viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByTree(viewport.getAlignment(), this.tree);
        OrderCommand undo = new OrderCommand("Tree Sort", oldOrder, viewport.getAlignment());
        ap.paintAlignment(true, false);
        return undo;
    }

    @Override
    public void font_actionPerformed(ActionEvent e) {
        if (this.treeCanvas == null) {
            return;
        }
        new FontChooser(this);
    }

    public Font getTreeFont() {
        return this.treeCanvas.font;
    }

    public void setTreeFont(Font f) {
        if (this.treeCanvas != null) {
            this.treeCanvas.setFont(f);
        }
    }

    @Override
    public void distanceMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowDistances(this.distanceMenu.isSelected());
    }

    @Override
    public void bootstrapMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowBootstrap(this.bootstrapMenu.isSelected());
    }

    @Override
    public void placeholdersMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setMarkPlaceholders(this.placeholdersMenu.isSelected());
    }

    @Override
    public void writeTreeImage(ImageMaker.TYPE imageFormat) {
        final int width = this.treeCanvas.getWidth();
        final int height = this.treeCanvas.getHeight();
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                TreePanel.this.treeCanvas.draw(g, width, height);
            }
        };
        String tree = MessageManager.getString("label.tree");
        ImageExporter exporter = new ImageExporter(writer, null, imageFormat, tree);
        try {
            exporter.doExport(null, this, width, height, tree.toLowerCase(Locale.ROOT));
        }
        catch (ImageOutputException ioex) {
            Console.error("Unexpected error whilst writing " + imageFormat.toString(), ioex);
        }
    }

    public void changeNames(final String labelClass) {
        this.tree.applyToNodes(new NodeTransformI(){

            @Override
            public void transform(BinaryNode node) {
                if (node instanceof SequenceNode && !((SequenceNode)node).isPlaceholder() && !((SequenceNode)node).isDummy()) {
                    String newname = null;
                    SequenceI sq = (SequenceI)node.element();
                    if (sq != null) {
                        List<DBRefEntry> refs = DBRefUtils.selectRefs(sq.getDBRefs(), new String[]{labelClass.toUpperCase(Locale.ROOT)});
                        if (refs != null) {
                            int ni = refs.size();
                            for (int i = 0; i < ni; ++i) {
                                newname = newname == null ? new String(refs.get(i).getAccessionId()) : newname + "; " + refs.get(i).getAccessionId();
                            }
                        }
                        if (newname == null) {
                            List<SequenceFeature> features = sq.getFeatures().getPositionalFeatures(labelClass);
                            for (SequenceFeature feature : features) {
                                if (newname == null) {
                                    newname = feature.getDescription();
                                    continue;
                                }
                                newname = newname + "; " + feature.getDescription();
                            }
                        }
                    }
                    if (newname != null) {
                        node.setName(newname);
                    }
                }
            }
        });
    }

    public String getPanelTitle() {
        if (this.treeTitle != null) {
            return this.treeTitle;
        }
        String treecalcnm = MessageManager.getString("label.tree_calc_" + this.treeType.toLowerCase(Locale.ROOT));
        String smn = this.scoreModelName;
        String ttl = MessageManager.formatMessage("label.calc_title", treecalcnm, smn);
        return ttl;
    }

    protected void writeEpsFile(File outFile, boolean textOption) {
        try {
            int width = this.treeCanvas.getWidth();
            int height = this.treeCanvas.getHeight();
            FileOutputStream out = new FileOutputStream(outFile);
            EpsGraphics2D pg = new EpsGraphics2D("Tree", out, 0, 0, width, height);
            pg.setAccurateTextMode(!textOption);
            this.treeCanvas.draw(pg, width, height);
            pg.flush();
            pg.close();
        }
        catch (Exception ex) {
            Console.errPrintln("Error writing tree as EPS");
            ex.printStackTrace();
        }
    }

    public AlignViewport getViewport() {
        return this.av;
    }

    public void setViewport(AlignViewport av) {
        this.av = av;
    }

    public TreeCanvas getTreeCanvas() {
        return this.treeCanvas;
    }

    class TreeLoader
    extends Thread {
        private NewickFile newtree;
        private AlignmentView odata = null;

        public TreeLoader(NewickFile newickFile, AlignmentView inputData) {
            this.newtree = newickFile;
            this.odata = inputData;
            if (newickFile != null) {
                TreePanel.this.showBootstrap(newickFile.HasBootstrap());
                TreePanel.this.showDistances(newickFile.HasDistances());
            }
        }

        @Override
        public void run() {
            if (this.newtree != null) {
                TreePanel.this.tree = new TreeModel(TreePanel.this.av.getAlignment().getSequencesArray(), this.odata, this.newtree);
                if (TreePanel.this.tree.getOriginalData() == null) {
                    TreePanel.this.originalSeqData.setVisible(false);
                }
            } else {
                ScoreModelI sm = ScoreModels.getInstance().getScoreModel(TreePanel.this.scoreModelName, TreePanel.this.treeCanvas.getAssociatedPanel());
                TreeBuilder njtree = TreePanel.this.treeType.equals("NJ") ? new NJTree(TreePanel.this.av, sm, TreePanel.this.similarityParams) : new AverageDistanceTree(TreePanel.this.av, sm, TreePanel.this.similarityParams);
                TreePanel.this.tree = new TreeModel(njtree);
            }
            TreePanel.this.showDistances(!TreePanel.this.columnWise);
            TreePanel.this.tree.reCount(TreePanel.this.tree.getTopNode());
            TreePanel.this.tree.findHeight(TreePanel.this.tree.getTopNode());
            TreePanel.this.treeCanvas.setTree(TreePanel.this.tree);
            TreePanel.this.treeCanvas.repaint();
            TreePanel.this.av.setCurrentTree(TreePanel.this.tree);
            if (TreePanel.this.av.getSortByTree()) {
                TreePanel.this.sortByTree_actionPerformed();
            }
        }
    }
}

