/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.Conservation;
import jalview.analysis.TreeModel;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.JalviewColourChooser;
import jalview.gui.PaintRefresher;
import jalview.gui.TreePanel;
import jalview.schemes.ColourSchemeI;
import jalview.structure.SelectionSource;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.MessageManager;
import jalview.ws.datamodel.MappableContactMatrixI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class TreeCanvas
extends JPanel
implements MouseListener,
Runnable,
Printable,
MouseMotionListener,
SelectionSource {
    public static final String PLACEHOLDER = " * ";
    TreeModel tree;
    JScrollPane scrollPane;
    TreePanel tp;
    private AlignViewport av;
    private AlignmentPanel ap;
    Font font;
    FontMetrics fm;
    boolean fitToWindow = true;
    boolean showDistances = false;
    boolean showBootstrap = false;
    boolean markPlaceholders = false;
    int offx = 20;
    int offy;
    private float threshold;
    String longestName;
    int labelLength = -1;
    Map<Object, Rectangle> nameHash = new Hashtable<Object, Rectangle>();
    Map<BinaryNode, Rectangle> nodeHash = new Hashtable<BinaryNode, Rectangle>();
    BinaryNode highlightNode;
    boolean applyToAllViews = false;

    public TreeCanvas(TreePanel tp, AlignmentPanel ap, JScrollPane scroller) {
        this.tp = tp;
        this.av = ap.av;
        this.setAssociatedPanel(ap);
        this.font = this.av.getFont();
        this.scrollPane = scroller;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void clearSelectedLeaves() {
        Vector<BinaryNode> leaves = this.tp.getTree().findLeaves(this.tp.getTree().getTopNode());
        if (this.tp.isColumnWise()) {
            this.markColumnsFor(this.getAssociatedPanels(), leaves, Color.white, true);
        } else {
            for (AlignmentPanel ap : this.getAssociatedPanels()) {
                SequenceGroup selected = ap.av.getSelectionGroup();
                if (selected != null) {
                    for (int i = 0; i < leaves.size(); ++i) {
                        SequenceI seq = (SequenceI)leaves.elementAt(i).element();
                        if (!selected.contains(seq)) continue;
                        selected.addOrRemove(seq, false);
                    }
                    selected.recalcConservation();
                }
                ap.av.sendSelection();
            }
        }
        PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
        this.repaint();
    }

    public void treeSelectionChanged(SequenceI sequence) {
        AlignmentPanel[] aps = this.getAssociatedPanels();
        for (int a = 0; a < aps.length; ++a) {
            SequenceGroup selected = aps[a].av.getSelectionGroup();
            if (selected == null) {
                selected = new SequenceGroup();
                aps[a].av.setSelectionGroup(selected);
            }
            selected.setEndRes(aps[a].av.getAlignment().getWidth() - 1);
            selected.addOrRemove(sequence, true);
        }
    }

    public void setTree(TreeModel tree) {
        ContactMatrixI cm;
        this.tree = tree;
        tree.findHeight(tree.getTopNode());
        Vector<BinaryNode> leaves = tree.findLeaves(tree.getTopNode());
        boolean has_placeholders = false;
        this.longestName = "";
        AlignmentAnnotation aa = this.tp.getAssocAnnotation();
        ContactMatrixI contactMatrixI = cm = aa != null ? this.av.getContactMatrix(aa) : null;
        if (cm != null && cm.hasCutHeight()) {
            this.threshold = (float)cm.getCutHeight();
        }
        for (int i = 0; i < leaves.size(); ++i) {
            BinaryNode lf = leaves.elementAt(i);
            if (lf instanceof SequenceNode && ((SequenceNode)lf).isPlaceholder()) {
                has_placeholders = true;
            }
            if (this.longestName.length() < ((Sequence)lf.element()).getName().length()) {
                this.longestName = PLACEHOLDER + ((Sequence)lf.element()).getName();
            }
            if (!this.tp.isColumnWise() || cm == null) continue;
            try {
                Color col = cm.getGroupColorForPosition(this.parseColumnNode(lf));
                this.setColor(lf, col.brighter());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setMarkPlaceholders(has_placeholders);
    }

    public void drawNode(Graphics g, BinaryNode node, double chunk, double wscale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            double height = node.height;
            double dist = node.dist;
            int xstart = (int)((height - dist) * wscale) + offx;
            int xend = (int)(height * wscale) + offx;
            int ypos = (int)((double)node.ycount * chunk) + offy;
            if (node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                if (this.av.getSequenceColour(seq) == Color.white) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.av.getSequenceColour(seq).darker());
                }
            } else {
                g.setColor(Color.black);
            }
            g.drawLine(xstart, ypos, xend, ypos);
            String nodeLabel = "";
            if (this.showDistances && node.dist > 0.0) {
                nodeLabel = new Format("%g").form(node.dist);
            }
            if (this.showBootstrap && node.bootstrap > -1) {
                if (this.showDistances) {
                    nodeLabel = nodeLabel + " : ";
                }
                nodeLabel = nodeLabel + String.valueOf(node.bootstrap);
            }
            if (!nodeLabel.equals("")) {
                g.drawString(nodeLabel, xstart + 2, ypos - 2);
            }
            String name = this.markPlaceholders && node instanceof SequenceNode && ((SequenceNode)node).isPlaceholder() ? PLACEHOLDER + node.getName() : node.getName();
            int charWidth = this.fm.stringWidth(name) + 3;
            int charHeight = this.font.getSize();
            Rectangle rect = new Rectangle(xend + 10, ypos - charHeight / 2, charWidth, charHeight);
            this.nameHash.put(node.element(), rect);
            boolean isSelected = false;
            if (this.tp.isColumnWise()) {
                isSelected = this.isColumnForNodeSelected(node);
            } else {
                SequenceGroup selected = this.av.getSelectionGroup();
                if (selected != null && selected.getSequences(null).contains(node.element())) {
                    isSelected = true;
                }
            }
            if (isSelected) {
                g.setColor(Color.gray);
                g.fillRect(xend + 10, ypos - charHeight / 2, charWidth, charHeight);
                g.setColor(Color.white);
            }
            g.drawString(name, xend + 10, ypos + this.fm.getDescent());
            g.setColor(Color.black);
        } else {
            this.drawNode(g, node.left(), chunk, wscale, width, offx, offy);
            this.drawNode(g, node.right(), chunk, wscale, width, offx, offy);
            double height = node.height;
            double dist = node.dist;
            int xstart = (int)((height - dist) * wscale) + offx;
            int xend = (int)(height * wscale) + offx;
            int ypos = (int)((double)node.ycount * chunk) + offy;
            g.setColor(node.color.darker());
            g.drawLine(xstart, ypos, xend, ypos);
            if (node == this.highlightNode) {
                g.fillRect(xend - 3, ypos - 3, 6, 6);
            } else {
                g.fillRect(xend - 2, ypos - 2, 4, 4);
            }
            int ystart = (node.left() == null ? 0 : (int)((double)node.left().ycount * chunk)) + offy;
            int yend = (node.right() == null ? 0 : (int)((double)node.right().ycount * chunk)) + offy;
            Rectangle pos = new Rectangle(xend - 2, ypos - 2, 5, 5);
            this.nodeHash.put(node, pos);
            g.drawLine((int)(height * wscale) + offx, ystart, (int)(height * wscale) + offx, yend);
            String nodeLabel = "";
            if (this.showDistances && node.dist > 0.0) {
                nodeLabel = new Format("%g").form(node.dist);
            }
            if (this.showBootstrap && node.bootstrap > -1) {
                if (this.showDistances) {
                    nodeLabel = nodeLabel + " : ";
                }
                nodeLabel = nodeLabel + String.valueOf(node.bootstrap);
            }
            if (!nodeLabel.equals("")) {
                g.drawString(nodeLabel, xstart + 2, ypos - 2);
            }
        }
    }

    public Object findElement(int x, int y) {
        Rectangle rect;
        for (Map.Entry<Object, Rectangle> entry : this.nameHash.entrySet()) {
            rect = entry.getValue();
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return entry.getKey();
        }
        for (Map.Entry<Object, Rectangle> entry : this.nodeHash.entrySet()) {
            rect = entry.getValue();
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return entry.getKey();
        }
        return null;
    }

    public void pickNodes(Rectangle pickBox) {
        int width = this.getWidth();
        int height = this.getHeight();
        BinaryNode top = this.tree.getTopNode();
        double wscale = ((double)width * 0.8 - (double)(this.offx * 2)) / this.tree.getMaxHeight();
        if (top.count == 0) {
            top.count = top.left().count + top.right().count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.pickNode(pickBox, top, chunk, wscale, width, this.offx, this.offy);
    }

    public void pickNode(Rectangle pickBox, BinaryNode node, float chunk, double wscale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            double height = node.height;
            int xend = (int)(height * wscale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            if (pickBox.contains(new Point(xend, ypos)) && node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                SequenceGroup sg = this.av.getSelectionGroup();
                if (sg != null) {
                    sg.addOrRemove(seq, true);
                }
            }
        } else {
            this.pickNode(pickBox, node.left(), chunk, wscale, width, offx, offy);
            this.pickNode(pickBox, node.right(), chunk, wscale, width, offx, offy);
        }
    }

    public void setColor(BinaryNode node, Color c) {
        if (node == null) {
            return;
        }
        node.color = c;
        if (node.element() instanceof SequenceI) {
            SequenceI seq = (SequenceI)node.element();
            AlignmentPanel[] aps = this.getAssociatedPanels();
            if (aps != null) {
                for (int a = 0; a < aps.length; ++a) {
                    aps[a].av.setSequenceColour(seq, c);
                }
            }
        }
        this.setColor(node.left(), c);
        this.setColor(node.right(), c);
    }

    void startPrinting() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        PageFormat pf;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat defaultPage = printJob.defaultPage();
        if (defaultPage == (pf = printJob.pageDialog(defaultPage))) {
            return;
        }
        printJob.setPrintable(this, pf);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
        pg.setFont(this.font);
        pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int pwidth = (int)pf.getImageableWidth();
        int pheight = (int)pf.getImageableHeight();
        int noPages = this.getHeight() / pheight;
        if (pi > noPages) {
            return 1;
        }
        if (pwidth > this.getWidth()) {
            pwidth = this.getWidth();
        }
        if (this.fitToWindow) {
            if (pheight > this.getHeight()) {
                pheight = this.getHeight();
            }
            noPages = 0;
        } else {
            FontMetrics fm = pg.getFontMetrics(this.font);
            int height = fm.getHeight() * this.nameHash.size();
            pg.translate(0, -pi * pheight);
            pg.setClip(0, pi * pheight, pwidth, pi * pheight + pheight);
            pheight = height;
        }
        this.draw(pg, pwidth, pheight);
        return 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.font);
        if (this.tree == null) {
            g.drawString(MessageManager.getString("label.calculating_tree") + "....", 20, this.getHeight() / 2);
        } else {
            this.fm = g.getFontMetrics(this.font);
            int nameCount = this.nameHash.size();
            if (nameCount == 0) {
                this.repaint();
            }
            if (this.fitToWindow || !this.fitToWindow && this.scrollPane.getHeight() > this.fm.getHeight() * nameCount + this.offy) {
                this.draw(g, this.scrollPane.getWidth(), this.scrollPane.getHeight());
                this.setPreferredSize(null);
            } else {
                this.setPreferredSize(new Dimension(this.scrollPane.getWidth(), this.fm.getHeight() * nameCount));
                this.draw(g, this.scrollPane.getWidth(), this.fm.getHeight() * nameCount);
            }
            this.scrollPane.revalidate();
        }
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void draw(Graphics g1, int width, int height) {
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        g2.setFont(this.font);
        if (this.longestName == null || this.tree == null) {
            g2.drawString("Calculating tree.", 20, 20);
            return;
        }
        this.offy = this.font.getSize() + 10;
        this.fm = g2.getFontMetrics(this.font);
        this.labelLength = this.fm.stringWidth(this.longestName) + 20;
        double wscale = (double)(width - this.labelLength - this.offx * 2) / this.tree.getMaxHeight();
        BinaryNode top = this.tree.getTopNode();
        if (top.count == 0) {
            top.count = top.left().count + top.right().count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.drawNode(g2, this.tree.getTopNode(), chunk, wscale, width, this.offx, this.offy);
        if (this.threshold != 0.0f) {
            if (this.av.getCurrentTree() == this.tree) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.gray);
            }
            int x = (int)(this.threshold * (float)(this.getWidth() - this.labelLength - 2 * this.offx) + (float)this.offx);
            g2.drawLine(x, 0, x, this.getHeight());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.chooseSubtreeColour();
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.highlightNode == null) {
            return;
        }
        if (evt.getClickCount() > 1) {
            this.tree.swapNodes(this.highlightNode);
            this.tree.reCount(this.tree.getTopNode());
            this.tree.findHeight(this.tree.getTopNode());
        } else {
            Vector<BinaryNode> leaves = this.tree.findLeaves(this.highlightNode);
            if (this.tp.isColumnWise()) {
                this.markColumnsFor(this.getAssociatedPanels(), leaves, Color.red, false);
            } else {
                for (int i = 0; i < leaves.size(); ++i) {
                    SequenceI seq = (SequenceI)leaves.elementAt(i).element();
                    this.treeSelectionChanged(seq);
                }
            }
            this.av.sendSelection();
        }
        PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
        this.repaint();
    }

    void chooseSubtreeColour() {
        String ttl = MessageManager.getString("label.select_subtree_colour");
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                TreeCanvas.this.setColor(TreeCanvas.this.highlightNode, c);
                PaintRefresher.Refresh(TreeCanvas.this.tp, ((TreeCanvas)TreeCanvas.this).ap.av.getSequenceSetId());
                TreeCanvas.this.repaint();
            }
        };
        JalviewColourChooser.showColourChooser(this, ttl, this.highlightNode.color, listener);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.av.setCurrentTree(this.tree);
        Object ob = this.findElement(evt.getX(), evt.getY());
        if (ob instanceof BinaryNode) {
            this.highlightNode = (BinaryNode)ob;
            this.setToolTipText("<html>" + MessageManager.getString("label.highlightnode"));
            this.repaint();
        } else if (this.highlightNode != null) {
            this.highlightNode = null;
            this.setToolTipText(null);
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ect) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        this.av.setCurrentTree(this.tree);
        if (e.isPopupTrigger()) {
            if (this.highlightNode != null) {
                this.chooseSubtreeColour();
            }
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int x = e.getX();
        Object ob = this.findElement(x, y = e.getY());
        if (ob instanceof SequenceI) {
            this.treeSelectionChanged((Sequence)ob);
            PaintRefresher.Refresh(this.tp, this.getAssociatedPanel().av.getSequenceSetId());
            this.repaint();
            this.av.sendSelection();
            return;
        }
        if (!(ob instanceof BinaryNode)) {
            if (this.tree.getMaxHeight() != 0.0) {
                this.threshold = (float)(x - this.offx) / (float)(this.getWidth() - this.labelLength - 2 * this.offx);
                List<BinaryNode> groups = this.tree.groupNodes(this.threshold);
                this.setColor(this.tree.getTopNode(), Color.black);
                AlignmentPanel[] aps = this.getAssociatedPanels();
                for (int a = 0; a < aps.length; ++a) {
                    aps[a].av.setSelectionGroup(null);
                    aps[a].av.getAlignment().deleteAllGroups();
                    aps[a].av.clearSequenceColours();
                    if (aps[a].av.getCodingComplement() != null) {
                        aps[a].av.getCodingComplement().setSelectionGroup(null);
                        aps[a].av.getCodingComplement().getAlignment().deleteAllGroups();
                        aps[a].av.getCodingComplement().clearSequenceColours();
                    }
                    aps[a].av.setUpdateStructures(true);
                }
                this.colourGroups(groups);
                if (groups.isEmpty()) {
                    this.threshold = 0.0f;
                }
            }
            Console.log.debug("Tree cut threshold set at:" + this.threshold);
            PaintRefresher.Refresh(this.tp, this.getAssociatedPanel().av.getSequenceSetId());
            this.repaint();
        }
    }

    void colourGroups(List<BinaryNode> groups) {
        AlignmentAnnotation aa;
        AlignmentPanel[] aps = this.getAssociatedPanels();
        ArrayList<BitSet> colGroups = new ArrayList<BitSet>();
        HashMap<BitSet, Color> colors = new HashMap<BitSet, Color>();
        for (int i = 0; i < groups.size(); ++i) {
            Color col = ColorUtils.getARandomColor();
            this.setColor(groups.get(i), col.brighter());
            Vector<BinaryNode> l = this.tree.findLeaves(groups.get(i));
            if (!this.tp.isColumnWise()) {
                this.createSeqGroupFor(aps, l, col);
                continue;
            }
            BitSet gp = this.createColumnGroupFor(l, col);
            colGroups.add(gp);
            colors.put(gp, col);
        }
        if (this.tp.isColumnWise() && (aa = this.tp.getAssocAnnotation()) != null) {
            ContactMatrixI cm = this.av.getContactMatrix(aa);
            if (cm != null) {
                cm.updateGroups(colGroups);
                for (BitSet gp : colors.keySet()) {
                    cm.setColorForGroup(gp, (Color)colors.get(gp));
                }
            }
            cm.transferGroupColorsTo(aa);
        }
        for (int a = 0; a < aps.length; ++a) {
            aps[a].updateAnnotation();
            AlignViewportI codingComplement = aps[a].av.getCodingComplement();
            if (codingComplement == null) continue;
            ((AlignViewport)codingComplement).getAlignPanel().updateAnnotation();
        }
    }

    private int parseColumnNode(BinaryNode bn) throws NumberFormatException {
        return Integer.parseInt(bn.getName().substring(bn.getName().indexOf("c") + 1));
    }

    private boolean isColumnForNodeSelected(BinaryNode bn) {
        SequenceI rseq = this.tp.assocAnnotation.sequenceRef;
        int colm = -1;
        try {
            colm = this.parseColumnNode(bn);
        }
        catch (Exception e) {
            return false;
        }
        if (this.av == null || this.av.getAlignment() == null) {
            return false;
        }
        ColumnSelection cs = this.av.getColumnSelection();
        HiddenColumns hc = this.av.getAlignment().getHiddenColumns();
        AlignmentAnnotation aa = this.tp.getAssocAnnotation();
        int offp = -1;
        if (aa != null) {
            ContactMatrixI cm = this.av.getContactMatrix(aa);
            if (cm instanceof MappableContactMatrixI) {
                MappableContactMatrixI mcm = (MappableContactMatrixI)cm;
                int[] pos = mcm.getMappedPositionsFor(rseq, colm + 1);
                if (pos != null) {
                    offp = rseq.findIndex(pos[0]);
                }
            } else {
                offp = colm;
            }
        }
        if (offp <= 0) {
            return false;
        }
        offp -= 2;
        if (!this.av.hasHiddenColumns()) {
            return cs.contains(offp);
        }
        if (hc.isVisible(offp)) {
            return cs.contains(offp);
        }
        return false;
    }

    private BitSet createColumnGroupFor(Vector<BinaryNode> l, Color col) {
        BitSet gp = new BitSet();
        for (BinaryNode bn : l) {
            int colm = -1;
            if (bn.element() != null && bn.element() instanceof Integer) {
                colm = (Integer)bn.element();
            } else {
                try {
                    colm = this.parseColumnNode(bn);
                }
                catch (Exception e) {
                    continue;
                }
            }
            gp.set(colm);
        }
        return gp;
    }

    private void markColumnsFor(AlignmentPanel[] aps, Vector<BinaryNode> l, Color col, boolean clearSelected) {
        SequenceI rseq = this.tp.assocAnnotation.sequenceRef;
        if (this.av == null || this.av.getAlignment() == null) {
            return;
        }
        ColumnSelection cs = this.av.getColumnSelection();
        HiddenColumns hc = this.av.getAlignment().getHiddenColumns();
        ContactMatrixI cm = this.av.getContactMatrix(this.tp.assocAnnotation);
        MappableContactMatrixI mcm = null;
        if (cm instanceof MappableContactMatrixI) {
            mcm = (MappableContactMatrixI)cm;
        }
        for (BinaryNode bn : l) {
            int offp;
            int colm = -1;
            try {
                colm = Integer.parseInt(bn.getName().substring(bn.getName().indexOf("c") + 1));
            }
            catch (Exception e) {
                continue;
            }
            if (mcm != null) {
                int[] seqpos = mcm.getMappedPositionsFor(rseq, colm);
                if (seqpos == null) continue;
                offp = rseq.findIndex(seqpos[0]) - 1;
            } else {
                int n = offp = rseq != null ? rseq.findIndex(rseq.getStart() + colm) : colm;
            }
            if (this.av.hasHiddenColumns() && !hc.isVisible(offp)) continue;
            if (clearSelected || cs.contains(offp)) {
                cs.removeElement(offp);
                continue;
            }
            cs.addElement(offp);
        }
        PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
    }

    public void createSeqGroupFor(AlignmentPanel[] aps, Vector<BinaryNode> l, Color col) {
        Vector<SequenceI> sequences = new Vector<SequenceI>();
        for (int j = 0; j < l.size(); ++j) {
            SequenceI s1 = (SequenceI)l.elementAt(j).element();
            if (sequences.contains(s1)) continue;
            sequences.addElement(s1);
        }
        ColourSchemeI cs = null;
        SequenceGroup _sg = new SequenceGroup(sequences, null, cs, true, true, false, 0, this.av.getAlignment().getWidth() - 1);
        _sg.setName("JTreeGroup:" + _sg.hashCode());
        _sg.setIdColour(col);
        for (int a = 0; a < aps.length; ++a) {
            SequenceGroup sg = new SequenceGroup(_sg);
            AlignViewport viewport = aps[a].av;
            if (viewport.getGlobalColourScheme() != null) {
                cs = viewport.getGlobalColourScheme().getInstance(viewport, sg);
                sg.setColourScheme(cs);
                sg.getGroupColourScheme().setThreshold(viewport.getResidueShading().getThreshold(), viewport.isIgnoreGapsConsensus());
                if (viewport.getResidueShading().conservationApplied()) {
                    Conservation c = new Conservation("Group", sg.getSequences(null), sg.getStartRes(), sg.getEndRes());
                    c.calculate();
                    c.verdict(false, viewport.getConsPercGaps());
                    sg.cs.setConservation(c);
                }
            }
            viewport.setUpdateStructures(true);
            viewport.addSequenceGroup(sg);
        }
    }

    public void setShowDistances(boolean state) {
        this.showDistances = state;
        this.repaint();
    }

    public void setShowBootstrap(boolean state) {
        this.showBootstrap = state;
        this.repaint();
    }

    public void setMarkPlaceholders(boolean state) {
        this.markPlaceholders = state;
        this.repaint();
    }

    AlignmentPanel[] getAssociatedPanels() {
        if (this.applyToAllViews) {
            return PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        }
        return new AlignmentPanel[]{this.getAssociatedPanel()};
    }

    public AlignmentPanel getAssociatedPanel() {
        return this.ap;
    }

    public void setAssociatedPanel(AlignmentPanel ap) {
        this.ap = ap;
    }

    public AlignViewport getViewport() {
        return this.av;
    }

    public void setViewport(AlignViewport av) {
        this.av = av;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public boolean isApplyToAllViews() {
        return this.applyToAllViews;
    }

    public void setApplyToAllViews(boolean applyToAllViews) {
        this.applyToAllViews = applyToAllViews;
    }
}

