/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.ColourMenuHelper;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.QuitHandler;
import jalview.gui.StructureViewer;
import jalview.gui.ViewSelectionMenu;
import jalview.io.DataSourceType;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GStructureViewer;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.structure.StructureMapping;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import jalview.ws.dbsources.EBIAlfaFold;
import jalview.ws.dbsources.Pdb;
import jalview.ws.utils.UrlDownloadClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class StructureViewerBase
extends GStructureViewer
implements Runnable,
ViewSelectionMenu.ViewSetProvider {
    private static List<JalviewStructureDisplayI> svbs = new ArrayList<JalviewStructureDisplayI>();
    protected List<String> _aps = new ArrayList<String>();
    protected Vector<AlignmentViewPanel> _alignwith = new Vector();
    protected Vector<AlignmentViewPanel> _colourwith = new Vector();
    private String viewId = null;
    private AlignmentPanel ap;
    protected boolean alignAddedStructures = false;
    protected volatile boolean _started = false;
    protected volatile boolean addingStructures = false;
    protected Thread worker = null;
    protected boolean allChainsSelected = false;
    protected boolean allHetatmBeingSelected = false;
    protected JMenu viewSelectionMenu;
    protected volatile boolean seqColoursApplied = false;
    private IProgressIndicator progressBar = null;
    private Random random = new Random();
    private static boolean quitClose = false;

    public static List<JalviewStructureDisplayI> getAllStructureViewerBases() {
        ArrayList<JalviewStructureDisplayI> goodSvbs = new ArrayList<JalviewStructureDisplayI>();
        for (JalviewStructureDisplayI s : svbs) {
            if (s == null || goodSvbs.contains(s)) continue;
            goodSvbs.add(s);
        }
        return goodSvbs;
    }

    public StructureViewerBase() {
        this.setFrameIcon(null);
        svbs.add(this);
    }

    @Override
    public boolean isAlignAddedStructures() {
        return this.alignAddedStructures;
    }

    @Override
    public void setAlignAddedStructures(boolean alignAdded) {
        this.alignAddedStructures = alignAdded;
    }

    public synchronized void setAddingStructures(boolean addingStructures) {
        this.addingStructures = addingStructures;
    }

    public boolean isLinkedWith(AlignmentPanel ap2) {
        return this._aps.contains(ap2.av.getSequenceSetId());
    }

    @Override
    public boolean isUsedforaligment(AlignmentViewPanel ap2) {
        return this._alignwith != null && this._alignwith.contains(ap2);
    }

    @Override
    public boolean isUsedForColourBy(AlignmentViewPanel ap2) {
        return this._colourwith != null && this._colourwith.contains(ap2);
    }

    @Override
    public boolean isColouredByViewer() {
        return !this.getBinding().isColourBySequence();
    }

    @Override
    public String getViewId() {
        if (this.viewId == null) {
            this.viewId = System.currentTimeMillis() + "." + this.hashCode();
        }
        return this.viewId;
    }

    protected void setViewId(String viewId) {
        this.viewId = viewId;
    }

    protected void buildActionMenu() {
        if (this._alignwith == null) {
            this._alignwith = new Vector();
        }
        if (this._alignwith.size() == 0 && this.ap != null) {
            this._alignwith.add(this.ap);
        }
        for (Component c : this.viewerActionMenu.getMenuComponents()) {
            if (c == this.alignStructs) continue;
            this.viewerActionMenu.remove((JMenuItem)c);
        }
    }

    @Override
    public AlignmentPanel getAlignmentPanel() {
        return this.ap;
    }

    protected void setAlignmentPanel(AlignmentPanel alp) {
        this.ap = alp;
    }

    @Override
    public AlignmentPanel[] getAllAlignmentPanels() {
        AlignmentPanel[] list = new AlignmentPanel[]{};
        for (String setid : this._aps) {
            AlignmentPanel[] panels = PaintRefresher.getAssociatedPanels(setid);
            if (panels == null) continue;
            AlignmentPanel[] t = new AlignmentPanel[list.length + panels.length];
            System.arraycopy(list, 0, t, 0, list.length);
            System.arraycopy(panels, 0, t, list.length, panels.length);
            list = t;
        }
        return list;
    }

    public void addAlignmentPanel(AlignmentPanel nap) {
        if (this.getAlignmentPanel() == null) {
            this.setAlignmentPanel(nap);
        }
        if (!this._aps.contains(nap.av.getSequenceSetId())) {
            this._aps.add(nap.av.getSequenceSetId());
        }
    }

    @Override
    public void removeAlignmentPanel(AlignmentViewPanel nap) {
        block4: {
            try {
                this._alignwith.remove(nap);
                this._colourwith.remove(nap);
                if (this.getAlignmentPanel() != nap) break block4;
                this.setAlignmentPanel(null);
                for (AlignmentPanel aps : this.getAllAlignmentPanels()) {
                    if (aps == nap) continue;
                    this.setAlignmentPanel(aps);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getAlignmentPanel() != null) {
            this.buildActionMenu();
        }
    }

    public void useAlignmentPanelForSuperposition(AlignmentPanel nap) {
        this.addAlignmentPanel(nap);
        if (!this._alignwith.contains(nap)) {
            this._alignwith.add(nap);
        }
    }

    public void excludeAlignmentPanelForSuperposition(AlignmentPanel nap) {
        if (this._alignwith.contains(nap)) {
            this._alignwith.remove(nap);
        }
    }

    public void useAlignmentPanelForColourbyseq(AlignmentPanel nap, boolean enableColourBySeq) {
        this.useAlignmentPanelForColourbyseq(nap);
        this.getBinding().setColourBySequence(enableColourBySeq);
        this.seqColour.setSelected(enableColourBySeq);
        this.viewerColour.setSelected(!enableColourBySeq);
    }

    public void useAlignmentPanelForColourbyseq(AlignmentPanel nap) {
        this.addAlignmentPanel(nap);
        if (!this._colourwith.contains(nap)) {
            this._colourwith.add(nap);
        }
    }

    public void excludeAlignmentPanelForColourbyseq(AlignmentPanel nap) {
        if (this._colourwith.contains(nap)) {
            this._colourwith.remove(nap);
        }
    }

    @Override
    public abstract StructureViewer.ViewerType getViewerType();

    protected void addStructure(final PDBEntry pdbentry, final SequenceI[] seqs, final String[] chains, final IProgressIndicator alignFrame) {
        if (pdbentry.getFile() == null && this.worker != null && this.worker.isAlive()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (StructureViewerBase.this.worker != null && StructureViewerBase.this.worker.isAlive() && StructureViewerBase.this._started) {
                        try {
                            Thread.sleep(100 + (int)Math.random() * 100);
                        }
                        catch (Exception exception) {}
                    }
                    StructureViewerBase.this.addStructure(pdbentry, seqs, chains, alignFrame);
                }
            }).start();
            return;
        }
        this.getBinding().addSequenceAndChain(new PDBEntry[]{pdbentry}, new SequenceI[][]{seqs}, new String[][]{chains});
        this.addingStructures = true;
        this._started = false;
        this.worker = new Thread(this);
        this.worker.start();
    }

    protected boolean hasPdbId(String pdbId) {
        return this.getBinding().hasPdbId(pdbId);
    }

    protected List<StructureViewerBase> getViewersFor(AlignmentPanel alp) {
        return Desktop.instance.getStructureViewers(alp, this.getClass());
    }

    @Override
    public void addToExistingViewer(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentViewPanel apanel, String pdbId) {
        if (this.hasPdbId(pdbId)) {
            return;
        }
        AlignmentPanel alignPanel = (AlignmentPanel)apanel;
        this.useAlignmentPanelForSuperposition(alignPanel);
        this.addStructure(pdbentry, seq, chains, alignPanel.alignFrame);
    }

    public void addSequenceMappingsToStructure(SequenceI[] seq, String[] chains, AlignmentViewPanel alpanel, String pdbFilename) {
        AlignmentPanel apanel = (AlignmentPanel)alpanel;
        apanel.getStructureSelectionManager().setMapping(seq, chains, pdbFilename, DataSourceType.FILE, this.getProgressIndicator());
        if (apanel.getSeqPanel().seqCanvas.fr != null) {
            apanel.getSeqPanel().seqCanvas.fr.featuresAdded();
            apanel.paintAlignment(true, false);
        }
        block0: for (StructureViewerBase viewer : this.getViewersFor(null)) {
            AAStructureBindingModel bindingModel = viewer.getBinding();
            for (int pe = 0; pe < bindingModel.getPdbCount(); ++pe) {
                if (!bindingModel.getPdbEntry(pe).getFile().equals(pdbFilename)) continue;
                bindingModel.addSequence(pe, seq);
                viewer.addAlignmentPanel(apanel);
                viewer.useAlignmentPanelForColourbyseq(apanel);
                viewer.buildActionMenu();
                apanel.getStructureSelectionManager().sequenceColoursChanged(apanel);
                continue block0;
            }
        }
    }

    @Override
    public boolean addAlreadyLoadedFile(SequenceI[] seq, String[] chains, AlignmentViewPanel apanel, String pdbId) {
        String alreadyMapped = apanel.getStructureSelectionManager().alreadyMappedToFile(pdbId);
        if (alreadyMapped == null) {
            return false;
        }
        this.addSequenceMappingsToStructure(seq, chains, apanel, alreadyMapped);
        return true;
    }

    void setChainMenuItems(List<String> chainNames) {
        this.chainMenu.removeAll();
        if (chainNames == null || chainNames.isEmpty()) {
            return;
        }
        JMenuItem menuItem = new JMenuItem(MessageManager.getString("label.all"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureViewerBase.this.allChainsSelected = true;
                for (int i = 0; i < StructureViewerBase.this.chainMenu.getItemCount(); ++i) {
                    if (!(StructureViewerBase.this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)StructureViewerBase.this.chainMenu.getItem(i)).setSelected(true);
                }
                StructureViewerBase.this.showSelectedChains();
                StructureViewerBase.this.allChainsSelected = false;
            }
        });
        this.chainMenu.add(menuItem);
        for (String chain : chainNames) {
            menuItem = new JCheckBoxMenuItem(chain, true);
            menuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (!StructureViewerBase.this.allChainsSelected) {
                        StructureViewerBase.this.showSelectedChains();
                    }
                }
            });
            this.chainMenu.add(menuItem);
        }
    }

    void setHetatmMenuItems(Map<String, String> hetatmNames) {
        this.hetatmMenu.removeAll();
        if (hetatmNames == null || hetatmNames.isEmpty()) {
            this.hetatmMenu.setVisible(false);
            return;
        }
        this.hetatmMenu.setVisible(true);
        this.allHetatmBeingSelected = false;
        JMenuItem allMenuItem = new JMenuItem(MessageManager.getString("label.all"));
        JMenuItem noneMenuItem = new JMenuItem(MessageManager.getString("label.none"));
        allMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureViewerBase.this.allHetatmBeingSelected = true;
                for (int i = 0; i < StructureViewerBase.this.hetatmMenu.getItemCount(); ++i) {
                    if (!(StructureViewerBase.this.hetatmMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)StructureViewerBase.this.hetatmMenu.getItem(i)).setSelected(true);
                }
                StructureViewerBase.this.allHetatmBeingSelected = false;
                StructureViewerBase.this.showSelectedHetatms();
            }
        });
        noneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureViewerBase.this.allHetatmBeingSelected = true;
                for (int i = 0; i < StructureViewerBase.this.hetatmMenu.getItemCount(); ++i) {
                    if (!(StructureViewerBase.this.hetatmMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)StructureViewerBase.this.hetatmMenu.getItem(i)).setSelected(false);
                }
                StructureViewerBase.this.allHetatmBeingSelected = false;
                StructureViewerBase.this.showSelectedHetatms();
            }
        });
        this.hetatmMenu.add(noneMenuItem);
        this.hetatmMenu.add(allMenuItem);
        for (Map.Entry<String, String> chain : hetatmNames.entrySet()) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(chain.getKey(), false);
            menuItem.setToolTipText(chain.getValue());
            menuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (!StructureViewerBase.this.allHetatmBeingSelected) {
                        StructureViewerBase.this.showSelectedHetatms();
                    }
                }
            });
            this.hetatmMenu.add(menuItem);
        }
    }

    @Override
    public void changeColour_actionPerformed(String colourSchemeName) {
        AlignmentI al = this.getAlignmentPanel().av.getAlignment();
        ColourSchemeI cs = ColourSchemes.getInstance().getColourScheme(colourSchemeName, this.getAlignmentPanel().av, al, null);
        this.getBinding().colourByJalviewColourScheme(cs);
    }

    protected void buildColourMenu() {
        this.colourMenu.removeAll();
        AlignmentI al = this.getAlignmentPanel().av.getAlignment();
        this.colourMenu.add(this.seqColour);
        this.colourMenu.add(this.chainColour);
        this.colourMenu.add(this.chargeColour);
        this.chargeColour.setEnabled(!al.isNucleotide());
        ButtonGroup itemGroup = ColourMenuHelper.addMenuItems(this.colourMenu, this, al, true);
        this.viewerColour.setSelected(false);
        this.viewerColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.viewerColour_actionPerformed();
            }
        });
        this.colourMenu.add(this.viewerColour);
        JMenuItem backGround = new JMenuItem();
        backGround.setText(MessageManager.getString("action.background_colour"));
        backGround.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.background_actionPerformed();
            }
        });
        this.colourMenu.add(backGround);
        itemGroup.add(this.seqColour);
        itemGroup.add(this.chainColour);
        itemGroup.add(this.chargeColour);
        itemGroup.add(this.viewerColour);
    }

    protected void initMenus() {
        AAStructureBindingModel binding = this.getBinding();
        this.seqColour = new JRadioButtonMenuItem();
        this.seqColour.setText(MessageManager.getString("action.by_sequence"));
        this.seqColour.setName(ViewerColour.BySequence.name());
        this.seqColour.setSelected(binding.isColourBySequence());
        this.seqColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.seqColour_actionPerformed();
            }
        });
        this.chainColour = new JRadioButtonMenuItem();
        this.chainColour.setText(MessageManager.getString("action.by_chain"));
        this.chainColour.setName(ViewerColour.ByChain.name());
        this.chainColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.chainColour_actionPerformed();
            }
        });
        this.chargeColour = new JRadioButtonMenuItem();
        this.chargeColour.setText(MessageManager.getString("label.charge_cysteine"));
        this.chargeColour.setName(ViewerColour.ChargeCysteine.name());
        this.chargeColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.chargeColour_actionPerformed();
            }
        });
        this.viewerColour = new JRadioButtonMenuItem();
        this.viewerColour.setText(MessageManager.getString("label.colour_with_viewer"));
        this.viewerColour.setToolTipText(MessageManager.getString("label.let_viewer_manage_structure_colours"));
        this.viewerColour.setName(ViewerColour.ByViewer.name());
        this.viewerColour.setSelected(!binding.isColourBySequence());
        if (this._colourwith == null) {
            this._colourwith = new Vector();
        }
        if (this._alignwith == null) {
            this._alignwith = new Vector();
        }
        ViewSelectionMenu seqColourBy = new ViewSelectionMenu(MessageManager.getString("label.colour_by"), this, this._colourwith, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!StructureViewerBase.this.seqColour.isSelected()) {
                    StructureViewerBase.this.seqColour.doClick();
                } else {
                    StructureViewerBase.this.seqColour_actionPerformed();
                }
            }
        });
        this.viewMenu.add(seqColourBy);
        final ItemListener handler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (StructureViewerBase.this._alignwith.isEmpty()) {
                    StructureViewerBase.this.alignStructs.setEnabled(false);
                    StructureViewerBase.this.alignStructs.setToolTipText(null);
                } else {
                    StructureViewerBase.this.alignStructs.setEnabled(true);
                    StructureViewerBase.this.alignStructs.setToolTipText(MessageManager.formatMessage("label.align_structures_using_linked_alignment_views", StructureViewerBase.this._alignwith.size()));
                }
            }
        };
        this.viewSelectionMenu = new ViewSelectionMenu(MessageManager.getString("label.superpose_with"), this, this._alignwith, handler);
        handler.itemStateChanged(null);
        this.viewerActionMenu.add((Component)this.viewSelectionMenu, 0);
        this.viewerActionMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                handler.itemStateChanged(null);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.viewerActionMenu.setText(this.getViewerName());
        this.helpItem.setText(MessageManager.formatMessage("label.viewer_help", this.getViewerName()));
        this.buildColourMenu();
    }

    @Override
    protected String alignStructsWithAllAlignPanels() {
        if (this.getAlignmentPanel() == null) {
            return null;
        }
        if (this._alignwith.size() == 0) {
            this._alignwith.add(this.getAlignmentPanel());
        }
        String reply = null;
        try {
            reply = this.getBinding().superposeStructures(this._alignwith);
            if (reply != null && !reply.isEmpty()) {
                String text = MessageManager.formatMessage("error.superposition_failed", reply);
                this.statusBar.setText(text);
            }
        }
        catch (Exception e) {
            StringBuffer sp = new StringBuffer();
            for (AlignmentViewPanel alignPanel : this._alignwith) {
                sp.append("'" + alignPanel.getViewName() + "' ");
            }
            Console.info("Couldn't align structures with the " + sp.toString() + "associated alignment panels.", e);
        }
        return reply;
    }

    @Override
    public void background_actionPerformed() {
        String ttl = MessageManager.getString("label.select_background_colour");
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                StructureViewerBase.this.getBinding().setBackgroundColour(c);
            }
        };
        JalviewColourChooser.showColourChooser(this, ttl, null, listener);
    }

    @Override
    public void viewerColour_actionPerformed() {
        if (this.viewerColour.isSelected()) {
            this.getBinding().setColourBySequence(false);
        }
    }

    @Override
    public void chainColour_actionPerformed() {
        this.chainColour.setSelected(true);
        this.getBinding().colourByChain();
    }

    @Override
    public void chargeColour_actionPerformed() {
        this.chargeColour.setSelected(true);
        this.getBinding().colourByCharge();
    }

    @Override
    public void seqColour_actionPerformed() {
        AAStructureBindingModel binding = this.getBinding();
        binding.setColourBySequence(this.seqColour.isSelected());
        if (this._colourwith == null) {
            this._colourwith = new Vector();
        }
        if (binding.isColourBySequence()) {
            if (!binding.isLoadingFromArchive() && this._colourwith.size() == 0 && this.getAlignmentPanel() != null) {
                this._colourwith.add(this.getAlignmentPanel().alignFrame.alignPanel);
            }
            for (AlignmentViewPanel alignPanel : this._colourwith) {
                binding.colourBySequence(alignPanel);
            }
            this.seqColoursApplied = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pdbFile_actionPerformed() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_pdb_file"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            BufferedReader in = null;
            try {
                String data;
                in = new BufferedReader(new FileReader(this.getBinding().getStructureFiles()[0]));
                File outFile = chooser.getSelectedFile();
                PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
                while ((data = in.readLine()) != null) {
                    if (data.indexOf("<PRE>") > -1 || data.indexOf("</PRE>") > -1) continue;
                    out.println(data);
                }
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void viewMapping_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.appendText(this.getBinding().printMappings());
        }
        catch (OutOfMemoryError e) {
            new OOMWarning("composing sequence-structure alignments for display in text box.", e);
            cap.dispose();
            return;
        }
        Desktop.addInternalFrame(cap, MessageManager.getString("label.pdb_sequence_mapping"), 550, 600);
    }

    protected abstract String getViewerName();

    @Override
    public void updateTitleAndMenus() {
        AAStructureBindingModel binding = this.getBinding();
        if (binding.hasFileLoadingError()) {
            this.repaint();
            return;
        }
        this.setChainMenuItems(binding.getChainNames());
        this.setHetatmMenuItems(binding.getHetatmNames());
        this.setTitle(binding.getViewerTitle(this.getViewerName(), true));
        this.viewSelectionMenu.setEnabled(false);
        if (this.getBinding().getMappedStructureCount() > 1 && this.getBinding().getSequence().length > 1) {
            this.viewSelectionMenu.setEnabled(true);
        }
        this.viewerActionMenu.setVisible(false);
        for (int i = 0; i < this.viewerActionMenu.getItemCount(); ++i) {
            if (!this.viewerActionMenu.getItem(i).isEnabled()) continue;
            this.viewerActionMenu.setVisible(true);
            break;
        }
        if (!binding.isLoadingFromArchive()) {
            this.seqColour_actionPerformed();
        }
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public boolean hasMapping() {
        if (this.worker != null && (this.addingStructures || this._started)) {
            return false;
        }
        if (this.getBinding() == null) {
            return this._aps == null || this._aps.size() == 0;
        }
        String[] pdbids = this.getBinding().getStructureFiles();
        if (pdbids == null) {
            return false;
        }
        int p = 0;
        for (String pdbid : pdbids) {
            StructureMapping[] sm = this.getBinding().getSsm().getMapping(pdbid);
            if (sm == null || sm.length <= 0 || sm[0] == null) continue;
            ++p;
        }
        if (p == 0 || p != pdbids.length) {
            return false;
        }
        return this.seqColoursApplied;
    }

    @Override
    public void raiseViewer() {
        this.toFront();
    }

    @Override
    public long startProgressBar(String msg) {
        long tm = this.random.nextLong();
        if (this.progressBar != null) {
            this.progressBar.setProgressBar(msg, tm);
        }
        return tm;
    }

    @Override
    public void stopProgressBar(String msg, long handle) {
        if (this.progressBar != null) {
            this.progressBar.setProgressBar(msg, handle);
        }
    }

    protected IProgressIndicator getProgressIndicator() {
        return this.progressBar;
    }

    protected void setProgressIndicator(IProgressIndicator pi) {
        this.progressBar = pi;
    }

    public void setProgressMessage(String message, long id) {
        if (this.progressBar != null) {
            this.progressBar.setProgressBar(message, id);
        }
    }

    @Override
    public void showConsole(boolean show) {
    }

    protected void showSelectedChains() {
        ArrayList<String> toshow = new ArrayList<String>();
        for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item;
            if (!(this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)this.chainMenu.getItem(i)).isSelected()) continue;
            toshow.add(item.getText());
        }
        this.getBinding().showChains(toshow);
    }

    protected void showSelectedHetatms() {
        ArrayList<String> toshow = new ArrayList<String>();
        for (int i = 0; i < this.hetatmMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item;
            if (!(this.hetatmMenu.getItem(i) instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)this.hetatmMenu.getItem(i)).isSelected()) continue;
            toshow.add(item.getText());
        }
        this.getBinding().showHetatms(toshow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchPdbFile(PDBEntry processingEntry) {
        String filePath = null;
        Pdb pdbclient = new Pdb();
        EBIAlfaFold afclient = new EBIAlfaFold();
        AlignmentI pdbseq = null;
        String pdbid = processingEntry.getId();
        long handle = System.currentTimeMillis() + (long)Thread.currentThread().hashCode();
        String msg = MessageManager.formatMessage("status.fetching_pdb", pdbid);
        this.getAlignmentPanel().alignFrame.setProgressBar(msg, handle);
        try {
            if (afclient.isValidReference(pdbid)) {
                pdbseq = afclient.getSequenceRecords(pdbid, processingEntry.getRetrievalUrl());
            } else if (processingEntry.hasRetrievalUrl()) {
                String safePDBId = URLEncoder.encode(pdbid, "UTF-8").replace("%", "__");
                File tmpFile = File.createTempFile(safePDBId, "." + (PDBEntry.Type.MMCIF.toString().equals(processingEntry.getType().toString()) ? "cif" : "pdb"));
                String fromUrl = processingEntry.getRetrievalUrl();
                UrlDownloadClient.download(fromUrl, tmpFile);
                String file = tmpFile.getAbsolutePath();
                if (file != null) {
                    pdbseq = EBIAlfaFold.importDownloadedStructureFromUrl(fromUrl, tmpFile, pdbid, null, null, null);
                }
            } else {
                pdbseq = pdbclient.getSequenceRecords(pdbid);
            }
        }
        catch (Exception e) {
            Console.errPrintln("Error retrieving PDB id " + pdbid + ": " + e.getMessage());
        }
        finally {
            msg = pdbid + " " + MessageManager.getString("label.state_completed");
            this.getAlignmentPanel().alignFrame.setProgressBar(msg, handle);
        }
        if (pdbseq != null && pdbseq.getHeight() > 0) {
            filePath = new File(pdbseq.getSequenceAt(0).getAllPDBEntries().elementAt(0).getFile()).getAbsolutePath();
            processingEntry.setFile(filePath);
        }
        return filePath;
    }

    @Override
    public File saveSession() {
        if (this.getBinding() == null) {
            return null;
        }
        File session = this.getBinding().saveSession();
        long l = session.length();
        int wait = 50;
        do {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long nextl = session.length();
            if (nextl == l) continue;
            wait = 50;
            l = nextl;
        } while (--wait > 0);
        return session;
    }

    public static void setQuitClose(boolean b) {
        quitClose = b;
    }

    @Override
    public boolean stillRunning() {
        AAStructureBindingModel binding = this.getBinding();
        return binding != null && binding.isViewerRunning();
    }

    @Override
    public void closeViewer(boolean forceClose) {
        AAStructureBindingModel binding = this.getBinding();
        if (this.stillRunning() && !forceClose) {
            String viewerName = this.getViewerName();
            int confirm = 2;
            if (QuitHandler.quitting()) {
                confirm = quitClose ? 0 : 1;
            } else {
                String prompt = MessageManager.formatMessage("label.confirm_close_viewer", binding.getViewerTitle(viewerName, false), viewerName);
                prompt = JvSwingUtils.wrapTooltip(true, prompt);
                String title = MessageManager.getString("label.close_viewer");
                confirm = this.showCloseDialog(title, prompt);
            }
            if (confirm == 2 || confirm == -1) {
                if (confirm == 2) {
                    try {
                        this.setClosed(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    QuitHandler.abortQuit();
                }
                return;
            }
            boolean bl = forceClose = confirm == 0;
        }
        if (binding != null) {
            binding.closeViewer(forceClose);
        }
        this.setAlignmentPanel(null);
        this._aps.clear();
        this._alignwith.clear();
        this._colourwith.clear();
        try {
            svbs.remove(this);
        }
        catch (Throwable t) {
            Console.info("Unexpected exception when deregistering structure viewer", t);
        }
        this.dispose();
    }

    private int showCloseDialog(String title, String prompt) {
        int confirmResponse = 2;
        confirmResponse = JvOptionPane.showConfirmDialog(this, prompt, MessageManager.getString("label.close_viewer"), 1, 2);
        return confirmResponse;
    }

    @Override
    public void showHelp_actionPerformed() {
        String url = this.getBinding().getHelpURL();
        if (url != null) {
            BrowserLauncher.openURL(url);
        }
    }

    @Override
    public boolean hasViewerActionsMenu() {
        return this.viewerActionMenu != null && this.viewerActionMenu.isEnabled() && this.viewerActionMenu.getItemCount() > 0 && this.viewerActionMenu.isVisible();
    }

    static enum ViewerColour {
        BySequence,
        ByChain,
        ChargeCysteine,
        ByViewer;

    }
}

