/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import com.formdev.flatlaf.extras.FlatDesktop;
import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.StructureViewerBase;
import jalview.io.BackupFiles;
import jalview.project.Jalview2XML;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextPane;

public class QuitHandler {
    private static final int MIN_WAIT_FOR_SAVE = 1000;
    private static final int MAX_WAIT_FOR_SAVE = 20000;
    private static boolean interactive = true;
    private static FlatDesktop.QuitResponse flatlafResponse = null;
    protected static Message message = Message.UNSAVED_CHANGES;
    private static ExecutorService executor = Executors.newFixedThreadPool(3);
    private static QResponse gotQuitResponse = QResponse.NULL;
    public static final Runnable defaultCancelQuit = () -> {
        Console.trace("QuitHandler: (default) Quit action CANCELLED by user");
        QuitHandler.setResponse(QResponse.CANCEL_QUIT);
    };
    public static final Runnable defaultOkQuit = () -> {
        Console.trace("QuitHandler: (default) Quit action CONFIRMED by user");
        QuitHandler.setResponse(QResponse.QUIT);
    };
    public static final Runnable defaultForceQuit = () -> {
        Console.trace("QuitHandler: (default) Quit action FORCED by user");
        Runtime.getRuntime().halt(0);
        QuitHandler.setResponse(QResponse.FORCE_QUIT);
    };
    private static JvOptionPane quitDialog = null;

    public static void setMessage(Message m) {
        message = m;
    }

    public static void setQuitHandler() {
        FlatDesktop.setQuitHandler(response -> {
            flatlafResponse = response;
            Desktop.instance.desktopQuit();
        });
    }

    public static void startForceQuit() {
        QuitHandler.setResponse(QResponse.FORCE_QUIT);
    }

    protected static QResponse setResponse(QResponse qresponse) {
        Console.trace("setResponse(" + qresponse.toString() + ")");
        gotQuitResponse = qresponse;
        if ((qresponse == QResponse.CANCEL_QUIT || qresponse == QResponse.NULL) && flatlafResponse != null) {
            Console.trace("Running flatLafResponse.cancelQuit()");
            flatlafResponse.cancelQuit();
        }
        return qresponse;
    }

    public static QResponse gotQuitResponse() {
        return gotQuitResponse;
    }

    public static QResponse getQuitResponse(boolean ui) {
        return QuitHandler.getQuitResponse(ui, defaultOkQuit, defaultForceQuit, defaultCancelQuit);
    }

    public static QResponse getQuitResponse(boolean ui, Runnable okQuit, Runnable forceQuit, Runnable cancelQuit) {
        int count;
        QResponse got = QuitHandler.gotQuitResponse();
        Console.trace("Quit response is '" + got.toString() + "' at start of getQuitResponse(...)");
        if (got != QResponse.NULL && got != QResponse.CANCEL_QUIT) {
            Console.trace("Returning already set quit response of '" + got.toString() + "' at start of getQuitResponse(...)");
            return got;
        }
        interactive = ui && !Platform.isHeadless();
        boolean confirmQuit = true;
        if (!interactive) {
            Console.debug("Non interactive quit -- not confirming");
            confirmQuit = false;
        } else if (Jalview2XML.allSavedUpToDate()) {
            Console.debug("Nothing changed -- not confirming quit");
            confirmQuit = false;
        } else {
            confirmQuit = Cache.getDefault("CONFIRM_KEYBOARD_QUIT", true);
            Console.trace("Jalview property 'CONFIRM_KEYBOARD_QUIT' is " + confirmQuit + " -- " + (confirmQuit ? "" : "not ") + "confirming quit");
        }
        got = confirmQuit ? QResponse.NULL : QResponse.QUIT;
        QuitHandler.setResponse(got);
        Console.trace("confirmQuit is '" + confirmQuit + "', setting quit response to " + (Object)((Object)got));
        if (confirmQuit) {
            String messageString = MessageManager.getString(message == Message.UNSAVED_ALIGNMENTS ? "label.unsaved_alignments" : "label.unsaved_changes");
            QuitHandler.setQuitDialog(JvOptionPane.newOptionDialog().setResponseHandler(0, defaultOkQuit).setResponseHandler(1, cancelQuit));
            JvOptionPane qd = QuitHandler.getQuitDialog();
            qd.showDialogOnTopAsync(MessageManager.getString("label.quit_jalview") + "\n" + messageString, MessageManager.getString("action.quit"), 0, 3, null, new Object[]{MessageManager.getString("action.quit"), MessageManager.getString("action.cancel")}, MessageManager.getString("action.quit"), true);
            Console.trace("Waiting for response handler to run action");
            qd.waitForHandlerToFinish();
        }
        got = QuitHandler.gotQuitResponse();
        Console.trace("Quit response is '" + got.toString() + "' after response handler");
        if (got != QResponse.CANCEL_QUIT && (count = Desktop.instance.structureViewersStillRunningCount()) > 0) {
            String alwaysCloseExternalViewers = Cache.getDefault("ALWAYS_CLOSE_EXTERNAL_VIEWERS", "ask");
            String prompt = MessageManager.formatMessage(count == 1 ? "label.confirm_quit_viewer" : "label.confirm_quit_viewers", new Object[0]);
            String title = MessageManager.getString(count == 1 ? "label.close_viewer" : "label.close_viewers");
            String cancelQuitText = MessageManager.getString("action.cancel_quit");
            Object[] buttonsText = new String[]{MessageManager.getString("action.yes"), MessageManager.getString("action.no"), cancelQuitText};
            int confirmResponse = -1;
            if (alwaysCloseExternalViewers == null || "ask".equals(alwaysCloseExternalViewers.toLowerCase(Locale.ROOT))) {
                confirmResponse = JvOptionPane.showOptionDialog((Component)Desktop.instance, prompt, title, 1, 2, null, buttonsText, (Object)cancelQuit);
            } else {
                int n = confirmResponse = Cache.getDefault("ALWAYS_CLOSE_EXTERNAL_VIEWERS", false) ? 0 : 1;
            }
            if (confirmResponse == 2) {
                QuitHandler.setResponse(QResponse.CANCEL_QUIT);
            } else {
                StructureViewerBase.setQuitClose(confirmResponse == 0);
            }
        }
        got = QuitHandler.gotQuitResponse();
        Console.trace("Quit response is '" + got.toString() + "' after external structure viewer check");
        if (got == QResponse.CANCEL_QUIT) {
            Console.debug("Cancelling quit.  Resetting response to NULL");
            QuitHandler.setResponse(QResponse.NULL);
            return QResponse.CANCEL_QUIT;
        }
        if (got == QResponse.QUIT) {
            Console.debug("Quit response is '" + got.toString() + "' before waiting for save");
            if (Cache.getDefault("WAIT_FOR_SAVE", true) && BackupFiles.hasSavesInProgress()) {
                QuitHandler.waitQuit(interactive, okQuit, forceQuit, cancelQuit);
            }
            Console.debug("Quit response is '" + got.toString() + "' after waiting for save");
        }
        Runnable next = null;
        got = QuitHandler.gotQuitResponse();
        Console.debug("Quit response is '" + got.toString() + "' before setting next");
        switch (QuitHandler.gotQuitResponse()) {
            case QUIT: {
                next = okQuit;
                break;
            }
            case FORCE_QUIT: {
                next = forceQuit;
                break;
            }
            default: {
                next = cancelQuit;
            }
        }
        Console.debug("Quit response is '" + got.toString() + "' after setting next");
        Console.debug("Next is '" + next + "'");
        try {
            executor.submit(next).get();
            Console.debug(next + " is submitted");
            got = QuitHandler.gotQuitResponse();
            Console.debug("Quit response is '" + got.toString() + "' after submitting next");
        }
        catch (RejectedExecutionException e) {
            Console.info("Quit aborted!");
            got = QResponse.NULL;
            QuitHandler.setResponse(QResponse.NULL);
        }
        catch (InterruptedException | ExecutionException e) {
            Console.debug("Exception during quit handling (final choice)", e);
        }
        Console.debug("Setting response to '" + got.toString() + "' after submitting next");
        QuitHandler.setResponse(got);
        Console.debug("Checking if quit was cancelled");
        if (QuitHandler.quitCancelled()) {
            Console.debug("Quit cancelled");
            QuitHandler.setResponse(QResponse.NULL);
            Console.debug("Set response to " + QResponse.NULL.toString() + ". Returning " + (Object)((Object)QResponse.CANCEL_QUIT));
            return QResponse.CANCEL_QUIT;
        }
        got = QuitHandler.gotQuitResponse();
        Console.debug("Returning " + got.toString());
        return got;
    }

    private static QResponse waitQuit(boolean interactive, Runnable okQuit, Runnable forceQuit, Runnable cancelQuit) {
        if (!BackupFiles.hasSavesInProgress()) {
            return QResponse.QUIT;
        }
        int size = 0;
        AlignFrame[] afArray = Desktop.getDesktopAlignFrames();
        if (afArray != null && afArray.length != 0) {
            for (int i = 0; i < afArray.length; ++i) {
                AlignFrame af = afArray[i];
                List<? extends AlignmentViewPanel> avpList = af.getAlignPanels();
                for (AlignmentViewPanel alignmentViewPanel : avpList) {
                    AlignmentI a = alignmentViewPanel.getAlignment();
                    List<SequenceI> sList = a.getSequences();
                    for (SequenceI s : sList) {
                        size += s.getLength();
                    }
                }
            }
        }
        int waitTime = Math.min(20000, Math.max(1000, size / 2));
        Console.debug("Set waitForSave to " + waitTime);
        int iteration = 0;
        boolean doIterations = true;
        while (doIterations && BackupFiles.hasSavesInProgress() && iteration++ < (interactive ? 100 : 5)) {
            Object[] options;
            CompletableFuture filesAllSaved = new CompletableFuture();
            for (CompletableFuture<Boolean> cf : BackupFiles.savesInProgressCompletableFutures(false)) {
                cf.whenComplete((ret, e) -> {
                    if (!BackupFiles.hasSavesInProgress()) {
                        filesAllSaved.complete(true);
                    }
                });
            }
            try {
                filesAllSaved.get(waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                Console.debug("Exception whilst waiting for files to save before quit", exception);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            if (!interactive || !BackupFiles.hasSavesInProgress()) continue;
            boolean bl = iteration > 0;
            JFrame parent = new JFrame();
            JButton[] buttons = new JButton[]{new JButton(), new JButton()};
            JvOptionPane waitDialog = JvOptionPane.newOptionDialog();
            JTextPane messagePane = new JTextPane();
            messagePane.setBackground(waitDialog.getBackground());
            messagePane.setBorder(null);
            messagePane.setText(QuitHandler.waitingForSaveMessage());
            for (CompletableFuture<Boolean> cf : BackupFiles.savesInProgressCompletableFutures(false)) {
                cf.whenComplete((ret, e) -> {
                    if (BackupFiles.hasSavesInProgress()) {
                        messagePane.setText(QuitHandler.waitingForSaveMessage());
                    } else if (!QuitHandler.quitCancelled()) {
                        for (int i = 0; i < buttons.length; ++i) {
                            Console.debug("DISABLING BUTTON " + buttons[i].getText());
                            buttons[i].setEnabled(false);
                            buttons[i].setVisible(false);
                        }
                        messagePane.setText(MessageManager.getString("label.all_saved") + "\n" + MessageManager.getString("label.quitting_bye"));
                        messagePane.setEditable(false);
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        parent.dispose();
                    }
                });
            }
            int dialogType = -1;
            if (bl) {
                options = new String[]{MessageManager.getString("action.force_quit"), MessageManager.getString("action.cancel_quit")};
                dialogType = 0;
                waitDialog.setResponseHandler(0, forceQuit).setResponseHandler(1, cancelQuit);
            } else {
                options = new String[]{MessageManager.getString("action.cancel_quit")};
                dialogType = 0;
                waitDialog.setResponseHandler(0, cancelQuit);
            }
            waitDialog.showDialogOnTopAsync(parent, messagePane, MessageManager.getString("label.wait_for_save"), dialogType, 2, null, options, MessageManager.getString("action.cancel_quit"), true, buttons);
            parent.dispose();
            QResponse thisWaitResponse = QuitHandler.gotQuitResponse();
            switch (thisWaitResponse) {
                case QUIT: {
                    break;
                }
                case FORCE_QUIT: {
                    doIterations = false;
                    break;
                }
                case CANCEL_QUIT: {
                    doIterations = false;
                    break;
                }
                case NULL: {
                    doIterations = false;
                    break;
                }
            }
        }
        return QuitHandler.gotQuitResponse();
    }

    private static String waitingForSaveMessage() {
        boolean any;
        StringBuilder messageSB = new StringBuilder();
        messageSB.append(MessageManager.getString("label.save_in_progress"));
        List<File> files = BackupFiles.savesInProgressFiles(false);
        boolean bl = any = files.size() > 0;
        if (any) {
            for (File file : files) {
                messageSB.append("\n\u2022 ").append(file.getName());
            }
        } else {
            messageSB.append(MessageManager.getString("label.unknown"));
        }
        messageSB.append("\n\n").append(MessageManager.getString("label.quit_after_saving"));
        return messageSB.toString();
    }

    public static void abortQuit() {
        QuitHandler.setResponse(QResponse.NULL);
    }

    private static void setQuitDialog(JvOptionPane qd) {
        quitDialog = qd;
    }

    private static JvOptionPane getQuitDialog() {
        return quitDialog;
    }

    public static boolean quitCancelled() {
        return QuitHandler.gotQuitResponse() == QResponse.CANCEL_QUIT || QuitHandler.gotQuitResponse() == QResponse.NULL;
    }

    public static boolean quitting() {
        return QuitHandler.gotQuitResponse() == QResponse.QUIT || QuitHandler.gotQuitResponse() == QResponse.FORCE_QUIT;
    }

    public static enum Message {
        UNSAVED_CHANGES,
        UNSAVED_ALIGNMENTS;

    }

    public static enum QResponse {
        NULL,
        QUIT,
        CANCEL_QUIT,
        FORCE_QUIT;

    }
}

