/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.bin.Console;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.pymol.PymolCommands;
import jalview.ext.pymol.PymolManager;
import jalview.gui.SequenceRenderer;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.structure.AtomSpec;
import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.AAStructureBindingModel;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PymolBindingModel
extends AAStructureBindingModel {
    private static String LABEL_FORMAT = "\"%s %s\" % (resn,resi)";
    private PymolManager pymolManager;
    List<String> structureFiles = new ArrayList<String>();
    Map<String, String> pymolObjects = new HashMap<String, String>();
    private String lastLabelSpec;

    public PymolBindingModel(StructureViewerBase viewer, StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs) {
        super(ssm, pdbentry, sequenceIs, null);
        this.pymolManager = new PymolManager();
        this.setStructureCommands(new PymolCommands());
        this.setViewer(viewer);
    }

    @Override
    public String[] getStructureFiles() {
        return this.structureFiles.toArray(new String[this.structureFiles.size()]);
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
        StringBuilder sb = new StringBuilder();
        for (AtomSpec atom : atoms) {
            String modelId = this.getModelIdForFile(atom.getPdbFile());
            sb.append(String.format(" %s//%s/%d/*", modelId, atom.getChain(), atom.getPdbResNum()));
        }
        String labelSpec = sb.toString();
        if (labelSpec.equals(this.lastLabelSpec)) {
            return;
        }
        StructureCommand command = new StructureCommand("indicate", labelSpec);
        this.executeCommand(command, false);
        this.lastLabelSpec = labelSpec;
    }

    @Override
    public SequenceRenderer getSequenceRenderer(AlignmentViewPanel avp) {
        return new SequenceRenderer(avp.getAlignViewport());
    }

    @Override
    protected List<String> executeCommand(StructureCommandI command, boolean getReply) {
        return this.pymolManager.sendCommand(command, getReply);
    }

    @Override
    protected String getModelIdForFile(String file) {
        return this.pymolObjects.containsKey(file) ? this.pymolObjects.get(file) : "";
    }

    @Override
    protected StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.PYMOL;
    }

    @Override
    public boolean isViewerRunning() {
        return this.pymolManager != null && this.pymolManager.isPymolLaunched();
    }

    @Override
    public void closeViewer(boolean closePymol) {
        super.closeViewer(closePymol);
        this.pymolManager = null;
    }

    public boolean launchPymol() {
        if (this.pymolManager.isPymolLaunched()) {
            return true;
        }
        Process pymol = this.pymolManager.launchPymol();
        if (pymol != null) {
            this.startExternalViewerMonitor(pymol);
        } else {
            Console.error("Failed to launch PyMOL!");
        }
        return pymol != null;
    }

    public void openFile(PDBEntry pe) {
        String file = pe.getFile();
        StructureCommandI cmd = this.getCommandGenerator().loadFile(file);
        String pdbId = pe.getId();
        try {
            String safePDBId = URLEncoder.encode(pdbId, "UTF-8");
            pdbId = safePDBId.replace('%', '_');
            pdbId = pdbId.replace("-", "__");
            char fc = pdbId.charAt(0);
            if (fc >= '0' && fc <= '9') {
                pdbId = 's' + pdbId;
            }
        }
        catch (Exception x) {
            Console.error("Unxpected encoding exception for '" + pdbId + "'", x);
        }
        cmd.addParameter(pdbId);
        this.executeCommand(cmd, false);
        this.pymolObjects.put(file, pdbId);
        if (!this.structureFiles.contains(file)) {
            this.structureFiles.add(file);
        }
        if (this.getSsm() != null) {
            this.getSsm().addStructureViewerListener(this);
        }
    }

    @Override
    protected String getModelId(int pdbfnum, String file) {
        return file;
    }

    @Override
    public String getSessionFileExtension() {
        return ".pse";
    }

    @Override
    public String getHelpURL() {
        return "https://pymolwiki.org/";
    }

    public int sendFeaturesToViewer(AlignmentViewPanel avp) {
        Map<String, Map<Object, AtomSpecModel>> featureValues = this.buildFeaturesMap(avp);
        List<StructureCommandI> commands = this.getCommandGenerator().setAttributes(featureValues);
        this.executeCommands(commands, false, null);
        return commands.size();
    }
}

