/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import jalview.analysis.AnnotationSorter;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.MemorySetting;
import jalview.ext.pymol.PymolManager;
import jalview.gui.Desktop;
import jalview.gui.Help;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OverviewCanvas;
import jalview.gui.StructureViewer;
import jalview.gui.WsPreferences;
import jalview.io.BackupFilesPresetEntry;
import jalview.io.FileFormatI;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.PIRFile;
import jalview.jbgui.GPreferences;
import jalview.jbgui.GSequenceLink;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.urls.UrlLinkTableModel;
import jalview.urls.api.UrlProviderI;
import jalview.urls.desktop.DesktopUrlProviderFactory;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.sifts.SiftsSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.help.HelpSetException;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Preferences
extends GPreferences {
    public static final String ENABLE_SPLIT_FRAME = "ENABLE_SPLIT_FRAME";
    public static final String SCALE_PROTEIN_TO_CDNA = "SCALE_PROTEIN_TO_CDNA";
    public static final String DEFAULT_COLOUR = "DEFAULT_COLOUR";
    public static final String DEFAULT_COLOUR_PROT = "DEFAULT_COLOUR_PROT";
    public static final String DEFAULT_COLOUR_NUC = "DEFAULT_COLOUR_NUC";
    public static final String ADD_TEMPFACT_ANN = "ADD_TEMPFACT_ANN";
    public static final String ADD_SS_ANN = "ADD_SS_ANN";
    public static final String USE_RNAVIEW = "USE_RNAVIEW";
    public static final String STRUCT_FROM_PDB = "STRUCT_FROM_PDB";
    public static final String STRUCTURE_DISPLAY = "STRUCTURE_DISPLAY";
    public static final String CHIMERA_PATH = "CHIMERA_PATH";
    public static final String CHIMERAX_PATH = "CHIMERAX_PATH";
    public static final String PYMOL_PATH = "PYMOL_PATH";
    public static final String SORT_ANNOTATIONS = "SORT_ANNOTATIONS";
    public static final String SHOW_AUTOCALC_ABOVE = "SHOW_AUTOCALC_ABOVE";
    public static final String SHOW_OCCUPANCY = "SHOW_OCCUPANCY";
    public static final String SHOW_OV_HIDDEN_AT_START = "SHOW_OV_HIDDEN_AT_START";
    public static final String USE_LEGACY_GAP = "USE_LEGACY_GAP";
    public static final String GAP_COLOUR = "GAP_COLOUR";
    public static final String HIDDEN_COLOUR = "HIDDEN_COLOUR";
    private static final int MIN_FONT_SIZE = 1;
    private static final int MAX_FONT_SIZE = 30;
    private String previousProxyType;
    private static Preferences INSTANCE = null;
    public static UrlProviderI sequenceUrlLinks;
    public static UrlLinkTableModel dataModel;
    public static List<String> groupURLLinks;
    JInternalFrame frame;
    private WsPreferences wsPrefs;
    private OptionsParam promptEachTimeOpt = new OptionsParam(MessageManager.getString("label.prompt_each_time"), "Prompt each time");
    private OptionsParam lineArtOpt = new OptionsParam(MessageManager.getString("label.lineart"), "Lineart");
    private OptionsParam textOpt = new OptionsParam(MessageManager.getString("action.text"), "Text");

    public static Preferences getInstance() {
        if (INSTANCE == null || Preferences.INSTANCE.frame == null || Preferences.INSTANCE.frame.isClosed()) {
            INSTANCE = new Preferences();
        }
        return INSTANCE;
    }

    public static void openPreferences() {
        Preferences.openPreferences(null, null);
    }

    public static void openPreferences(GPreferences.TabRef selectTab, String message) {
        Preferences p = Preferences.getInstance();
        if (selectTab != null) {
            p.selectTab(selectTab, message);
        }
        p.frame.show();
        p.frame.moveToFront();
        p.frame.grabFocus();
    }

    public void selectTab(GPreferences.TabRef selectTab, String message) {
        this.selectTab(selectTab);
        if (message != null) {
            this.setMessage(message);
        }
        this.frame.show();
    }

    private Preferences() {
        String proxyTypeString;
        int i;
        Cache.disableSessionProperties();
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        if (!Platform.isJS()) {
            this.wsPrefs = new WsPreferences();
            this.wsTab.add((Component)this.wsPrefs, "Center");
        }
        int width = 500;
        int height = 450;
        if (Platform.isAMacAndNotJS()) {
            width = 570;
            height = 480;
        }
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.preferences"), width, height);
        this.frame.setMinimumSize(new Dimension(width, height));
        this.seqLimit.setSelected(Cache.getDefault("SHOW_JVSUFFIX", true));
        this.rightAlign.setSelected(Cache.getDefault("RIGHT_ALIGN_IDS", false));
        this.fullScreen.setSelected(Cache.getDefault("SHOW_FULLSCREEN", false));
        this.annotations.setSelected(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.conservation.setSelected(Cache.getDefault("SHOW_CONSERVATION", true));
        this.quality.setSelected(Cache.getDefault("SHOW_QUALITY", true));
        this.identity.setSelected(Cache.getDefault("SHOW_IDENTITY", true));
        this.ssConsensus.setSelected(Cache.getDefault("SHOW_SS_CONSENSUS", false));
        this.openoverv.setSelected(Cache.getDefault("SHOW_OVERVIEW", false));
        this.showUnconserved.setSelected(Cache.getDefault("SHOW_UNCONSERVED", false));
        this.showOccupancy.setSelected(Cache.getDefault(SHOW_OCCUPANCY, false));
        this.showGroupConsensus.setSelected(Cache.getDefault("SHOW_GROUP_CONSENSUS", false));
        this.showGroupConservation.setSelected(Cache.getDefault("SHOW_GROUP_CONSERVATION", false));
        this.showConsensHistogram.setSelected(Cache.getDefault("SHOW_CONSENSUS_HISTOGRAM", true));
        this.showConsensLogo.setSelected(Cache.getDefault("SHOW_CONSENSUS_LOGO", false));
        this.showNpTooltip.setSelected(Cache.getDefault("SHOW_NPFEATS_TOOLTIP", true));
        this.showDbRefTooltip.setSelected(Cache.getDefault("SHOW_DBREFS_TOOLTIP", true));
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontNameCB.addItem(fonts[i]);
        }
        for (i = 1; i <= 30; ++i) {
            this.fontSizeCB.addItem(i + "");
        }
        this.fontStyleCB.addItem("plain");
        this.fontStyleCB.addItem("bold");
        this.fontStyleCB.addItem("italic");
        this.fontNameCB.setSelectedItem(Cache.getDefault("FONT_NAME", "SansSerif"));
        this.fontSizeCB.setSelectedItem(Cache.getDefault("FONT_SIZE", "10"));
        this.fontStyleCB.setSelectedItem(Cache.getDefault("FONT_STYLE", "0"));
        this.smoothFont.setSelected(Cache.getDefault("ANTI_ALIAS", true));
        this.scaleProteinToCdna.setSelected(Cache.getDefault(SCALE_PROTEIN_TO_CDNA, false));
        this.idItalics.setSelected(Cache.getDefault("ID_ITALICS", true));
        this.wrap.setSelected(Cache.getDefault("WRAP_ALIGNMENT", false));
        this.gapSymbolCB.addItem("-");
        this.gapSymbolCB.addItem(".");
        this.gapSymbolCB.setSelectedItem(Cache.getDefault("GAP_SYMBOL", "-"));
        this.sortby.addItem("No sort");
        this.sortby.addItem("Id");
        this.sortby.addItem("Pairwise Identity");
        this.sortby.setSelectedItem(Cache.getDefault("SORT_ALIGNMENT", "No sort"));
        this.sortAnnBy.addItem(AnnotationSorter.SequenceAnnotationOrder.NONE.toString());
        this.sortAnnBy.addItem(AnnotationSorter.SequenceAnnotationOrder.SEQUENCE_AND_LABEL.toString());
        this.sortAnnBy.addItem(AnnotationSorter.SequenceAnnotationOrder.LABEL_AND_SEQUENCE.toString());
        AnnotationSorter.SequenceAnnotationOrder savedSort = AnnotationSorter.SequenceAnnotationOrder.valueOf(Cache.getDefault(SORT_ANNOTATIONS, AnnotationSorter.SequenceAnnotationOrder.NONE.name()));
        this.sortAnnBy.setSelectedItem(savedSort.toString());
        this.sortAutocalc.addItem("Autocalculated first");
        this.sortAutocalc.addItem("Autocalculated last");
        boolean showAbove = Cache.getDefault(SHOW_AUTOCALC_ABOVE, true);
        this.sortAutocalc.setSelectedItem(showAbove ? this.sortAutocalc.getItemAt(0) : this.sortAutocalc.getItemAt(1));
        this.startupCheckbox.setSelected(Cache.getDefault("SHOW_STARTUP_FILE", true));
        this.startupFileTextfield.setText(Cache.getDefault("STARTUP_FILE", Cache.getDefault("www.jalview.org", "https://www.jalview.org") + "/examples/exampleFile_2_7.jvp"));
        this.protColour.addItem("None");
        this.nucColour.addItem("None");
        for (ColourSchemeI cs : ColourSchemes.getInstance().getColourSchemes()) {
            String name = cs.getSchemeName();
            this.protColour.addItem(name);
            this.nucColour.addItem(name);
        }
        String oldProp = Cache.getDefault(DEFAULT_COLOUR, "None");
        String newProp = Cache.getDefault(DEFAULT_COLOUR_PROT, null);
        this.protColour.setSelectedItem(newProp != null ? newProp : oldProp);
        newProp = Cache.getDefault(DEFAULT_COLOUR_NUC, null);
        this.nucColour.setSelectedItem(newProp != null ? newProp : oldProp);
        this.minColour.setBackground(Cache.getDefaultColour("ANNOTATIONCOLOUR_MIN", Color.orange));
        this.maxColour.setBackground(Cache.getDefaultColour("ANNOTATIONCOLOUR_MAX", Color.red));
        this.gapColour.setBackground(Cache.getDefaultColour(GAP_COLOUR, OverviewCanvas.OVERVIEW_DEFAULT_GAP));
        this.hiddenColour.setBackground(Cache.getDefaultColour(HIDDEN_COLOUR, OverviewCanvas.OVERVIEW_DEFAULT_HIDDEN));
        this.useLegacyGap.setSelected(Cache.getDefault(USE_LEGACY_GAP, false));
        this.gapLabel.setEnabled(!this.useLegacyGap.isSelected());
        this.gapColour.setEnabled(!this.useLegacyGap.isSelected());
        this.showHiddenAtStart.setSelected(Cache.getDefault(SHOW_OV_HIDDEN_AT_START, false));
        boolean structSelected = Cache.getDefault(STRUCT_FROM_PDB, true);
        this.structFromPdb.setSelected(structSelected);
        this.addSecondaryStructure.setSelected(Cache.getDefault(ADD_SS_ANN, true));
        this.addSecondaryStructure.setEnabled(structSelected);
        this.addTempFactor.setSelected(Cache.getDefault(ADD_TEMPFACT_ANN, true));
        this.addTempFactor.setEnabled(structSelected);
        final String viewerType = Cache.getDefault(STRUCTURE_DISPLAY, StructureViewer.ViewerType.JMOL.name());
        this.structViewer.setSelectedItem(viewerType);
        String viewerPath = "";
        StructureViewer.ViewerType type = null;
        try {
            type = StructureViewer.ViewerType.valueOf(viewerType);
            switch (type) {
                case JMOL: {
                    break;
                }
                case CHIMERA: {
                    viewerPath = Cache.getDefault(CHIMERA_PATH, "");
                    break;
                }
                case CHIMERAX: {
                    viewerPath = Cache.getDefault(CHIMERAX_PATH, "");
                    break;
                }
                case PYMOL: {
                    viewerPath = Cache.getDefault(PYMOL_PATH, "");
                }
            }
        }
        catch (IllegalArgumentException e) {
            Console.error("Unknown structure viewer type: " + viewerType + ", defaulting to Jmol");
            type = StructureViewer.ViewerType.JMOL;
        }
        this.structureViewerPath.setText(viewerPath);
        this.structureViewerPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Preferences.this.validateViewerPath()) {
                    String path = Preferences.this.structureViewerPath.getText();
                    try {
                        StructureViewer.ViewerType type = StructureViewer.ViewerType.valueOf(viewerType);
                        switch (type) {
                            case JMOL: {
                                break;
                            }
                            case CHIMERA: {
                                Cache.setProperty(Preferences.CHIMERA_PATH, path);
                                break;
                            }
                            case CHIMERAX: {
                                Cache.setProperty(Preferences.CHIMERAX_PATH, path);
                                break;
                            }
                            case PYMOL: {
                                Cache.setProperty(Preferences.PYMOL_PATH, path);
                            }
                        }
                    }
                    catch (IllegalArgumentException x) {
                        Console.error("Failed to set path - unknown viewer type", x);
                    }
                }
            }
        });
        if (Cache.getDefault("MAP_WITH_SIFTS", false)) {
            this.siftsMapping.setSelected(true);
        } else {
            this.nwMapping.setSelected(true);
        }
        SiftsSettings.setMapWithSifts(Cache.getDefault("MAP_WITH_SIFTS", false));
        this.linkUrlTable.setModel(dataModel);
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.linkUrlTable.getModel());
        this.linkUrlTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        UrlLinkTableModel m = (UrlLinkTableModel)this.linkUrlTable.getModel();
        sortKeys.add(new RowSorter.SortKey(m.getPrimaryColumn(), SortOrder.DESCENDING));
        sortKeys.add(new RowSorter.SortKey(m.getSelectedColumn(), SortOrder.DESCENDING));
        sortKeys.add(new RowSorter.SortKey(m.getNameColumn(), SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        ActionListener onReset = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.filterTB.setText("");
                sorter.setRowFilter(RowFilter.regexFilter("", new int[0]));
            }
        };
        this.doReset.addActionListener(onReset);
        final RowFilter<TableModel, Object> customUrlFilter = new RowFilter<TableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Object> entry) {
                return ((UrlLinkTableModel)entry.getModel()).isUserEntry(entry);
            }
        };
        TableRowSorter<TableModel> customSorter = new TableRowSorter<TableModel>(this.linkUrlTable.getModel());
        customSorter.setRowFilter(customUrlFilter);
        ActionListener onCustomOnly = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.filterTB.setText("");
                sorter.setRowFilter(customUrlFilter);
            }
        };
        this.userOnly.addActionListener(onCustomOnly);
        this.filterTB.getDocument().addDocumentListener(new DocumentListener(){
            String caseInsensitiveFlag = "(?i)";

            @Override
            public void changedUpdate(DocumentEvent e) {
                sorter.setRowFilter(RowFilter.regexFilter(this.caseInsensitiveFlag + Preferences.this.filterTB.getText(), new int[0]));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                sorter.setRowFilter(RowFilter.regexFilter(this.caseInsensitiveFlag + Preferences.this.filterTB.getText(), new int[0]));
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                sorter.setRowFilter(RowFilter.regexFilter(this.caseInsensitiveFlag + Preferences.this.filterTB.getText(), new int[0]));
            }
        });
        this.linkUrlTable.getSelectionModel().addListSelectionListener(new UrlListSelectionHandler());
        int onClickCol = ((UrlLinkTableModel)this.linkUrlTable.getModel()).getPrimaryColumn();
        String onClickName = this.linkUrlTable.getColumnName(onClickCol);
        this.linkUrlTable.getColumn(onClickName).setCellRenderer(new GPreferences.RadioButtonRenderer());
        this.linkUrlTable.getColumn(onClickName).setCellEditor(new GPreferences.RadioButtonEditor());
        for (int column = 0; column < this.linkUrlTable.getColumnCount(); ++column) {
            if (!this.linkUrlTable.getModel().getColumnClass(column).equals(Boolean.class)) continue;
            Object tableColumn = this.linkUrlTable.getColumnModel().getColumn(column);
            int preferredWidth = ((TableColumn)tableColumn).getMinWidth();
            TableCellRenderer cellRenderer = this.linkUrlTable.getCellRenderer(0, column);
            Component c = this.linkUrlTable.prepareRenderer(cellRenderer, 0, column);
            int cwidth = c.getPreferredSize().width + this.linkUrlTable.getIntercellSpacing().width;
            preferredWidth = Math.max(preferredWidth, cwidth);
            ((TableColumn)tableColumn).setPreferredWidth(preferredWidth);
        }
        this.previousProxyType = proxyTypeString = Cache.getDefault("USE_PROXY", "false");
        switch (proxyTypeString) {
            case "none": {
                this.proxyType.setSelected(this.noProxy.getModel(), true);
                break;
            }
            case "false": {
                this.proxyType.setSelected(this.systemProxy.getModel(), true);
                break;
            }
            case "true": {
                this.proxyType.setSelected(this.customProxy.getModel(), true);
                break;
            }
            default: {
                Console.warn("Incorrect PROXY_TYPE - should be 'none' (clear proxy properties), 'false' (system settings), 'true' (custom settings): " + proxyTypeString);
            }
        }
        this.proxyServerHttpTB.setText(Cache.getDefault("PROXY_SERVER", ""));
        this.proxyPortHttpTB.setText(Cache.getDefault("PROXY_PORT", ""));
        this.proxyServerHttpsTB.setText(Cache.getDefault("PROXY_SERVER_HTTPS", ""));
        this.proxyPortHttpsTB.setText(Cache.getDefault("PROXY_PORT_HTTPS", ""));
        this.proxyAuth.setSelected(Cache.getDefault("PROXY_AUTH", false));
        this.proxyAuthUsernameTB.setText(Cache.getDefault("PROXY_AUTH_USERNAME", ""));
        this.proxyAuthPasswordPB.setText(Cache.proxyAuthPassword == null ? "" : new String(Cache.proxyAuthPassword));
        this.setCustomProxyEnabled();
        this.applyProxyButtonEnabled(false);
        this.usagestats.setSelected(Cache.getDefault("USAGESTATS", false));
        this.questionnaire.setSelected(Cache.getProperty("NOQUESTIONNAIRES") == null);
        this.versioncheck.setSelected(Cache.getDefault("VERSION_CHECK", true));
        this.setupOutputCombo(this.epsRendering, "EPS_RENDERING");
        this.setupOutputCombo(this.htmlRendering, "HTML_RENDERING");
        this.setupOutputCombo(this.svgRendering, "SVG_RENDERING");
        this.autoIdWidth.setSelected(Cache.getDefault("FIGURE_AUTOIDWIDTH", false));
        this.userIdWidth.setEnabled(!this.autoIdWidth.isSelected());
        this.userIdWidthlabel.setEnabled(!this.autoIdWidth.isSelected());
        Integer wi = Cache.getIntegerProperty("FIGURE_FIXEDIDWIDTH");
        this.userIdWidth.setText(wi == null ? "" : wi.toString());
        this.blcjv.setSelected(Cache.getDefault("BLC_JVSUFFIX", true));
        this.clustaljv.setSelected(Cache.getDefault("CLUSTAL_JVSUFFIX", true));
        this.fastajv.setSelected(Cache.getDefault("FASTA_JVSUFFIX", true));
        this.msfjv.setSelected(Cache.getDefault("MSF_JVSUFFIX", true));
        this.pfamjv.setSelected(Cache.getDefault("PFAM_JVSUFFIX", true));
        this.pileupjv.setSelected(Cache.getDefault("PILEUP_JVSUFFIX", true));
        this.pirjv.setSelected(Cache.getDefault("PIR_JVSUFFIX", true));
        this.modellerOutput.setSelected(Cache.getDefault("PIR_MODELLER", false));
        this.embbedBioJSON.setSelected(Cache.getDefault("EXPORT_EMBBED_BIOJSON", true));
        this.autoCalculateConsCheck.setSelected(Cache.getDefault("AUTO_CALC_CONSENSUS", true));
        this.padGaps.setSelected(Cache.getDefault("PAD_GAPS", false));
        this.sortByTree.setSelected(Cache.getDefault("SORT_BY_TREE", false));
        this.annotations_actionPerformed(null);
        this.loadLastSavedBackupsOptions();
        Cache.enableSessionProperties();
    }

    protected void setupOutputCombo(JComboBox<Object> comboBox, String propertyKey) {
        String defaultOption;
        Cache.disableSessionProperties();
        comboBox.addItem(this.promptEachTimeOpt);
        comboBox.addItem(this.lineArtOpt);
        comboBox.addItem(this.textOpt);
        String string = defaultOption = Platform.isJS() ? "Text" : Cache.getDefault(propertyKey, "Prompt each time");
        if (defaultOption.equalsIgnoreCase("Text")) {
            comboBox.setSelectedItem(this.textOpt);
        } else if (defaultOption.equalsIgnoreCase("Lineart")) {
            comboBox.setSelectedItem(this.lineArtOpt);
        } else {
            comboBox.setSelectedItem(this.promptEachTimeOpt);
        }
        Cache.enableSessionProperties();
    }

    @Override
    public void ok_actionPerformed(ActionEvent e) {
        Cache.disableSessionProperties();
        if (!this.validateSettings()) {
            return;
        }
        this.saveProxySettings();
        Cache.applicationProperties.setProperty("SHOW_JVSUFFIX", Boolean.toString(this.seqLimit.isSelected()));
        Cache.applicationProperties.setProperty("RIGHT_ALIGN_IDS", Boolean.toString(this.rightAlign.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_FULLSCREEN", Boolean.toString(this.fullScreen.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_OVERVIEW", Boolean.toString(this.openoverv.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_ANNOTATIONS", Boolean.toString(this.annotations.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSERVATION", Boolean.toString(this.conservation.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_QUALITY", Boolean.toString(this.quality.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_IDENTITY", Boolean.toString(this.identity.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_SS_CONSENSUS", Boolean.toString(this.ssConsensus.isSelected()));
        Cache.applicationProperties.setProperty("GAP_SYMBOL", this.gapSymbolCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_NAME", this.fontNameCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_STYLE", this.fontStyleCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_SIZE", this.fontSizeCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("ID_ITALICS", Boolean.toString(this.idItalics.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_UNCONSERVED", Boolean.toString(this.showUnconserved.isSelected()));
        Cache.applicationProperties.setProperty(SHOW_OCCUPANCY, Boolean.toString(this.showOccupancy.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_GROUP_CONSENSUS", Boolean.toString(this.showGroupConsensus.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_GROUP_CONSERVATION", Boolean.toString(this.showGroupConservation.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSENSUS_HISTOGRAM", Boolean.toString(this.showConsensHistogram.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSENSUS_LOGO", Boolean.toString(this.showConsensLogo.isSelected()));
        Cache.applicationProperties.setProperty("ANTI_ALIAS", Boolean.toString(this.smoothFont.isSelected()));
        Cache.applicationProperties.setProperty(SCALE_PROTEIN_TO_CDNA, Boolean.toString(this.scaleProteinToCdna.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_NPFEATS_TOOLTIP", Boolean.toString(this.showNpTooltip.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_DBREFS_TOOLTIP", Boolean.toString(this.showDbRefTooltip.isSelected()));
        Cache.applicationProperties.setProperty("WRAP_ALIGNMENT", Boolean.toString(this.wrap.isSelected()));
        Cache.applicationProperties.setProperty("STARTUP_FILE", this.startupFileTextfield.getText());
        Cache.applicationProperties.setProperty("SHOW_STARTUP_FILE", Boolean.toString(this.startupCheckbox.isSelected()));
        Cache.applicationProperties.setProperty("SORT_ALIGNMENT", this.sortby.getSelectedItem().toString());
        AnnotationSorter.SequenceAnnotationOrder annSortOrder = AnnotationSorter.SequenceAnnotationOrder.forDescription(this.sortAnnBy.getSelectedItem().toString());
        if (annSortOrder != null) {
            Cache.applicationProperties.setProperty(SORT_ANNOTATIONS, annSortOrder.name());
        }
        boolean showAutocalcFirst = this.sortAutocalc.getSelectedIndex() == 0;
        Cache.applicationProperties.setProperty(SHOW_AUTOCALC_ABOVE, Boolean.valueOf(showAutocalcFirst).toString());
        Cache.applicationProperties.setProperty(DEFAULT_COLOUR_PROT, this.protColour.getSelectedItem().toString());
        Cache.applicationProperties.setProperty(DEFAULT_COLOUR_NUC, this.nucColour.getSelectedItem().toString());
        Cache.setColourProperty("ANNOTATIONCOLOUR_MIN", this.minColour.getBackground());
        Cache.setColourProperty("ANNOTATIONCOLOUR_MAX", this.maxColour.getBackground());
        Cache.setColourProperty(GAP_COLOUR, this.gapColour.getBackground());
        Cache.setColourProperty(HIDDEN_COLOUR, this.hiddenColour.getBackground());
        Cache.applicationProperties.setProperty(USE_LEGACY_GAP, Boolean.toString(this.useLegacyGap.isSelected()));
        Cache.applicationProperties.setProperty(SHOW_OV_HIDDEN_AT_START, Boolean.toString(this.showHiddenAtStart.isSelected()));
        Cache.applicationProperties.setProperty(ADD_TEMPFACT_ANN, Boolean.toString(this.addTempFactor.isSelected()));
        Cache.applicationProperties.setProperty(ADD_SS_ANN, Boolean.toString(this.addSecondaryStructure.isSelected()));
        Cache.applicationProperties.setProperty(STRUCT_FROM_PDB, Boolean.toString(this.structFromPdb.isSelected()));
        String viewer = this.structViewer.getSelectedItem().toString();
        String viewerPath = this.structureViewerPath.getText();
        Cache.applicationProperties.setProperty(STRUCTURE_DISPLAY, viewer);
        if (viewer.equals(StructureViewer.ViewerType.CHIMERA.name())) {
            Cache.setOrRemove(CHIMERA_PATH, viewerPath);
        } else if (viewer.equals(StructureViewer.ViewerType.CHIMERAX.name())) {
            Cache.setOrRemove(CHIMERAX_PATH, viewerPath);
        } else if (viewer.equals(StructureViewer.ViewerType.PYMOL.name())) {
            Cache.setOrRemove(PYMOL_PATH, viewerPath);
        }
        Cache.applicationProperties.setProperty("MAP_WITH_SIFTS", Boolean.toString(this.siftsMapping.isSelected()));
        SiftsSettings.setMapWithSifts(this.siftsMapping.isSelected());
        Cache.applicationProperties.setProperty("EPS_RENDERING", ((OptionsParam)this.epsRendering.getSelectedItem()).getCode());
        Cache.applicationProperties.setProperty("HTML_RENDERING", ((OptionsParam)this.htmlRendering.getSelectedItem()).getCode());
        Cache.applicationProperties.setProperty("SVG_RENDERING", ((OptionsParam)this.svgRendering.getSelectedItem()).getCode());
        String menuLinks = sequenceUrlLinks.writeUrlsAsString(true);
        if (menuLinks.isEmpty()) {
            Cache.applicationProperties.remove("SEQUENCE_LINKS");
        } else {
            Cache.applicationProperties.setProperty("SEQUENCE_LINKS", menuLinks.toString());
        }
        String nonMenuLinks = sequenceUrlLinks.writeUrlsAsString(false);
        if (nonMenuLinks.isEmpty()) {
            Cache.applicationProperties.remove("STORED_LINKS");
        } else {
            Cache.applicationProperties.setProperty("STORED_LINKS", nonMenuLinks.toString());
        }
        Cache.applicationProperties.setProperty("DEFAULT_URL", sequenceUrlLinks.getPrimaryUrlId());
        Cache.setProperty("VERSION_CHECK", Boolean.toString(this.versioncheck.isSelected()));
        if (Cache.getProperty("USAGESTATS") != null || this.usagestats.isSelected()) {
            Cache.setProperty("USAGESTATS", Boolean.toString(this.usagestats.isSelected()));
        }
        if (!this.questionnaire.isSelected()) {
            Cache.setProperty("NOQUESTIONNAIRES", "true");
        } else {
            Cache.removeProperty("NOQUESTIONNAIRES");
        }
        Cache.applicationProperties.setProperty("BLC_JVSUFFIX", Boolean.toString(this.blcjv.isSelected()));
        Cache.applicationProperties.setProperty("CLUSTAL_JVSUFFIX", Boolean.toString(this.clustaljv.isSelected()));
        Cache.applicationProperties.setProperty("FASTA_JVSUFFIX", Boolean.toString(this.fastajv.isSelected()));
        Cache.applicationProperties.setProperty("MSF_JVSUFFIX", Boolean.toString(this.msfjv.isSelected()));
        Cache.applicationProperties.setProperty("PFAM_JVSUFFIX", Boolean.toString(this.pfamjv.isSelected()));
        Cache.applicationProperties.setProperty("PILEUP_JVSUFFIX", Boolean.toString(this.pileupjv.isSelected()));
        Cache.applicationProperties.setProperty("PIR_JVSUFFIX", Boolean.toString(this.pirjv.isSelected()));
        Cache.applicationProperties.setProperty("PIR_MODELLER", Boolean.toString(this.modellerOutput.isSelected()));
        Cache.applicationProperties.setProperty("EXPORT_EMBBED_BIOJSON", Boolean.toString(this.embbedBioJSON.isSelected()));
        PIRFile.useModellerOutput = this.modellerOutput.isSelected();
        Cache.applicationProperties.setProperty("FIGURE_AUTOIDWIDTH", Boolean.toString(this.autoIdWidth.isSelected()));
        this.userIdWidth_actionPerformed();
        Cache.applicationProperties.setProperty("FIGURE_FIXEDIDWIDTH", this.userIdWidth.getText());
        Cache.applicationProperties.setProperty("AUTO_CALC_CONSENSUS", Boolean.toString(this.autoCalculateConsCheck.isSelected()));
        Cache.applicationProperties.setProperty("SORT_BY_TREE", Boolean.toString(this.sortByTree.isSelected()));
        Cache.applicationProperties.setProperty("PAD_GAPS", Boolean.toString(this.padGaps.isSelected()));
        if (!Platform.isJS()) {
            this.wsPrefs.updateAndRefreshWsMenuConfig(false);
        }
        Cache.applicationProperties.setProperty("BACKUPFILES_ENABLED", Boolean.toString(this.enableBackupFiles.isSelected()));
        int preset = this.getComboIntStringKey(this.backupfilesPresetsCombo);
        Cache.applicationProperties.setProperty("BACKUPFILES_PRESET", Integer.toString(preset));
        if (preset == 0) {
            BackupFilesPresetEntry customBFPE = this.getBackupfilesCurrentEntry();
            BackupFilesPresetEntry.backupfilesPresetEntriesValues.put(0, customBFPE);
            Cache.applicationProperties.setProperty("BACKUPFILES_CUSTOM", customBFPE.toString());
        }
        BackupFilesPresetEntry savedBFPE = BackupFilesPresetEntry.backupfilesPresetEntriesValues.get(preset);
        Cache.applicationProperties.setProperty("BACKUPFILES_SAVED", savedBFPE.toString());
        Cache.applicationProperties.setProperty("MEMORY_CUSTOMISED_SETTINGS", Boolean.toString(this.customiseMemorySetting.isSelected()));
        Cache.applicationProperties.setProperty(MemorySetting.MEMORY_JVMMEMPC, Integer.toString(this.jvmMemoryPercentSlider.getValue()));
        Cache.applicationProperties.setProperty(MemorySetting.MEMORY_JVMMEMMAX, this.jvmMemoryMaxTextField.getText());
        Cache.saveProperties();
        Desktop.instance.doConfigureStructurePrefs();
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Cache.enableSessionProperties();
    }

    @Override
    public void saveProxySettings() {
        Cache.disableSessionProperties();
        String newProxyType = this.customProxy.isSelected() ? "true" : (this.noProxy.isSelected() ? "none" : "false");
        Cache.applicationProperties.setProperty("USE_PROXY", newProxyType);
        Cache.setOrRemove("PROXY_SERVER", this.proxyServerHttpTB.getText());
        Cache.setOrRemove("PROXY_PORT", this.proxyPortHttpTB.getText());
        Cache.setOrRemove("PROXY_SERVER_HTTPS", this.proxyServerHttpsTB.getText());
        Cache.setOrRemove("PROXY_PORT_HTTPS", this.proxyPortHttpsTB.getText());
        Cache.setOrRemove("PROXY_AUTH", Boolean.toString(this.proxyAuth.isSelected()));
        Cache.setOrRemove("PROXY_AUTH_USERNAME", this.proxyAuthUsernameTB.getText());
        Cache.proxyAuthPassword = this.proxyAuthPasswordPB.getPassword();
        Cache.setProxyPropertiesFromPreferences(this.previousProxyType);
        if (newProxyType.equals("true") || !newProxyType.equals(this.previousProxyType)) {
            ++this.wsPrefs.update;
        }
        this.previousProxyType = newProxyType;
        Cache.enableSessionProperties();
    }

    private boolean validateSettings() {
        if (!this.validateStructure()) {
            this.structureTab.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateStructure() {
        return this.validateViewerPath();
    }

    @Override
    public void startupFileTextfield_mouseClicked() {
        Cache.disableSessionProperties();
        JalviewFileChooser chooser = JalviewFileChooser.forRead(Cache.getProperty("LAST_DIRECTORY"), null);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.select_startup_file"));
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            FileFormatI format = chooser.getSelectedFormat();
            if (format != null) {
                Cache.applicationProperties.setProperty("DEFAULT_FILE_FORMAT", format.getName());
            }
            this.startupFileTextfield.setText(chooser.getSelectedFile().getAbsolutePath());
        }
        Cache.enableSessionProperties();
    }

    @Override
    public void cancel_actionPerformed(ActionEvent e) {
        try {
            if (!Platform.isJS()) {
                this.wsPrefs.updateWsMenuConfig(true);
                this.wsPrefs.refreshWs_actionPerformed(e);
            }
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void annotations_actionPerformed(ActionEvent e) {
        this.conservation.setEnabled(this.annotations.isSelected());
        this.quality.setEnabled(this.annotations.isSelected());
        this.identity.setEnabled(this.annotations.isSelected());
        this.ssConsensus.setEnabled(this.annotations.isSelected());
        this.showOccupancy.setEnabled(this.annotations.isSelected());
        this.showGroupConsensus.setEnabled(this.annotations.isSelected());
        this.showGroupConservation.setEnabled(this.annotations.isSelected());
        this.showConsensHistogram.setEnabled(this.annotations.isSelected() && (this.identity.isSelected() || this.showGroupConsensus.isSelected()));
        this.showConsensLogo.setEnabled(this.annotations.isSelected() && (this.identity.isSelected() || this.showGroupConsensus.isSelected()));
    }

    @Override
    public void newLink_actionPerformed(ActionEvent e) {
        GSequenceLink link = new GSequenceLink();
        boolean valid = false;
        while (!valid && JvOptionPane.showInternalConfirmDialog(Desktop.desktop, link, MessageManager.getString("label.new_sequence_url_link"), 2, -1, null) == 0) {
            if (!link.checkValid()) continue;
            if (((UrlLinkTableModel)this.linkUrlTable.getModel()).isUniqueName(link.getName())) {
                ((UrlLinkTableModel)this.linkUrlTable.getModel()).insertRow(link.getName(), link.getURL());
                valid = true;
                continue;
            }
            link.notifyDuplicate();
        }
    }

    @Override
    public void editLink_actionPerformed(ActionEvent e) {
        GSequenceLink link = new GSequenceLink();
        int index = this.linkUrlTable.getSelectedRow();
        if (index == -1) {
            Console.debug("Edit with no row selected in linkUrlTable");
            return;
        }
        int nameCol = ((UrlLinkTableModel)this.linkUrlTable.getModel()).getNameColumn();
        int urlCol = ((UrlLinkTableModel)this.linkUrlTable.getModel()).getUrlColumn();
        String oldName = this.linkUrlTable.getValueAt(index, nameCol).toString();
        link.setName(oldName);
        link.setURL(this.linkUrlTable.getValueAt(index, urlCol).toString());
        boolean valid = false;
        while (!valid && JvOptionPane.showInternalConfirmDialog(Desktop.desktop, link, MessageManager.getString("label.edit_sequence_url_link"), 2, -1, null) == 0) {
            if (!link.checkValid()) continue;
            if (oldName.equals(link.getName()) || ((UrlLinkTableModel)this.linkUrlTable.getModel()).isUniqueName(link.getName())) {
                this.linkUrlTable.setValueAt(link.getName(), index, nameCol);
                this.linkUrlTable.setValueAt(link.getURL(), index, urlCol);
                valid = true;
                continue;
            }
            link.notifyDuplicate();
        }
    }

    @Override
    public void deleteLink_actionPerformed(ActionEvent e) {
        int index = this.linkUrlTable.getSelectedRow();
        int modelIndex = -1;
        if (index == -1) {
            Console.debug("Delete with no row selected in linkUrlTable");
            return;
        }
        modelIndex = this.linkUrlTable.convertRowIndexToModel(index);
        ((UrlLinkTableModel)this.linkUrlTable.getModel()).removeRow(modelIndex);
    }

    @Override
    protected void showunconserved_actionPerformed(ActionEvent e) {
        super.showunconserved_actionPerformed(e);
    }

    public static List<String> getGroupURLLinks() {
        return groupURLLinks;
    }

    @Override
    public void minColour_actionPerformed(JPanel panel) {
        JalviewColourChooser.showColourChooser(this, MessageManager.getString("label.select_colour_minimum_value"), panel);
    }

    @Override
    public void maxColour_actionPerformed(JPanel panel) {
        JalviewColourChooser.showColourChooser(this, MessageManager.getString("label.select_colour_maximum_value"), panel);
    }

    @Override
    public void gapColour_actionPerformed(JPanel gap) {
        if (!this.useLegacyGap.isSelected()) {
            JalviewColourChooser.showColourChooser(this, MessageManager.getString("label.select_gap_colour"), gap);
        }
    }

    @Override
    public void hiddenColour_actionPerformed(JPanel hidden) {
        JalviewColourChooser.showColourChooser(this, MessageManager.getString("label.select_hidden_colour"), hidden);
    }

    @Override
    protected void useLegacyGaps_actionPerformed(ActionEvent e) {
        boolean enabled = this.useLegacyGap.isSelected();
        if (enabled) {
            this.gapColour.setBackground(OverviewCanvas.OVERVIEW_DEFAULT_LEGACY_GAP);
        } else {
            this.gapColour.setBackground(OverviewCanvas.OVERVIEW_DEFAULT_GAP);
        }
        this.gapColour.setEnabled(!enabled);
        this.gapLabel.setEnabled(!enabled);
    }

    @Override
    protected void resetOvDefaults_actionPerformed(ActionEvent e) {
        this.useLegacyGap.setSelected(false);
        this.useLegacyGaps_actionPerformed(null);
        this.showHiddenAtStart.setSelected(false);
        this.hiddenColour.setBackground(OverviewCanvas.OVERVIEW_DEFAULT_HIDDEN);
    }

    @Override
    protected void userIdWidth_actionPerformed() {
        try {
            String val = this.userIdWidth.getText().trim();
            if (val.length() > 0) {
                Integer iw = Integer.parseInt(val);
                if (iw < 12) {
                    throw new NumberFormatException();
                }
                this.userIdWidth.setText(iw.toString());
            }
        }
        catch (NumberFormatException x) {
            this.userIdWidth.setText("");
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("warn.user_defined_width_requirements"), MessageManager.getString("label.invalid_id_column_width"), 2);
        }
    }

    @Override
    protected void autoIdWidth_actionPerformed() {
        this.userIdWidth.setEnabled(!this.autoIdWidth.isSelected());
        this.userIdWidthlabel.setEnabled(!this.autoIdWidth.isSelected());
    }

    private boolean validateViewerPath() {
        File f;
        if (this.structureViewerPath.getText().trim().length() > 0 && !(f = new File(this.structureViewerPath.getText())).canExecute()) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.invalid_viewer_path"), MessageManager.getString("label.invalid_viewer_path"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void structureViewer_actionPerformed(String selectedItem) {
        if (selectedItem.equals(StructureViewer.ViewerType.JMOL.name())) {
            this.structureViewerPath.setEnabled(false);
            this.structureViewerPathLabel.setEnabled(false);
            return;
        }
        boolean found = false;
        this.structureViewerPath.setEnabled(true);
        this.structureViewerPathLabel.setEnabled(true);
        this.structureViewerPathLabel.setText(MessageManager.formatMessage("label.viewer_path", selectedItem));
        String viewerPath = "";
        List<String> paths = null;
        Cache.disableSessionProperties();
        try {
            StructureViewer.ViewerType viewerType = StructureViewer.ViewerType.valueOf(selectedItem);
            switch (viewerType) {
                case JMOL: {
                    break;
                }
                case CHIMERA: {
                    viewerPath = Cache.getDefault(CHIMERA_PATH, "");
                    paths = StructureManager.getChimeraPaths(false);
                    break;
                }
                case CHIMERAX: {
                    viewerPath = Cache.getDefault(CHIMERAX_PATH, "");
                    paths = StructureManager.getChimeraPaths(true);
                    break;
                }
                case PYMOL: {
                    viewerPath = Cache.getDefault(PYMOL_PATH, "");
                    paths = PymolManager.getPymolPaths();
                }
            }
        }
        catch (IllegalArgumentException viewerType) {
            // empty catch block
        }
        Cache.enableSessionProperties();
        this.structureViewerPath.setText(viewerPath);
        paths.add(0, this.structureViewerPath.getText());
        for (String path : paths) {
            if (!new File(path.trim()).canExecute()) continue;
            found = true;
            break;
        }
        if (!found) {
            Object[] options = new String[]{"OK", "Help"};
            int showHelp = JvOptionPane.showInternalOptionDialog(Desktop.desktop, JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.viewer_missing")), "", 0, 2, null, options, options[0]);
            if (showHelp == 1) {
                this.selectTab(GPreferences.TabRef.STRUCTURE_TAB, null);
                try {
                    Help.showHelpWindow(Help.HelpId.StructureViewer);
                }
                catch (HelpSetException e) {
                    e.printStackTrace();
                }
            } else if (showHelp == 0) {
                this.selectTab(GPreferences.TabRef.STRUCTURE_TAB, null);
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                    try {
                        for (int i = 0; i < 3; ++i) {
                            this.structureViewerPath.setBackground(Color.PINK);
                            Thread.sleep(500L);
                            this.structureViewerPath.setBackground(Color.WHITE);
                            Thread.sleep(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    static {
        Cache.disableSessionProperties();
        String inMenuString = Cache.getDefault("SEQUENCE_LINKS", "");
        String notInMenuString = Cache.getDefault("STORED_LINKS", "");
        String defaultUrl = Cache.getDefault("DEFAULT_URL", "EMBL-EBI Search");
        if (inMenuString.isEmpty() && notInMenuString.isEmpty()) {
            inMenuString = "EMBL-EBI Search|https://www.ebi.ac.uk/ebisearch/search.ebi?db=allebi&query=$SEQUENCE_ID$";
        }
        DesktopUrlProviderFactory factory = new DesktopUrlProviderFactory(defaultUrl, inMenuString, notInMenuString);
        sequenceUrlLinks = factory.createUrlProvider();
        dataModel = new UrlLinkTableModel(sequenceUrlLinks);
        groupURLLinks = new ArrayList<String>();
        Cache.enableSessionProperties();
    }

    private class UrlListSelectionHandler
    implements ListSelectionListener {
        private UrlListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int index = lsm.getMinSelectionIndex();
            if (index == -1) {
                Preferences.this.editLink.setEnabled(false);
                Preferences.this.deleteLink.setEnabled(false);
                return;
            }
            int modelIndex = Preferences.this.linkUrlTable.convertRowIndexToModel(index);
            if (((UrlLinkTableModel)Preferences.this.linkUrlTable.getModel()).isRowDeletable(modelIndex)) {
                Preferences.this.deleteLink.setEnabled(true);
            } else {
                Preferences.this.deleteLink.setEnabled(false);
            }
            if (((UrlLinkTableModel)Preferences.this.linkUrlTable.getModel()).isRowEditable(modelIndex)) {
                Preferences.this.editLink.setEnabled(true);
            } else {
                Preferences.this.editLink.setEnabled(false);
            }
        }
    }

    public class OptionsParam {
        private String name;
        private String code;

        public OptionsParam(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object that) {
            if (!(that instanceof OptionsParam)) {
                return false;
            }
            return this.code.equalsIgnoreCase(((OptionsParam)that).code);
        }

        public int hashCode() {
            return this.name.hashCode() + this.code.hashCode();
        }
    }
}

