/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AAFrequency;
import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.AlignmentUtils;
import jalview.analysis.Conservation;
import jalview.api.AlignCalcWorkerI;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.commands.ChangeCaseCommand;
import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationChooser;
import jalview.gui.AppVarna;
import jalview.gui.ColourMenuHelper;
import jalview.gui.CutAndPasteHtmlTransfer;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.EditNameDialog;
import jalview.gui.FeatureEditor;
import jalview.gui.FeatureRenderer;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.PaintRefresher;
import jalview.gui.Preferences;
import jalview.gui.SliderPanel;
import jalview.gui.StructureChooser;
import jalview.gui.TextColourChooser;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FormatAdapter;
import jalview.io.SequenceAnnotationReport;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.schemes.PIDColourScheme;
import jalview.util.BrowserLauncher;
import jalview.util.Comparison;
import jalview.util.GroupUrlLink;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.StringUtils;
import jalview.util.UrlLink;
import jalview.workers.SecondaryStructureConsensusThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;

public class PopupMenu
extends JPopupMenu
implements ColourMenuHelper.ColourChangeListener {
    private static final int FEATURE_DESC_MAX = 40;
    private final boolean forIdPanel;
    private final AlignmentPanel ap;
    private final SequenceI sequence;
    JMenu groupMenu = new JMenu();
    JMenuItem groupName = new JMenuItem();
    protected JCheckBoxMenuItem abovePIDColour = new JCheckBoxMenuItem();
    protected JMenuItem modifyPID = new JMenuItem();
    protected JCheckBoxMenuItem conservationMenuItem = new JCheckBoxMenuItem();
    protected JRadioButtonMenuItem annotationColour;
    protected JMenuItem modifyConservation = new JMenuItem();
    JMenu sequenceMenu = new JMenu();
    JMenuItem makeReferenceSeq = new JMenuItem();
    JMenuItem createGroupMenuItem = new JMenuItem();
    JMenuItem unGroupMenuItem = new JMenuItem();
    JMenu colourMenu = new JMenu();
    JCheckBoxMenuItem showBoxes = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showText = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showColourText = new JCheckBoxMenuItem();
    JCheckBoxMenuItem displayNonconserved = new JCheckBoxMenuItem();
    JMenu editMenu = new JMenu();
    JMenuItem upperCase = new JMenuItem();
    JMenuItem lowerCase = new JMenuItem();
    JMenuItem toggle = new JMenuItem();
    JMenu outputMenu = new JMenu();
    JMenu seqShowAnnotationsMenu = new JMenu();
    JMenu seqHideAnnotationsMenu = new JMenu();
    JMenuItem seqAddReferenceAnnotations = new JMenuItem(MessageManager.getString("label.add_reference_annotations"));
    JMenu groupShowAnnotationsMenu = new JMenu();
    JMenu groupHideAnnotationsMenu = new JMenu();
    JMenuItem groupAddReferenceAnnotations = new JMenuItem(MessageManager.getString("label.add_reference_annotations"));
    JMenuItem textColour = new JMenuItem();
    JMenu editGroupMenu = new JMenu();
    JMenuItem chooseStructure = new JMenuItem();
    JMenu rnaStructureMenu = new JMenu();

    protected static JMenu buildLinkMenu(SequenceI seq, List<SequenceFeature> features) {
        JMenu linkMenu = new JMenu(MessageManager.getString("action.link"));
        List<String> nlinks = null;
        if (seq != null) {
            nlinks = Preferences.sequenceUrlLinks.getLinksForMenu();
            UrlLink.sort(nlinks);
        } else {
            nlinks = new ArrayList<String>();
        }
        if (features != null) {
            for (SequenceFeature sf : features) {
                if (sf.links == null) continue;
                for (String link : sf.links) {
                    nlinks.add(link);
                }
            }
        }
        LinkedHashMap<String, List<String>> linkset = new LinkedHashMap<String, List<String>>();
        for (String link : nlinks) {
            UrlLink urlLink = null;
            try {
                urlLink = new UrlLink(link);
            }
            catch (Exception foo) {
                Console.error("Exception for URLLink '" + link + "'", foo);
                continue;
            }
            if (!urlLink.isValid()) {
                Console.error(urlLink.getInvalidMessage());
                continue;
            }
            urlLink.createLinksFromSeq(seq, linkset);
        }
        PopupMenu.addUrlLinks(linkMenu, linkset.values());
        return linkMenu;
    }

    private static void addUrlLinks(JMenu linkMenu, Collection<List<String>> linkset) {
        for (List<String> linkstrset : linkset) {
            final String url = linkstrset.get(3);
            JMenuItem item = new JMenuItem(linkstrset.get(1));
            item.setToolTipText(MessageManager.formatMessage("label.open_url_param", url));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PopupMenu.showLink(url);
                        }
                    }).start();
                }
            });
            linkMenu.add(item);
        }
    }

    static void showLink(String url) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.web_browser_not_found_unix"), MessageManager.getString("label.web_browser_not_found"), 2);
            ex.printStackTrace();
        }
    }

    static void addshowLink(JMenu linkMenu, String label, final GroupUrlLink urlgenerator, final Object[] urlstub) {
        JMenuItem item = new JMenuItem(label);
        item.setToolTipText(MessageManager.formatMessage("label.open_url_seqs_param", urlgenerator.getUrl_prefix(), urlgenerator.getNumberInvolved(urlstub)));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PopupMenu.showLink(urlgenerator.constructFrom(urlstub));
                        }
                        catch (GroupUrlLink.UrlStringTooLongException urlStringTooLongException) {
                            // empty catch block
                        }
                    }
                }).start();
            }
        });
        linkMenu.add(item);
    }

    public PopupMenu(AlignmentPanel ap, SequenceI seq, int column) {
        this(false, ap, seq, column, null);
    }

    public PopupMenu(AlignmentPanel alignPanel, SequenceI seq, List<String> groupLinks) {
        this(true, alignPanel, seq, -1, groupLinks);
    }

    private PopupMenu(boolean fromIdPanel, final AlignmentPanel alignPanel, final SequenceI seq, int column, List<String> groupLinks) {
        SequenceGroup sg;
        boolean isDefinedGroup;
        Objects.requireNonNull(seq);
        this.forIdPanel = fromIdPanel;
        this.ap = alignPanel;
        this.sequence = seq;
        for (String ff : FileFormats.getInstance().getWritableFormats(true)) {
            JMenuItem item = new JMenuItem(ff);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenu.this.outputText_actionPerformed(e);
                }
            });
            this.outputMenu.add(item);
        }
        List<SequenceI> selectedSequence = this.forIdPanel && seq != null ? Arrays.asList(seq) : Collections.emptyList();
        this.buildAnnotationTypesMenus(this.seqShowAnnotationsMenu, this.seqHideAnnotationsMenu, selectedSequence);
        this.configureReferenceAnnotationsMenu(this.seqAddReferenceAnnotations, selectedSequence);
        List<SequenceI> selectedGroup = alignPanel.av.getSelectionGroup() == null ? Collections.emptyList() : alignPanel.av.getSelectionGroup().getSequences();
        this.buildAnnotationTypesMenus(this.groupShowAnnotationsMenu, this.groupHideAnnotationsMenu, selectedGroup);
        this.configureReferenceAnnotationsMenu(this.groupAddReferenceAnnotations, selectedGroup);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.forIdPanel) {
            int index;
            JMenuItem menuItem;
            this.sequenceMenu.setText(this.sequence.getName());
            if (seq == alignPanel.av.getAlignment().getSeqrep()) {
                this.makeReferenceSeq.setText(MessageManager.getString("action.unmark_as_reference"));
            } else {
                this.makeReferenceSeq.setText(MessageManager.getString("action.set_as_reference"));
            }
            if (!alignPanel.av.getAlignment().isNucleotide()) {
                this.remove(this.rnaStructureMenu);
            } else {
                int origCount = this.rnaStructureMenu.getItemCount();
                AlignmentAnnotation[] aas = alignPanel.av.getAlignment().getAlignmentAnnotation();
                if (aas != null) {
                    for (final AlignmentAnnotation aa : aas) {
                        if (!aa.isValidStruc() || aa.sequenceRef != null) continue;
                        menuItem = new JMenuItem();
                        menuItem.setText(MessageManager.formatMessage("label.2d_rna_structure_line", aa.label));
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                new AppVarna(seq, aa, alignPanel);
                            }
                        });
                        this.rnaStructureMenu.add(menuItem);
                    }
                }
                if (seq.getAnnotation() != null) {
                    AlignmentAnnotation[] seqAnns;
                    for (final AlignmentAnnotation aa : seqAnns = seq.getAnnotation()) {
                        if (!aa.isValidStruc()) continue;
                        menuItem = new JMenuItem();
                        menuItem.setText(MessageManager.formatMessage("label.2d_rna_sequence_name", seq.getName()));
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                new AppVarna(seq, aa, alignPanel);
                            }
                        });
                        this.rnaStructureMenu.add(menuItem);
                    }
                }
                if (this.rnaStructureMenu.getItemCount() == origCount) {
                    this.remove(this.rnaStructureMenu);
                }
            }
            menuItem = new JMenuItem(MessageManager.getString("action.hide_sequences"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenu.this.hideSequences(false);
                }
            });
            this.add(menuItem);
            if (alignPanel.av.getSelectionGroup() != null && alignPanel.av.getSelectionGroup().getSize() > 1) {
                menuItem = new JMenuItem(MessageManager.formatMessage("label.represent_group_with", seq.getName()));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PopupMenu.this.hideSequences(true);
                    }
                });
                this.sequenceMenu.add(menuItem);
            }
            if (alignPanel.av.hasHiddenRows() && alignPanel.av.adjustForHiddenSeqs(index = alignPanel.av.getAlignment().findIndex(seq)) - alignPanel.av.adjustForHiddenSeqs(index - 1) > 1) {
                menuItem = new JMenuItem(MessageManager.getString("action.reveal_sequences"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        alignPanel.av.showSequence(index);
                        if (alignPanel.overviewPanel != null) {
                            alignPanel.overviewPanel.updateOverviewImage();
                        }
                    }
                });
                this.add(menuItem);
            }
        }
        if (alignPanel.av.hasHiddenRows()) {
            boolean addOption;
            boolean bl = addOption = seq != null;
            if (!addOption && alignPanel.av.getAlignment().getHeight() == 0) {
                addOption = true;
            }
            if (addOption) {
                JMenuItem menuItem = new JMenuItem(MessageManager.getString("action.reveal_all"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        alignPanel.av.showAllHiddenSeqs();
                        if (alignPanel.overviewPanel != null) {
                            alignPanel.overviewPanel.updateOverviewImage();
                        }
                    }
                });
                this.add(menuItem);
            }
        }
        boolean bl = isDefinedGroup = (sg = alignPanel.av.getSelectionGroup()) != null ? alignPanel.av.getAlignment().getGroups().contains(sg) : false;
        if (sg != null && sg.getSize() > 0) {
            this.groupName.setText(MessageManager.getString("label.edit_name_and_description_current_group"));
            ColourMenuHelper.setColourSelected(this.colourMenu, sg.getColourScheme());
            this.conservationMenuItem.setEnabled(!sg.isNucleotide());
            if (sg.cs != null) {
                if (sg.cs.conservationApplied()) {
                    this.conservationMenuItem.setSelected(true);
                }
                if (sg.cs.getThreshold() > 0) {
                    this.abovePIDColour.setSelected(true);
                }
            }
            this.modifyConservation.setEnabled(this.conservationMenuItem.isSelected());
            this.modifyPID.setEnabled(this.abovePIDColour.isSelected());
            this.displayNonconserved.setSelected(sg.getShowNonconserved());
            this.showText.setSelected(sg.getDisplayText());
            this.showColourText.setSelected(sg.getColourText());
            this.showBoxes.setSelected(sg.getDisplayBoxes());
            if (groupLinks != null && groupLinks.size() > 0) {
                this.buildGroupURLMenu(sg, groupLinks);
            }
            Hashtable<String, PDBEntry> pdbe = new Hashtable<String, PDBEntry>();
            Hashtable<String, PDBEntry> reppdb = new Hashtable<String, PDBEntry>();
            SequenceI sqass = null;
            for (SequenceI sq : alignPanel.av.getSequenceSelection()) {
                Vector<PDBEntry> pes = sq.getDatasetSequence().getAllPDBEntries();
                if (pes == null || pes.size() <= 0) continue;
                reppdb.put(pes.get(0).getId(), pes.get(0));
                for (PDBEntry pe : pes) {
                    pdbe.put(pe.getId(), pe);
                    if (sqass != null) continue;
                    sqass = sq;
                }
            }
            if (pdbe.size() > 0) {
                PDBEntry[] pe = pdbe.values().toArray(new PDBEntry[pdbe.size()]);
                PDBEntry[] pDBEntryArray = reppdb.values().toArray(new PDBEntry[reppdb.size()]);
            }
        } else {
            this.groupMenu.setVisible(false);
            this.editMenu.setVisible(false);
        }
        if (!isDefinedGroup) {
            this.createGroupMenuItem.setVisible(true);
            this.unGroupMenuItem.setVisible(false);
            this.editGroupMenu.setText(MessageManager.getString("action.edit_new_group"));
        } else {
            this.createGroupMenuItem.setVisible(false);
            this.unGroupMenuItem.setVisible(true);
            this.editGroupMenu.setText(MessageManager.getString("action.edit_group"));
        }
        if (!this.forIdPanel) {
            this.sequenceMenu.setVisible(false);
            this.chooseStructure.setVisible(false);
            this.rnaStructureMenu.setVisible(false);
        }
        this.addLinksAndFeatures(seq, column);
    }

    void addLinksAndFeatures(SequenceI seq, int column) {
        List<SequenceFeature> features = null;
        features = this.forIdPanel ? this.sequence.getFeatures().getNonPositionalFeatures(new String[0]) : this.ap.getFeatureRenderer().findFeaturesAtColumn(this.sequence, column + 1);
        this.addLinks(seq, features);
        if (!this.forIdPanel) {
            this.addFeatureDetails(features, seq, column);
        }
    }

    protected void addFeatureDetails(List<SequenceFeature> features, SequenceI seq, int column) {
        MappedFeatures mf = null;
        if (this.ap.av.isShowComplementFeatures() && !Comparison.isGap(this.sequence.getCharAt(column))) {
            AlignViewportI complement = this.ap.getAlignViewport().getCodingComplement();
            AlignFrame af = Desktop.getAlignFrameFor(complement);
            FeatureRenderer fr2 = af.getFeatureRenderer();
            int seqPos = this.sequence.findPosition(column);
            mf = fr2.findComplementFeaturesAtResidue(this.sequence, seqPos);
        }
        if (features.isEmpty() && mf == null) {
            return;
        }
        JMenu details = new JMenu(MessageManager.getString("label.feature_details"));
        this.add(details);
        String name = seq.getName();
        for (SequenceFeature sf : features) {
            this.addFeatureDetailsMenuItem(details, name, sf, null);
        }
        if (mf != null) {
            for (SequenceFeature sf : mf.features) {
                this.addFeatureDetailsMenuItem(details, name, sf, mf);
            }
        }
    }

    void addFeatureDetailsMenuItem(JMenu details, final String seqName, final SequenceFeature sf, final MappedFeatures mf) {
        String featureGroup;
        String description;
        int start = sf.getBegin();
        int end = sf.getEnd();
        if (mf != null) {
            int[] localRange = mf.getMappedPositions(start, end);
            if (localRange == null) {
                return;
            }
            start = localRange[0];
            end = localRange[localRange.length - 1];
        }
        StringBuilder desc = new StringBuilder();
        desc.append(sf.getType()).append(" ").append(String.valueOf(start));
        if (start != end) {
            desc.append(sf.isContactFeature() ? ":" : "-");
            desc.append(String.valueOf(end));
        }
        if ((description = sf.getDescription()) != null) {
            boolean hasLink;
            desc.append(" ");
            description = StringUtils.stripHtmlTags(description);
            boolean bl = hasLink = description.indexOf("a href") > -1;
            if (description.length() > 40 && !hasLink) {
                description = description.substring(0, 40) + "...";
            }
            desc.append(description);
        }
        if ((featureGroup = sf.getFeatureGroup()) != null) {
            desc.append(" (").append(featureGroup).append(")");
        }
        String htmlText = JvSwingUtils.wrapTooltip(true, desc.toString());
        JMenuItem item = new JMenuItem(htmlText);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showFeatureDetails(sf, seqName, mf);
            }
        });
        details.add(item);
    }

    protected void showFeatureDetails(SequenceFeature sf, String seqName, MappedFeatures mf) {
        JInternalFrame details;
        if (Platform.isJS()) {
            details = new JInternalFrame();
            details.setFrameIcon(null);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(true);
            panel.setBackground(Color.white);
            JLabel reprt = new JLabel(MessageManager.formatMessage("label.html_content", sf.getDetailsReport(seqName, mf)));
            reprt.setBackground(Color.WHITE);
            reprt.setOpaque(true);
            panel.add((Component)reprt, "Center");
            details.setContentPane(panel);
            details.pack();
        } else {
            CutAndPasteHtmlTransfer cap = new CutAndPasteHtmlTransfer();
            cap.addStylesheetRule("table { border-collapse: collapse;}");
            cap.addStylesheetRule("table, td, th {border: 1px solid black;}");
            cap.setText(sf.getDetailsReport(seqName, mf));
            details = cap;
        }
        Desktop.addInternalFrame(details, MessageManager.getString("label.feature_details"), 500, 500);
    }

    void addLinks(SequenceI seq, List<SequenceFeature> features) {
        JMenu linkMenu = PopupMenu.buildLinkMenu(this.forIdPanel ? seq : null, features);
        if (linkMenu.getItemCount() > 0) {
            if (this.forIdPanel) {
                this.sequenceMenu.add(linkMenu);
            } else {
                this.add(linkMenu);
            }
        }
    }

    protected void buildAnnotationTypesMenus(JMenu showMenu, JMenu hideMenu, List<SequenceI> forSequences) {
        showMenu.removeAll();
        hideMenu.removeAll();
        List<String> all = Arrays.asList(MessageManager.getString("label.all"));
        this.addAnnotationTypeToShowHide(showMenu, forSequences, "", all, true, true);
        this.addAnnotationTypeToShowHide(hideMenu, forSequences, "", all, true, false);
        showMenu.addSeparator();
        hideMenu.addSeparator();
        AlignmentAnnotation[] annotations = this.ap.getAlignment().getAlignmentAnnotation();
        LinkedHashMap<String, List<List<String>>> shownTypes = new LinkedHashMap<String, List<List<String>>>();
        LinkedHashMap<String, List<List<String>>> hiddenTypes = new LinkedHashMap<String, List<List<String>>>();
        AlignmentAnnotationUtils.getShownHiddenTypes(shownTypes, hiddenTypes, AlignmentAnnotationUtils.asList(annotations), forSequences);
        for (String calcId : hiddenTypes.keySet()) {
            for (List type : (List)hiddenTypes.get(calcId)) {
                this.addAnnotationTypeToShowHide(showMenu, forSequences, calcId, type, false, true);
            }
        }
        showMenu.setEnabled(!hiddenTypes.isEmpty());
        for (String calcId : shownTypes.keySet()) {
            for (List type : (List)shownTypes.get(calcId)) {
                this.addAnnotationTypeToShowHide(hideMenu, forSequences, calcId, type, false, false);
            }
        }
        hideMenu.setEnabled(!shownTypes.isEmpty());
    }

    protected List<SequenceI> getSequenceScope(SequenceI seq) {
        List<Object> forSequences = null;
        SequenceGroup selectionGroup = this.ap.av.getSelectionGroup();
        forSequences = selectionGroup != null && selectionGroup.getSize() > 0 ? selectionGroup.getSequences() : (seq == null ? Collections.emptyList() : Arrays.asList(seq));
        return forSequences;
    }

    protected void addAnnotationTypeToShowHide(JMenu showOrHideMenu, final List<SequenceI> forSequences, String calcId, final List<String> types, final boolean allTypes, final boolean actionIsShow) {
        String label = types.toString();
        label = label.substring(1, label.length() - 1);
        JMenuItem item = new JMenuItem(label);
        item.setToolTipText(calcId);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentUtils.showOrHideSequenceAnnotations(PopupMenu.this.ap.getAlignment(), types, forSequences, allTypes, actionIsShow);
                PopupMenu.this.refresh();
            }
        });
        showOrHideMenu.add(item);
    }

    private void buildGroupURLMenu(SequenceGroup sg, List<String> groupLinks) {
        JMenu groupLinksMenu = new JMenu(MessageManager.getString("action.group_link"));
        JMenu[] linkMenus = new JMenu[]{null, new JMenu(MessageManager.getString("action.ids")), new JMenu(MessageManager.getString("action.sequences")), new JMenu(MessageManager.getString("action.ids_sequences"))};
        SequenceI[] seqs = this.ap.av.getSelectionAsNewSequence();
        String[][] idandseqs = GroupUrlLink.formStrings(seqs);
        Hashtable<String, Object[]> commonDbrefs = new Hashtable<String, Object[]>();
        for (int sq = 0; sq < seqs.length; ++sq) {
            int nd;
            int start = seqs[sq].findPosition(sg.getStartRes());
            int end = seqs[sq].findPosition(sg.getEndRes());
            SequenceI sqi = seqs[sq];
            while (sqi.getDatasetSequence() != null) {
                sqi = sqi.getDatasetSequence();
            }
            Sequence.DBModList<DBRefEntry> dbr = sqi.getDBRefs();
            if (dbr == null || (nd = dbr.size()) <= 0) continue;
            for (int d = 0; d < nd; ++d) {
                DBRefEntry e = (DBRefEntry)dbr.get(d);
                String src = e.getSource();
                Object[] sarray = (Object[])commonDbrefs.get(src);
                if (sarray == null) {
                    sarray = new Object[]{new int[]{0}, new String[seqs.length]};
                    commonDbrefs.put(src, sarray);
                }
                if (((String[])sarray[1])[sq] != null || e.hasMap() && e.getMap().locateMappedRange(start, end) == null) continue;
                ((String[])sarray[1])[sq] = e.getAccessionId();
                int[] nArray = (int[])sarray[0];
                nArray[0] = nArray[0] + 1;
            }
        }
        boolean addMenu = false;
        for (String link : groupLinks) {
            String[] ids;
            String[] seqstr;
            GroupUrlLink urlLink = null;
            try {
                urlLink = new GroupUrlLink(link);
            }
            catch (Exception foo) {
                Console.error("Exception for GroupURLLink '" + link + "'", foo);
                continue;
            }
            if (!urlLink.isValid()) {
                Console.error(urlLink.getInvalidMessage());
                continue;
            }
            String label = urlLink.getLabel();
            boolean usingNames = false;
            String ltarget = urlLink.getTarget();
            Object[] idset = (Object[])commonDbrefs.get(ltarget.toUpperCase(Locale.ROOT));
            if (idset != null) {
                int numinput = ((int[])idset[0])[0];
                String[] allids = (String[])idset[1];
                seqstr = new String[numinput];
                ids = new String[numinput];
                int idcount = 0;
                for (int sq = 0; sq < seqs.length; ++sq) {
                    if (allids[sq] == null) continue;
                    ids[idcount] = allids[sq];
                    seqstr[idcount++] = idandseqs[1][sq];
                }
            } else {
                seqstr = idandseqs[1];
                ids = idandseqs[0];
                usingNames = true;
            }
            Object[] urlset = null;
            try {
                urlset = urlLink.makeUrlStubs(ids, seqstr, "FromJalview" + System.currentTimeMillis(), false);
            }
            catch (GroupUrlLink.UrlStringTooLongException allids) {
                // empty catch block
            }
            if (urlset == null) continue;
            int type = urlLink.getGroupURLType() & 3;
            PopupMenu.addshowLink(linkMenus[type], label + ((type & 1) == 1 ? "(" + (usingNames ? "Names" : ltarget) + ")" : ""), urlLink, urlset);
            addMenu = true;
        }
        if (addMenu) {
            groupLinksMenu = new JMenu(MessageManager.getString("action.group_link"));
            for (int m = 0; m < linkMenus.length; ++m) {
                if (linkMenus[m] == null || linkMenus[m].getMenuComponentCount() <= 0) continue;
                groupLinksMenu.add(linkMenus[m]);
            }
            this.groupMenu.add(groupLinksMenu);
        }
    }

    private void jbInit() throws Exception {
        this.groupMenu.setText(MessageManager.getString("label.selection"));
        this.groupName.setText(MessageManager.getString("label.name"));
        this.groupName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.groupName_actionPerformed();
            }
        });
        this.sequenceMenu.setText(MessageManager.getString("label.sequence"));
        JMenuItem sequenceName = new JMenuItem(MessageManager.getString("label.edit_name_description"));
        sequenceName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.sequenceName_actionPerformed();
            }
        });
        JMenuItem chooseAnnotations = new JMenuItem(MessageManager.getString("action.choose_annotations"));
        chooseAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.chooseAnnotations_actionPerformed(e);
            }
        });
        JMenuItem sequenceDetails = new JMenuItem(MessageManager.getString("label.sequence_details"));
        sequenceDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.createSequenceDetailsReport(new SequenceI[]{PopupMenu.this.sequence});
            }
        });
        JMenuItem sequenceSelDetails = new JMenuItem(MessageManager.getString("label.sequence_details"));
        sequenceSelDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.createSequenceDetailsReport(((PopupMenu)PopupMenu.this).ap.av.getSequenceSelection());
            }
        });
        this.unGroupMenuItem.setText(MessageManager.getString("action.remove_group"));
        this.unGroupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.unGroupMenuItem_actionPerformed();
            }
        });
        this.createGroupMenuItem.setText(MessageManager.getString("action.create_group"));
        this.createGroupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.createGroupMenuItem_actionPerformed();
            }
        });
        JMenuItem outline = new JMenuItem(MessageManager.getString("action.border_colour"));
        outline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.outline_actionPerformed();
            }
        });
        this.showBoxes.setText(MessageManager.getString("action.boxes"));
        this.showBoxes.setState(true);
        this.showBoxes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showBoxes_actionPerformed();
            }
        });
        this.showText.setText(MessageManager.getString("action.text"));
        this.showText.setState(true);
        this.showText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showText_actionPerformed();
            }
        });
        this.showColourText.setText(MessageManager.getString("label.colour_text"));
        this.showColourText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showColourText_actionPerformed();
            }
        });
        this.displayNonconserved.setText(MessageManager.getString("label.show_non_conserved"));
        this.displayNonconserved.setState(true);
        this.displayNonconserved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.showNonconserved_actionPerformed();
            }
        });
        this.editMenu.setText(MessageManager.getString("action.edit"));
        JMenuItem cut = new JMenuItem(MessageManager.getString("action.cut"));
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.cut_actionPerformed();
            }
        });
        JMenuItem justifyLeftMenuItem = new JMenuItem(MessageManager.getString("action.left_justify"));
        justifyLeftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PopupMenu)PopupMenu.this).ap.alignFrame.avc.justify_Region(true);
            }
        });
        JMenuItem justifyRightMenuItem = new JMenuItem(MessageManager.getString("action.right_justify"));
        justifyRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PopupMenu)PopupMenu.this).ap.alignFrame.avc.justify_Region(false);
            }
        });
        this.upperCase.setText(MessageManager.getString("label.to_upper_case"));
        this.upperCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.changeCase(e);
            }
        });
        JMenuItem copy = new JMenuItem(MessageManager.getString("action.copy"));
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.copy_actionPerformed();
            }
        });
        this.lowerCase.setText(MessageManager.getString("label.to_lower_case"));
        this.lowerCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.changeCase(e);
            }
        });
        this.toggle.setText(MessageManager.getString("label.toggle_case"));
        this.toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.changeCase(e);
            }
        });
        this.outputMenu.setText(MessageManager.getString("label.out_to_textbox") + "...");
        this.seqShowAnnotationsMenu.setText(MessageManager.getString("label.show_annotations"));
        this.seqHideAnnotationsMenu.setText(MessageManager.getString("label.hide_annotations"));
        this.groupShowAnnotationsMenu.setText(MessageManager.getString("label.show_annotations"));
        this.groupHideAnnotationsMenu.setText(MessageManager.getString("label.hide_annotations"));
        JMenuItem sequenceFeature = new JMenuItem(MessageManager.getString("label.create_sequence_feature"));
        sequenceFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.sequenceFeature_actionPerformed();
            }
        });
        this.editGroupMenu.setText(MessageManager.getString("label.group"));
        this.chooseStructure.setText(MessageManager.getString("label.show_pdbstruct_dialog"));
        this.chooseStructure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SequenceI[] selectedSeqs = new SequenceI[]{PopupMenu.this.sequence};
                if (((PopupMenu)PopupMenu.this).ap.av.getSelectionGroup() != null) {
                    selectedSeqs = ((PopupMenu)PopupMenu.this).ap.av.getSequenceSelection();
                }
                new StructureChooser(selectedSeqs, PopupMenu.this.sequence, PopupMenu.this.ap);
            }
        });
        this.rnaStructureMenu.setText(MessageManager.getString("label.view_rna_structure"));
        JMenuItem editSequence = new JMenuItem(MessageManager.getString("label.edit_sequence") + "...");
        editSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenu.this.editSequence_actionPerformed();
            }
        });
        this.makeReferenceSeq.setText(MessageManager.getString("label.mark_as_representative"));
        this.makeReferenceSeq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenu.this.makeReferenceSeq_actionPerformed(actionEvent);
            }
        });
        this.groupMenu.add(sequenceSelDetails);
        this.add(this.groupMenu);
        this.add(this.sequenceMenu);
        this.add(this.rnaStructureMenu);
        this.add(this.chooseStructure);
        if (this.forIdPanel) {
            JMenuItem hideInsertions = new JMenuItem(MessageManager.getString("label.hide_insertions"));
            hideInsertions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenu.this.hideInsertions_actionPerformed(e);
                }
            });
            this.add(hideInsertions);
        }
        this.sequenceMenu.add(this.seqShowAnnotationsMenu);
        this.sequenceMenu.add(this.seqHideAnnotationsMenu);
        this.sequenceMenu.add(this.seqAddReferenceAnnotations);
        this.groupMenu.add(this.groupShowAnnotationsMenu);
        this.groupMenu.add(this.groupHideAnnotationsMenu);
        this.groupMenu.add(this.groupAddReferenceAnnotations);
        this.groupMenu.add(this.editMenu);
        this.groupMenu.add(this.outputMenu);
        this.groupMenu.add(sequenceFeature);
        this.groupMenu.add(this.createGroupMenuItem);
        this.groupMenu.add(this.unGroupMenuItem);
        this.groupMenu.add(this.editGroupMenu);
        this.sequenceMenu.add(sequenceName);
        this.sequenceMenu.add(sequenceDetails);
        this.sequenceMenu.add(this.makeReferenceSeq);
        this.initColourMenu();
        this.buildColourMenu();
        this.editMenu.add(copy);
        this.editMenu.add(cut);
        this.editMenu.add(justifyLeftMenuItem);
        this.editMenu.add(justifyRightMenuItem);
        this.editMenu.add(editSequence);
        this.editMenu.add(this.upperCase);
        this.editMenu.add(this.lowerCase);
        this.editMenu.add(this.toggle);
        this.editGroupMenu.add(this.groupName);
        this.editGroupMenu.add(this.colourMenu);
        this.editGroupMenu.add(this.showBoxes);
        this.editGroupMenu.add(this.showText);
        this.editGroupMenu.add(this.showColourText);
        this.editGroupMenu.add(outline);
        this.editGroupMenu.add(this.displayNonconserved);
    }

    protected void initColourMenu() {
        this.colourMenu.setText(MessageManager.getString("label.group_colour"));
        this.textColour.setText(MessageManager.getString("label.text_colour"));
        this.textColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.textColour_actionPerformed();
            }
        });
        this.abovePIDColour.setText(MessageManager.getString("label.above_identity_threshold"));
        this.abovePIDColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.abovePIDColour_actionPerformed(PopupMenu.this.abovePIDColour.isSelected());
            }
        });
        this.modifyPID.setText(MessageManager.getString("label.modify_identity_threshold"));
        this.modifyPID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.modifyPID_actionPerformed();
            }
        });
        this.conservationMenuItem.setText(MessageManager.getString("action.by_conservation"));
        this.conservationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.conservationMenuItem_actionPerformed(PopupMenu.this.conservationMenuItem.isSelected());
            }
        });
        this.annotationColour = new JRadioButtonMenuItem(MessageManager.getString("action.by_annotation"));
        this.annotationColour.setName("Annotation");
        this.annotationColour.setEnabled(false);
        this.annotationColour.setToolTipText(MessageManager.getString("label.by_annotation_tooltip"));
        this.modifyConservation.setText(MessageManager.getString("label.modify_conservation_threshold"));
        this.modifyConservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.modifyConservation_actionPerformed();
            }
        });
    }

    protected void buildColourMenu() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg == null) {
            return;
        }
        this.colourMenu.removeAll();
        this.colourMenu.add(this.textColour);
        this.colourMenu.addSeparator();
        ButtonGroup bg = ColourMenuHelper.addMenuItems(this.colourMenu, this, sg, false);
        bg.add(this.annotationColour);
        this.colourMenu.add(this.annotationColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.conservationMenuItem);
        this.colourMenu.add(this.modifyConservation);
        this.colourMenu.add(this.abovePIDColour);
        this.colourMenu.add(this.modifyPID);
    }

    protected void modifyConservation_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs != null) {
            SliderPanel.setConservationSlider(this.ap, sg.cs, sg.getName());
            SliderPanel.showConservationSlider();
        }
    }

    protected void modifyPID_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs != null) {
            SliderPanel.setPIDSliderSource(this.ap, sg.cs, this.getGroup().getName());
            SliderPanel.showPIDSlider();
        }
    }

    protected void configureReferenceAnnotationsMenu(JMenuItem menuItem, List<SequenceI> forSequences) {
        menuItem.setEnabled(false);
        TreeMap<String, String> tipEntries = new TreeMap<String, String>();
        final LinkedHashMap<SequenceI, List<AlignmentAnnotation>> candidates = new LinkedHashMap<SequenceI, List<AlignmentAnnotation>>();
        AlignmentI al = this.ap.av.getAlignment();
        AlignmentUtils.findAddableReferenceAnnotations(forSequences, tipEntries, candidates, al);
        if (!candidates.isEmpty()) {
            StringBuilder tooltip = new StringBuilder(64);
            tooltip.append(MessageManager.getString("label.add_annotations_for"));
            menuItem.setEnabled(true);
            for (String calcId : tipEntries.keySet()) {
                tooltip.append("<br/>" + calcId + "/" + (String)tipEntries.get(calcId));
            }
            String tooltipText = JvSwingUtils.wrapTooltip(true, tooltip.toString());
            menuItem.setToolTipText(tooltipText);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenu.this.addReferenceAnnotations_actionPerformed(candidates);
                }
            });
        }
    }

    protected void addReferenceAnnotations_actionPerformed(Map<SequenceI, List<AlignmentAnnotation>> candidates) {
        AlignmentI alignment = this.ap.getAlignment();
        AlignmentUtils.addReferenceAnnotations(candidates, alignment, null);
        if (AlignmentUtils.isSSAnnotationPresent(candidates)) {
            this.restartSSConsensusWorker();
        }
        this.refresh();
    }

    private void restartSSConsensusWorker() {
        List<AlignCalcWorkerI> workers = this.ap.alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(SecondaryStructureConsensusThread.class);
        if (workers != null && !workers.isEmpty()) {
            this.ap.alignFrame.getViewport().getCalcManager().startWorker(workers.remove(0));
        }
    }

    protected void makeReferenceSeq_actionPerformed(ActionEvent actionEvent) {
        if (!this.ap.av.getAlignment().hasSeqrep()) {
            this.ap.av.setDisplayReferenceSeq(true);
            this.ap.av.setColourByReferenceSeq(true);
            this.ap.av.getAlignment().setSeqrep(this.sequence);
        } else if (this.ap.av.getAlignment().getSeqrep() == this.sequence) {
            this.ap.av.getAlignment().setSeqrep(null);
        } else {
            this.ap.av.getAlignment().setSeqrep(this.sequence);
        }
        this.refresh();
    }

    protected void hideInsertions_actionPerformed(ActionEvent actionEvent) {
        HiddenColumns hidden = this.ap.av.getAlignment().getHiddenColumns();
        BitSet inserts = new BitSet();
        boolean markedPopup = false;
        if (this.ap.av.getSelectionGroup() != null) {
            inserts.set(this.ap.av.getSelectionGroup().getStartRes(), this.ap.av.getSelectionGroup().getEndRes() + 1);
            for (SequenceI sq : this.ap.av.getSelectionGroup().getSequences()) {
                if (sq == this.sequence) {
                    markedPopup = true;
                }
                inserts.and(sq.getInsertionsAsBits());
            }
            hidden.clearAndHideColumns(inserts, this.ap.av.getSelectionGroup().getStartRes(), this.ap.av.getSelectionGroup().getEndRes());
        } else if (!markedPopup && this.sequence != null) {
            inserts.or(this.sequence.getInsertionsAsBits());
            hidden.hideColumns(inserts);
        }
        this.refresh();
    }

    protected void sequenceSelectionDetails_actionPerformed() {
        this.createSequenceDetailsReport(this.ap.av.getSequenceSelection());
    }

    public void createSequenceDetailsReport(SequenceI[] sequences) {
        Object[] objectArray;
        JInternalFrame frame;
        StringBuilder contents = new StringBuilder(128);
        contents.append("<html><body>");
        for (SequenceI seq : sequences) {
            contents.append("<p><h2>" + MessageManager.formatMessage("label.create_sequence_details_report_annotation_for", seq.getDisplayId(true)) + "</h2></p>\n<p>");
            new SequenceAnnotationReport(false).createSequenceAnnotationReport(contents, seq, true, true, this.ap.getSeqPanel().seqCanvas.fr);
            contents.append("</p>");
        }
        contents.append("</body></html>");
        String report = contents.toString();
        if (Platform.isJS()) {
            JLabel textLabel = new JLabel();
            textLabel.setText(report);
            textLabel.setBackground(Color.WHITE);
            JPanel pane = new JPanel(new BorderLayout());
            pane.setOpaque(true);
            pane.setBackground(Color.WHITE);
            pane.add((Component)textLabel, "North");
            frame = new JInternalFrame();
            frame.setFrameIcon(null);
            frame.getContentPane().add(new JScrollPane(pane));
        } else {
            CutAndPasteHtmlTransfer cap = new CutAndPasteHtmlTransfer();
            cap.setText(report);
            frame = cap;
        }
        if (sequences.length == 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = sequences[0].getDisplayId(true);
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = MessageManager.getString("label.selection");
        }
        Desktop.addInternalFrame(frame, MessageManager.formatMessage("label.sequence_details_for", objectArray), 500, 400);
    }

    protected void showNonconserved_actionPerformed() {
        this.getGroup().setShowNonconserved(this.displayNonconserved.isSelected());
        this.refresh();
    }

    void refresh() {
        this.ap.updateAnnotation();
        PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId());
    }

    public void abovePIDColour_actionPerformed(boolean selected) {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (selected) {
            sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.getHiddenRepSequences()), sg.getStartRes(), sg.getEndRes() + 1));
            int threshold = SliderPanel.setPIDSliderSource(this.ap, sg.getGroupColourScheme(), this.getGroup().getName());
            sg.cs.setThreshold(threshold, this.ap.av.isIgnoreGapsConsensus());
            SliderPanel.showPIDSlider();
        } else {
            sg.cs.setThreshold(0, this.ap.av.isIgnoreGapsConsensus());
            SliderPanel.hidePIDSlider();
        }
        this.modifyPID.setEnabled(selected);
        this.refresh();
    }

    protected void chooseAnnotations_actionPerformed(ActionEvent e) {
        new AnnotationChooser(this.ap);
    }

    public void conservationMenuItem_actionPerformed(boolean selected) {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (selected) {
            Conservation c = new Conservation("Group", sg.getSequences(this.ap.av.getHiddenRepSequences()), sg.getStartRes(), sg.getEndRes() + 1);
            c.calculate();
            c.verdict(false, this.ap.av.getConsPercGaps());
            sg.cs.setConservation(c);
            SliderPanel.setConservationSlider(this.ap, sg.getGroupColourScheme(), sg.getName());
            SliderPanel.showConservationSlider();
        } else {
            sg.cs.setConservation(null);
            SliderPanel.hideConservationSlider();
        }
        this.modifyConservation.setEnabled(selected);
        this.refresh();
    }

    protected void groupName_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        EditNameDialog dialog = new EditNameDialog(sg.getName(), sg.getDescription(), MessageManager.getString("label.group_name"), MessageManager.getString("label.group_description"));
        dialog.showDialog(this.ap.alignFrame, MessageManager.getString("label.edit_group_name_description"), () -> {
            sg.setName(dialog.getName());
            sg.setDescription(dialog.getDescription());
            this.refresh();
        });
    }

    SequenceGroup getGroup() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            this.ap.av.getAlignment().addGroup(sg);
        }
        return sg;
    }

    void sequenceName_actionPerformed() {
        EditNameDialog dialog = new EditNameDialog(this.sequence.getName(), this.sequence.getDescription(), MessageManager.getString("label.sequence_name"), MessageManager.getString("label.sequence_description"));
        dialog.showDialog(this.ap.alignFrame, MessageManager.getString("label.edit_sequence_name_description"), () -> {
            if (dialog.getName() != null) {
                if (dialog.getName().indexOf(" ") > -1) {
                    String ok = MessageManager.getString("action.ok");
                    String cancel = MessageManager.getString("action.cancel");
                    String message = MessageManager.getString("label.spaces_converted_to_underscores");
                    String title = MessageManager.getString("label.no_spaces_allowed_sequence_name");
                    Object[] options = new Object[]{ok, cancel};
                    JvOptionPane.frameDialog(message, title, 2, null, null, null, false);
                }
                this.sequence.setName(dialog.getName().replace(' ', '_'));
                this.ap.paintAlignment(false, false);
            }
            this.sequence.setDescription(dialog.getDescription());
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        });
    }

    void unGroupMenuItem_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        this.ap.av.getAlignment().deleteGroup(sg);
        this.ap.av.setSelectionGroup(null);
        this.refresh();
    }

    void createGroupMenuItem_actionPerformed() {
        this.getGroup();
        this.refresh();
    }

    protected void outline_actionPerformed() {
        String title = MessageManager.getString("label.select_outline_colour");
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                PopupMenu.this.getGroup().setOutlineColour(c);
                PopupMenu.this.refresh();
            }
        };
        JalviewColourChooser.showColourChooser(Desktop.getDesktop(), title, Color.BLUE, listener);
    }

    public void showBoxes_actionPerformed() {
        this.getGroup().setDisplayBoxes(this.showBoxes.isSelected());
        this.refresh();
    }

    public void showText_actionPerformed() {
        this.getGroup().setDisplayText(this.showText.isSelected());
        this.refresh();
    }

    public void showColourText_actionPerformed() {
        this.getGroup().setColourText(this.showColourText.isSelected());
        this.refresh();
    }

    void hideSequences(boolean representGroup) {
        this.ap.av.hideSequences(this.sequence, representGroup);
    }

    public void copy_actionPerformed() {
        this.ap.alignFrame.copy_actionPerformed();
    }

    public void cut_actionPerformed() {
        this.ap.alignFrame.cut_actionPerformed();
    }

    void changeCase(ActionEvent e) {
        Object source = e.getSource();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            int caseChange;
            String description;
            List<int[]> startEnd = this.ap.av.getVisibleRegionBoundaries(sg.getStartRes(), sg.getEndRes() + 1);
            if (source == this.toggle) {
                description = MessageManager.getString("label.toggle_case");
                caseChange = ChangeCaseCommand.TOGGLE_CASE;
            } else if (source == this.upperCase) {
                description = MessageManager.getString("label.to_upper_case");
                caseChange = ChangeCaseCommand.TO_UPPER;
            } else {
                description = MessageManager.getString("label.to_lower_case");
                caseChange = ChangeCaseCommand.TO_LOWER;
            }
            ChangeCaseCommand caseCommand = new ChangeCaseCommand(description, sg.getSequencesAsArray(this.ap.av.getHiddenRepSequences()), startEnd, caseChange);
            this.ap.alignFrame.addHistoryItem(caseCommand);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    public void outputText_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setForInput(null);
        Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.alignment_output_command", e.getActionCommand()), 600, 500);
        Object omitHidden = null;
        Console.outPrintln("PROMPT USER HERE");
        FileFormatI fileFormat = FileFormats.getInstance().forName(e.getActionCommand());
        cap.setText(new FormatAdapter(this.ap).formatSequences(fileFormat, this.ap, true));
    }

    public void sequenceFeature_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg == null) {
            return;
        }
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
        int gSize = sg.getSize();
        for (int i = 0; i < gSize; ++i) {
            int end;
            int start = sg.getSequenceAt(i).findPosition(sg.getStartRes());
            if (start > (end = sg.findEndRes(sg.getSequenceAt(i)))) continue;
            seqs.add(sg.getSequenceAt(i).getDatasetSequence());
            features.add(new SequenceFeature(null, null, start, end, null));
        }
        if (!seqs.isEmpty()) {
            new FeatureEditor(this.ap, seqs, features, true).showDialog();
        }
    }

    public void textColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        if (sg != null) {
            new TextColourChooser().chooseColour(this.ap, sg);
        }
    }

    public void editSequence_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        SequenceI seq = this.sequence;
        if (sg != null) {
            if (seq == null) {
                seq = sg.getSequenceAt(0);
            }
            EditNameDialog dialog = new EditNameDialog(seq.getSequenceAsString(sg.getStartRes(), sg.getEndRes() + 1), null, MessageManager.getString("label.edit_sequence"), null);
            dialog.showDialog(this.ap.alignFrame, MessageManager.getString("label.edit_sequence"), () -> {
                EditCommand editCommand = new EditCommand(MessageManager.getString("label.edit_sequences"), EditCommand.Action.REPLACE, dialog.getName().replace(' ', this.ap.av.getGapCharacter()), sg.getSequencesAsArray(this.ap.av.getHiddenRepSequences()), sg.getStartRes(), sg.getEndRes() + 1, this.ap.av.getAlignment());
                this.ap.alignFrame.addHistoryItem(editCommand);
                this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
            });
        }
    }

    @Override
    public void changeColour_actionPerformed(String colourSchemeName) {
        SequenceGroup sg = this.getGroup();
        ColourSchemeI colourScheme = ColourSchemes.getInstance().getColourScheme(colourSchemeName, this.ap.av, sg, this.ap.av.getHiddenRepSequences());
        sg.setColourScheme(colourScheme);
        if (colourScheme instanceof Blosum62ColourScheme || colourScheme instanceof PIDColourScheme) {
            sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.getHiddenRepSequences()), sg.getStartRes(), sg.getEndRes() + 1));
        }
        this.refresh();
    }
}

