/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ReorderableJList;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.RNA;
import jalview.bin.Console;
import jalview.datamodel.SequenceI;
import jalview.ext.varna.JalviewVarnaBinding;
import jalview.structure.AtomSpec;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppVarnaBinding
extends JalviewVarnaBinding {
    public VARNAPanel vp;
    protected JPanel _listPanel = new JPanel();
    private ReorderableJList _sideList = null;
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private static int _nextID = 1;
    private int _algoCode;
    private BackupHolder _rnaList;

    public AppVarnaBinding() {
        this.init();
    }

    private void init() {
        DefaultListModel<FullBackup> dlm = new DefaultListModel<FullBackup>();
        int marginTools = 40;
        DefaultListSelectionModel m = new DefaultListSelectionModel();
        m.setSelectionMode(0);
        m.setLeadAnchorNotificationEnabled(false);
        this._sideList = new ReorderableJList();
        this._sideList.setModel(dlm);
        this._sideList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AppVarnaBinding.this.mouseClicked(e);
            }
        });
        this._sideList.setSelectionModel((ListSelectionModel)m);
        this._sideList.setPreferredSize(new Dimension(100, 0));
        this._sideList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AppVarnaBinding.this.changeSelectedStructure_actionPerformed(evt);
            }
        });
        this._rnaList = new BackupHolder(dlm, (JList)this._sideList);
        try {
            this.vp = new VARNAPanel("0", ".");
        }
        catch (ExceptionNonEqualLength e) {
            this.vp.errorDialog((Exception)((Object)e));
        }
        this.vp.setPreferredSize(new Dimension(400, 400));
        JScrollPane listScroller = new JScrollPane((Component)this._sideList);
        listScroller.setPreferredSize(new Dimension(150, 0));
        this.vp.setBackground(this._backgroundColor);
        JLabel j = new JLabel(MessageManager.getString("label.structures_manager"), 0);
        this._listPanel.setLayout(new BorderLayout());
        this._listPanel.add((Component)j, "North");
        this._listPanel.add((Component)listScroller, "Center");
        new DropTarget((Component)this.vp, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                AppVarnaBinding.this.drop(dtde);
            }
        });
    }

    public JPanel getListPanel() {
        return this._listPanel;
    }

    public RNA getSelectedRNA() {
        int selectedIndex = this._sideList.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        FullBackup selected = this._rnaList.getElementAt(selectedIndex);
        return selected.rna;
    }

    public void updateSelectedRNA(RNA rnaEdit) {
        this.vp.repaint();
        this.vp.showRNA(rnaEdit);
    }

    public static String generateDefaultName() {
        return "User file #" + _nextID++;
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return info;
    }

    private Color getSafeColor(String col, Color def) {
        Color result;
        try {
            result = Color.decode(col);
        }
        catch (Exception e) {
            try {
                result = Color.getColor(col, def);
            }
            catch (Exception e2) {
                return def;
            }
        }
        return result;
    }

    public VARNAPanel get_varnaPanel() {
        return this.vp;
    }

    public void set_varnaPanel(VARNAPanel surface) {
        this.vp = surface;
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                dtde.acceptDrop(3);
                Object ob = tr.getTransferData(flavors[i]);
                if (ob instanceof List) {
                    List list = (List)ob;
                    for (int j = 0; j < list.size(); ++j) {
                        DropTarget dt;
                        Component c;
                        Object o = list.get(j);
                        if (!(dtde.getSource() instanceof DropTarget) || !((c = (dt = (DropTarget)dtde.getSource()).getComponent()) instanceof VARNAPanel)) continue;
                        String path = o.toString();
                        VARNAPanel varnaPanel = (VARNAPanel)c;
                        try {
                            FullBackup bck = VARNAPanel.importSession((String)path);
                            this._rnaList.add(bck.config, bck.rna, bck.name, true);
                            continue;
                        }
                        catch (ExceptionLoadingFailed e3) {
                            int mn = 1;
                            ArrayList mdls = RNAFactory.loadSecStr((String)path);
                            for (RNA r : mdls) {
                                r.drawRNA(varnaPanel.getConfig());
                                String name = r.getName();
                                if (name.equals("")) {
                                    name = path.substring(path.lastIndexOf(File.separatorChar) + 1);
                                }
                                if (mdls.size() > 1) {
                                    name = name + " (Model " + mn++ + ")";
                                }
                                this._rnaList.add(varnaPanel.getConfig().clone(), r, name, true);
                            }
                        }
                    }
                }
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int index = this._sideList.locationToIndex(e.getPoint());
            ListModel dlm = this._sideList.getModel();
            this._sideList.ensureIndexIsVisible(index);
        }
    }

    @Override
    public String[] getStructureFiles() {
        return null;
    }

    @Override
    public void releaseReferences(Object svl) {
    }

    @Override
    public void updateColours(Object source) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
    }

    @Override
    public boolean isListeningFor(SequenceI seq) {
        return true;
    }

    public String getStateInfo(RNA rna) {
        if (this.vp == null) {
            return null;
        }
        FullBackup sel = (FullBackup)this._sideList.getSelectedValue();
        FullBackup model = null;
        ListModel models = this._sideList.getModel();
        for (int i = 0; i < models.getSize(); ++i) {
            model = (FullBackup)models.getElementAt(i);
            if (model.rna == rna) break;
        }
        if (model == null) {
            return null;
        }
        this.vp.showRNA(model.rna, model.config);
        try {
            File temp = File.createTempFile("varna", null);
            temp.deleteOnExit();
            String filePath = temp.getAbsolutePath();
            this.vp.toXML(filePath);
            this.vp.showRNA(sel.rna, sel.config);
            return filePath;
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getSelectedIndex() {
        return this._sideList.getSelectedIndex();
    }

    protected void changeSelectedStructure_actionPerformed(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.showSelectedStructure();
        }
    }

    protected void showSelectedStructure() {
        FullBackup sel = (FullBackup)this._sideList.getSelectedValue();
        if (sel != null) {
            this.vp.showRNA(sel.rna, sel.config);
        }
    }

    public void setSelectedIndex(int selectedRna) {
        this._sideList.setSelectedIndex(selectedRna);
    }

    public void addStructure(RNA rna) {
        VARNAConfig config = this.vp.getConfig().clone();
        this.addStructure(rna, config);
    }

    protected void addStructure(RNA rna, VARNAConfig config) {
        this.drawRna(rna, config);
        this._rnaList.add(config, rna, rna.getName());
    }

    protected void drawRna(RNA rna, VARNAConfig config) {
        try {
            rna.drawRNA(rna.getDrawMode(), config);
        }
        catch (ExceptionNAViewAlgorithm e) {
            Console.errPrintln("Error drawing RNA: " + e.getMessage());
        }
    }

    private class BackupHolder {
        private DefaultListModel<FullBackup> _rnalist;
        private List<RNA> _rnas = new ArrayList<RNA>();
        JList _l;

        public BackupHolder(DefaultListModel<FullBackup> rnaList, JList l) {
            this._rnalist = rnaList;
            this._l = l;
        }

        public void add(VARNAConfig c, RNA r, String name) {
            this.add(c, r, name, false);
        }

        public void add(VARNAConfig c, RNA r, String name, boolean select) {
            if (select) {
                this._l.removeSelectionInterval(0, this._rnalist.size());
            }
            if (name.equals("")) {
                name = AppVarnaBinding.generateDefaultName();
            }
            FullBackup bck = new FullBackup(c, r, name);
            this._rnas.add(r);
            this._rnalist.addElement(bck);
            if (select) {
                this._l.setSelectedIndex(0);
            }
        }

        public FullBackup getElementAt(int i) {
            return this._rnalist.getElementAt(i);
        }
    }
}

